import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudVbsBackupPolicyV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vbs_backup_policy_v2#id DataOpentelekomcloudVbsBackupPolicyV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vbs_backup_policy_v2#name DataOpentelekomcloudVbsBackupPolicyV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vbs_backup_policy_v2#policy_resource_count DataOpentelekomcloudVbsBackupPolicyV2#policy_resource_count}
    */
    readonly policyResourceCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vbs_backup_policy_v2#region DataOpentelekomcloudVbsBackupPolicyV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vbs_backup_policy_v2#status DataOpentelekomcloudVbsBackupPolicyV2#status}
    */
    readonly status?: string;
    /**
    * filter_tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vbs_backup_policy_v2#filter_tags DataOpentelekomcloudVbsBackupPolicyV2#filter_tags}
    */
    readonly filterTags?: DataOpentelekomcloudVbsBackupPolicyV2FilterTags[] | cdktf.IResolvable;
}
export interface DataOpentelekomcloudVbsBackupPolicyV2Tags {
}
export declare function dataOpentelekomcloudVbsBackupPolicyV2TagsToTerraform(struct?: DataOpentelekomcloudVbsBackupPolicyV2Tags): any;
export declare class DataOpentelekomcloudVbsBackupPolicyV2TagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudVbsBackupPolicyV2Tags | undefined;
    set internalValue(value: DataOpentelekomcloudVbsBackupPolicyV2Tags | undefined);
    get key(): string;
    get value(): string;
}
export declare class DataOpentelekomcloudVbsBackupPolicyV2TagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudVbsBackupPolicyV2TagsOutputReference;
}
export interface DataOpentelekomcloudVbsBackupPolicyV2FilterTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vbs_backup_policy_v2#key DataOpentelekomcloudVbsBackupPolicyV2#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vbs_backup_policy_v2#values DataOpentelekomcloudVbsBackupPolicyV2#values}
    */
    readonly values: string[];
}
export declare function dataOpentelekomcloudVbsBackupPolicyV2FilterTagsToTerraform(struct?: DataOpentelekomcloudVbsBackupPolicyV2FilterTags | cdktf.IResolvable): any;
export declare class DataOpentelekomcloudVbsBackupPolicyV2FilterTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudVbsBackupPolicyV2FilterTags | cdktf.IResolvable | undefined;
    set internalValue(value: DataOpentelekomcloudVbsBackupPolicyV2FilterTags | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class DataOpentelekomcloudVbsBackupPolicyV2FilterTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataOpentelekomcloudVbsBackupPolicyV2FilterTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudVbsBackupPolicyV2FilterTagsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vbs_backup_policy_v2 opentelekomcloud_vbs_backup_policy_v2}
*/
export declare class DataOpentelekomcloudVbsBackupPolicyV2 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_vbs_backup_policy_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vbs_backup_policy_v2 opentelekomcloud_vbs_backup_policy_v2} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudVbsBackupPolicyV2Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudVbsBackupPolicyV2Config);
    get frequency(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _policyResourceCount?;
    get policyResourceCount(): number;
    set policyResourceCount(value: number);
    resetPolicyResourceCount(): void;
    get policyResourceCountInput(): number | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get remainFirstBackup(): string;
    get rententionNum(): number;
    get startTime(): string;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _tags;
    get tags(): DataOpentelekomcloudVbsBackupPolicyV2TagsList;
    private _filterTags;
    get filterTags(): DataOpentelekomcloudVbsBackupPolicyV2FilterTagsList;
    putFilterTags(value: DataOpentelekomcloudVbsBackupPolicyV2FilterTags[] | cdktf.IResolvable): void;
    resetFilterTags(): void;
    get filterTagsInput(): cdktf.IResolvable | DataOpentelekomcloudVbsBackupPolicyV2FilterTags[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
