import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudVpcepServiceV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1#id DataOpentelekomcloudVpcepServiceV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1#name DataOpentelekomcloudVpcepServiceV1#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1#status DataOpentelekomcloudVpcepServiceV1#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1#tags DataOpentelekomcloudVpcepServiceV1#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataOpentelekomcloudVpcepServiceV1Port {
}
export declare function dataOpentelekomcloudVpcepServiceV1PortToTerraform(struct?: DataOpentelekomcloudVpcepServiceV1Port): any;
export declare class DataOpentelekomcloudVpcepServiceV1PortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudVpcepServiceV1Port | undefined;
    set internalValue(value: DataOpentelekomcloudVpcepServiceV1Port | undefined);
    get clientPort(): number;
    get protocol(): string;
    get serverPort(): number;
}
export declare class DataOpentelekomcloudVpcepServiceV1PortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudVpcepServiceV1PortOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1 opentelekomcloud_vpcep_service_v1}
*/
export declare class DataOpentelekomcloudVpcepServiceV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_vpcep_service_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1 opentelekomcloud_vpcep_service_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudVpcepServiceV1Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudVpcepServiceV1Config);
    get approvalEnabled(): cdktf.IResolvable;
    get connectionCount(): number;
    get createdAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _port;
    get port(): DataOpentelekomcloudVpcepServiceV1PortList;
    get portId(): string;
    get projectId(): string;
    get serverType(): string;
    get serviceType(): string;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get tcpProxy(): string;
    get updatedAt(): string;
    get vipPortId(): string;
    get vpcId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
