import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DcsInstanceV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#access_user DcsInstanceV1#access_user}
    */
    readonly accessUser?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#available_zones DcsInstanceV1#available_zones}
    */
    readonly availableZones: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#backup_at DcsInstanceV1#backup_at}
    */
    readonly backupAt?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#backup_type DcsInstanceV1#backup_type}
    */
    readonly backupType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#begin_at DcsInstanceV1#begin_at}
    */
    readonly beginAt?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#capacity DcsInstanceV1#capacity}
    */
    readonly capacity: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#description DcsInstanceV1#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#engine DcsInstanceV1#engine}
    */
    readonly engine: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#engine_version DcsInstanceV1#engine_version}
    */
    readonly engineVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#id DcsInstanceV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#maintain_begin DcsInstanceV1#maintain_begin}
    */
    readonly maintainBegin?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#maintain_end DcsInstanceV1#maintain_end}
    */
    readonly maintainEnd?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#name DcsInstanceV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#password DcsInstanceV1#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#period_type DcsInstanceV1#period_type}
    */
    readonly periodType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#product_id DcsInstanceV1#product_id}
    */
    readonly productId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#save_days DcsInstanceV1#save_days}
    */
    readonly saveDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#security_group_id DcsInstanceV1#security_group_id}
    */
    readonly securityGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#subnet_id DcsInstanceV1#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#vpc_id DcsInstanceV1#vpc_id}
    */
    readonly vpcId: string;
    /**
    * backup_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#backup_policy DcsInstanceV1#backup_policy}
    */
    readonly backupPolicy?: DcsInstanceV1BackupPolicy;
    /**
    * configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#configuration DcsInstanceV1#configuration}
    */
    readonly configuration?: DcsInstanceV1Configuration[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#timeouts DcsInstanceV1#timeouts}
    */
    readonly timeouts?: DcsInstanceV1Timeouts;
}
export interface DcsInstanceV1BackupPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#backup_at DcsInstanceV1#backup_at}
    */
    readonly backupAt: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#backup_type DcsInstanceV1#backup_type}
    */
    readonly backupType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#begin_at DcsInstanceV1#begin_at}
    */
    readonly beginAt: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#period_type DcsInstanceV1#period_type}
    */
    readonly periodType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#save_days DcsInstanceV1#save_days}
    */
    readonly saveDays?: number;
}
export declare function dcsInstanceV1BackupPolicyToTerraform(struct?: DcsInstanceV1BackupPolicyOutputReference | DcsInstanceV1BackupPolicy): any;
export declare class DcsInstanceV1BackupPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DcsInstanceV1BackupPolicy | undefined;
    set internalValue(value: DcsInstanceV1BackupPolicy | undefined);
    private _backupAt?;
    get backupAt(): number[];
    set backupAt(value: number[]);
    get backupAtInput(): number[] | undefined;
    private _backupType?;
    get backupType(): string;
    set backupType(value: string);
    resetBackupType(): void;
    get backupTypeInput(): string | undefined;
    private _beginAt?;
    get beginAt(): string;
    set beginAt(value: string);
    get beginAtInput(): string | undefined;
    private _periodType?;
    get periodType(): string;
    set periodType(value: string);
    get periodTypeInput(): string | undefined;
    private _saveDays?;
    get saveDays(): number;
    set saveDays(value: number);
    resetSaveDays(): void;
    get saveDaysInput(): number | undefined;
}
export interface DcsInstanceV1Configuration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#parameter_id DcsInstanceV1#parameter_id}
    */
    readonly parameterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#parameter_name DcsInstanceV1#parameter_name}
    */
    readonly parameterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#parameter_value DcsInstanceV1#parameter_value}
    */
    readonly parameterValue: string;
}
export declare function dcsInstanceV1ConfigurationToTerraform(struct?: DcsInstanceV1Configuration | cdktf.IResolvable): any;
export declare class DcsInstanceV1ConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DcsInstanceV1Configuration | cdktf.IResolvable | undefined;
    set internalValue(value: DcsInstanceV1Configuration | cdktf.IResolvable | undefined);
    private _parameterId?;
    get parameterId(): string;
    set parameterId(value: string);
    get parameterIdInput(): string | undefined;
    private _parameterName?;
    get parameterName(): string;
    set parameterName(value: string);
    get parameterNameInput(): string | undefined;
    private _parameterValue?;
    get parameterValue(): string;
    set parameterValue(value: string);
    get parameterValueInput(): string | undefined;
}
export declare class DcsInstanceV1ConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DcsInstanceV1Configuration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DcsInstanceV1ConfigurationOutputReference;
}
export interface DcsInstanceV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#create DcsInstanceV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#delete DcsInstanceV1#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1#update DcsInstanceV1#update}
    */
    readonly update?: string;
}
export declare function dcsInstanceV1TimeoutsToTerraform(struct?: DcsInstanceV1TimeoutsOutputReference | DcsInstanceV1Timeouts | cdktf.IResolvable): any;
export declare class DcsInstanceV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DcsInstanceV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DcsInstanceV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1 opentelekomcloud_dcs_instance_v1}
*/
export declare class DcsInstanceV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_dcs_instance_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1 opentelekomcloud_dcs_instance_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DcsInstanceV1Config
    */
    constructor(scope: Construct, id: string, config: DcsInstanceV1Config);
    private _accessUser?;
    get accessUser(): string;
    set accessUser(value: string);
    resetAccessUser(): void;
    get accessUserInput(): string | undefined;
    private _availableZones?;
    get availableZones(): string[];
    set availableZones(value: string[]);
    get availableZonesInput(): string[] | undefined;
    private _backupAt?;
    get backupAt(): number[];
    set backupAt(value: number[]);
    resetBackupAt(): void;
    get backupAtInput(): number[] | undefined;
    private _backupType?;
    get backupType(): string;
    set backupType(value: string);
    resetBackupType(): void;
    get backupTypeInput(): string | undefined;
    private _beginAt?;
    get beginAt(): string;
    set beginAt(value: string);
    resetBeginAt(): void;
    get beginAtInput(): string | undefined;
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    get capacityInput(): number | undefined;
    get createdAt(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _engine?;
    get engine(): string;
    set engine(value: string);
    get engineInput(): string | undefined;
    private _engineVersion?;
    get engineVersion(): string;
    set engineVersion(value: string);
    get engineVersionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get internalVersion(): string;
    get ip(): string;
    private _maintainBegin?;
    get maintainBegin(): string;
    set maintainBegin(value: string);
    resetMaintainBegin(): void;
    get maintainBeginInput(): string | undefined;
    private _maintainEnd?;
    get maintainEnd(): string;
    set maintainEnd(value: string);
    resetMaintainEnd(): void;
    get maintainEndInput(): string | undefined;
    get maxMemory(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get orderId(): string;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _periodType?;
    get periodType(): string;
    set periodType(value: string);
    resetPeriodType(): void;
    get periodTypeInput(): string | undefined;
    get port(): number;
    private _productId?;
    get productId(): string;
    set productId(value: string);
    get productIdInput(): string | undefined;
    get resourceSpecCode(): string;
    private _saveDays?;
    get saveDays(): number;
    set saveDays(value: number);
    resetSaveDays(): void;
    get saveDaysInput(): number | undefined;
    private _securityGroupId?;
    get securityGroupId(): string;
    set securityGroupId(value: string);
    get securityGroupIdInput(): string | undefined;
    get securityGroupName(): string;
    get status(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    get subnetName(): string;
    get usedMemory(): number;
    get userId(): string;
    get userName(): string;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    get vpcName(): string;
    private _backupPolicy;
    get backupPolicy(): DcsInstanceV1BackupPolicyOutputReference;
    putBackupPolicy(value: DcsInstanceV1BackupPolicy): void;
    resetBackupPolicy(): void;
    get backupPolicyInput(): DcsInstanceV1BackupPolicy | undefined;
    private _configuration;
    get configuration(): DcsInstanceV1ConfigurationList;
    putConfiguration(value: DcsInstanceV1Configuration[] | cdktf.IResolvable): void;
    resetConfiguration(): void;
    get configurationInput(): cdktf.IResolvable | DcsInstanceV1Configuration[] | undefined;
    private _timeouts;
    get timeouts(): DcsInstanceV1TimeoutsOutputReference;
    putTimeouts(value: DcsInstanceV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DcsInstanceV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
