import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DmsQueueV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1#description DmsQueueV1#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1#id DmsQueueV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1#max_consume_count DmsQueueV1#max_consume_count}
    */
    readonly maxConsumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1#name DmsQueueV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1#queue_mode DmsQueueV1#queue_mode}
    */
    readonly queueMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1#redrive_policy DmsQueueV1#redrive_policy}
    */
    readonly redrivePolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1#retention_hours DmsQueueV1#retention_hours}
    */
    readonly retentionHours?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1 opentelekomcloud_dms_queue_v1}
*/
export declare class DmsQueueV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_dms_queue_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1 opentelekomcloud_dms_queue_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DmsQueueV1Config
    */
    constructor(scope: Construct, id: string, config: DmsQueueV1Config);
    get created(): number;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get groupCount(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxConsumeCount?;
    get maxConsumeCount(): number;
    set maxConsumeCount(value: number);
    resetMaxConsumeCount(): void;
    get maxConsumeCountInput(): number | undefined;
    get maxMsgSizeByte(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get producedMessages(): number;
    private _queueMode?;
    get queueMode(): string;
    set queueMode(value: string);
    resetQueueMode(): void;
    get queueModeInput(): string | undefined;
    private _redrivePolicy?;
    get redrivePolicy(): string;
    set redrivePolicy(value: string);
    resetRedrivePolicy(): void;
    get redrivePolicyInput(): string | undefined;
    get reservation(): number;
    private _retentionHours?;
    get retentionHours(): number;
    set retentionHours(value: number);
    resetRetentionHours(): void;
    get retentionHoursInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
