import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EcsInstanceV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#auto_recovery EcsInstanceV1#auto_recovery}
    */
    readonly autoRecovery?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#availability_zone EcsInstanceV1#availability_zone}
    */
    readonly availabilityZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#delete_disks_on_termination EcsInstanceV1#delete_disks_on_termination}
    */
    readonly deleteDisksOnTermination?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#flavor EcsInstanceV1#flavor}
    */
    readonly flavor: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#id EcsInstanceV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#image_id EcsInstanceV1#image_id}
    */
    readonly imageId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#key_name EcsInstanceV1#key_name}
    */
    readonly keyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#name EcsInstanceV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#password EcsInstanceV1#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#security_groups EcsInstanceV1#security_groups}
    */
    readonly securityGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#system_disk_kms_id EcsInstanceV1#system_disk_kms_id}
    */
    readonly systemDiskKmsId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#system_disk_size EcsInstanceV1#system_disk_size}
    */
    readonly systemDiskSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#system_disk_type EcsInstanceV1#system_disk_type}
    */
    readonly systemDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#tags EcsInstanceV1#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#user_data EcsInstanceV1#user_data}
    */
    readonly userData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#vpc_id EcsInstanceV1#vpc_id}
    */
    readonly vpcId: string;
    /**
    * data_disks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#data_disks EcsInstanceV1#data_disks}
    */
    readonly dataDisks?: EcsInstanceV1DataDisks[] | cdktf.IResolvable;
    /**
    * nics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#nics EcsInstanceV1#nics}
    */
    readonly nics: EcsInstanceV1Nics[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#timeouts EcsInstanceV1#timeouts}
    */
    readonly timeouts?: EcsInstanceV1Timeouts;
}
export interface EcsInstanceV1DataDisks {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#kms_id EcsInstanceV1#kms_id}
    */
    readonly kmsId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#size EcsInstanceV1#size}
    */
    readonly size: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#snapshot_id EcsInstanceV1#snapshot_id}
    */
    readonly snapshotId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#type EcsInstanceV1#type}
    */
    readonly type: string;
}
export declare function ecsInstanceV1DataDisksToTerraform(struct?: EcsInstanceV1DataDisks | cdktf.IResolvable): any;
export declare class EcsInstanceV1DataDisksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EcsInstanceV1DataDisks | cdktf.IResolvable | undefined;
    set internalValue(value: EcsInstanceV1DataDisks | cdktf.IResolvable | undefined);
    private _kmsId?;
    get kmsId(): string;
    set kmsId(value: string);
    resetKmsId(): void;
    get kmsIdInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    resetSnapshotId(): void;
    get snapshotIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class EcsInstanceV1DataDisksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EcsInstanceV1DataDisks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EcsInstanceV1DataDisksOutputReference;
}
export interface EcsInstanceV1Nics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#ip_address EcsInstanceV1#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#network_id EcsInstanceV1#network_id}
    */
    readonly networkId: string;
}
export declare function ecsInstanceV1NicsToTerraform(struct?: EcsInstanceV1Nics | cdktf.IResolvable): any;
export declare class EcsInstanceV1NicsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EcsInstanceV1Nics | cdktf.IResolvable | undefined;
    set internalValue(value: EcsInstanceV1Nics | cdktf.IResolvable | undefined);
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    get macAddress(): string;
    private _networkId?;
    get networkId(): string;
    set networkId(value: string);
    get networkIdInput(): string | undefined;
    get portId(): string;
    get type(): string;
}
export declare class EcsInstanceV1NicsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EcsInstanceV1Nics[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EcsInstanceV1NicsOutputReference;
}
export interface EcsInstanceV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#create EcsInstanceV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#delete EcsInstanceV1#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1#update EcsInstanceV1#update}
    */
    readonly update?: string;
}
export declare function ecsInstanceV1TimeoutsToTerraform(struct?: EcsInstanceV1TimeoutsOutputReference | EcsInstanceV1Timeouts | cdktf.IResolvable): any;
export declare class EcsInstanceV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EcsInstanceV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EcsInstanceV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1 opentelekomcloud_ecs_instance_v1}
*/
export declare class EcsInstanceV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_ecs_instance_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1 opentelekomcloud_ecs_instance_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EcsInstanceV1Config
    */
    constructor(scope: Construct, id: string, config: EcsInstanceV1Config);
    private _autoRecovery?;
    get autoRecovery(): boolean | cdktf.IResolvable;
    set autoRecovery(value: boolean | cdktf.IResolvable);
    resetAutoRecovery(): void;
    get autoRecoveryInput(): boolean | cdktf.IResolvable | undefined;
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    get availabilityZoneInput(): string | undefined;
    private _deleteDisksOnTermination?;
    get deleteDisksOnTermination(): boolean | cdktf.IResolvable;
    set deleteDisksOnTermination(value: boolean | cdktf.IResolvable);
    resetDeleteDisksOnTermination(): void;
    get deleteDisksOnTerminationInput(): boolean | cdktf.IResolvable | undefined;
    private _flavor?;
    get flavor(): string;
    set flavor(value: string);
    get flavorInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageId?;
    get imageId(): string;
    set imageId(value: string);
    get imageIdInput(): string | undefined;
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    resetKeyName(): void;
    get keyNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _securityGroups?;
    get securityGroups(): string[];
    set securityGroups(value: string[]);
    resetSecurityGroups(): void;
    get securityGroupsInput(): string[] | undefined;
    private _systemDiskKmsId?;
    get systemDiskKmsId(): string;
    set systemDiskKmsId(value: string);
    resetSystemDiskKmsId(): void;
    get systemDiskKmsIdInput(): string | undefined;
    private _systemDiskSize?;
    get systemDiskSize(): number;
    set systemDiskSize(value: number);
    resetSystemDiskSize(): void;
    get systemDiskSizeInput(): number | undefined;
    private _systemDiskType?;
    get systemDiskType(): string;
    set systemDiskType(value: string);
    resetSystemDiskType(): void;
    get systemDiskTypeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _dataDisks;
    get dataDisks(): EcsInstanceV1DataDisksList;
    putDataDisks(value: EcsInstanceV1DataDisks[] | cdktf.IResolvable): void;
    resetDataDisks(): void;
    get dataDisksInput(): cdktf.IResolvable | EcsInstanceV1DataDisks[] | undefined;
    private _nics;
    get nics(): EcsInstanceV1NicsList;
    putNics(value: EcsInstanceV1Nics[] | cdktf.IResolvable): void;
    get nicsInput(): cdktf.IResolvable | EcsInstanceV1Nics[] | undefined;
    private _timeouts;
    get timeouts(): EcsInstanceV1TimeoutsOutputReference;
    putTimeouts(value: EcsInstanceV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EcsInstanceV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
