import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FwRuleV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#action FwRuleV2#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#description FwRuleV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#destination_ip_address FwRuleV2#destination_ip_address}
    */
    readonly destinationIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#destination_port FwRuleV2#destination_port}
    */
    readonly destinationPort?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#enabled FwRuleV2#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#id FwRuleV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#ip_version FwRuleV2#ip_version}
    */
    readonly ipVersion?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#name FwRuleV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#protocol FwRuleV2#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#region FwRuleV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#source_ip_address FwRuleV2#source_ip_address}
    */
    readonly sourceIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#source_port FwRuleV2#source_port}
    */
    readonly sourcePort?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#tenant_id FwRuleV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2#value_specs FwRuleV2#value_specs}
    */
    readonly valueSpecs?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2 opentelekomcloud_fw_rule_v2}
*/
export declare class FwRuleV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_fw_rule_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2 opentelekomcloud_fw_rule_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FwRuleV2Config
    */
    constructor(scope: Construct, id: string, config: FwRuleV2Config);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destinationIpAddress?;
    get destinationIpAddress(): string;
    set destinationIpAddress(value: string);
    resetDestinationIpAddress(): void;
    get destinationIpAddressInput(): string | undefined;
    private _destinationPort?;
    get destinationPort(): string;
    set destinationPort(value: string);
    resetDestinationPort(): void;
    get destinationPortInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipVersion?;
    get ipVersion(): number;
    set ipVersion(value: number);
    resetIpVersion(): void;
    get ipVersionInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _sourceIpAddress?;
    get sourceIpAddress(): string;
    set sourceIpAddress(value: string);
    resetSourceIpAddress(): void;
    get sourceIpAddressInput(): string | undefined;
    private _sourcePort?;
    get sourcePort(): string;
    set sourcePort(value: string);
    resetSourcePort(): void;
    get sourcePortInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _valueSpecs?;
    get valueSpecs(): {
        [key: string]: string;
    };
    set valueSpecs(value: {
        [key: string]: string;
    });
    resetValueSpecs(): void;
    get valueSpecsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
