import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityAgencyV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3#delegated_domain_name IdentityAgencyV3#delegated_domain_name}
    */
    readonly delegatedDomainName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3#description IdentityAgencyV3#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3#domain_roles IdentityAgencyV3#domain_roles}
    */
    readonly domainRoles?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3#id IdentityAgencyV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3#name IdentityAgencyV3#name}
    */
    readonly name: string;
    /**
    * project_role block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3#project_role IdentityAgencyV3#project_role}
    */
    readonly projectRole?: IdentityAgencyV3ProjectRole[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3#timeouts IdentityAgencyV3#timeouts}
    */
    readonly timeouts?: IdentityAgencyV3Timeouts;
}
export interface IdentityAgencyV3ProjectRole {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3#project IdentityAgencyV3#project}
    */
    readonly project: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3#roles IdentityAgencyV3#roles}
    */
    readonly roles: string[];
}
export declare function identityAgencyV3ProjectRoleToTerraform(struct?: IdentityAgencyV3ProjectRole | cdktf.IResolvable): any;
export declare class IdentityAgencyV3ProjectRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IdentityAgencyV3ProjectRole | cdktf.IResolvable | undefined;
    set internalValue(value: IdentityAgencyV3ProjectRole | cdktf.IResolvable | undefined);
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    get rolesInput(): string[] | undefined;
}
export declare class IdentityAgencyV3ProjectRoleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IdentityAgencyV3ProjectRole[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IdentityAgencyV3ProjectRoleOutputReference;
}
export interface IdentityAgencyV3Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3#create IdentityAgencyV3#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3#delete IdentityAgencyV3#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3#update IdentityAgencyV3#update}
    */
    readonly update?: string;
}
export declare function identityAgencyV3TimeoutsToTerraform(struct?: IdentityAgencyV3TimeoutsOutputReference | IdentityAgencyV3Timeouts | cdktf.IResolvable): any;
export declare class IdentityAgencyV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IdentityAgencyV3Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IdentityAgencyV3Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3 opentelekomcloud_identity_agency_v3}
*/
export declare class IdentityAgencyV3 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_identity_agency_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3 opentelekomcloud_identity_agency_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityAgencyV3Config
    */
    constructor(scope: Construct, id: string, config: IdentityAgencyV3Config);
    get createTime(): string;
    private _delegatedDomainName?;
    get delegatedDomainName(): string;
    set delegatedDomainName(value: string);
    get delegatedDomainNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _domainRoles?;
    get domainRoles(): string[];
    set domainRoles(value: string[]);
    resetDomainRoles(): void;
    get domainRolesInput(): string[] | undefined;
    get duration(): string;
    get expireTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectRole;
    get projectRole(): IdentityAgencyV3ProjectRoleList;
    putProjectRole(value: IdentityAgencyV3ProjectRole[] | cdktf.IResolvable): void;
    resetProjectRole(): void;
    get projectRoleInput(): cdktf.IResolvable | IdentityAgencyV3ProjectRole[] | undefined;
    private _timeouts;
    get timeouts(): IdentityAgencyV3TimeoutsOutputReference;
    putTimeouts(value: IdentityAgencyV3Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IdentityAgencyV3Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
