import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityMappingV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_mapping_v3#id IdentityMappingV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_mapping_v3#mapping_id IdentityMappingV3#mapping_id}
    */
    readonly mappingId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_mapping_v3#rules IdentityMappingV3#rules}
    */
    readonly rules: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_mapping_v3 opentelekomcloud_identity_mapping_v3}
*/
export declare class IdentityMappingV3 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_identity_mapping_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_mapping_v3 opentelekomcloud_identity_mapping_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityMappingV3Config
    */
    constructor(scope: Construct, id: string, config: IdentityMappingV3Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _links;
    get links(): cdktf.StringMap;
    private _mappingId?;
    get mappingId(): string;
    set mappingId(value: string);
    get mappingIdInput(): string | undefined;
    private _rules?;
    get rules(): string;
    set rules(value: string);
    get rulesInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
