import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityRoleV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#description IdentityRoleV3#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#display_layer IdentityRoleV3#display_layer}
    */
    readonly displayLayer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#display_name IdentityRoleV3#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#id IdentityRoleV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * statement block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#statement IdentityRoleV3#statement}
    */
    readonly statement: IdentityRoleV3Statement[] | cdktf.IResolvable;
}
export interface IdentityRoleV3Statement {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#action IdentityRoleV3#action}
    */
    readonly action: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#effect IdentityRoleV3#effect}
    */
    readonly effect: string;
}
export declare function identityRoleV3StatementToTerraform(struct?: IdentityRoleV3Statement | cdktf.IResolvable): any;
export declare class IdentityRoleV3StatementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IdentityRoleV3Statement | cdktf.IResolvable | undefined;
    set internalValue(value: IdentityRoleV3Statement | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string[];
    set action(value: string[]);
    get actionInput(): string[] | undefined;
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
}
export declare class IdentityRoleV3StatementList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IdentityRoleV3Statement[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IdentityRoleV3StatementOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3 opentelekomcloud_identity_role_v3}
*/
export declare class IdentityRoleV3 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_identity_role_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3 opentelekomcloud_identity_role_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityRoleV3Config
    */
    constructor(scope: Construct, id: string, config: IdentityRoleV3Config);
    get catalog(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _displayLayer?;
    get displayLayer(): string;
    set displayLayer(value: string);
    get displayLayerInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get domainId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _statement;
    get statement(): IdentityRoleV3StatementList;
    putStatement(value: IdentityRoleV3Statement[] | cdktf.IResolvable): void;
    get statementInput(): cdktf.IResolvable | IdentityRoleV3Statement[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
