import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmsGrantV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1#grantee_principal KmsGrantV1#grantee_principal}
    */
    readonly granteePrincipal: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1#id KmsGrantV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1#key_id KmsGrantV1#key_id}
    */
    readonly keyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1#name KmsGrantV1#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1#operations KmsGrantV1#operations}
    */
    readonly operations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1#retiring_principal KmsGrantV1#retiring_principal}
    */
    readonly retiringPrincipal?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1 opentelekomcloud_kms_grant_v1}
*/
export declare class KmsGrantV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_kms_grant_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1 opentelekomcloud_kms_grant_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmsGrantV1Config
    */
    constructor(scope: Construct, id: string, config: KmsGrantV1Config);
    get creationDate(): string;
    private _granteePrincipal?;
    get granteePrincipal(): string;
    set granteePrincipal(value: string);
    get granteePrincipalInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issuingPrincipal(): string;
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    get keyIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _operations?;
    get operations(): string[];
    set operations(value: string[]);
    resetOperations(): void;
    get operationsInput(): string[] | undefined;
    private _retiringPrincipal?;
    get retiringPrincipal(): string;
    set retiringPrincipal(value: string);
    resetRetiringPrincipal(): void;
    get retiringPrincipalInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
