"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LbListenerV3 = exports.LbListenerV3InsertHeadersOutputReference = exports.lbListenerV3InsertHeadersToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function lbListenerV3InsertHeadersToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        forward_elb_ip: cdktf.booleanToTerraform(struct.forwardElbIp),
        forwarded_for_port: cdktf.booleanToTerraform(struct.forwardedForPort),
        forwarded_host: cdktf.booleanToTerraform(struct.forwardedHost),
        forwarded_port: cdktf.booleanToTerraform(struct.forwardedPort),
    };
}
exports.lbListenerV3InsertHeadersToTerraform = lbListenerV3InsertHeadersToTerraform;
class LbListenerV3InsertHeadersOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._forwardElbIp !== undefined) {
            hasAnyValues = true;
            internalValueResult.forwardElbIp = this._forwardElbIp;
        }
        if (this._forwardedForPort !== undefined) {
            hasAnyValues = true;
            internalValueResult.forwardedForPort = this._forwardedForPort;
        }
        if (this._forwardedHost !== undefined) {
            hasAnyValues = true;
            internalValueResult.forwardedHost = this._forwardedHost;
        }
        if (this._forwardedPort !== undefined) {
            hasAnyValues = true;
            internalValueResult.forwardedPort = this._forwardedPort;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._forwardElbIp = undefined;
            this._forwardedForPort = undefined;
            this._forwardedHost = undefined;
            this._forwardedPort = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._forwardElbIp = value.forwardElbIp;
            this._forwardedForPort = value.forwardedForPort;
            this._forwardedHost = value.forwardedHost;
            this._forwardedPort = value.forwardedPort;
        }
    }
    get forwardElbIp() {
        return this.getBooleanAttribute('forward_elb_ip');
    }
    set forwardElbIp(value) {
        this._forwardElbIp = value;
    }
    resetForwardElbIp() {
        this._forwardElbIp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forwardElbIpInput() {
        return this._forwardElbIp;
    }
    get forwardedForPort() {
        return this.getBooleanAttribute('forwarded_for_port');
    }
    set forwardedForPort(value) {
        this._forwardedForPort = value;
    }
    resetForwardedForPort() {
        this._forwardedForPort = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forwardedForPortInput() {
        return this._forwardedForPort;
    }
    get forwardedHost() {
        return this.getBooleanAttribute('forwarded_host');
    }
    set forwardedHost(value) {
        this._forwardedHost = value;
    }
    resetForwardedHost() {
        this._forwardedHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forwardedHostInput() {
        return this._forwardedHost;
    }
    get forwardedPort() {
        return this.getBooleanAttribute('forwarded_port');
    }
    set forwardedPort(value) {
        this._forwardedPort = value;
    }
    resetForwardedPort() {
        this._forwardedPort = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forwardedPortInput() {
        return this._forwardedPort;
    }
}
exports.LbListenerV3InsertHeadersOutputReference = LbListenerV3InsertHeadersOutputReference;
_a = JSII_RTTI_SYMBOL_1;
LbListenerV3InsertHeadersOutputReference[_a] = { fqn: "@cdktf/provider-opentelekomcloud.LbListenerV3InsertHeadersOutputReference", version: "0.5.33" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3 opentelekomcloud_lb_listener_v3}
*/
class LbListenerV3 extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3 opentelekomcloud_lb_listener_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbListenerV3Config
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'opentelekomcloud_lb_listener_v3',
            terraformGeneratorMetadata: {
                providerName: 'opentelekomcloud',
                providerVersion: '1.29.6',
                providerVersionConstraint: '~> 1.26'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // insert_headers - computed: false, optional: true, required: false
        this._insertHeaders = new LbListenerV3InsertHeadersOutputReference(this, "insert_headers");
        this._adminStateUp = config.adminStateUp;
        this._clientCaTlsContainerRef = config.clientCaTlsContainerRef;
        this._clientTimeout = config.clientTimeout;
        this._defaultPoolId = config.defaultPoolId;
        this._defaultTlsContainerRef = config.defaultTlsContainerRef;
        this._description = config.description;
        this._http2Enable = config.http2Enable;
        this._id = config.id;
        this._keepAliveTimeout = config.keepAliveTimeout;
        this._loadbalancerId = config.loadbalancerId;
        this._memberRetryEnable = config.memberRetryEnable;
        this._memberTimeout = config.memberTimeout;
        this._name = config.name;
        this._protocol = config.protocol;
        this._protocolPort = config.protocolPort;
        this._sniContainerRefs = config.sniContainerRefs;
        this._tags = config.tags;
        this._tlsCiphersPolicy = config.tlsCiphersPolicy;
        this._insertHeaders.internalValue = config.insertHeaders;
    }
    get adminStateUp() {
        return this.getBooleanAttribute('admin_state_up');
    }
    set adminStateUp(value) {
        this._adminStateUp = value;
    }
    resetAdminStateUp() {
        this._adminStateUp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get adminStateUpInput() {
        return this._adminStateUp;
    }
    get clientCaTlsContainerRef() {
        return this.getStringAttribute('client_ca_tls_container_ref');
    }
    set clientCaTlsContainerRef(value) {
        this._clientCaTlsContainerRef = value;
    }
    resetClientCaTlsContainerRef() {
        this._clientCaTlsContainerRef = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCaTlsContainerRefInput() {
        return this._clientCaTlsContainerRef;
    }
    get clientTimeout() {
        return this.getNumberAttribute('client_timeout');
    }
    set clientTimeout(value) {
        this._clientTimeout = value;
    }
    resetClientTimeout() {
        this._clientTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientTimeoutInput() {
        return this._clientTimeout;
    }
    // created_at - computed: true, optional: false, required: false
    get createdAt() {
        return this.getStringAttribute('created_at');
    }
    get defaultPoolId() {
        return this.getStringAttribute('default_pool_id');
    }
    set defaultPoolId(value) {
        this._defaultPoolId = value;
    }
    resetDefaultPoolId() {
        this._defaultPoolId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultPoolIdInput() {
        return this._defaultPoolId;
    }
    get defaultTlsContainerRef() {
        return this.getStringAttribute('default_tls_container_ref');
    }
    set defaultTlsContainerRef(value) {
        this._defaultTlsContainerRef = value;
    }
    resetDefaultTlsContainerRef() {
        this._defaultTlsContainerRef = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultTlsContainerRefInput() {
        return this._defaultTlsContainerRef;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get http2Enable() {
        return this.getBooleanAttribute('http2_enable');
    }
    set http2Enable(value) {
        this._http2Enable = value;
    }
    resetHttp2Enable() {
        this._http2Enable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get http2EnableInput() {
        return this._http2Enable;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get keepAliveTimeout() {
        return this.getNumberAttribute('keep_alive_timeout');
    }
    set keepAliveTimeout(value) {
        this._keepAliveTimeout = value;
    }
    resetKeepAliveTimeout() {
        this._keepAliveTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepAliveTimeoutInput() {
        return this._keepAliveTimeout;
    }
    get loadbalancerId() {
        return this.getStringAttribute('loadbalancer_id');
    }
    set loadbalancerId(value) {
        this._loadbalancerId = value;
    }
    // Temporarily expose input value. Use with caution.
    get loadbalancerIdInput() {
        return this._loadbalancerId;
    }
    get memberRetryEnable() {
        return this.getBooleanAttribute('member_retry_enable');
    }
    set memberRetryEnable(value) {
        this._memberRetryEnable = value;
    }
    resetMemberRetryEnable() {
        this._memberRetryEnable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memberRetryEnableInput() {
        return this._memberRetryEnable;
    }
    get memberTimeout() {
        return this.getNumberAttribute('member_timeout');
    }
    set memberTimeout(value) {
        this._memberTimeout = value;
    }
    resetMemberTimeout() {
        this._memberTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memberTimeoutInput() {
        return this._memberTimeout;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    resetName() {
        this._name = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get protocol() {
        return this.getStringAttribute('protocol');
    }
    set protocol(value) {
        this._protocol = value;
    }
    // Temporarily expose input value. Use with caution.
    get protocolInput() {
        return this._protocol;
    }
    get protocolPort() {
        return this.getNumberAttribute('protocol_port');
    }
    set protocolPort(value) {
        this._protocolPort = value;
    }
    // Temporarily expose input value. Use with caution.
    get protocolPortInput() {
        return this._protocolPort;
    }
    get sniContainerRefs() {
        return cdktf.Fn.tolist(this.getListAttribute('sni_container_refs'));
    }
    set sniContainerRefs(value) {
        this._sniContainerRefs = value;
    }
    resetSniContainerRefs() {
        this._sniContainerRefs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sniContainerRefsInput() {
        return this._sniContainerRefs;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get tlsCiphersPolicy() {
        return this.getStringAttribute('tls_ciphers_policy');
    }
    set tlsCiphersPolicy(value) {
        this._tlsCiphersPolicy = value;
    }
    resetTlsCiphersPolicy() {
        this._tlsCiphersPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsCiphersPolicyInput() {
        return this._tlsCiphersPolicy;
    }
    // updated_at - computed: true, optional: false, required: false
    get updatedAt() {
        return this.getStringAttribute('updated_at');
    }
    get insertHeaders() {
        return this._insertHeaders;
    }
    putInsertHeaders(value) {
        this._insertHeaders.internalValue = value;
    }
    resetInsertHeaders() {
        this._insertHeaders.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insertHeadersInput() {
        return this._insertHeaders.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            admin_state_up: cdktf.booleanToTerraform(this._adminStateUp),
            client_ca_tls_container_ref: cdktf.stringToTerraform(this._clientCaTlsContainerRef),
            client_timeout: cdktf.numberToTerraform(this._clientTimeout),
            default_pool_id: cdktf.stringToTerraform(this._defaultPoolId),
            default_tls_container_ref: cdktf.stringToTerraform(this._defaultTlsContainerRef),
            description: cdktf.stringToTerraform(this._description),
            http2_enable: cdktf.booleanToTerraform(this._http2Enable),
            id: cdktf.stringToTerraform(this._id),
            keep_alive_timeout: cdktf.numberToTerraform(this._keepAliveTimeout),
            loadbalancer_id: cdktf.stringToTerraform(this._loadbalancerId),
            member_retry_enable: cdktf.booleanToTerraform(this._memberRetryEnable),
            member_timeout: cdktf.numberToTerraform(this._memberTimeout),
            name: cdktf.stringToTerraform(this._name),
            protocol: cdktf.stringToTerraform(this._protocol),
            protocol_port: cdktf.numberToTerraform(this._protocolPort),
            sni_container_refs: cdktf.listMapper(cdktf.stringToTerraform)(this._sniContainerRefs),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            tls_ciphers_policy: cdktf.stringToTerraform(this._tlsCiphersPolicy),
            insert_headers: lbListenerV3InsertHeadersToTerraform(this._insertHeaders.internalValue),
        };
    }
}
exports.LbListenerV3 = LbListenerV3;
_b = JSII_RTTI_SYMBOL_1;
LbListenerV3[_b] = { fqn: "@cdktf/provider-opentelekomcloud.LbListenerV3", version: "0.5.33" };
// =================
// STATIC PROPERTIES
// =================
LbListenerV3.tfResourceType = "opentelekomcloud_lb_listener_v3";
//# sourceMappingURL=data:application/json;base64,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