import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbLoadbalancerV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#admin_state_up LbLoadbalancerV3#admin_state_up}
    */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#availability_zones LbLoadbalancerV3#availability_zones}
    */
    readonly availabilityZones: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#description LbLoadbalancerV3#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#id LbLoadbalancerV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#ip_target_enable LbLoadbalancerV3#ip_target_enable}
    */
    readonly ipTargetEnable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#l4_flavor LbLoadbalancerV3#l4_flavor}
    */
    readonly l4Flavor?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#l7_flavor LbLoadbalancerV3#l7_flavor}
    */
    readonly l7Flavor?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#name LbLoadbalancerV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#network_ids LbLoadbalancerV3#network_ids}
    */
    readonly networkIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#router_id LbLoadbalancerV3#router_id}
    */
    readonly routerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#subnet_id LbLoadbalancerV3#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#tags LbLoadbalancerV3#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#vip_address LbLoadbalancerV3#vip_address}
    */
    readonly vipAddress?: string;
    /**
    * public_ip block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#public_ip LbLoadbalancerV3#public_ip}
    */
    readonly publicIp?: LbLoadbalancerV3PublicIp;
}
export interface LbLoadbalancerV3PublicIp {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#bandwidth_charge_mode LbLoadbalancerV3#bandwidth_charge_mode}
    */
    readonly bandwidthChargeMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#bandwidth_name LbLoadbalancerV3#bandwidth_name}
    */
    readonly bandwidthName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#bandwidth_share_type LbLoadbalancerV3#bandwidth_share_type}
    */
    readonly bandwidthShareType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#bandwidth_size LbLoadbalancerV3#bandwidth_size}
    */
    readonly bandwidthSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#id LbLoadbalancerV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3#ip_type LbLoadbalancerV3#ip_type}
    */
    readonly ipType?: string;
}
export declare function lbLoadbalancerV3PublicIpToTerraform(struct?: LbLoadbalancerV3PublicIpOutputReference | LbLoadbalancerV3PublicIp): any;
export declare class LbLoadbalancerV3PublicIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbLoadbalancerV3PublicIp | undefined;
    set internalValue(value: LbLoadbalancerV3PublicIp | undefined);
    get managed(): cdktf.IResolvable;
    get address(): string;
    private _bandwidthChargeMode?;
    get bandwidthChargeMode(): string;
    set bandwidthChargeMode(value: string);
    resetBandwidthChargeMode(): void;
    get bandwidthChargeModeInput(): string | undefined;
    private _bandwidthName?;
    get bandwidthName(): string;
    set bandwidthName(value: string);
    resetBandwidthName(): void;
    get bandwidthNameInput(): string | undefined;
    private _bandwidthShareType?;
    get bandwidthShareType(): string;
    set bandwidthShareType(value: string);
    resetBandwidthShareType(): void;
    get bandwidthShareTypeInput(): string | undefined;
    private _bandwidthSize?;
    get bandwidthSize(): number;
    set bandwidthSize(value: number);
    resetBandwidthSize(): void;
    get bandwidthSizeInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipType?;
    get ipType(): string;
    set ipType(value: string);
    resetIpType(): void;
    get ipTypeInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3 opentelekomcloud_lb_loadbalancer_v3}
*/
export declare class LbLoadbalancerV3 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_lb_loadbalancer_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3 opentelekomcloud_lb_loadbalancer_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbLoadbalancerV3Config
    */
    constructor(scope: Construct, id: string, config: LbLoadbalancerV3Config);
    private _adminStateUp?;
    get adminStateUp(): boolean | cdktf.IResolvable;
    set adminStateUp(value: boolean | cdktf.IResolvable);
    resetAdminStateUp(): void;
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _availabilityZones?;
    get availabilityZones(): string[];
    set availabilityZones(value: string[]);
    get availabilityZonesInput(): string[] | undefined;
    get createdAt(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipTargetEnable?;
    get ipTargetEnable(): boolean | cdktf.IResolvable;
    set ipTargetEnable(value: boolean | cdktf.IResolvable);
    resetIpTargetEnable(): void;
    get ipTargetEnableInput(): boolean | cdktf.IResolvable | undefined;
    private _l4Flavor?;
    get l4Flavor(): string;
    set l4Flavor(value: string);
    resetL4Flavor(): void;
    get l4FlavorInput(): string | undefined;
    private _l7Flavor?;
    get l7Flavor(): string;
    set l7Flavor(value: string);
    resetL7Flavor(): void;
    get l7FlavorInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _networkIds?;
    get networkIds(): string[];
    set networkIds(value: string[]);
    get networkIdsInput(): string[] | undefined;
    private _routerId?;
    get routerId(): string;
    set routerId(value: string);
    resetRouterId(): void;
    get routerIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get updatedAt(): string;
    private _vipAddress?;
    get vipAddress(): string;
    set vipAddress(value: string);
    resetVipAddress(): void;
    get vipAddressInput(): string | undefined;
    get vipPortId(): string;
    private _publicIp;
    get publicIp(): LbLoadbalancerV3PublicIpOutputReference;
    putPublicIp(value: LbLoadbalancerV3PublicIp): void;
    resetPublicIp(): void;
    get publicIpInput(): LbLoadbalancerV3PublicIp | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
