import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogtankTopicV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/logtank_topic_v2#group_id LogtankTopicV2#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/logtank_topic_v2#id LogtankTopicV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/logtank_topic_v2#topic_name LogtankTopicV2#topic_name}
    */
    readonly topicName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/logtank_topic_v2 opentelekomcloud_logtank_topic_v2}
*/
export declare class LogtankTopicV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_logtank_topic_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/logtank_topic_v2 opentelekomcloud_logtank_topic_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogtankTopicV2Config
    */
    constructor(scope: Construct, id: string, config: LogtankTopicV2Config);
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get indexEnabled(): cdktf.IResolvable;
    private _topicName?;
    get topicName(): string;
    set topicName(value: string);
    get topicNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
