import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MrsClusterV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#available_zone_id MrsClusterV1#available_zone_id}
    */
    readonly availableZoneId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#billing_type MrsClusterV1#billing_type}
    */
    readonly billingType: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#cluster_admin_secret MrsClusterV1#cluster_admin_secret}
    */
    readonly clusterAdminSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#cluster_name MrsClusterV1#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#cluster_type MrsClusterV1#cluster_type}
    */
    readonly clusterType?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#cluster_version MrsClusterV1#cluster_version}
    */
    readonly clusterVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#core_data_volume_count MrsClusterV1#core_data_volume_count}
    */
    readonly coreDataVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#core_data_volume_size MrsClusterV1#core_data_volume_size}
    */
    readonly coreDataVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#core_data_volume_type MrsClusterV1#core_data_volume_type}
    */
    readonly coreDataVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#core_node_num MrsClusterV1#core_node_num}
    */
    readonly coreNodeNum: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#core_node_size MrsClusterV1#core_node_size}
    */
    readonly coreNodeSize: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#id MrsClusterV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#log_collection MrsClusterV1#log_collection}
    */
    readonly logCollection?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#master_data_volume_count MrsClusterV1#master_data_volume_count}
    */
    readonly masterDataVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#master_data_volume_size MrsClusterV1#master_data_volume_size}
    */
    readonly masterDataVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#master_data_volume_type MrsClusterV1#master_data_volume_type}
    */
    readonly masterDataVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#master_node_num MrsClusterV1#master_node_num}
    */
    readonly masterNodeNum: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#master_node_size MrsClusterV1#master_node_size}
    */
    readonly masterNodeSize: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#node_public_cert_name MrsClusterV1#node_public_cert_name}
    */
    readonly nodePublicCertName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#region MrsClusterV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#safe_mode MrsClusterV1#safe_mode}
    */
    readonly safeMode: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#subnet_id MrsClusterV1#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#tags MrsClusterV1#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#volume_size MrsClusterV1#volume_size}
    */
    readonly volumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#volume_type MrsClusterV1#volume_type}
    */
    readonly volumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#vpc_id MrsClusterV1#vpc_id}
    */
    readonly vpcId: string;
    /**
    * add_jobs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#add_jobs MrsClusterV1#add_jobs}
    */
    readonly addJobs?: MrsClusterV1AddJobs[] | cdktf.IResolvable;
    /**
    * bootstrap_scripts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#bootstrap_scripts MrsClusterV1#bootstrap_scripts}
    */
    readonly bootstrapScripts?: MrsClusterV1BootstrapScripts[] | cdktf.IResolvable;
    /**
    * component_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#component_list MrsClusterV1#component_list}
    */
    readonly componentList: MrsClusterV1ComponentList[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#timeouts MrsClusterV1#timeouts}
    */
    readonly timeouts?: MrsClusterV1Timeouts;
}
export interface MrsClusterV1AddJobs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#arguments MrsClusterV1#arguments}
    */
    readonly arguments?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#file_action MrsClusterV1#file_action}
    */
    readonly fileAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#hive_script_path MrsClusterV1#hive_script_path}
    */
    readonly hiveScriptPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#hql MrsClusterV1#hql}
    */
    readonly hql?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#input MrsClusterV1#input}
    */
    readonly input?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#jar_path MrsClusterV1#jar_path}
    */
    readonly jarPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#job_log MrsClusterV1#job_log}
    */
    readonly jobLog?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#job_name MrsClusterV1#job_name}
    */
    readonly jobName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#job_type MrsClusterV1#job_type}
    */
    readonly jobType: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#output MrsClusterV1#output}
    */
    readonly output?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#shutdown_cluster MrsClusterV1#shutdown_cluster}
    */
    readonly shutdownCluster?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#submit_job_once_cluster_run MrsClusterV1#submit_job_once_cluster_run}
    */
    readonly submitJobOnceClusterRun: boolean | cdktf.IResolvable;
}
export declare function mrsClusterV1AddJobsToTerraform(struct?: MrsClusterV1AddJobs | cdktf.IResolvable): any;
export declare class MrsClusterV1AddJobsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrsClusterV1AddJobs | cdktf.IResolvable | undefined;
    set internalValue(value: MrsClusterV1AddJobs | cdktf.IResolvable | undefined);
    private _arguments?;
    get arguments(): string;
    set arguments(value: string);
    resetArguments(): void;
    get argumentsInput(): string | undefined;
    private _fileAction?;
    get fileAction(): string;
    set fileAction(value: string);
    resetFileAction(): void;
    get fileActionInput(): string | undefined;
    private _hiveScriptPath?;
    get hiveScriptPath(): string;
    set hiveScriptPath(value: string);
    resetHiveScriptPath(): void;
    get hiveScriptPathInput(): string | undefined;
    private _hql?;
    get hql(): string;
    set hql(value: string);
    resetHql(): void;
    get hqlInput(): string | undefined;
    private _input?;
    get input(): string;
    set input(value: string);
    resetInput(): void;
    get inputInput(): string | undefined;
    private _jarPath?;
    get jarPath(): string;
    set jarPath(value: string);
    get jarPathInput(): string | undefined;
    private _jobLog?;
    get jobLog(): string;
    set jobLog(value: string);
    resetJobLog(): void;
    get jobLogInput(): string | undefined;
    private _jobName?;
    get jobName(): string;
    set jobName(value: string);
    get jobNameInput(): string | undefined;
    private _jobType?;
    get jobType(): number;
    set jobType(value: number);
    get jobTypeInput(): number | undefined;
    private _output?;
    get output(): string;
    set output(value: string);
    resetOutput(): void;
    get outputInput(): string | undefined;
    private _shutdownCluster?;
    get shutdownCluster(): boolean | cdktf.IResolvable;
    set shutdownCluster(value: boolean | cdktf.IResolvable);
    resetShutdownCluster(): void;
    get shutdownClusterInput(): boolean | cdktf.IResolvable | undefined;
    private _submitJobOnceClusterRun?;
    get submitJobOnceClusterRun(): boolean | cdktf.IResolvable;
    set submitJobOnceClusterRun(value: boolean | cdktf.IResolvable);
    get submitJobOnceClusterRunInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class MrsClusterV1AddJobsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrsClusterV1AddJobs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrsClusterV1AddJobsOutputReference;
}
export interface MrsClusterV1BootstrapScripts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#active_master MrsClusterV1#active_master}
    */
    readonly activeMaster?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#before_component_start MrsClusterV1#before_component_start}
    */
    readonly beforeComponentStart?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#fail_action MrsClusterV1#fail_action}
    */
    readonly failAction: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#name MrsClusterV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#nodes MrsClusterV1#nodes}
    */
    readonly nodes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#parameters MrsClusterV1#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#uri MrsClusterV1#uri}
    */
    readonly uri: string;
}
export declare function mrsClusterV1BootstrapScriptsToTerraform(struct?: MrsClusterV1BootstrapScripts | cdktf.IResolvable): any;
export declare class MrsClusterV1BootstrapScriptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrsClusterV1BootstrapScripts | cdktf.IResolvable | undefined;
    set internalValue(value: MrsClusterV1BootstrapScripts | cdktf.IResolvable | undefined);
    private _activeMaster?;
    get activeMaster(): boolean | cdktf.IResolvable;
    set activeMaster(value: boolean | cdktf.IResolvable);
    resetActiveMaster(): void;
    get activeMasterInput(): boolean | cdktf.IResolvable | undefined;
    private _beforeComponentStart?;
    get beforeComponentStart(): boolean | cdktf.IResolvable;
    set beforeComponentStart(value: boolean | cdktf.IResolvable);
    resetBeforeComponentStart(): void;
    get beforeComponentStartInput(): boolean | cdktf.IResolvable | undefined;
    private _failAction?;
    get failAction(): string;
    set failAction(value: string);
    get failActionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodes?;
    get nodes(): string[];
    set nodes(value: string[]);
    get nodesInput(): string[] | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class MrsClusterV1BootstrapScriptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrsClusterV1BootstrapScripts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrsClusterV1BootstrapScriptsOutputReference;
}
export interface MrsClusterV1ComponentList {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#component_name MrsClusterV1#component_name}
    */
    readonly componentName: string;
}
export declare function mrsClusterV1ComponentListToTerraform(struct?: MrsClusterV1ComponentList | cdktf.IResolvable): any;
export declare class MrsClusterV1ComponentListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrsClusterV1ComponentList | cdktf.IResolvable | undefined;
    set internalValue(value: MrsClusterV1ComponentList | cdktf.IResolvable | undefined);
    get componentDesc(): string;
    get componentId(): string;
    private _componentName?;
    get componentName(): string;
    set componentName(value: string);
    get componentNameInput(): string | undefined;
    get componentVersion(): string;
}
export declare class MrsClusterV1ComponentListList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrsClusterV1ComponentList[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrsClusterV1ComponentListOutputReference;
}
export interface MrsClusterV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#create MrsClusterV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#delete MrsClusterV1#delete}
    */
    readonly delete?: string;
}
export declare function mrsClusterV1TimeoutsToTerraform(struct?: MrsClusterV1TimeoutsOutputReference | MrsClusterV1Timeouts | cdktf.IResolvable): any;
export declare class MrsClusterV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MrsClusterV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MrsClusterV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1 opentelekomcloud_mrs_cluster_v1}
*/
export declare class MrsClusterV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_mrs_cluster_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1 opentelekomcloud_mrs_cluster_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MrsClusterV1Config
    */
    constructor(scope: Construct, id: string, config: MrsClusterV1Config);
    private _availableZoneId?;
    get availableZoneId(): string;
    set availableZoneId(value: string);
    get availableZoneIdInput(): string | undefined;
    get availableZoneName(): string;
    private _billingType?;
    get billingType(): number;
    set billingType(value: number);
    get billingTypeInput(): number | undefined;
    get chargingStartTime(): string;
    private _clusterAdminSecret?;
    get clusterAdminSecret(): string;
    set clusterAdminSecret(value: string);
    resetClusterAdminSecret(): void;
    get clusterAdminSecretInput(): string | undefined;
    get clusterId(): string;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    get clusterState(): string;
    private _clusterType?;
    get clusterType(): number;
    set clusterType(value: number);
    resetClusterType(): void;
    get clusterTypeInput(): number | undefined;
    private _clusterVersion?;
    get clusterVersion(): string;
    set clusterVersion(value: string);
    get clusterVersionInput(): string | undefined;
    private _coreDataVolumeCount?;
    get coreDataVolumeCount(): number;
    set coreDataVolumeCount(value: number);
    resetCoreDataVolumeCount(): void;
    get coreDataVolumeCountInput(): number | undefined;
    private _coreDataVolumeSize?;
    get coreDataVolumeSize(): number;
    set coreDataVolumeSize(value: number);
    resetCoreDataVolumeSize(): void;
    get coreDataVolumeSizeInput(): number | undefined;
    private _coreDataVolumeType?;
    get coreDataVolumeType(): string;
    set coreDataVolumeType(value: string);
    resetCoreDataVolumeType(): void;
    get coreDataVolumeTypeInput(): string | undefined;
    private _coreNodeNum?;
    get coreNodeNum(): number;
    set coreNodeNum(value: number);
    get coreNodeNumInput(): number | undefined;
    get coreNodeProductId(): string;
    private _coreNodeSize?;
    get coreNodeSize(): string;
    set coreNodeSize(value: string);
    get coreNodeSizeInput(): string | undefined;
    get coreNodeSpecId(): string;
    get createAt(): string;
    get deploymentId(): string;
    get duration(): string;
    get errorInfo(): string;
    get externalAlternateIp(): string;
    get externalIp(): string;
    get fee(): string;
    get hadoopVersion(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instanceId(): string;
    get internalIp(): string;
    private _logCollection?;
    get logCollection(): number;
    set logCollection(value: number);
    resetLogCollection(): void;
    get logCollectionInput(): number | undefined;
    private _masterDataVolumeCount?;
    get masterDataVolumeCount(): number;
    set masterDataVolumeCount(value: number);
    resetMasterDataVolumeCount(): void;
    get masterDataVolumeCountInput(): number | undefined;
    private _masterDataVolumeSize?;
    get masterDataVolumeSize(): number;
    set masterDataVolumeSize(value: number);
    resetMasterDataVolumeSize(): void;
    get masterDataVolumeSizeInput(): number | undefined;
    private _masterDataVolumeType?;
    get masterDataVolumeType(): string;
    set masterDataVolumeType(value: string);
    resetMasterDataVolumeType(): void;
    get masterDataVolumeTypeInput(): string | undefined;
    get masterNodeIp(): string;
    private _masterNodeNum?;
    get masterNodeNum(): number;
    set masterNodeNum(value: number);
    get masterNodeNumInput(): number | undefined;
    get masterNodeProductId(): string;
    private _masterNodeSize?;
    get masterNodeSize(): string;
    set masterNodeSize(value: string);
    get masterNodeSizeInput(): string | undefined;
    get masterNodeSpecId(): string;
    private _nodePublicCertName?;
    get nodePublicCertName(): string;
    set nodePublicCertName(value: string);
    get nodePublicCertNameInput(): string | undefined;
    get orderId(): string;
    get privateIpFirst(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get remark(): string;
    private _safeMode?;
    get safeMode(): number;
    set safeMode(value: number);
    get safeModeInput(): number | undefined;
    get securityGroupsId(): string;
    get slaveSecurityGroupsId(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get tenantId(): string;
    get updateAt(): string;
    get vnc(): string;
    private _volumeSize?;
    get volumeSize(): number;
    set volumeSize(value: number);
    resetVolumeSize(): void;
    get volumeSizeInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _addJobs;
    get addJobs(): MrsClusterV1AddJobsList;
    putAddJobs(value: MrsClusterV1AddJobs[] | cdktf.IResolvable): void;
    resetAddJobs(): void;
    get addJobsInput(): cdktf.IResolvable | MrsClusterV1AddJobs[] | undefined;
    private _bootstrapScripts;
    get bootstrapScripts(): MrsClusterV1BootstrapScriptsList;
    putBootstrapScripts(value: MrsClusterV1BootstrapScripts[] | cdktf.IResolvable): void;
    resetBootstrapScripts(): void;
    get bootstrapScriptsInput(): cdktf.IResolvable | MrsClusterV1BootstrapScripts[] | undefined;
    private _componentList;
    get componentList(): MrsClusterV1ComponentListList;
    putComponentList(value: MrsClusterV1ComponentList[] | cdktf.IResolvable): void;
    get componentListInput(): cdktf.IResolvable | MrsClusterV1ComponentList[] | undefined;
    private _timeouts;
    get timeouts(): MrsClusterV1TimeoutsOutputReference;
    putTimeouts(value: MrsClusterV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MrsClusterV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
