import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MrsJobV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#arguments MrsJobV1#arguments}
    */
    readonly arguments?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#cluster_id MrsJobV1#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#hive_script_path MrsJobV1#hive_script_path}
    */
    readonly hiveScriptPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#id MrsJobV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#input MrsJobV1#input}
    */
    readonly input?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#is_protected MrsJobV1#is_protected}
    */
    readonly isProtected?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#is_public MrsJobV1#is_public}
    */
    readonly isPublic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#jar_path MrsJobV1#jar_path}
    */
    readonly jarPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#job_log MrsJobV1#job_log}
    */
    readonly jobLog?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#job_name MrsJobV1#job_name}
    */
    readonly jobName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#job_type MrsJobV1#job_type}
    */
    readonly jobType: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#output MrsJobV1#output}
    */
    readonly output?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#region MrsJobV1#region}
    */
    readonly region?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#timeouts MrsJobV1#timeouts}
    */
    readonly timeouts?: MrsJobV1Timeouts;
}
export interface MrsJobV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#create MrsJobV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#delete MrsJobV1#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1#update MrsJobV1#update}
    */
    readonly update?: string;
}
export declare function mrsJobV1TimeoutsToTerraform(struct?: MrsJobV1TimeoutsOutputReference | MrsJobV1Timeouts | cdktf.IResolvable): any;
export declare class MrsJobV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MrsJobV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MrsJobV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1 opentelekomcloud_mrs_job_v1}
*/
export declare class MrsJobV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_mrs_job_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1 opentelekomcloud_mrs_job_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MrsJobV1Config
    */
    constructor(scope: Construct, id: string, config: MrsJobV1Config);
    private _arguments?;
    get arguments(): string;
    set arguments(value: string);
    resetArguments(): void;
    get argumentsInput(): string | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _hiveScriptPath?;
    get hiveScriptPath(): string;
    set hiveScriptPath(value: string);
    resetHiveScriptPath(): void;
    get hiveScriptPathInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _input?;
    get input(): string;
    set input(value: string);
    resetInput(): void;
    get inputInput(): string | undefined;
    private _isProtected?;
    get isProtected(): boolean | cdktf.IResolvable;
    set isProtected(value: boolean | cdktf.IResolvable);
    resetIsProtected(): void;
    get isProtectedInput(): boolean | cdktf.IResolvable | undefined;
    private _isPublic?;
    get isPublic(): boolean | cdktf.IResolvable;
    set isPublic(value: boolean | cdktf.IResolvable);
    resetIsPublic(): void;
    get isPublicInput(): boolean | cdktf.IResolvable | undefined;
    private _jarPath?;
    get jarPath(): string;
    set jarPath(value: string);
    get jarPathInput(): string | undefined;
    private _jobLog?;
    get jobLog(): string;
    set jobLog(value: string);
    resetJobLog(): void;
    get jobLogInput(): string | undefined;
    private _jobName?;
    get jobName(): string;
    set jobName(value: string);
    get jobNameInput(): string | undefined;
    get jobState(): string;
    private _jobType?;
    get jobType(): number;
    set jobType(value: number);
    get jobTypeInput(): number | undefined;
    private _output?;
    get output(): string;
    set output(value: string);
    resetOutput(): void;
    get outputInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _timeouts;
    get timeouts(): MrsJobV1TimeoutsOutputReference;
    putTimeouts(value: MrsJobV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MrsJobV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
