import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NatDnatRuleV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2#external_service_port NatDnatRuleV2#external_service_port}
    */
    readonly externalServicePort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2#floating_ip_id NatDnatRuleV2#floating_ip_id}
    */
    readonly floatingIpId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2#id NatDnatRuleV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2#internal_service_port NatDnatRuleV2#internal_service_port}
    */
    readonly internalServicePort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2#nat_gateway_id NatDnatRuleV2#nat_gateway_id}
    */
    readonly natGatewayId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2#port_id NatDnatRuleV2#port_id}
    */
    readonly portId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2#private_ip NatDnatRuleV2#private_ip}
    */
    readonly privateIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2#protocol NatDnatRuleV2#protocol}
    */
    readonly protocol: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2#timeouts NatDnatRuleV2#timeouts}
    */
    readonly timeouts?: NatDnatRuleV2Timeouts;
}
export interface NatDnatRuleV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2#create NatDnatRuleV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2#delete NatDnatRuleV2#delete}
    */
    readonly delete?: string;
}
export declare function natDnatRuleV2TimeoutsToTerraform(struct?: NatDnatRuleV2TimeoutsOutputReference | NatDnatRuleV2Timeouts | cdktf.IResolvable): any;
export declare class NatDnatRuleV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NatDnatRuleV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NatDnatRuleV2Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2 opentelekomcloud_nat_dnat_rule_v2}
*/
export declare class NatDnatRuleV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_nat_dnat_rule_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2 opentelekomcloud_nat_dnat_rule_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NatDnatRuleV2Config
    */
    constructor(scope: Construct, id: string, config: NatDnatRuleV2Config);
    get createdAt(): string;
    private _externalServicePort?;
    get externalServicePort(): number;
    set externalServicePort(value: number);
    get externalServicePortInput(): number | undefined;
    get floatingIpAddress(): string;
    private _floatingIpId?;
    get floatingIpId(): string;
    set floatingIpId(value: string);
    get floatingIpIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _internalServicePort?;
    get internalServicePort(): number;
    set internalServicePort(value: number);
    get internalServicePortInput(): number | undefined;
    private _natGatewayId?;
    get natGatewayId(): string;
    set natGatewayId(value: string);
    get natGatewayIdInput(): string | undefined;
    private _portId?;
    get portId(): string;
    set portId(value: string);
    resetPortId(): void;
    get portIdInput(): string | undefined;
    private _privateIp?;
    get privateIp(): string;
    set privateIp(value: string);
    resetPrivateIp(): void;
    get privateIpInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    get status(): string;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): NatDnatRuleV2TimeoutsOutputReference;
    putTimeouts(value: NatDnatRuleV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NatDnatRuleV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
