import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NatSnatRuleV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2#cidr NatSnatRuleV2#cidr}
    */
    readonly cidr?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2#floating_ip_id NatSnatRuleV2#floating_ip_id}
    */
    readonly floatingIpId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2#id NatSnatRuleV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2#nat_gateway_id NatSnatRuleV2#nat_gateway_id}
    */
    readonly natGatewayId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2#network_id NatSnatRuleV2#network_id}
    */
    readonly networkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2#region NatSnatRuleV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2#source_type NatSnatRuleV2#source_type}
    */
    readonly sourceType?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2#timeouts NatSnatRuleV2#timeouts}
    */
    readonly timeouts?: NatSnatRuleV2Timeouts;
}
export interface NatSnatRuleV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2#create NatSnatRuleV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2#delete NatSnatRuleV2#delete}
    */
    readonly delete?: string;
}
export declare function natSnatRuleV2TimeoutsToTerraform(struct?: NatSnatRuleV2TimeoutsOutputReference | NatSnatRuleV2Timeouts | cdktf.IResolvable): any;
export declare class NatSnatRuleV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NatSnatRuleV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NatSnatRuleV2Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2 opentelekomcloud_nat_snat_rule_v2}
*/
export declare class NatSnatRuleV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_nat_snat_rule_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2 opentelekomcloud_nat_snat_rule_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NatSnatRuleV2Config
    */
    constructor(scope: Construct, id: string, config: NatSnatRuleV2Config);
    private _cidr?;
    get cidr(): string;
    set cidr(value: string);
    resetCidr(): void;
    get cidrInput(): string | undefined;
    private _floatingIpId?;
    get floatingIpId(): string;
    set floatingIpId(value: string);
    get floatingIpIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _natGatewayId?;
    get natGatewayId(): string;
    set natGatewayId(value: string);
    get natGatewayIdInput(): string | undefined;
    private _networkId?;
    get networkId(): string;
    set networkId(value: string);
    resetNetworkId(): void;
    get networkIdInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _sourceType?;
    get sourceType(): number;
    set sourceType(value: number);
    resetSourceType(): void;
    get sourceTypeInput(): number | undefined;
    private _timeouts;
    get timeouts(): NatSnatRuleV2TimeoutsOutputReference;
    putTimeouts(value: NatSnatRuleV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NatSnatRuleV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
