import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkingFloatingipAssociateV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2#floating_ip NetworkingFloatingipAssociateV2#floating_ip}
    */
    readonly floatingIp: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2#id NetworkingFloatingipAssociateV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2#port_id NetworkingFloatingipAssociateV2#port_id}
    */
    readonly portId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2#region NetworkingFloatingipAssociateV2#region}
    */
    readonly region?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2 opentelekomcloud_networking_floatingip_associate_v2}
*/
export declare class NetworkingFloatingipAssociateV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_networking_floatingip_associate_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2 opentelekomcloud_networking_floatingip_associate_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkingFloatingipAssociateV2Config
    */
    constructor(scope: Construct, id: string, config: NetworkingFloatingipAssociateV2Config);
    private _floatingIp?;
    get floatingIp(): string;
    set floatingIp(value: string);
    get floatingIpInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _portId?;
    get portId(): string;
    set portId(value: string);
    get portIdInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
