import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkingFloatingipV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_v2#fixed_ip NetworkingFloatingipV2#fixed_ip}
    */
    readonly fixedIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_v2#id NetworkingFloatingipV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_v2#pool NetworkingFloatingipV2#pool}
    */
    readonly pool?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_v2#port_id NetworkingFloatingipV2#port_id}
    */
    readonly portId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_v2#region NetworkingFloatingipV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_v2#tenant_id NetworkingFloatingipV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_v2#value_specs NetworkingFloatingipV2#value_specs}
    */
    readonly valueSpecs?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_v2#timeouts NetworkingFloatingipV2#timeouts}
    */
    readonly timeouts?: NetworkingFloatingipV2Timeouts;
}
export interface NetworkingFloatingipV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_v2#create NetworkingFloatingipV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_v2#delete NetworkingFloatingipV2#delete}
    */
    readonly delete?: string;
}
export declare function networkingFloatingipV2TimeoutsToTerraform(struct?: NetworkingFloatingipV2TimeoutsOutputReference | NetworkingFloatingipV2Timeouts | cdktf.IResolvable): any;
export declare class NetworkingFloatingipV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkingFloatingipV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkingFloatingipV2Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_v2 opentelekomcloud_networking_floatingip_v2}
*/
export declare class NetworkingFloatingipV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_networking_floatingip_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_v2 opentelekomcloud_networking_floatingip_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkingFloatingipV2Config = {}
    */
    constructor(scope: Construct, id: string, config?: NetworkingFloatingipV2Config);
    get address(): string;
    private _fixedIp?;
    get fixedIp(): string;
    set fixedIp(value: string);
    resetFixedIp(): void;
    get fixedIpInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _pool?;
    get pool(): string;
    set pool(value: string);
    resetPool(): void;
    get poolInput(): string | undefined;
    private _portId?;
    get portId(): string;
    set portId(value: string);
    resetPortId(): void;
    get portIdInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _valueSpecs?;
    get valueSpecs(): {
        [key: string]: string;
    };
    set valueSpecs(value: {
        [key: string]: string;
    });
    resetValueSpecs(): void;
    get valueSpecsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): NetworkingFloatingipV2TimeoutsOutputReference;
    putTimeouts(value: NetworkingFloatingipV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkingFloatingipV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
