import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkingRouterInterfaceV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2#id NetworkingRouterInterfaceV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2#port_id NetworkingRouterInterfaceV2#port_id}
    */
    readonly portId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2#region NetworkingRouterInterfaceV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2#router_id NetworkingRouterInterfaceV2#router_id}
    */
    readonly routerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2#subnet_id NetworkingRouterInterfaceV2#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2#timeouts NetworkingRouterInterfaceV2#timeouts}
    */
    readonly timeouts?: NetworkingRouterInterfaceV2Timeouts;
}
export interface NetworkingRouterInterfaceV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2#create NetworkingRouterInterfaceV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2#delete NetworkingRouterInterfaceV2#delete}
    */
    readonly delete?: string;
}
export declare function networkingRouterInterfaceV2TimeoutsToTerraform(struct?: NetworkingRouterInterfaceV2TimeoutsOutputReference | NetworkingRouterInterfaceV2Timeouts | cdktf.IResolvable): any;
export declare class NetworkingRouterInterfaceV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkingRouterInterfaceV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkingRouterInterfaceV2Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2 opentelekomcloud_networking_router_interface_v2}
*/
export declare class NetworkingRouterInterfaceV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_networking_router_interface_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2 opentelekomcloud_networking_router_interface_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkingRouterInterfaceV2Config
    */
    constructor(scope: Construct, id: string, config: NetworkingRouterInterfaceV2Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _portId?;
    get portId(): string;
    set portId(value: string);
    resetPortId(): void;
    get portIdInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _routerId?;
    get routerId(): string;
    set routerId(value: string);
    get routerIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetworkingRouterInterfaceV2TimeoutsOutputReference;
    putTimeouts(value: NetworkingRouterInterfaceV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkingRouterInterfaceV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
