import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkingRouterRouteV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2#destination_cidr NetworkingRouterRouteV2#destination_cidr}
    */
    readonly destinationCidr: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2#id NetworkingRouterRouteV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2#next_hop NetworkingRouterRouteV2#next_hop}
    */
    readonly nextHop: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2#region NetworkingRouterRouteV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2#router_id NetworkingRouterRouteV2#router_id}
    */
    readonly routerId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2 opentelekomcloud_networking_router_route_v2}
*/
export declare class NetworkingRouterRouteV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_networking_router_route_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2 opentelekomcloud_networking_router_route_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkingRouterRouteV2Config
    */
    constructor(scope: Construct, id: string, config: NetworkingRouterRouteV2Config);
    private _destinationCidr?;
    get destinationCidr(): string;
    set destinationCidr(value: string);
    get destinationCidrInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _nextHop?;
    get nextHop(): string;
    set nextHop(value: string);
    get nextHopInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _routerId?;
    get routerId(): string;
    set routerId(value: string);
    get routerIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
