import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkingSecgroupRuleV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#description NetworkingSecgroupRuleV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#direction NetworkingSecgroupRuleV2#direction}
    */
    readonly direction: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#ethertype NetworkingSecgroupRuleV2#ethertype}
    */
    readonly ethertype: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#id NetworkingSecgroupRuleV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#port_range_max NetworkingSecgroupRuleV2#port_range_max}
    */
    readonly portRangeMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#port_range_min NetworkingSecgroupRuleV2#port_range_min}
    */
    readonly portRangeMin?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#protocol NetworkingSecgroupRuleV2#protocol}
    */
    readonly protocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#region NetworkingSecgroupRuleV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#remote_group_id NetworkingSecgroupRuleV2#remote_group_id}
    */
    readonly remoteGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#remote_ip_prefix NetworkingSecgroupRuleV2#remote_ip_prefix}
    */
    readonly remoteIpPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#security_group_id NetworkingSecgroupRuleV2#security_group_id}
    */
    readonly securityGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#tenant_id NetworkingSecgroupRuleV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#timeouts NetworkingSecgroupRuleV2#timeouts}
    */
    readonly timeouts?: NetworkingSecgroupRuleV2Timeouts;
}
export interface NetworkingSecgroupRuleV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2#delete NetworkingSecgroupRuleV2#delete}
    */
    readonly delete?: string;
}
export declare function networkingSecgroupRuleV2TimeoutsToTerraform(struct?: NetworkingSecgroupRuleV2TimeoutsOutputReference | NetworkingSecgroupRuleV2Timeouts | cdktf.IResolvable): any;
export declare class NetworkingSecgroupRuleV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkingSecgroupRuleV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkingSecgroupRuleV2Timeouts | cdktf.IResolvable | undefined);
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2 opentelekomcloud_networking_secgroup_rule_v2}
*/
export declare class NetworkingSecgroupRuleV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_networking_secgroup_rule_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2 opentelekomcloud_networking_secgroup_rule_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkingSecgroupRuleV2Config
    */
    constructor(scope: Construct, id: string, config: NetworkingSecgroupRuleV2Config);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _ethertype?;
    get ethertype(): string;
    set ethertype(value: string);
    get ethertypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _portRangeMax?;
    get portRangeMax(): number;
    set portRangeMax(value: number);
    resetPortRangeMax(): void;
    get portRangeMaxInput(): number | undefined;
    private _portRangeMin?;
    get portRangeMin(): number;
    set portRangeMin(value: number);
    resetPortRangeMin(): void;
    get portRangeMinInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _remoteGroupId?;
    get remoteGroupId(): string;
    set remoteGroupId(value: string);
    resetRemoteGroupId(): void;
    get remoteGroupIdInput(): string | undefined;
    private _remoteIpPrefix?;
    get remoteIpPrefix(): string;
    set remoteIpPrefix(value: string);
    resetRemoteIpPrefix(): void;
    get remoteIpPrefixInput(): string | undefined;
    private _securityGroupId?;
    get securityGroupId(): string;
    set securityGroupId(value: string);
    get securityGroupIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetworkingSecgroupRuleV2TimeoutsOutputReference;
    putTimeouts(value: NetworkingSecgroupRuleV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkingSecgroupRuleV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
