import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkingSecgroupV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_v2#delete_default_rules NetworkingSecgroupV2#delete_default_rules}
    */
    readonly deleteDefaultRules?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_v2#description NetworkingSecgroupV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_v2#id NetworkingSecgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_v2#name NetworkingSecgroupV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_v2#region NetworkingSecgroupV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_v2#tenant_id NetworkingSecgroupV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_v2#timeouts NetworkingSecgroupV2#timeouts}
    */
    readonly timeouts?: NetworkingSecgroupV2Timeouts;
}
export interface NetworkingSecgroupV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_v2#delete NetworkingSecgroupV2#delete}
    */
    readonly delete?: string;
}
export declare function networkingSecgroupV2TimeoutsToTerraform(struct?: NetworkingSecgroupV2TimeoutsOutputReference | NetworkingSecgroupV2Timeouts | cdktf.IResolvable): any;
export declare class NetworkingSecgroupV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkingSecgroupV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkingSecgroupV2Timeouts | cdktf.IResolvable | undefined);
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_v2 opentelekomcloud_networking_secgroup_v2}
*/
export declare class NetworkingSecgroupV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_networking_secgroup_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_v2 opentelekomcloud_networking_secgroup_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkingSecgroupV2Config
    */
    constructor(scope: Construct, id: string, config: NetworkingSecgroupV2Config);
    private _deleteDefaultRules?;
    get deleteDefaultRules(): boolean | cdktf.IResolvable;
    set deleteDefaultRules(value: boolean | cdktf.IResolvable);
    resetDeleteDefaultRules(): void;
    get deleteDefaultRulesInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetworkingSecgroupV2TimeoutsOutputReference;
    putTimeouts(value: NetworkingSecgroupV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkingSecgroupV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
