import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkingVipAssociateV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_associate_v2#id NetworkingVipAssociateV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_associate_v2#port_ids NetworkingVipAssociateV2#port_ids}
    */
    readonly portIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_associate_v2#vip_id NetworkingVipAssociateV2#vip_id}
    */
    readonly vipId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_associate_v2 opentelekomcloud_networking_vip_associate_v2}
*/
export declare class NetworkingVipAssociateV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_networking_vip_associate_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_associate_v2 opentelekomcloud_networking_vip_associate_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkingVipAssociateV2Config
    */
    constructor(scope: Construct, id: string, config: NetworkingVipAssociateV2Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _portIds?;
    get portIds(): string[];
    set portIds(value: string[]);
    get portIdsInput(): string[] | undefined;
    private _vipId?;
    get vipId(): string;
    set vipId(value: string);
    get vipIdInput(): string | undefined;
    get vipIpAddress(): string;
    get vipSubnetId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
