"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpentelekomcloudProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud opentelekomcloud}
*/
class OpentelekomcloudProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud opentelekomcloud} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OpentelekomcloudProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'opentelekomcloud',
            terraformGeneratorMetadata: {
                providerName: 'opentelekomcloud',
                providerVersion: '1.29.6',
                providerVersionConstraint: '~> 1.26'
            },
            terraformProviderSource: 'opentelekomcloud/opentelekomcloud'
        });
        this._accessKey = config.accessKey;
        this._agencyDomainName = config.agencyDomainName;
        this._agencyName = config.agencyName;
        this._authUrl = config.authUrl;
        this._cacertFile = config.cacertFile;
        this._cert = config.cert;
        this._cloud = config.cloud;
        this._delegatedProject = config.delegatedProject;
        this._domainId = config.domainId;
        this._domainName = config.domainName;
        this._endpointType = config.endpointType;
        this._insecure = config.insecure;
        this._key = config.key;
        this._maxRetries = config.maxRetries;
        this._passcode = config.passcode;
        this._password = config.password;
        this._region = config.region;
        this._secretKey = config.secretKey;
        this._securityToken = config.securityToken;
        this._swauth = config.swauth;
        this._tenantId = config.tenantId;
        this._tenantName = config.tenantName;
        this._token = config.token;
        this._userId = config.userId;
        this._userName = config.userName;
        this._alias = config.alias;
    }
    get accessKey() {
        return this._accessKey;
    }
    set accessKey(value) {
        this._accessKey = value;
    }
    resetAccessKey() {
        this._accessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessKeyInput() {
        return this._accessKey;
    }
    get agencyDomainName() {
        return this._agencyDomainName;
    }
    set agencyDomainName(value) {
        this._agencyDomainName = value;
    }
    resetAgencyDomainName() {
        this._agencyDomainName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get agencyDomainNameInput() {
        return this._agencyDomainName;
    }
    get agencyName() {
        return this._agencyName;
    }
    set agencyName(value) {
        this._agencyName = value;
    }
    resetAgencyName() {
        this._agencyName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get agencyNameInput() {
        return this._agencyName;
    }
    get authUrl() {
        return this._authUrl;
    }
    set authUrl(value) {
        this._authUrl = value;
    }
    resetAuthUrl() {
        this._authUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authUrlInput() {
        return this._authUrl;
    }
    get cacertFile() {
        return this._cacertFile;
    }
    set cacertFile(value) {
        this._cacertFile = value;
    }
    resetCacertFile() {
        this._cacertFile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cacertFileInput() {
        return this._cacertFile;
    }
    get cert() {
        return this._cert;
    }
    set cert(value) {
        this._cert = value;
    }
    resetCert() {
        this._cert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certInput() {
        return this._cert;
    }
    get cloud() {
        return this._cloud;
    }
    set cloud(value) {
        this._cloud = value;
    }
    resetCloud() {
        this._cloud = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudInput() {
        return this._cloud;
    }
    get delegatedProject() {
        return this._delegatedProject;
    }
    set delegatedProject(value) {
        this._delegatedProject = value;
    }
    resetDelegatedProject() {
        this._delegatedProject = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get delegatedProjectInput() {
        return this._delegatedProject;
    }
    get domainId() {
        return this._domainId;
    }
    set domainId(value) {
        this._domainId = value;
    }
    resetDomainId() {
        this._domainId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get domainIdInput() {
        return this._domainId;
    }
    get domainName() {
        return this._domainName;
    }
    set domainName(value) {
        this._domainName = value;
    }
    resetDomainName() {
        this._domainName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get domainNameInput() {
        return this._domainName;
    }
    get endpointType() {
        return this._endpointType;
    }
    set endpointType(value) {
        this._endpointType = value;
    }
    resetEndpointType() {
        this._endpointType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get endpointTypeInput() {
        return this._endpointType;
    }
    get insecure() {
        return this._insecure;
    }
    set insecure(value) {
        this._insecure = value;
    }
    resetInsecure() {
        this._insecure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureInput() {
        return this._insecure;
    }
    get key() {
        return this._key;
    }
    set key(value) {
        this._key = value;
    }
    resetKey() {
        this._key = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyInput() {
        return this._key;
    }
    get maxRetries() {
        return this._maxRetries;
    }
    set maxRetries(value) {
        this._maxRetries = value;
    }
    resetMaxRetries() {
        this._maxRetries = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxRetriesInput() {
        return this._maxRetries;
    }
    get passcode() {
        return this._passcode;
    }
    set passcode(value) {
        this._passcode = value;
    }
    resetPasscode() {
        this._passcode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passcodeInput() {
        return this._passcode;
    }
    get password() {
        return this._password;
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get secretKey() {
        return this._secretKey;
    }
    set secretKey(value) {
        this._secretKey = value;
    }
    resetSecretKey() {
        this._secretKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretKeyInput() {
        return this._secretKey;
    }
    get securityToken() {
        return this._securityToken;
    }
    set securityToken(value) {
        this._securityToken = value;
    }
    resetSecurityToken() {
        this._securityToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityTokenInput() {
        return this._securityToken;
    }
    get swauth() {
        return this._swauth;
    }
    set swauth(value) {
        this._swauth = value;
    }
    resetSwauth() {
        this._swauth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get swauthInput() {
        return this._swauth;
    }
    get tenantId() {
        return this._tenantId;
    }
    set tenantId(value) {
        this._tenantId = value;
    }
    resetTenantId() {
        this._tenantId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tenantIdInput() {
        return this._tenantId;
    }
    get tenantName() {
        return this._tenantName;
    }
    set tenantName(value) {
        this._tenantName = value;
    }
    resetTenantName() {
        this._tenantName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tenantNameInput() {
        return this._tenantName;
    }
    get token() {
        return this._token;
    }
    set token(value) {
        this._token = value;
    }
    resetToken() {
        this._token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token;
    }
    get userId() {
        return this._userId;
    }
    set userId(value) {
        this._userId = value;
    }
    resetUserId() {
        this._userId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userIdInput() {
        return this._userId;
    }
    get userName() {
        return this._userName;
    }
    set userName(value) {
        this._userName = value;
    }
    resetUserName() {
        this._userName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userNameInput() {
        return this._userName;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_key: cdktf.stringToTerraform(this._accessKey),
            agency_domain_name: cdktf.stringToTerraform(this._agencyDomainName),
            agency_name: cdktf.stringToTerraform(this._agencyName),
            auth_url: cdktf.stringToTerraform(this._authUrl),
            cacert_file: cdktf.stringToTerraform(this._cacertFile),
            cert: cdktf.stringToTerraform(this._cert),
            cloud: cdktf.stringToTerraform(this._cloud),
            delegated_project: cdktf.stringToTerraform(this._delegatedProject),
            domain_id: cdktf.stringToTerraform(this._domainId),
            domain_name: cdktf.stringToTerraform(this._domainName),
            endpoint_type: cdktf.stringToTerraform(this._endpointType),
            insecure: cdktf.booleanToTerraform(this._insecure),
            key: cdktf.stringToTerraform(this._key),
            max_retries: cdktf.numberToTerraform(this._maxRetries),
            passcode: cdktf.stringToTerraform(this._passcode),
            password: cdktf.stringToTerraform(this._password),
            region: cdktf.stringToTerraform(this._region),
            secret_key: cdktf.stringToTerraform(this._secretKey),
            security_token: cdktf.stringToTerraform(this._securityToken),
            swauth: cdktf.booleanToTerraform(this._swauth),
            tenant_id: cdktf.stringToTerraform(this._tenantId),
            tenant_name: cdktf.stringToTerraform(this._tenantName),
            token: cdktf.stringToTerraform(this._token),
            user_id: cdktf.stringToTerraform(this._userId),
            user_name: cdktf.stringToTerraform(this._userName),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.OpentelekomcloudProvider = OpentelekomcloudProvider;
_a = JSII_RTTI_SYMBOL_1;
OpentelekomcloudProvider[_a] = { fqn: "@cdktf/provider-opentelekomcloud.OpentelekomcloudProvider", version: "0.5.33" };
// =================
// STATIC PROPERTIES
// =================
OpentelekomcloudProvider.tfResourceType = "opentelekomcloud";
//# sourceMappingURL=data:application/json;base64,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