import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RdsParametergroupV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#description RdsParametergroupV3#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#id RdsParametergroupV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#name RdsParametergroupV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#values RdsParametergroupV3#values}
    */
    readonly values?: {
        [key: string]: string;
    };
    /**
    * datastore block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#datastore RdsParametergroupV3#datastore}
    */
    readonly datastore: RdsParametergroupV3Datastore;
}
export interface RdsParametergroupV3ConfigurationParameters {
}
export declare function rdsParametergroupV3ConfigurationParametersToTerraform(struct?: RdsParametergroupV3ConfigurationParameters): any;
export declare class RdsParametergroupV3ConfigurationParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RdsParametergroupV3ConfigurationParameters | undefined;
    set internalValue(value: RdsParametergroupV3ConfigurationParameters | undefined);
    get description(): string;
    get name(): string;
    get readonly(): cdktf.IResolvable;
    get restartRequired(): cdktf.IResolvable;
    get type(): string;
    get value(): string;
    get valueRange(): string;
}
export declare class RdsParametergroupV3ConfigurationParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RdsParametergroupV3ConfigurationParametersOutputReference;
}
export interface RdsParametergroupV3Datastore {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#type RdsParametergroupV3#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#version RdsParametergroupV3#version}
    */
    readonly version: string;
}
export declare function rdsParametergroupV3DatastoreToTerraform(struct?: RdsParametergroupV3DatastoreOutputReference | RdsParametergroupV3Datastore): any;
export declare class RdsParametergroupV3DatastoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RdsParametergroupV3Datastore | undefined;
    set internalValue(value: RdsParametergroupV3Datastore | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3 opentelekomcloud_rds_parametergroup_v3}
*/
export declare class RdsParametergroupV3 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_rds_parametergroup_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3 opentelekomcloud_rds_parametergroup_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RdsParametergroupV3Config
    */
    constructor(scope: Construct, id: string, config: RdsParametergroupV3Config);
    private _configurationParameters;
    get configurationParameters(): RdsParametergroupV3ConfigurationParametersList;
    get created(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get updated(): string;
    private _values?;
    get values(): {
        [key: string]: string;
    };
    set values(value: {
        [key: string]: string;
    });
    resetValues(): void;
    get valuesInput(): {
        [key: string]: string;
    } | undefined;
    private _datastore;
    get datastore(): RdsParametergroupV3DatastoreOutputReference;
    putDatastore(value: RdsParametergroupV3Datastore): void;
    get datastoreInput(): RdsParametergroupV3Datastore | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
