import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RtsSoftwareConfigV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1#config RtsSoftwareConfigV1#config}
    */
    readonly config?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1#group RtsSoftwareConfigV1#group}
    */
    readonly group?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1#id RtsSoftwareConfigV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1#input_values RtsSoftwareConfigV1#input_values}
    */
    readonly inputValues?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1#name RtsSoftwareConfigV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1#options RtsSoftwareConfigV1#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1#output_values RtsSoftwareConfigV1#output_values}
    */
    readonly outputValues?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1#region RtsSoftwareConfigV1#region}
    */
    readonly region?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1#timeouts RtsSoftwareConfigV1#timeouts}
    */
    readonly timeouts?: RtsSoftwareConfigV1Timeouts;
}
export interface RtsSoftwareConfigV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1#create RtsSoftwareConfigV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1#delete RtsSoftwareConfigV1#delete}
    */
    readonly delete?: string;
}
export declare function rtsSoftwareConfigV1TimeoutsToTerraform(struct?: RtsSoftwareConfigV1TimeoutsOutputReference | RtsSoftwareConfigV1Timeouts | cdktf.IResolvable): any;
export declare class RtsSoftwareConfigV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RtsSoftwareConfigV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: RtsSoftwareConfigV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1 opentelekomcloud_rts_software_config_v1}
*/
export declare class RtsSoftwareConfigV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_rts_software_config_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1 opentelekomcloud_rts_software_config_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RtsSoftwareConfigV1Config
    */
    constructor(scope: Construct, id: string, config: RtsSoftwareConfigV1Config);
    private _config?;
    get config(): string;
    set config(value: string);
    resetConfig(): void;
    get configInput(): string | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inputValues?;
    get inputValues(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set inputValues(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    resetInputValues(): void;
    get inputValuesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _outputValues?;
    get outputValues(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set outputValues(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    resetOutputValues(): void;
    get outputValuesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _timeouts;
    get timeouts(): RtsSoftwareConfigV1TimeoutsOutputReference;
    putTimeouts(value: RtsSoftwareConfigV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | RtsSoftwareConfigV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
