import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SfsShareAccessRulesV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2#id SfsShareAccessRulesV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2#share_id SfsShareAccessRulesV2#share_id}
    */
    readonly shareId: string;
    /**
    * access_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2#access_rule SfsShareAccessRulesV2#access_rule}
    */
    readonly accessRule: SfsShareAccessRulesV2AccessRule[] | cdktf.IResolvable;
}
export interface SfsShareAccessRulesV2AccessRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2#access_level SfsShareAccessRulesV2#access_level}
    */
    readonly accessLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2#access_to SfsShareAccessRulesV2#access_to}
    */
    readonly accessTo: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2#access_type SfsShareAccessRulesV2#access_type}
    */
    readonly accessType?: string;
}
export declare function sfsShareAccessRulesV2AccessRuleToTerraform(struct?: SfsShareAccessRulesV2AccessRule | cdktf.IResolvable): any;
export declare class SfsShareAccessRulesV2AccessRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SfsShareAccessRulesV2AccessRule | cdktf.IResolvable | undefined;
    set internalValue(value: SfsShareAccessRulesV2AccessRule | cdktf.IResolvable | undefined);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    get accessLevelInput(): string | undefined;
    get accessRuleStatus(): string;
    private _accessTo?;
    get accessTo(): string;
    set accessTo(value: string);
    get accessToInput(): string | undefined;
    private _accessType?;
    get accessType(): string;
    set accessType(value: string);
    resetAccessType(): void;
    get accessTypeInput(): string | undefined;
    get shareAccessId(): string;
}
export declare class SfsShareAccessRulesV2AccessRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SfsShareAccessRulesV2AccessRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SfsShareAccessRulesV2AccessRuleOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2 opentelekomcloud_sfs_share_access_rules_v2}
*/
export declare class SfsShareAccessRulesV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_sfs_share_access_rules_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2 opentelekomcloud_sfs_share_access_rules_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SfsShareAccessRulesV2Config
    */
    constructor(scope: Construct, id: string, config: SfsShareAccessRulesV2Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _shareId?;
    get shareId(): string;
    set shareId(value: string);
    get shareIdInput(): string | undefined;
    private _accessRule;
    get accessRule(): SfsShareAccessRulesV2AccessRuleList;
    putAccessRule(value: SfsShareAccessRulesV2AccessRule[] | cdktf.IResolvable): void;
    get accessRuleInput(): cdktf.IResolvable | SfsShareAccessRulesV2AccessRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
