import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SfsTurboShareV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#availability_zone SfsTurboShareV1#availability_zone}
    */
    readonly availabilityZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#crypt_key_id SfsTurboShareV1#crypt_key_id}
    */
    readonly cryptKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#id SfsTurboShareV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#name SfsTurboShareV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#region SfsTurboShareV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#security_group_id SfsTurboShareV1#security_group_id}
    */
    readonly securityGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#share_proto SfsTurboShareV1#share_proto}
    */
    readonly shareProto?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#share_type SfsTurboShareV1#share_type}
    */
    readonly shareType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#size SfsTurboShareV1#size}
    */
    readonly size: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#subnet_id SfsTurboShareV1#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#vpc_id SfsTurboShareV1#vpc_id}
    */
    readonly vpcId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#timeouts SfsTurboShareV1#timeouts}
    */
    readonly timeouts?: SfsTurboShareV1Timeouts;
}
export interface SfsTurboShareV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#create SfsTurboShareV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1#delete SfsTurboShareV1#delete}
    */
    readonly delete?: string;
}
export declare function sfsTurboShareV1TimeoutsToTerraform(struct?: SfsTurboShareV1TimeoutsOutputReference | SfsTurboShareV1Timeouts | cdktf.IResolvable): any;
export declare class SfsTurboShareV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SfsTurboShareV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SfsTurboShareV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1 opentelekomcloud_sfs_turbo_share_v1}
*/
export declare class SfsTurboShareV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_sfs_turbo_share_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_turbo_share_v1 opentelekomcloud_sfs_turbo_share_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SfsTurboShareV1Config
    */
    constructor(scope: Construct, id: string, config: SfsTurboShareV1Config);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    get availabilityZoneInput(): string | undefined;
    get availableCapacity(): string;
    private _cryptKeyId?;
    get cryptKeyId(): string;
    set cryptKeyId(value: string);
    resetCryptKeyId(): void;
    get cryptKeyIdInput(): string | undefined;
    get exportLocation(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _securityGroupId?;
    get securityGroupId(): string;
    set securityGroupId(value: string);
    get securityGroupIdInput(): string | undefined;
    private _shareProto?;
    get shareProto(): string;
    set shareProto(value: string);
    resetShareProto(): void;
    get shareProtoInput(): string | undefined;
    private _shareType?;
    get shareType(): string;
    set shareType(value: string);
    resetShareType(): void;
    get shareTypeInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    get version(): string;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SfsTurboShareV1TimeoutsOutputReference;
    putTimeouts(value: SfsTurboShareV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SfsTurboShareV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
