import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SmnTopicAttributeV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_attribute_v2#attribute_name SmnTopicAttributeV2#attribute_name}
    */
    readonly attributeName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_attribute_v2#id SmnTopicAttributeV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_attribute_v2#topic_attribute SmnTopicAttributeV2#topic_attribute}
    */
    readonly topicAttribute: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_attribute_v2#topic_urn SmnTopicAttributeV2#topic_urn}
    */
    readonly topicUrn: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_attribute_v2 opentelekomcloud_smn_topic_attribute_v2}
*/
export declare class SmnTopicAttributeV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_smn_topic_attribute_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_attribute_v2 opentelekomcloud_smn_topic_attribute_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SmnTopicAttributeV2Config
    */
    constructor(scope: Construct, id: string, config: SmnTopicAttributeV2Config);
    private _attributeName?;
    get attributeName(): string;
    set attributeName(value: string);
    get attributeNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _topicAttribute?;
    get topicAttribute(): string;
    set topicAttribute(value: string);
    get topicAttributeInput(): string | undefined;
    private _topicUrn?;
    get topicUrn(): string;
    set topicUrn(value: string);
    get topicUrnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
