import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SwrDomainV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2#access_domain SwrDomainV2#access_domain}
    */
    readonly accessDomain: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2#deadline SwrDomainV2#deadline}
    */
    readonly deadline: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2#description SwrDomainV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2#id SwrDomainV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2#organization SwrDomainV2#organization}
    */
    readonly organization: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2#permission SwrDomainV2#permission}
    */
    readonly permission: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2#repository SwrDomainV2#repository}
    */
    readonly repository: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2#timeouts SwrDomainV2#timeouts}
    */
    readonly timeouts?: SwrDomainV2Timeouts;
}
export interface SwrDomainV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2#default SwrDomainV2#default}
    */
    readonly default?: string;
}
export declare function swrDomainV2TimeoutsToTerraform(struct?: SwrDomainV2TimeoutsOutputReference | SwrDomainV2Timeouts | cdktf.IResolvable): any;
export declare class SwrDomainV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SwrDomainV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SwrDomainV2Timeouts | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2 opentelekomcloud_swr_domain_v2}
*/
export declare class SwrDomainV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_swr_domain_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2 opentelekomcloud_swr_domain_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SwrDomainV2Config
    */
    constructor(scope: Construct, id: string, config: SwrDomainV2Config);
    private _accessDomain?;
    get accessDomain(): string;
    set accessDomain(value: string);
    get accessDomainInput(): string | undefined;
    get created(): string;
    get creatorId(): string;
    get creatorName(): string;
    private _deadline?;
    get deadline(): string;
    set deadline(value: string);
    get deadlineInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _permission?;
    get permission(): string;
    set permission(value: string);
    get permissionInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    get status(): cdktf.IResolvable;
    get updated(): string;
    private _timeouts;
    get timeouts(): SwrDomainV2TimeoutsOutputReference;
    putTimeouts(value: SwrDomainV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SwrDomainV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
