import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SwrOrganizationPermissionsV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2#auth SwrOrganizationPermissionsV2#auth}
    */
    readonly auth: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2#id SwrOrganizationPermissionsV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2#organization SwrOrganizationPermissionsV2#organization}
    */
    readonly organization: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2#user_id SwrOrganizationPermissionsV2#user_id}
    */
    readonly userId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2#username SwrOrganizationPermissionsV2#username}
    */
    readonly username: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2#timeouts SwrOrganizationPermissionsV2#timeouts}
    */
    readonly timeouts?: SwrOrganizationPermissionsV2Timeouts;
}
export interface SwrOrganizationPermissionsV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2#default SwrOrganizationPermissionsV2#default}
    */
    readonly default?: string;
}
export declare function swrOrganizationPermissionsV2TimeoutsToTerraform(struct?: SwrOrganizationPermissionsV2TimeoutsOutputReference | SwrOrganizationPermissionsV2Timeouts | cdktf.IResolvable): any;
export declare class SwrOrganizationPermissionsV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SwrOrganizationPermissionsV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SwrOrganizationPermissionsV2Timeouts | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2 opentelekomcloud_swr_organization_permissions_v2}
*/
export declare class SwrOrganizationPermissionsV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_swr_organization_permissions_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2 opentelekomcloud_swr_organization_permissions_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SwrOrganizationPermissionsV2Config
    */
    constructor(scope: Construct, id: string, config: SwrOrganizationPermissionsV2Config);
    private _auth?;
    get auth(): number;
    set auth(value: number);
    get authInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _timeouts;
    get timeouts(): SwrOrganizationPermissionsV2TimeoutsOutputReference;
    putTimeouts(value: SwrOrganizationPermissionsV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SwrOrganizationPermissionsV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
