import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpcBandwidthV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_bandwidth_v2#id VpcBandwidthV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_bandwidth_v2#name VpcBandwidthV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_bandwidth_v2#size VpcBandwidthV2#size}
    */
    readonly size: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_bandwidth_v2 opentelekomcloud_vpc_bandwidth_v2}
*/
export declare class VpcBandwidthV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_vpc_bandwidth_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_bandwidth_v2 opentelekomcloud_vpc_bandwidth_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcBandwidthV2Config
    */
    constructor(scope: Construct, id: string, config: VpcBandwidthV2Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
