import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpcPeeringConnectionV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_v2#id VpcPeeringConnectionV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_v2#name VpcPeeringConnectionV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_v2#peer_tenant_id VpcPeeringConnectionV2#peer_tenant_id}
    */
    readonly peerTenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_v2#peer_vpc_id VpcPeeringConnectionV2#peer_vpc_id}
    */
    readonly peerVpcId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_v2#region VpcPeeringConnectionV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_v2#vpc_id VpcPeeringConnectionV2#vpc_id}
    */
    readonly vpcId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_v2#timeouts VpcPeeringConnectionV2#timeouts}
    */
    readonly timeouts?: VpcPeeringConnectionV2Timeouts;
}
export interface VpcPeeringConnectionV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_v2#create VpcPeeringConnectionV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_v2#delete VpcPeeringConnectionV2#delete}
    */
    readonly delete?: string;
}
export declare function vpcPeeringConnectionV2TimeoutsToTerraform(struct?: VpcPeeringConnectionV2TimeoutsOutputReference | VpcPeeringConnectionV2Timeouts | cdktf.IResolvable): any;
export declare class VpcPeeringConnectionV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpcPeeringConnectionV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VpcPeeringConnectionV2Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_v2 opentelekomcloud_vpc_peering_connection_v2}
*/
export declare class VpcPeeringConnectionV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_vpc_peering_connection_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_v2 opentelekomcloud_vpc_peering_connection_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcPeeringConnectionV2Config
    */
    constructor(scope: Construct, id: string, config: VpcPeeringConnectionV2Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peerTenantId?;
    get peerTenantId(): string;
    set peerTenantId(value: string);
    resetPeerTenantId(): void;
    get peerTenantIdInput(): string | undefined;
    private _peerVpcId?;
    get peerVpcId(): string;
    set peerVpcId(value: string);
    get peerVpcIdInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get status(): string;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): VpcPeeringConnectionV2TimeoutsOutputReference;
    putTimeouts(value: VpcPeeringConnectionV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VpcPeeringConnectionV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
