import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpcSubnetV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#availability_zone VpcSubnetV1#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#cidr VpcSubnetV1#cidr}
    */
    readonly cidr: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#description VpcSubnetV1#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#dhcp_enable VpcSubnetV1#dhcp_enable}
    */
    readonly dhcpEnable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#dns_list VpcSubnetV1#dns_list}
    */
    readonly dnsList?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#gateway_ip VpcSubnetV1#gateway_ip}
    */
    readonly gatewayIp: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#id VpcSubnetV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#name VpcSubnetV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#ntp_addresses VpcSubnetV1#ntp_addresses}
    */
    readonly ntpAddresses?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#primary_dns VpcSubnetV1#primary_dns}
    */
    readonly primaryDns?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#region VpcSubnetV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#secondary_dns VpcSubnetV1#secondary_dns}
    */
    readonly secondaryDns?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#tags VpcSubnetV1#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#vpc_id VpcSubnetV1#vpc_id}
    */
    readonly vpcId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#timeouts VpcSubnetV1#timeouts}
    */
    readonly timeouts?: VpcSubnetV1Timeouts;
}
export interface VpcSubnetV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#create VpcSubnetV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1#delete VpcSubnetV1#delete}
    */
    readonly delete?: string;
}
export declare function vpcSubnetV1TimeoutsToTerraform(struct?: VpcSubnetV1TimeoutsOutputReference | VpcSubnetV1Timeouts | cdktf.IResolvable): any;
export declare class VpcSubnetV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpcSubnetV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VpcSubnetV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1 opentelekomcloud_vpc_subnet_v1}
*/
export declare class VpcSubnetV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_vpc_subnet_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1 opentelekomcloud_vpc_subnet_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcSubnetV1Config
    */
    constructor(scope: Construct, id: string, config: VpcSubnetV1Config);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    private _cidr?;
    get cidr(): string;
    set cidr(value: string);
    get cidrInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dhcpEnable?;
    get dhcpEnable(): boolean | cdktf.IResolvable;
    set dhcpEnable(value: boolean | cdktf.IResolvable);
    resetDhcpEnable(): void;
    get dhcpEnableInput(): boolean | cdktf.IResolvable | undefined;
    private _dnsList?;
    get dnsList(): string[];
    set dnsList(value: string[]);
    resetDnsList(): void;
    get dnsListInput(): string[] | undefined;
    private _gatewayIp?;
    get gatewayIp(): string;
    set gatewayIp(value: string);
    get gatewayIpInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get networkId(): string;
    private _ntpAddresses?;
    get ntpAddresses(): string;
    set ntpAddresses(value: string);
    resetNtpAddresses(): void;
    get ntpAddressesInput(): string | undefined;
    private _primaryDns?;
    get primaryDns(): string;
    set primaryDns(value: string);
    resetPrimaryDns(): void;
    get primaryDnsInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _secondaryDns?;
    get secondaryDns(): string;
    set secondaryDns(value: string);
    resetSecondaryDns(): void;
    get secondaryDnsInput(): string | undefined;
    get subnetId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): VpcSubnetV1TimeoutsOutputReference;
    putTimeouts(value: VpcSubnetV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VpcSubnetV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
