import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpcepEndpointV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1#enable_dns VpcepEndpointV1#enable_dns}
    */
    readonly enableDns?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1#enable_whitelist VpcepEndpointV1#enable_whitelist}
    */
    readonly enableWhitelist?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1#id VpcepEndpointV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1#port_ip VpcepEndpointV1#port_ip}
    */
    readonly portIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1#route_tables VpcepEndpointV1#route_tables}
    */
    readonly routeTables?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1#service_id VpcepEndpointV1#service_id}
    */
    readonly serviceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1#subnet_id VpcepEndpointV1#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1#tags VpcepEndpointV1#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1#vpc_id VpcepEndpointV1#vpc_id}
    */
    readonly vpcId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1#whitelist VpcepEndpointV1#whitelist}
    */
    readonly whitelist?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1#timeouts VpcepEndpointV1#timeouts}
    */
    readonly timeouts?: VpcepEndpointV1Timeouts;
}
export interface VpcepEndpointV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1#default VpcepEndpointV1#default}
    */
    readonly default?: string;
}
export declare function vpcepEndpointV1TimeoutsToTerraform(struct?: VpcepEndpointV1TimeoutsOutputReference | VpcepEndpointV1Timeouts | cdktf.IResolvable): any;
export declare class VpcepEndpointV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpcepEndpointV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VpcepEndpointV1Timeouts | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1 opentelekomcloud_vpcep_endpoint_v1}
*/
export declare class VpcepEndpointV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_vpcep_endpoint_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1 opentelekomcloud_vpcep_endpoint_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcepEndpointV1Config
    */
    constructor(scope: Construct, id: string, config: VpcepEndpointV1Config);
    get dnsNames(): string[];
    private _enableDns?;
    get enableDns(): boolean | cdktf.IResolvable;
    set enableDns(value: boolean | cdktf.IResolvable);
    resetEnableDns(): void;
    get enableDnsInput(): boolean | cdktf.IResolvable | undefined;
    private _enableWhitelist?;
    get enableWhitelist(): boolean | cdktf.IResolvable;
    set enableWhitelist(value: boolean | cdktf.IResolvable);
    resetEnableWhitelist(): void;
    get enableWhitelistInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get markerId(): number;
    private _portIp?;
    get portIp(): string;
    set portIp(value: string);
    resetPortIp(): void;
    get portIpInput(): string | undefined;
    get projectId(): string;
    private _routeTables?;
    get routeTables(): string[];
    set routeTables(value: string[]);
    resetRouteTables(): void;
    get routeTablesInput(): string[] | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
    get serviceName(): string;
    get serviceType(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _whitelist?;
    get whitelist(): string[];
    set whitelist(value: string[]);
    resetWhitelist(): void;
    get whitelistInput(): string[] | undefined;
    private _timeouts;
    get timeouts(): VpcepEndpointV1TimeoutsOutputReference;
    putTimeouts(value: VpcepEndpointV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VpcepEndpointV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
