import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpnaasIpsecPolicyV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#auth_algorithm VpnaasIpsecPolicyV2#auth_algorithm}
    */
    readonly authAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#description VpnaasIpsecPolicyV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#encapsulation_mode VpnaasIpsecPolicyV2#encapsulation_mode}
    */
    readonly encapsulationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#encryption_algorithm VpnaasIpsecPolicyV2#encryption_algorithm}
    */
    readonly encryptionAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#id VpnaasIpsecPolicyV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#name VpnaasIpsecPolicyV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#pfs VpnaasIpsecPolicyV2#pfs}
    */
    readonly pfs?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#region VpnaasIpsecPolicyV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#tenant_id VpnaasIpsecPolicyV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#transform_protocol VpnaasIpsecPolicyV2#transform_protocol}
    */
    readonly transformProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#value_specs VpnaasIpsecPolicyV2#value_specs}
    */
    readonly valueSpecs?: {
        [key: string]: string;
    };
    /**
    * lifetime block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#lifetime VpnaasIpsecPolicyV2#lifetime}
    */
    readonly lifetime?: VpnaasIpsecPolicyV2Lifetime[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#timeouts VpnaasIpsecPolicyV2#timeouts}
    */
    readonly timeouts?: VpnaasIpsecPolicyV2Timeouts;
}
export interface VpnaasIpsecPolicyV2Lifetime {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#units VpnaasIpsecPolicyV2#units}
    */
    readonly units?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#value VpnaasIpsecPolicyV2#value}
    */
    readonly value?: number;
}
export declare function vpnaasIpsecPolicyV2LifetimeToTerraform(struct?: VpnaasIpsecPolicyV2Lifetime | cdktf.IResolvable): any;
export declare class VpnaasIpsecPolicyV2LifetimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnaasIpsecPolicyV2Lifetime | cdktf.IResolvable | undefined;
    set internalValue(value: VpnaasIpsecPolicyV2Lifetime | cdktf.IResolvable | undefined);
    private _units?;
    get units(): string;
    set units(value: string);
    resetUnits(): void;
    get unitsInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    resetValue(): void;
    get valueInput(): number | undefined;
}
export declare class VpnaasIpsecPolicyV2LifetimeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnaasIpsecPolicyV2Lifetime[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnaasIpsecPolicyV2LifetimeOutputReference;
}
export interface VpnaasIpsecPolicyV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2#create VpnaasIpsecPolicyV2#create}
    */
    readonly create?: string;
}
export declare function vpnaasIpsecPolicyV2TimeoutsToTerraform(struct?: VpnaasIpsecPolicyV2TimeoutsOutputReference | VpnaasIpsecPolicyV2Timeouts | cdktf.IResolvable): any;
export declare class VpnaasIpsecPolicyV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnaasIpsecPolicyV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VpnaasIpsecPolicyV2Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2 opentelekomcloud_vpnaas_ipsec_policy_v2}
*/
export declare class VpnaasIpsecPolicyV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_vpnaas_ipsec_policy_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2 opentelekomcloud_vpnaas_ipsec_policy_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpnaasIpsecPolicyV2Config = {}
    */
    constructor(scope: Construct, id: string, config?: VpnaasIpsecPolicyV2Config);
    private _authAlgorithm?;
    get authAlgorithm(): string;
    set authAlgorithm(value: string);
    resetAuthAlgorithm(): void;
    get authAlgorithmInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _encapsulationMode?;
    get encapsulationMode(): string;
    set encapsulationMode(value: string);
    resetEncapsulationMode(): void;
    get encapsulationModeInput(): string | undefined;
    private _encryptionAlgorithm?;
    get encryptionAlgorithm(): string;
    set encryptionAlgorithm(value: string);
    resetEncryptionAlgorithm(): void;
    get encryptionAlgorithmInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _pfs?;
    get pfs(): string;
    set pfs(value: string);
    resetPfs(): void;
    get pfsInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _transformProtocol?;
    get transformProtocol(): string;
    set transformProtocol(value: string);
    resetTransformProtocol(): void;
    get transformProtocolInput(): string | undefined;
    private _valueSpecs?;
    get valueSpecs(): {
        [key: string]: string;
    };
    set valueSpecs(value: {
        [key: string]: string;
    });
    resetValueSpecs(): void;
    get valueSpecsInput(): {
        [key: string]: string;
    } | undefined;
    private _lifetime;
    get lifetime(): VpnaasIpsecPolicyV2LifetimeList;
    putLifetime(value: VpnaasIpsecPolicyV2Lifetime[] | cdktf.IResolvable): void;
    resetLifetime(): void;
    get lifetimeInput(): cdktf.IResolvable | VpnaasIpsecPolicyV2Lifetime[] | undefined;
    private _timeouts;
    get timeouts(): VpnaasIpsecPolicyV2TimeoutsOutputReference;
    putTimeouts(value: VpnaasIpsecPolicyV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VpnaasIpsecPolicyV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
