import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpnaasSiteConnectionV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#admin_state_up VpnaasSiteConnectionV2#admin_state_up}
    */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#description VpnaasSiteConnectionV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#id VpnaasSiteConnectionV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#ikepolicy_id VpnaasSiteConnectionV2#ikepolicy_id}
    */
    readonly ikepolicyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#initiator VpnaasSiteConnectionV2#initiator}
    */
    readonly initiator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#ipsecpolicy_id VpnaasSiteConnectionV2#ipsecpolicy_id}
    */
    readonly ipsecpolicyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#local_ep_group_id VpnaasSiteConnectionV2#local_ep_group_id}
    */
    readonly localEpGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#local_id VpnaasSiteConnectionV2#local_id}
    */
    readonly localId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#mtu VpnaasSiteConnectionV2#mtu}
    */
    readonly mtu?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#name VpnaasSiteConnectionV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#peer_address VpnaasSiteConnectionV2#peer_address}
    */
    readonly peerAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#peer_cidrs VpnaasSiteConnectionV2#peer_cidrs}
    */
    readonly peerCidrs?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#peer_ep_group_id VpnaasSiteConnectionV2#peer_ep_group_id}
    */
    readonly peerEpGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#peer_id VpnaasSiteConnectionV2#peer_id}
    */
    readonly peerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#psk VpnaasSiteConnectionV2#psk}
    */
    readonly psk: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#region VpnaasSiteConnectionV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#tags VpnaasSiteConnectionV2#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#tenant_id VpnaasSiteConnectionV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#value_specs VpnaasSiteConnectionV2#value_specs}
    */
    readonly valueSpecs?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#vpnservice_id VpnaasSiteConnectionV2#vpnservice_id}
    */
    readonly vpnserviceId: string;
    /**
    * dpd block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#dpd VpnaasSiteConnectionV2#dpd}
    */
    readonly dpd?: VpnaasSiteConnectionV2Dpd[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#timeouts VpnaasSiteConnectionV2#timeouts}
    */
    readonly timeouts?: VpnaasSiteConnectionV2Timeouts;
}
export interface VpnaasSiteConnectionV2Dpd {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#action VpnaasSiteConnectionV2#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#interval VpnaasSiteConnectionV2#interval}
    */
    readonly interval?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#timeout VpnaasSiteConnectionV2#timeout}
    */
    readonly timeout?: number;
}
export declare function vpnaasSiteConnectionV2DpdToTerraform(struct?: VpnaasSiteConnectionV2Dpd | cdktf.IResolvable): any;
export declare class VpnaasSiteConnectionV2DpdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnaasSiteConnectionV2Dpd | cdktf.IResolvable | undefined;
    set internalValue(value: VpnaasSiteConnectionV2Dpd | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
}
export declare class VpnaasSiteConnectionV2DpdList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnaasSiteConnectionV2Dpd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnaasSiteConnectionV2DpdOutputReference;
}
export interface VpnaasSiteConnectionV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#create VpnaasSiteConnectionV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#delete VpnaasSiteConnectionV2#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2#update VpnaasSiteConnectionV2#update}
    */
    readonly update?: string;
}
export declare function vpnaasSiteConnectionV2TimeoutsToTerraform(struct?: VpnaasSiteConnectionV2TimeoutsOutputReference | VpnaasSiteConnectionV2Timeouts | cdktf.IResolvable): any;
export declare class VpnaasSiteConnectionV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnaasSiteConnectionV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VpnaasSiteConnectionV2Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2 opentelekomcloud_vpnaas_site_connection_v2}
*/
export declare class VpnaasSiteConnectionV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_vpnaas_site_connection_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2 opentelekomcloud_vpnaas_site_connection_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpnaasSiteConnectionV2Config
    */
    constructor(scope: Construct, id: string, config: VpnaasSiteConnectionV2Config);
    private _adminStateUp?;
    get adminStateUp(): boolean | cdktf.IResolvable;
    set adminStateUp(value: boolean | cdktf.IResolvable);
    resetAdminStateUp(): void;
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ikepolicyId?;
    get ikepolicyId(): string;
    set ikepolicyId(value: string);
    get ikepolicyIdInput(): string | undefined;
    private _initiator?;
    get initiator(): string;
    set initiator(value: string);
    resetInitiator(): void;
    get initiatorInput(): string | undefined;
    private _ipsecpolicyId?;
    get ipsecpolicyId(): string;
    set ipsecpolicyId(value: string);
    get ipsecpolicyIdInput(): string | undefined;
    private _localEpGroupId?;
    get localEpGroupId(): string;
    set localEpGroupId(value: string);
    resetLocalEpGroupId(): void;
    get localEpGroupIdInput(): string | undefined;
    private _localId?;
    get localId(): string;
    set localId(value: string);
    resetLocalId(): void;
    get localIdInput(): string | undefined;
    private _mtu?;
    get mtu(): number;
    set mtu(value: number);
    resetMtu(): void;
    get mtuInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _peerAddress?;
    get peerAddress(): string;
    set peerAddress(value: string);
    get peerAddressInput(): string | undefined;
    private _peerCidrs?;
    get peerCidrs(): string[];
    set peerCidrs(value: string[]);
    resetPeerCidrs(): void;
    get peerCidrsInput(): string[] | undefined;
    private _peerEpGroupId?;
    get peerEpGroupId(): string;
    set peerEpGroupId(value: string);
    resetPeerEpGroupId(): void;
    get peerEpGroupIdInput(): string | undefined;
    private _peerId?;
    get peerId(): string;
    set peerId(value: string);
    get peerIdInput(): string | undefined;
    private _psk?;
    get psk(): string;
    set psk(value: string);
    get pskInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _valueSpecs?;
    get valueSpecs(): {
        [key: string]: string;
    };
    set valueSpecs(value: {
        [key: string]: string;
    });
    resetValueSpecs(): void;
    get valueSpecsInput(): {
        [key: string]: string;
    } | undefined;
    private _vpnserviceId?;
    get vpnserviceId(): string;
    set vpnserviceId(value: string);
    get vpnserviceIdInput(): string | undefined;
    private _dpd;
    get dpd(): VpnaasSiteConnectionV2DpdList;
    putDpd(value: VpnaasSiteConnectionV2Dpd[] | cdktf.IResolvable): void;
    resetDpd(): void;
    get dpdInput(): cdktf.IResolvable | VpnaasSiteConnectionV2Dpd[] | undefined;
    private _timeouts;
    get timeouts(): VpnaasSiteConnectionV2TimeoutsOutputReference;
    putTimeouts(value: VpnaasSiteConnectionV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VpnaasSiteConnectionV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
