import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WafAlarmNotificationV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1#enabled WafAlarmNotificationV1#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1#id WafAlarmNotificationV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1#locale WafAlarmNotificationV1#locale}
    */
    readonly locale?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1#send_frequency WafAlarmNotificationV1#send_frequency}
    */
    readonly sendFrequency: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1#threat WafAlarmNotificationV1#threat}
    */
    readonly threat: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1#times WafAlarmNotificationV1#times}
    */
    readonly times: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1#topic_urn WafAlarmNotificationV1#topic_urn}
    */
    readonly topicUrn: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1 opentelekomcloud_waf_alarm_notification_v1}
*/
export declare class WafAlarmNotificationV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_waf_alarm_notification_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1 opentelekomcloud_waf_alarm_notification_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WafAlarmNotificationV1Config
    */
    constructor(scope: Construct, id: string, config: WafAlarmNotificationV1Config);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _locale?;
    get locale(): string;
    set locale(value: string);
    resetLocale(): void;
    get localeInput(): string | undefined;
    private _sendFrequency?;
    get sendFrequency(): number;
    set sendFrequency(value: number);
    get sendFrequencyInput(): number | undefined;
    private _threat?;
    get threat(): string[];
    set threat(value: string[]);
    get threatInput(): string[] | undefined;
    private _times?;
    get times(): number;
    set times(value: number);
    get timesInput(): number | undefined;
    private _topicUrn?;
    get topicUrn(): string;
    set topicUrn(value: string);
    get topicUrnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
