import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WafDatamaskingRuleV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_datamasking_rule_v1#category WafDatamaskingRuleV1#category}
    */
    readonly category: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_datamasking_rule_v1#id WafDatamaskingRuleV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_datamasking_rule_v1#index WafDatamaskingRuleV1#index}
    */
    readonly index: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_datamasking_rule_v1#policy_id WafDatamaskingRuleV1#policy_id}
    */
    readonly policyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_datamasking_rule_v1#url WafDatamaskingRuleV1#url}
    */
    readonly url: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_datamasking_rule_v1#timeouts WafDatamaskingRuleV1#timeouts}
    */
    readonly timeouts?: WafDatamaskingRuleV1Timeouts;
}
export interface WafDatamaskingRuleV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_datamasking_rule_v1#create WafDatamaskingRuleV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_datamasking_rule_v1#delete WafDatamaskingRuleV1#delete}
    */
    readonly delete?: string;
}
export declare function wafDatamaskingRuleV1TimeoutsToTerraform(struct?: WafDatamaskingRuleV1TimeoutsOutputReference | WafDatamaskingRuleV1Timeouts | cdktf.IResolvable): any;
export declare class WafDatamaskingRuleV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WafDatamaskingRuleV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WafDatamaskingRuleV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_datamasking_rule_v1 opentelekomcloud_waf_datamasking_rule_v1}
*/
export declare class WafDatamaskingRuleV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_waf_datamasking_rule_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_datamasking_rule_v1 opentelekomcloud_waf_datamasking_rule_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WafDatamaskingRuleV1Config
    */
    constructor(scope: Construct, id: string, config: WafDatamaskingRuleV1Config);
    private _category?;
    get category(): string;
    set category(value: string);
    get categoryInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _timeouts;
    get timeouts(): WafDatamaskingRuleV1TimeoutsOutputReference;
    putTimeouts(value: WafDatamaskingRuleV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WafDatamaskingRuleV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
