import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WafDomainV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#certificate_id WafDomainV1#certificate_id}
    */
    readonly certificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#cipher WafDomainV1#cipher}
    */
    readonly cipher?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#hostname WafDomainV1#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#id WafDomainV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#policy_id WafDomainV1#policy_id}
    */
    readonly policyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#proxy WafDomainV1#proxy}
    */
    readonly proxy: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#sip_header_list WafDomainV1#sip_header_list}
    */
    readonly sipHeaderList?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#sip_header_name WafDomainV1#sip_header_name}
    */
    readonly sipHeaderName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#tls WafDomainV1#tls}
    */
    readonly tls?: string;
    /**
    * server block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#server WafDomainV1#server}
    */
    readonly server: WafDomainV1Server[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#timeouts WafDomainV1#timeouts}
    */
    readonly timeouts?: WafDomainV1Timeouts;
}
export interface WafDomainV1Server {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#address WafDomainV1#address}
    */
    readonly address: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#back_protocol WafDomainV1#back_protocol}
    */
    readonly backProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#client_protocol WafDomainV1#client_protocol}
    */
    readonly clientProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#front_protocol WafDomainV1#front_protocol}
    */
    readonly frontProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#port WafDomainV1#port}
    */
    readonly port: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#server_protocol WafDomainV1#server_protocol}
    */
    readonly serverProtocol?: string;
}
export declare function wafDomainV1ServerToTerraform(struct?: WafDomainV1Server | cdktf.IResolvable): any;
export declare class WafDomainV1ServerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WafDomainV1Server | cdktf.IResolvable | undefined;
    set internalValue(value: WafDomainV1Server | cdktf.IResolvable | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _backProtocol?;
    get backProtocol(): string;
    set backProtocol(value: string);
    resetBackProtocol(): void;
    get backProtocolInput(): string | undefined;
    private _clientProtocol?;
    get clientProtocol(): string;
    set clientProtocol(value: string);
    resetClientProtocol(): void;
    get clientProtocolInput(): string | undefined;
    private _frontProtocol?;
    get frontProtocol(): string;
    set frontProtocol(value: string);
    resetFrontProtocol(): void;
    get frontProtocolInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
    private _serverProtocol?;
    get serverProtocol(): string;
    set serverProtocol(value: string);
    resetServerProtocol(): void;
    get serverProtocolInput(): string | undefined;
}
export declare class WafDomainV1ServerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WafDomainV1Server[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WafDomainV1ServerOutputReference;
}
export interface WafDomainV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#create WafDomainV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#delete WafDomainV1#delete}
    */
    readonly delete?: string;
}
export declare function wafDomainV1TimeoutsToTerraform(struct?: WafDomainV1TimeoutsOutputReference | WafDomainV1Timeouts | cdktf.IResolvable): any;
export declare class WafDomainV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WafDomainV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WafDomainV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1 opentelekomcloud_waf_domain_v1}
*/
export declare class WafDomainV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_waf_domain_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1 opentelekomcloud_waf_domain_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WafDomainV1Config
    */
    constructor(scope: Construct, id: string, config: WafDomainV1Config);
    get accessCode(): string;
    get accessStatus(): number;
    private _certificateId?;
    get certificateId(): string;
    set certificateId(value: string);
    resetCertificateId(): void;
    get certificateIdInput(): string | undefined;
    private _cipher?;
    get cipher(): string;
    set cipher(value: string);
    resetCipher(): void;
    get cipherInput(): string | undefined;
    get cname(): string;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    get protectStatus(): number;
    get protocol(): string;
    private _proxy?;
    get proxy(): boolean | cdktf.IResolvable;
    set proxy(value: boolean | cdktf.IResolvable);
    get proxyInput(): boolean | cdktf.IResolvable | undefined;
    private _sipHeaderList?;
    get sipHeaderList(): string[];
    set sipHeaderList(value: string[]);
    resetSipHeaderList(): void;
    get sipHeaderListInput(): string[] | undefined;
    private _sipHeaderName?;
    get sipHeaderName(): string;
    set sipHeaderName(value: string);
    resetSipHeaderName(): void;
    get sipHeaderNameInput(): string | undefined;
    get subDomain(): string;
    private _tls?;
    get tls(): string;
    set tls(value: string);
    resetTls(): void;
    get tlsInput(): string | undefined;
    get txtCode(): string;
    private _server;
    get server(): WafDomainV1ServerList;
    putServer(value: WafDomainV1Server[] | cdktf.IResolvable): void;
    get serverInput(): cdktf.IResolvable | WafDomainV1Server[] | undefined;
    private _timeouts;
    get timeouts(): WafDomainV1TimeoutsOutputReference;
    putTimeouts(value: WafDomainV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WafDomainV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
