import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WafPolicyV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#full_detection WafPolicyV1#full_detection}
    */
    readonly fullDetection?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#hosts WafPolicyV1#hosts}
    */
    readonly hosts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#id WafPolicyV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#level WafPolicyV1#level}
    */
    readonly level?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#name WafPolicyV1#name}
    */
    readonly name: string;
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#action WafPolicyV1#action}
    */
    readonly action?: WafPolicyV1Action;
    /**
    * options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#options WafPolicyV1#options}
    */
    readonly options?: WafPolicyV1Options;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#timeouts WafPolicyV1#timeouts}
    */
    readonly timeouts?: WafPolicyV1Timeouts;
}
export interface WafPolicyV1Action {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#category WafPolicyV1#category}
    */
    readonly category: string;
}
export declare function wafPolicyV1ActionToTerraform(struct?: WafPolicyV1ActionOutputReference | WafPolicyV1Action): any;
export declare class WafPolicyV1ActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WafPolicyV1Action | undefined;
    set internalValue(value: WafPolicyV1Action | undefined);
    private _category?;
    get category(): string;
    set category(value: string);
    get categoryInput(): string | undefined;
}
export interface WafPolicyV1Options {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#antitamper WafPolicyV1#antitamper}
    */
    readonly antitamper?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#cc WafPolicyV1#cc}
    */
    readonly cc?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#common WafPolicyV1#common}
    */
    readonly common?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#crawler WafPolicyV1#crawler}
    */
    readonly crawler?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#crawler_engine WafPolicyV1#crawler_engine}
    */
    readonly crawlerEngine?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#crawler_other WafPolicyV1#crawler_other}
    */
    readonly crawlerOther?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#crawler_scanner WafPolicyV1#crawler_scanner}
    */
    readonly crawlerScanner?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#crawler_script WafPolicyV1#crawler_script}
    */
    readonly crawlerScript?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#custom WafPolicyV1#custom}
    */
    readonly custom?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#ignore WafPolicyV1#ignore}
    */
    readonly ignore?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#privacy WafPolicyV1#privacy}
    */
    readonly privacy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#webattack WafPolicyV1#webattack}
    */
    readonly webattack?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#webshell WafPolicyV1#webshell}
    */
    readonly webshell?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#whiteblackip WafPolicyV1#whiteblackip}
    */
    readonly whiteblackip?: boolean | cdktf.IResolvable;
}
export declare function wafPolicyV1OptionsToTerraform(struct?: WafPolicyV1OptionsOutputReference | WafPolicyV1Options): any;
export declare class WafPolicyV1OptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WafPolicyV1Options | undefined;
    set internalValue(value: WafPolicyV1Options | undefined);
    private _antitamper?;
    get antitamper(): boolean | cdktf.IResolvable;
    set antitamper(value: boolean | cdktf.IResolvable);
    resetAntitamper(): void;
    get antitamperInput(): boolean | cdktf.IResolvable | undefined;
    private _cc?;
    get cc(): boolean | cdktf.IResolvable;
    set cc(value: boolean | cdktf.IResolvable);
    resetCc(): void;
    get ccInput(): boolean | cdktf.IResolvable | undefined;
    private _common?;
    get common(): boolean | cdktf.IResolvable;
    set common(value: boolean | cdktf.IResolvable);
    resetCommon(): void;
    get commonInput(): boolean | cdktf.IResolvable | undefined;
    private _crawler?;
    get crawler(): boolean | cdktf.IResolvable;
    set crawler(value: boolean | cdktf.IResolvable);
    resetCrawler(): void;
    get crawlerInput(): boolean | cdktf.IResolvable | undefined;
    private _crawlerEngine?;
    get crawlerEngine(): boolean | cdktf.IResolvable;
    set crawlerEngine(value: boolean | cdktf.IResolvable);
    resetCrawlerEngine(): void;
    get crawlerEngineInput(): boolean | cdktf.IResolvable | undefined;
    private _crawlerOther?;
    get crawlerOther(): boolean | cdktf.IResolvable;
    set crawlerOther(value: boolean | cdktf.IResolvable);
    resetCrawlerOther(): void;
    get crawlerOtherInput(): boolean | cdktf.IResolvable | undefined;
    private _crawlerScanner?;
    get crawlerScanner(): boolean | cdktf.IResolvable;
    set crawlerScanner(value: boolean | cdktf.IResolvable);
    resetCrawlerScanner(): void;
    get crawlerScannerInput(): boolean | cdktf.IResolvable | undefined;
    private _crawlerScript?;
    get crawlerScript(): boolean | cdktf.IResolvable;
    set crawlerScript(value: boolean | cdktf.IResolvable);
    resetCrawlerScript(): void;
    get crawlerScriptInput(): boolean | cdktf.IResolvable | undefined;
    private _custom?;
    get custom(): boolean | cdktf.IResolvable;
    set custom(value: boolean | cdktf.IResolvable);
    resetCustom(): void;
    get customInput(): boolean | cdktf.IResolvable | undefined;
    private _ignore?;
    get ignore(): boolean | cdktf.IResolvable;
    set ignore(value: boolean | cdktf.IResolvable);
    resetIgnore(): void;
    get ignoreInput(): boolean | cdktf.IResolvable | undefined;
    private _privacy?;
    get privacy(): boolean | cdktf.IResolvable;
    set privacy(value: boolean | cdktf.IResolvable);
    resetPrivacy(): void;
    get privacyInput(): boolean | cdktf.IResolvable | undefined;
    private _webattack?;
    get webattack(): boolean | cdktf.IResolvable;
    set webattack(value: boolean | cdktf.IResolvable);
    resetWebattack(): void;
    get webattackInput(): boolean | cdktf.IResolvable | undefined;
    private _webshell?;
    get webshell(): boolean | cdktf.IResolvable;
    set webshell(value: boolean | cdktf.IResolvable);
    resetWebshell(): void;
    get webshellInput(): boolean | cdktf.IResolvable | undefined;
    private _whiteblackip?;
    get whiteblackip(): boolean | cdktf.IResolvable;
    set whiteblackip(value: boolean | cdktf.IResolvable);
    resetWhiteblackip(): void;
    get whiteblackipInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WafPolicyV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#create WafPolicyV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1#delete WafPolicyV1#delete}
    */
    readonly delete?: string;
}
export declare function wafPolicyV1TimeoutsToTerraform(struct?: WafPolicyV1TimeoutsOutputReference | WafPolicyV1Timeouts | cdktf.IResolvable): any;
export declare class WafPolicyV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WafPolicyV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WafPolicyV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1 opentelekomcloud_waf_policy_v1}
*/
export declare class WafPolicyV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_waf_policy_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1 opentelekomcloud_waf_policy_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WafPolicyV1Config
    */
    constructor(scope: Construct, id: string, config: WafPolicyV1Config);
    private _fullDetection?;
    get fullDetection(): boolean | cdktf.IResolvable;
    set fullDetection(value: boolean | cdktf.IResolvable);
    resetFullDetection(): void;
    get fullDetectionInput(): boolean | cdktf.IResolvable | undefined;
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    resetHosts(): void;
    get hostsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _level?;
    get level(): number;
    set level(value: number);
    resetLevel(): void;
    get levelInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _action;
    get action(): WafPolicyV1ActionOutputReference;
    putAction(value: WafPolicyV1Action): void;
    resetAction(): void;
    get actionInput(): WafPolicyV1Action | undefined;
    private _options;
    get options(): WafPolicyV1OptionsOutputReference;
    putOptions(value: WafPolicyV1Options): void;
    resetOptions(): void;
    get optionsInput(): WafPolicyV1Options | undefined;
    private _timeouts;
    get timeouts(): WafPolicyV1TimeoutsOutputReference;
    putTimeouts(value: WafPolicyV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WafPolicyV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
