import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WafWhiteblackipRuleV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#addr WafWhiteblackipRuleV1#addr}
    */
    readonly addr: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#id WafWhiteblackipRuleV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#policy_id WafWhiteblackipRuleV1#policy_id}
    */
    readonly policyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#white WafWhiteblackipRuleV1#white}
    */
    readonly white?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#timeouts WafWhiteblackipRuleV1#timeouts}
    */
    readonly timeouts?: WafWhiteblackipRuleV1Timeouts;
}
export interface WafWhiteblackipRuleV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#create WafWhiteblackipRuleV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#delete WafWhiteblackipRuleV1#delete}
    */
    readonly delete?: string;
}
export declare function wafWhiteblackipRuleV1TimeoutsToTerraform(struct?: WafWhiteblackipRuleV1TimeoutsOutputReference | WafWhiteblackipRuleV1Timeouts | cdktf.IResolvable): any;
export declare class WafWhiteblackipRuleV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WafWhiteblackipRuleV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WafWhiteblackipRuleV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1 opentelekomcloud_waf_whiteblackip_rule_v1}
*/
export declare class WafWhiteblackipRuleV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_waf_whiteblackip_rule_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1 opentelekomcloud_waf_whiteblackip_rule_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WafWhiteblackipRuleV1Config
    */
    constructor(scope: Construct, id: string, config: WafWhiteblackipRuleV1Config);
    private _addr?;
    get addr(): string;
    set addr(value: string);
    get addrInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    private _white?;
    get white(): number;
    set white(value: number);
    resetWhite(): void;
    get whiteInput(): number | undefined;
    private _timeouts;
    get timeouts(): WafWhiteblackipRuleV1TimeoutsOutputReference;
    putTimeouts(value: WafWhiteblackipRuleV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WafWhiteblackipRuleV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
