"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import sys
import typing

import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _OutputScriptType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OutputScriptTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OutputScriptType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SCRIPT_TYPE_PUBKEY_HASH: _OutputScriptType.ValueType  # 0
    SCRIPT_TYPE_SCRIPT_HASH: _OutputScriptType.ValueType  # 1
    SCRIPT_TYPE_WITNESS_V0_PUBKEY_HASH: _OutputScriptType.ValueType  # 2
    SCRIPT_TYPE_WITNESS_V0_SCRIPT_HASH: _OutputScriptType.ValueType  # 3
    SCRIPT_TYPE_PUBKEY: _OutputScriptType.ValueType  # 4
    SCRIPT_TYPE_MULTISIG: _OutputScriptType.ValueType  # 5
    SCRIPT_TYPE_NULLDATA: _OutputScriptType.ValueType  # 6
    SCRIPT_TYPE_NON_STANDARD: _OutputScriptType.ValueType  # 7
    SCRIPT_TYPE_WITNESS_UNKNOWN: _OutputScriptType.ValueType  # 8
    SCRIPT_TYPE_WITNESS_V1_TAPROOT: _OutputScriptType.ValueType  # 9

class OutputScriptType(_OutputScriptType, metaclass=_OutputScriptTypeEnumTypeWrapper): ...

SCRIPT_TYPE_PUBKEY_HASH: OutputScriptType.ValueType  # 0
SCRIPT_TYPE_SCRIPT_HASH: OutputScriptType.ValueType  # 1
SCRIPT_TYPE_WITNESS_V0_PUBKEY_HASH: OutputScriptType.ValueType  # 2
SCRIPT_TYPE_WITNESS_V0_SCRIPT_HASH: OutputScriptType.ValueType  # 3
SCRIPT_TYPE_PUBKEY: OutputScriptType.ValueType  # 4
SCRIPT_TYPE_MULTISIG: OutputScriptType.ValueType  # 5
SCRIPT_TYPE_NULLDATA: OutputScriptType.ValueType  # 6
SCRIPT_TYPE_NON_STANDARD: OutputScriptType.ValueType  # 7
SCRIPT_TYPE_WITNESS_UNKNOWN: OutputScriptType.ValueType  # 8
SCRIPT_TYPE_WITNESS_V1_TAPROOT: OutputScriptType.ValueType  # 9
global___OutputScriptType = OutputScriptType

class _CoinSelectionStrategy:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CoinSelectionStrategyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CoinSelectionStrategy.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STRATEGY_USE_GLOBAL_CONFIG: _CoinSelectionStrategy.ValueType  # 0
    """Use the coin selection strategy defined in the global configuration
    (lnd.conf).
    """
    STRATEGY_LARGEST: _CoinSelectionStrategy.ValueType  # 1
    """Select the largest available coins first during coin selection."""
    STRATEGY_RANDOM: _CoinSelectionStrategy.ValueType  # 2
    """Randomly select the available coins during coin selection."""

class CoinSelectionStrategy(_CoinSelectionStrategy, metaclass=_CoinSelectionStrategyEnumTypeWrapper): ...

STRATEGY_USE_GLOBAL_CONFIG: CoinSelectionStrategy.ValueType  # 0
"""Use the coin selection strategy defined in the global configuration
(lnd.conf).
"""
STRATEGY_LARGEST: CoinSelectionStrategy.ValueType  # 1
"""Select the largest available coins first during coin selection."""
STRATEGY_RANDOM: CoinSelectionStrategy.ValueType  # 2
"""Randomly select the available coins during coin selection."""
global___CoinSelectionStrategy = CoinSelectionStrategy

class _AddressType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AddressTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AddressType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    WITNESS_PUBKEY_HASH: _AddressType.ValueType  # 0
    NESTED_PUBKEY_HASH: _AddressType.ValueType  # 1
    UNUSED_WITNESS_PUBKEY_HASH: _AddressType.ValueType  # 2
    UNUSED_NESTED_PUBKEY_HASH: _AddressType.ValueType  # 3
    TAPROOT_PUBKEY: _AddressType.ValueType  # 4
    UNUSED_TAPROOT_PUBKEY: _AddressType.ValueType  # 5

class AddressType(_AddressType, metaclass=_AddressTypeEnumTypeWrapper):
    """
    `AddressType` has to be one of:

    - `p2wkh`: Pay to witness key hash (`WITNESS_PUBKEY_HASH` = 0)
    - `np2wkh`: Pay to nested witness key hash (`NESTED_PUBKEY_HASH` = 1)
    - `p2tr`: Pay to taproot pubkey (`TAPROOT_PUBKEY` = 4)
    """

WITNESS_PUBKEY_HASH: AddressType.ValueType  # 0
NESTED_PUBKEY_HASH: AddressType.ValueType  # 1
UNUSED_WITNESS_PUBKEY_HASH: AddressType.ValueType  # 2
UNUSED_NESTED_PUBKEY_HASH: AddressType.ValueType  # 3
TAPROOT_PUBKEY: AddressType.ValueType  # 4
UNUSED_TAPROOT_PUBKEY: AddressType.ValueType  # 5
global___AddressType = AddressType

class _CommitmentType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CommitmentTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CommitmentType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN_COMMITMENT_TYPE: _CommitmentType.ValueType  # 0
    """
    Returned when the commitment type isn't known or unavailable.
    """
    LEGACY: _CommitmentType.ValueType  # 1
    """
    A channel using the legacy commitment format having tweaked to_remote
    keys.
    """
    STATIC_REMOTE_KEY: _CommitmentType.ValueType  # 2
    """
    A channel that uses the modern commitment format where the key in the
    output of the remote party does not change each state. This makes back
    up and recovery easier as when the channel is closed, the funds go
    directly to that key.
    """
    ANCHORS: _CommitmentType.ValueType  # 3
    """
    A channel that uses a commitment format that has anchor outputs on the
    commitments, allowing fee bumping after a force close transaction has
    been broadcast.
    """
    SCRIPT_ENFORCED_LEASE: _CommitmentType.ValueType  # 4
    """
    A channel that uses a commitment type that builds upon the anchors
    commitment format, but in addition requires a CLTV clause to spend outputs
    paying to the channel initiator. This is intended for use on leased channels
    to guarantee that the channel initiator has no incentives to close a leased
    channel before its maturity date.
    """
    SIMPLE_TAPROOT: _CommitmentType.ValueType  # 5
    """
    A channel that uses musig2 for the funding output, and the new tapscript
    features where relevant.

    TODO(roasbeef): need script enforce mirror type for the above as well?
    """

class CommitmentType(_CommitmentType, metaclass=_CommitmentTypeEnumTypeWrapper): ...

UNKNOWN_COMMITMENT_TYPE: CommitmentType.ValueType  # 0
"""
Returned when the commitment type isn't known or unavailable.
"""
LEGACY: CommitmentType.ValueType  # 1
"""
A channel using the legacy commitment format having tweaked to_remote
keys.
"""
STATIC_REMOTE_KEY: CommitmentType.ValueType  # 2
"""
A channel that uses the modern commitment format where the key in the
output of the remote party does not change each state. This makes back
up and recovery easier as when the channel is closed, the funds go
directly to that key.
"""
ANCHORS: CommitmentType.ValueType  # 3
"""
A channel that uses a commitment format that has anchor outputs on the
commitments, allowing fee bumping after a force close transaction has
been broadcast.
"""
SCRIPT_ENFORCED_LEASE: CommitmentType.ValueType  # 4
"""
A channel that uses a commitment type that builds upon the anchors
commitment format, but in addition requires a CLTV clause to spend outputs
paying to the channel initiator. This is intended for use on leased channels
to guarantee that the channel initiator has no incentives to close a leased
channel before its maturity date.
"""
SIMPLE_TAPROOT: CommitmentType.ValueType  # 5
"""
A channel that uses musig2 for the funding output, and the new tapscript
features where relevant.

TODO(roasbeef): need script enforce mirror type for the above as well?
"""
global___CommitmentType = CommitmentType

class _Initiator:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _InitiatorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Initiator.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INITIATOR_UNKNOWN: _Initiator.ValueType  # 0
    INITIATOR_LOCAL: _Initiator.ValueType  # 1
    INITIATOR_REMOTE: _Initiator.ValueType  # 2
    INITIATOR_BOTH: _Initiator.ValueType  # 3

class Initiator(_Initiator, metaclass=_InitiatorEnumTypeWrapper): ...

INITIATOR_UNKNOWN: Initiator.ValueType  # 0
INITIATOR_LOCAL: Initiator.ValueType  # 1
INITIATOR_REMOTE: Initiator.ValueType  # 2
INITIATOR_BOTH: Initiator.ValueType  # 3
global___Initiator = Initiator

class _ResolutionType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ResolutionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ResolutionType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TYPE_UNKNOWN: _ResolutionType.ValueType  # 0
    ANCHOR: _ResolutionType.ValueType  # 1
    """We resolved an anchor output."""
    INCOMING_HTLC: _ResolutionType.ValueType  # 2
    """
    We are resolving an incoming htlc on chain. This if this htlc is
    claimed, we swept the incoming htlc with the preimage. If it is timed
    out, our peer swept the timeout path.
    """
    OUTGOING_HTLC: _ResolutionType.ValueType  # 3
    """
    We are resolving an outgoing htlc on chain. If this htlc is claimed,
    the remote party swept the htlc with the preimage. If it is timed out,
    we swept it with the timeout path.
    """
    COMMIT: _ResolutionType.ValueType  # 4
    """We force closed and need to sweep our time locked commitment output."""

class ResolutionType(_ResolutionType, metaclass=_ResolutionTypeEnumTypeWrapper): ...

TYPE_UNKNOWN: ResolutionType.ValueType  # 0
ANCHOR: ResolutionType.ValueType  # 1
"""We resolved an anchor output."""
INCOMING_HTLC: ResolutionType.ValueType  # 2
"""
We are resolving an incoming htlc on chain. This if this htlc is
claimed, we swept the incoming htlc with the preimage. If it is timed
out, our peer swept the timeout path.
"""
OUTGOING_HTLC: ResolutionType.ValueType  # 3
"""
We are resolving an outgoing htlc on chain. If this htlc is claimed,
the remote party swept the htlc with the preimage. If it is timed out,
we swept it with the timeout path.
"""
COMMIT: ResolutionType.ValueType  # 4
"""We force closed and need to sweep our time locked commitment output."""
global___ResolutionType = ResolutionType

class _ResolutionOutcome:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ResolutionOutcomeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ResolutionOutcome.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    OUTCOME_UNKNOWN: _ResolutionOutcome.ValueType  # 0
    """Outcome unknown."""
    CLAIMED: _ResolutionOutcome.ValueType  # 1
    """An output was claimed on chain."""
    UNCLAIMED: _ResolutionOutcome.ValueType  # 2
    """An output was left unclaimed on chain."""
    ABANDONED: _ResolutionOutcome.ValueType  # 3
    """
    ResolverOutcomeAbandoned indicates that an output that we did not
    claim on chain, for example an anchor that we did not sweep and a
    third party claimed on chain, or a htlc that we could not decode
    so left unclaimed.
    """
    FIRST_STAGE: _ResolutionOutcome.ValueType  # 4
    """
    If we force closed our channel, our htlcs need to be claimed in two
    stages. This outcome represents the broadcast of a timeout or success
    transaction for this two stage htlc claim.
    """
    TIMEOUT: _ResolutionOutcome.ValueType  # 5
    """A htlc was timed out on chain."""

class ResolutionOutcome(_ResolutionOutcome, metaclass=_ResolutionOutcomeEnumTypeWrapper): ...

OUTCOME_UNKNOWN: ResolutionOutcome.ValueType  # 0
"""Outcome unknown."""
CLAIMED: ResolutionOutcome.ValueType  # 1
"""An output was claimed on chain."""
UNCLAIMED: ResolutionOutcome.ValueType  # 2
"""An output was left unclaimed on chain."""
ABANDONED: ResolutionOutcome.ValueType  # 3
"""
ResolverOutcomeAbandoned indicates that an output that we did not
claim on chain, for example an anchor that we did not sweep and a
third party claimed on chain, or a htlc that we could not decode
so left unclaimed.
"""
FIRST_STAGE: ResolutionOutcome.ValueType  # 4
"""
If we force closed our channel, our htlcs need to be claimed in two
stages. This outcome represents the broadcast of a timeout or success
transaction for this two stage htlc claim.
"""
TIMEOUT: ResolutionOutcome.ValueType  # 5
"""A htlc was timed out on chain."""
global___ResolutionOutcome = ResolutionOutcome

class _NodeMetricType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _NodeMetricTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_NodeMetricType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN: _NodeMetricType.ValueType  # 0
    BETWEENNESS_CENTRALITY: _NodeMetricType.ValueType  # 1

class NodeMetricType(_NodeMetricType, metaclass=_NodeMetricTypeEnumTypeWrapper): ...

UNKNOWN: NodeMetricType.ValueType  # 0
BETWEENNESS_CENTRALITY: NodeMetricType.ValueType  # 1
global___NodeMetricType = NodeMetricType

class _InvoiceHTLCState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _InvoiceHTLCStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_InvoiceHTLCState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ACCEPTED: _InvoiceHTLCState.ValueType  # 0
    SETTLED: _InvoiceHTLCState.ValueType  # 1
    CANCELED: _InvoiceHTLCState.ValueType  # 2

class InvoiceHTLCState(_InvoiceHTLCState, metaclass=_InvoiceHTLCStateEnumTypeWrapper): ...

ACCEPTED: InvoiceHTLCState.ValueType  # 0
SETTLED: InvoiceHTLCState.ValueType  # 1
CANCELED: InvoiceHTLCState.ValueType  # 2
global___InvoiceHTLCState = InvoiceHTLCState

class _PaymentFailureReason:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PaymentFailureReasonEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PaymentFailureReason.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    FAILURE_REASON_NONE: _PaymentFailureReason.ValueType  # 0
    """
    Payment isn't failed (yet).
    """
    FAILURE_REASON_TIMEOUT: _PaymentFailureReason.ValueType  # 1
    """
    There are more routes to try, but the payment timeout was exceeded.
    """
    FAILURE_REASON_NO_ROUTE: _PaymentFailureReason.ValueType  # 2
    """
    All possible routes were tried and failed permanently. Or were no
    routes to the destination at all.
    """
    FAILURE_REASON_ERROR: _PaymentFailureReason.ValueType  # 3
    """
    A non-recoverable error has occured.
    """
    FAILURE_REASON_INCORRECT_PAYMENT_DETAILS: _PaymentFailureReason.ValueType  # 4
    """
    Payment details incorrect (unknown hash, invalid amt or
    invalid final cltv delta)
    """
    FAILURE_REASON_INSUFFICIENT_BALANCE: _PaymentFailureReason.ValueType  # 5
    """
    Insufficient local balance.
    """

class PaymentFailureReason(_PaymentFailureReason, metaclass=_PaymentFailureReasonEnumTypeWrapper): ...

FAILURE_REASON_NONE: PaymentFailureReason.ValueType  # 0
"""
Payment isn't failed (yet).
"""
FAILURE_REASON_TIMEOUT: PaymentFailureReason.ValueType  # 1
"""
There are more routes to try, but the payment timeout was exceeded.
"""
FAILURE_REASON_NO_ROUTE: PaymentFailureReason.ValueType  # 2
"""
All possible routes were tried and failed permanently. Or were no
routes to the destination at all.
"""
FAILURE_REASON_ERROR: PaymentFailureReason.ValueType  # 3
"""
A non-recoverable error has occured.
"""
FAILURE_REASON_INCORRECT_PAYMENT_DETAILS: PaymentFailureReason.ValueType  # 4
"""
Payment details incorrect (unknown hash, invalid amt or
invalid final cltv delta)
"""
FAILURE_REASON_INSUFFICIENT_BALANCE: PaymentFailureReason.ValueType  # 5
"""
Insufficient local balance.
"""
global___PaymentFailureReason = PaymentFailureReason

class _FeatureBit:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FeatureBitEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FeatureBit.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DATALOSS_PROTECT_REQ: _FeatureBit.ValueType  # 0
    DATALOSS_PROTECT_OPT: _FeatureBit.ValueType  # 1
    INITIAL_ROUING_SYNC: _FeatureBit.ValueType  # 3
    UPFRONT_SHUTDOWN_SCRIPT_REQ: _FeatureBit.ValueType  # 4
    UPFRONT_SHUTDOWN_SCRIPT_OPT: _FeatureBit.ValueType  # 5
    GOSSIP_QUERIES_REQ: _FeatureBit.ValueType  # 6
    GOSSIP_QUERIES_OPT: _FeatureBit.ValueType  # 7
    TLV_ONION_REQ: _FeatureBit.ValueType  # 8
    TLV_ONION_OPT: _FeatureBit.ValueType  # 9
    EXT_GOSSIP_QUERIES_REQ: _FeatureBit.ValueType  # 10
    EXT_GOSSIP_QUERIES_OPT: _FeatureBit.ValueType  # 11
    STATIC_REMOTE_KEY_REQ: _FeatureBit.ValueType  # 12
    STATIC_REMOTE_KEY_OPT: _FeatureBit.ValueType  # 13
    PAYMENT_ADDR_REQ: _FeatureBit.ValueType  # 14
    PAYMENT_ADDR_OPT: _FeatureBit.ValueType  # 15
    MPP_REQ: _FeatureBit.ValueType  # 16
    MPP_OPT: _FeatureBit.ValueType  # 17
    WUMBO_CHANNELS_REQ: _FeatureBit.ValueType  # 18
    WUMBO_CHANNELS_OPT: _FeatureBit.ValueType  # 19
    ANCHORS_REQ: _FeatureBit.ValueType  # 20
    ANCHORS_OPT: _FeatureBit.ValueType  # 21
    ANCHORS_ZERO_FEE_HTLC_REQ: _FeatureBit.ValueType  # 22
    ANCHORS_ZERO_FEE_HTLC_OPT: _FeatureBit.ValueType  # 23
    ROUTE_BLINDING_REQUIRED: _FeatureBit.ValueType  # 24
    ROUTE_BLINDING_OPTIONAL: _FeatureBit.ValueType  # 25
    AMP_REQ: _FeatureBit.ValueType  # 30
    AMP_OPT: _FeatureBit.ValueType  # 31

class FeatureBit(_FeatureBit, metaclass=_FeatureBitEnumTypeWrapper): ...

DATALOSS_PROTECT_REQ: FeatureBit.ValueType  # 0
DATALOSS_PROTECT_OPT: FeatureBit.ValueType  # 1
INITIAL_ROUING_SYNC: FeatureBit.ValueType  # 3
UPFRONT_SHUTDOWN_SCRIPT_REQ: FeatureBit.ValueType  # 4
UPFRONT_SHUTDOWN_SCRIPT_OPT: FeatureBit.ValueType  # 5
GOSSIP_QUERIES_REQ: FeatureBit.ValueType  # 6
GOSSIP_QUERIES_OPT: FeatureBit.ValueType  # 7
TLV_ONION_REQ: FeatureBit.ValueType  # 8
TLV_ONION_OPT: FeatureBit.ValueType  # 9
EXT_GOSSIP_QUERIES_REQ: FeatureBit.ValueType  # 10
EXT_GOSSIP_QUERIES_OPT: FeatureBit.ValueType  # 11
STATIC_REMOTE_KEY_REQ: FeatureBit.ValueType  # 12
STATIC_REMOTE_KEY_OPT: FeatureBit.ValueType  # 13
PAYMENT_ADDR_REQ: FeatureBit.ValueType  # 14
PAYMENT_ADDR_OPT: FeatureBit.ValueType  # 15
MPP_REQ: FeatureBit.ValueType  # 16
MPP_OPT: FeatureBit.ValueType  # 17
WUMBO_CHANNELS_REQ: FeatureBit.ValueType  # 18
WUMBO_CHANNELS_OPT: FeatureBit.ValueType  # 19
ANCHORS_REQ: FeatureBit.ValueType  # 20
ANCHORS_OPT: FeatureBit.ValueType  # 21
ANCHORS_ZERO_FEE_HTLC_REQ: FeatureBit.ValueType  # 22
ANCHORS_ZERO_FEE_HTLC_OPT: FeatureBit.ValueType  # 23
ROUTE_BLINDING_REQUIRED: FeatureBit.ValueType  # 24
ROUTE_BLINDING_OPTIONAL: FeatureBit.ValueType  # 25
AMP_REQ: FeatureBit.ValueType  # 30
AMP_OPT: FeatureBit.ValueType  # 31
global___FeatureBit = FeatureBit

class _UpdateFailure:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _UpdateFailureEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_UpdateFailure.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UPDATE_FAILURE_UNKNOWN: _UpdateFailure.ValueType  # 0
    UPDATE_FAILURE_PENDING: _UpdateFailure.ValueType  # 1
    UPDATE_FAILURE_NOT_FOUND: _UpdateFailure.ValueType  # 2
    UPDATE_FAILURE_INTERNAL_ERR: _UpdateFailure.ValueType  # 3
    UPDATE_FAILURE_INVALID_PARAMETER: _UpdateFailure.ValueType  # 4

class UpdateFailure(_UpdateFailure, metaclass=_UpdateFailureEnumTypeWrapper): ...

UPDATE_FAILURE_UNKNOWN: UpdateFailure.ValueType  # 0
UPDATE_FAILURE_PENDING: UpdateFailure.ValueType  # 1
UPDATE_FAILURE_NOT_FOUND: UpdateFailure.ValueType  # 2
UPDATE_FAILURE_INTERNAL_ERR: UpdateFailure.ValueType  # 3
UPDATE_FAILURE_INVALID_PARAMETER: UpdateFailure.ValueType  # 4
global___UpdateFailure = UpdateFailure

@typing.final
class LookupHtlcResolutionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_ID_FIELD_NUMBER: builtins.int
    HTLC_INDEX_FIELD_NUMBER: builtins.int
    chan_id: builtins.int
    htlc_index: builtins.int
    def __init__(
        self,
        *,
        chan_id: builtins.int = ...,
        htlc_index: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["chan_id", b"chan_id", "htlc_index", b"htlc_index"]) -> None: ...

global___LookupHtlcResolutionRequest = LookupHtlcResolutionRequest

@typing.final
class LookupHtlcResolutionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SETTLED_FIELD_NUMBER: builtins.int
    OFFCHAIN_FIELD_NUMBER: builtins.int
    settled: builtins.bool
    """Settled is true is the htlc was settled. If false, the htlc was failed."""
    offchain: builtins.bool
    """Offchain indicates whether the htlc was resolved off-chain or on-chain."""
    def __init__(
        self,
        *,
        settled: builtins.bool = ...,
        offchain: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["offchain", b"offchain", "settled", b"settled"]) -> None: ...

global___LookupHtlcResolutionResponse = LookupHtlcResolutionResponse

@typing.final
class SubscribeCustomMessagesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SubscribeCustomMessagesRequest = SubscribeCustomMessagesRequest

@typing.final
class CustomMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PEER_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    peer: builtins.bytes
    """Peer from which the message originates"""
    type: builtins.int
    """Message type. This value will be in the custom range (>= 32768)."""
    data: builtins.bytes
    """Raw message data"""
    def __init__(
        self,
        *,
        peer: builtins.bytes = ...,
        type: builtins.int = ...,
        data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "peer", b"peer", "type", b"type"]) -> None: ...

global___CustomMessage = CustomMessage

@typing.final
class SendCustomMessageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PEER_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    peer: builtins.bytes
    """Peer to send the message to"""
    type: builtins.int
    """Message type. This value needs to be in the custom range (>= 32768).
    To send a type < custom range, lnd needs to be compiled with the `dev`
    build tag, and the message type to override should be specified in lnd's
    experimental protocol configuration.
    """
    data: builtins.bytes
    """Raw message data."""
    def __init__(
        self,
        *,
        peer: builtins.bytes = ...,
        type: builtins.int = ...,
        data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "peer", b"peer", "type", b"type"]) -> None: ...

global___SendCustomMessageRequest = SendCustomMessageRequest

@typing.final
class SendCustomMessageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SendCustomMessageResponse = SendCustomMessageResponse

@typing.final
class Utxo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_TYPE_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    AMOUNT_SAT_FIELD_NUMBER: builtins.int
    PK_SCRIPT_FIELD_NUMBER: builtins.int
    OUTPOINT_FIELD_NUMBER: builtins.int
    CONFIRMATIONS_FIELD_NUMBER: builtins.int
    address_type: global___AddressType.ValueType
    """The type of address"""
    address: builtins.str
    """The address"""
    amount_sat: builtins.int
    """The value of the unspent coin in satoshis"""
    pk_script: builtins.str
    """The pkscript in hex"""
    confirmations: builtins.int
    """The number of confirmations for the Utxo"""
    @property
    def outpoint(self) -> global___OutPoint:
        """The outpoint in format txid:n"""

    def __init__(
        self,
        *,
        address_type: global___AddressType.ValueType = ...,
        address: builtins.str = ...,
        amount_sat: builtins.int = ...,
        pk_script: builtins.str = ...,
        outpoint: global___OutPoint | None = ...,
        confirmations: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["outpoint", b"outpoint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "address_type", b"address_type", "amount_sat", b"amount_sat", "confirmations", b"confirmations", "outpoint", b"outpoint", "pk_script", b"pk_script"]) -> None: ...

global___Utxo = Utxo

@typing.final
class OutputDetail(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUT_TYPE_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    PK_SCRIPT_FIELD_NUMBER: builtins.int
    OUTPUT_INDEX_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    IS_OUR_ADDRESS_FIELD_NUMBER: builtins.int
    output_type: global___OutputScriptType.ValueType
    """The type of the output"""
    address: builtins.str
    """The address"""
    pk_script: builtins.str
    """The pkscript in hex"""
    output_index: builtins.int
    """The output index used in the raw transaction"""
    amount: builtins.int
    """The value of the output coin in satoshis"""
    is_our_address: builtins.bool
    """Denotes if the output is controlled by the internal wallet"""
    def __init__(
        self,
        *,
        output_type: global___OutputScriptType.ValueType = ...,
        address: builtins.str = ...,
        pk_script: builtins.str = ...,
        output_index: builtins.int = ...,
        amount: builtins.int = ...,
        is_our_address: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "amount", b"amount", "is_our_address", b"is_our_address", "output_index", b"output_index", "output_type", b"output_type", "pk_script", b"pk_script"]) -> None: ...

global___OutputDetail = OutputDetail

@typing.final
class Transaction(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TX_HASH_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    NUM_CONFIRMATIONS_FIELD_NUMBER: builtins.int
    BLOCK_HASH_FIELD_NUMBER: builtins.int
    BLOCK_HEIGHT_FIELD_NUMBER: builtins.int
    TIME_STAMP_FIELD_NUMBER: builtins.int
    TOTAL_FEES_FIELD_NUMBER: builtins.int
    DEST_ADDRESSES_FIELD_NUMBER: builtins.int
    OUTPUT_DETAILS_FIELD_NUMBER: builtins.int
    RAW_TX_HEX_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    PREVIOUS_OUTPOINTS_FIELD_NUMBER: builtins.int
    tx_hash: builtins.str
    """The transaction hash"""
    amount: builtins.int
    """The transaction amount, denominated in satoshis"""
    num_confirmations: builtins.int
    """The number of confirmations"""
    block_hash: builtins.str
    """The hash of the block this transaction was included in"""
    block_height: builtins.int
    """The height of the block this transaction was included in"""
    time_stamp: builtins.int
    """Timestamp of this transaction"""
    total_fees: builtins.int
    """Fees paid for this transaction"""
    raw_tx_hex: builtins.str
    """The raw transaction hex."""
    label: builtins.str
    """A label that was optionally set on transaction broadcast."""
    @property
    def dest_addresses(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Addresses that received funds for this transaction. Deprecated as it is
        now incorporated in the output_details field.
        """

    @property
    def output_details(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OutputDetail]:
        """Outputs that received funds for this transaction"""

    @property
    def previous_outpoints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PreviousOutPoint]:
        """PreviousOutpoints/Inputs of this transaction."""

    def __init__(
        self,
        *,
        tx_hash: builtins.str = ...,
        amount: builtins.int = ...,
        num_confirmations: builtins.int = ...,
        block_hash: builtins.str = ...,
        block_height: builtins.int = ...,
        time_stamp: builtins.int = ...,
        total_fees: builtins.int = ...,
        dest_addresses: collections.abc.Iterable[builtins.str] | None = ...,
        output_details: collections.abc.Iterable[global___OutputDetail] | None = ...,
        raw_tx_hex: builtins.str = ...,
        label: builtins.str = ...,
        previous_outpoints: collections.abc.Iterable[global___PreviousOutPoint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["amount", b"amount", "block_hash", b"block_hash", "block_height", b"block_height", "dest_addresses", b"dest_addresses", "label", b"label", "num_confirmations", b"num_confirmations", "output_details", b"output_details", "previous_outpoints", b"previous_outpoints", "raw_tx_hex", b"raw_tx_hex", "time_stamp", b"time_stamp", "total_fees", b"total_fees", "tx_hash", b"tx_hash"]) -> None: ...

global___Transaction = Transaction

@typing.final
class GetTransactionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_HEIGHT_FIELD_NUMBER: builtins.int
    END_HEIGHT_FIELD_NUMBER: builtins.int
    ACCOUNT_FIELD_NUMBER: builtins.int
    start_height: builtins.int
    """
    The height from which to list transactions, inclusive. If this value is
    greater than end_height, transactions will be read in reverse.
    """
    end_height: builtins.int
    """
    The height until which to list transactions, inclusive. To include
    unconfirmed transactions, this value should be set to -1, which will
    return transactions from start_height until the current chain tip and
    unconfirmed transactions. If no end_height is provided, the call will
    default to this option.
    """
    account: builtins.str
    """An optional filter to only include transactions relevant to an account."""
    def __init__(
        self,
        *,
        start_height: builtins.int = ...,
        end_height: builtins.int = ...,
        account: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["account", b"account", "end_height", b"end_height", "start_height", b"start_height"]) -> None: ...

global___GetTransactionsRequest = GetTransactionsRequest

@typing.final
class TransactionDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSACTIONS_FIELD_NUMBER: builtins.int
    @property
    def transactions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Transaction]:
        """The list of transactions relevant to the wallet."""

    def __init__(
        self,
        *,
        transactions: collections.abc.Iterable[global___Transaction] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["transactions", b"transactions"]) -> None: ...

global___TransactionDetails = TransactionDetails

@typing.final
class FeeLimit(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIXED_FIELD_NUMBER: builtins.int
    FIXED_MSAT_FIELD_NUMBER: builtins.int
    PERCENT_FIELD_NUMBER: builtins.int
    fixed: builtins.int
    """
    The fee limit expressed as a fixed amount of satoshis.

    The fields fixed and fixed_msat are mutually exclusive.
    """
    fixed_msat: builtins.int
    """
    The fee limit expressed as a fixed amount of millisatoshis.

    The fields fixed and fixed_msat are mutually exclusive.
    """
    percent: builtins.int
    """The fee limit expressed as a percentage of the payment amount."""
    def __init__(
        self,
        *,
        fixed: builtins.int = ...,
        fixed_msat: builtins.int = ...,
        percent: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["fixed", b"fixed", "fixed_msat", b"fixed_msat", "limit", b"limit", "percent", b"percent"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["fixed", b"fixed", "fixed_msat", b"fixed_msat", "limit", b"limit", "percent", b"percent"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["limit", b"limit"]) -> typing.Literal["fixed", "fixed_msat", "percent"] | None: ...

global___FeeLimit = FeeLimit

@typing.final
class SendRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DestCustomRecordsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DEST_FIELD_NUMBER: builtins.int
    DEST_STRING_FIELD_NUMBER: builtins.int
    AMT_FIELD_NUMBER: builtins.int
    AMT_MSAT_FIELD_NUMBER: builtins.int
    PAYMENT_HASH_FIELD_NUMBER: builtins.int
    PAYMENT_HASH_STRING_FIELD_NUMBER: builtins.int
    PAYMENT_REQUEST_FIELD_NUMBER: builtins.int
    FINAL_CLTV_DELTA_FIELD_NUMBER: builtins.int
    FEE_LIMIT_FIELD_NUMBER: builtins.int
    OUTGOING_CHAN_ID_FIELD_NUMBER: builtins.int
    LAST_HOP_PUBKEY_FIELD_NUMBER: builtins.int
    CLTV_LIMIT_FIELD_NUMBER: builtins.int
    DEST_CUSTOM_RECORDS_FIELD_NUMBER: builtins.int
    ALLOW_SELF_PAYMENT_FIELD_NUMBER: builtins.int
    DEST_FEATURES_FIELD_NUMBER: builtins.int
    PAYMENT_ADDR_FIELD_NUMBER: builtins.int
    dest: builtins.bytes
    """
    The identity pubkey of the payment recipient. When using REST, this field
    must be encoded as base64.
    """
    dest_string: builtins.str
    """
    The hex-encoded identity pubkey of the payment recipient. Deprecated now
    that the REST gateway supports base64 encoding of bytes fields.
    """
    amt: builtins.int
    """
    The amount to send expressed in satoshis.

    The fields amt and amt_msat are mutually exclusive.
    """
    amt_msat: builtins.int
    """
    The amount to send expressed in millisatoshis.

    The fields amt and amt_msat are mutually exclusive.
    """
    payment_hash: builtins.bytes
    """
    The hash to use within the payment's HTLC. When using REST, this field
    must be encoded as base64.
    """
    payment_hash_string: builtins.str
    """
    The hex-encoded hash to use within the payment's HTLC. Deprecated now
    that the REST gateway supports base64 encoding of bytes fields.
    """
    payment_request: builtins.str
    """
    A bare-bones invoice for a payment within the Lightning Network. With the
    details of the invoice, the sender has all the data necessary to send a
    payment to the recipient.
    """
    final_cltv_delta: builtins.int
    """
    The CLTV delta from the current height that should be used to set the
    timelock for the final hop.
    """
    outgoing_chan_id: builtins.int
    """
    The channel id of the channel that must be taken to the first hop. If zero,
    any channel may be used.
    """
    last_hop_pubkey: builtins.bytes
    """
    The pubkey of the last hop of the route. If empty, any hop may be used.
    """
    cltv_limit: builtins.int
    """
    An optional maximum total time lock for the route. This should not exceed
    lnd's `--max-cltv-expiry` setting. If zero, then the value of
    `--max-cltv-expiry` is enforced.
    """
    allow_self_payment: builtins.bool
    """If set, circular payments to self are permitted."""
    payment_addr: builtins.bytes
    """
    The payment address of the generated invoice.  This is also called
    payment secret in specifications (e.g. BOLT 11).
    """
    @property
    def fee_limit(self) -> global___FeeLimit:
        """
        The maximum number of satoshis that will be paid as a fee of the payment.
        This value can be represented either as a percentage of the amount being
        sent, or as a fixed amount of the maximum fee the user is willing the pay to
        send the payment. If not specified, lnd will use a default value of 100%
        fees for small amounts (<=1k sat) or 5% fees for larger amounts.
        """

    @property
    def dest_custom_records(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.bytes]:
        """
        An optional field that can be used to pass an arbitrary set of TLV records
        to a peer which understands the new records. This can be used to pass
        application specific data during the payment attempt. Record types are
        required to be in the custom range >= 65536. When using REST, the values
        must be encoded as base64.
        """

    @property
    def dest_features(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___FeatureBit.ValueType]:
        """
        Features assumed to be supported by the final node. All transitive feature
        dependencies must also be set properly. For a given feature bit pair, either
        optional or remote may be set, but not both. If this field is nil or empty,
        the router will try to load destination features from the graph as a
        fallback.
        """

    def __init__(
        self,
        *,
        dest: builtins.bytes = ...,
        dest_string: builtins.str = ...,
        amt: builtins.int = ...,
        amt_msat: builtins.int = ...,
        payment_hash: builtins.bytes = ...,
        payment_hash_string: builtins.str = ...,
        payment_request: builtins.str = ...,
        final_cltv_delta: builtins.int = ...,
        fee_limit: global___FeeLimit | None = ...,
        outgoing_chan_id: builtins.int = ...,
        last_hop_pubkey: builtins.bytes = ...,
        cltv_limit: builtins.int = ...,
        dest_custom_records: collections.abc.Mapping[builtins.int, builtins.bytes] | None = ...,
        allow_self_payment: builtins.bool = ...,
        dest_features: collections.abc.Iterable[global___FeatureBit.ValueType] | None = ...,
        payment_addr: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["fee_limit", b"fee_limit"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allow_self_payment", b"allow_self_payment", "amt", b"amt", "amt_msat", b"amt_msat", "cltv_limit", b"cltv_limit", "dest", b"dest", "dest_custom_records", b"dest_custom_records", "dest_features", b"dest_features", "dest_string", b"dest_string", "fee_limit", b"fee_limit", "final_cltv_delta", b"final_cltv_delta", "last_hop_pubkey", b"last_hop_pubkey", "outgoing_chan_id", b"outgoing_chan_id", "payment_addr", b"payment_addr", "payment_hash", b"payment_hash", "payment_hash_string", b"payment_hash_string", "payment_request", b"payment_request"]) -> None: ...

global___SendRequest = SendRequest

@typing.final
class SendResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYMENT_ERROR_FIELD_NUMBER: builtins.int
    PAYMENT_PREIMAGE_FIELD_NUMBER: builtins.int
    PAYMENT_ROUTE_FIELD_NUMBER: builtins.int
    PAYMENT_HASH_FIELD_NUMBER: builtins.int
    payment_error: builtins.str
    payment_preimage: builtins.bytes
    payment_hash: builtins.bytes
    @property
    def payment_route(self) -> global___Route: ...
    def __init__(
        self,
        *,
        payment_error: builtins.str = ...,
        payment_preimage: builtins.bytes = ...,
        payment_route: global___Route | None = ...,
        payment_hash: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["payment_route", b"payment_route"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["payment_error", b"payment_error", "payment_hash", b"payment_hash", "payment_preimage", b"payment_preimage", "payment_route", b"payment_route"]) -> None: ...

global___SendResponse = SendResponse

@typing.final
class SendToRouteRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYMENT_HASH_FIELD_NUMBER: builtins.int
    PAYMENT_HASH_STRING_FIELD_NUMBER: builtins.int
    ROUTE_FIELD_NUMBER: builtins.int
    payment_hash: builtins.bytes
    """
    The payment hash to use for the HTLC. When using REST, this field must be
    encoded as base64.
    """
    payment_hash_string: builtins.str
    """
    An optional hex-encoded payment hash to be used for the HTLC. Deprecated now
    that the REST gateway supports base64 encoding of bytes fields.
    """
    @property
    def route(self) -> global___Route:
        """Route that should be used to attempt to complete the payment."""

    def __init__(
        self,
        *,
        payment_hash: builtins.bytes = ...,
        payment_hash_string: builtins.str = ...,
        route: global___Route | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["route", b"route"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["payment_hash", b"payment_hash", "payment_hash_string", b"payment_hash_string", "route", b"route"]) -> None: ...

global___SendToRouteRequest = SendToRouteRequest

@typing.final
class ChannelAcceptRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODE_PUBKEY_FIELD_NUMBER: builtins.int
    CHAIN_HASH_FIELD_NUMBER: builtins.int
    PENDING_CHAN_ID_FIELD_NUMBER: builtins.int
    FUNDING_AMT_FIELD_NUMBER: builtins.int
    PUSH_AMT_FIELD_NUMBER: builtins.int
    DUST_LIMIT_FIELD_NUMBER: builtins.int
    MAX_VALUE_IN_FLIGHT_FIELD_NUMBER: builtins.int
    CHANNEL_RESERVE_FIELD_NUMBER: builtins.int
    MIN_HTLC_FIELD_NUMBER: builtins.int
    FEE_PER_KW_FIELD_NUMBER: builtins.int
    CSV_DELAY_FIELD_NUMBER: builtins.int
    MAX_ACCEPTED_HTLCS_FIELD_NUMBER: builtins.int
    CHANNEL_FLAGS_FIELD_NUMBER: builtins.int
    COMMITMENT_TYPE_FIELD_NUMBER: builtins.int
    WANTS_ZERO_CONF_FIELD_NUMBER: builtins.int
    WANTS_SCID_ALIAS_FIELD_NUMBER: builtins.int
    node_pubkey: builtins.bytes
    """The pubkey of the node that wishes to open an inbound channel."""
    chain_hash: builtins.bytes
    """The hash of the genesis block that the proposed channel resides in."""
    pending_chan_id: builtins.bytes
    """The pending channel id."""
    funding_amt: builtins.int
    """The funding amount in satoshis that initiator wishes to use in the
    channel.
    """
    push_amt: builtins.int
    """The push amount of the proposed channel in millisatoshis."""
    dust_limit: builtins.int
    """The dust limit of the initiator's commitment tx."""
    max_value_in_flight: builtins.int
    """The maximum amount of coins in millisatoshis that can be pending in this
    channel.
    """
    channel_reserve: builtins.int
    """The minimum amount of satoshis the initiator requires us to have at all
    times.
    """
    min_htlc: builtins.int
    """The smallest HTLC in millisatoshis that the initiator will accept."""
    fee_per_kw: builtins.int
    """The initial fee rate that the initiator suggests for both commitment
    transactions.
    """
    csv_delay: builtins.int
    """
    The number of blocks to use for the relative time lock in the pay-to-self
    output of both commitment transactions.
    """
    max_accepted_htlcs: builtins.int
    """The total number of incoming HTLC's that the initiator will accept."""
    channel_flags: builtins.int
    """A bit-field which the initiator uses to specify proposed channel
    behavior.
    """
    commitment_type: global___CommitmentType.ValueType
    """The commitment type the initiator wishes to use for the proposed channel."""
    wants_zero_conf: builtins.bool
    """Whether the initiator wants to open a zero-conf channel via the channel
    type.
    """
    wants_scid_alias: builtins.bool
    """Whether the initiator wants to use the scid-alias channel type. This is
    separate from the feature bit.
    """
    def __init__(
        self,
        *,
        node_pubkey: builtins.bytes = ...,
        chain_hash: builtins.bytes = ...,
        pending_chan_id: builtins.bytes = ...,
        funding_amt: builtins.int = ...,
        push_amt: builtins.int = ...,
        dust_limit: builtins.int = ...,
        max_value_in_flight: builtins.int = ...,
        channel_reserve: builtins.int = ...,
        min_htlc: builtins.int = ...,
        fee_per_kw: builtins.int = ...,
        csv_delay: builtins.int = ...,
        max_accepted_htlcs: builtins.int = ...,
        channel_flags: builtins.int = ...,
        commitment_type: global___CommitmentType.ValueType = ...,
        wants_zero_conf: builtins.bool = ...,
        wants_scid_alias: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["chain_hash", b"chain_hash", "channel_flags", b"channel_flags", "channel_reserve", b"channel_reserve", "commitment_type", b"commitment_type", "csv_delay", b"csv_delay", "dust_limit", b"dust_limit", "fee_per_kw", b"fee_per_kw", "funding_amt", b"funding_amt", "max_accepted_htlcs", b"max_accepted_htlcs", "max_value_in_flight", b"max_value_in_flight", "min_htlc", b"min_htlc", "node_pubkey", b"node_pubkey", "pending_chan_id", b"pending_chan_id", "push_amt", b"push_amt", "wants_scid_alias", b"wants_scid_alias", "wants_zero_conf", b"wants_zero_conf"]) -> None: ...

global___ChannelAcceptRequest = ChannelAcceptRequest

@typing.final
class ChannelAcceptResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCEPT_FIELD_NUMBER: builtins.int
    PENDING_CHAN_ID_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    UPFRONT_SHUTDOWN_FIELD_NUMBER: builtins.int
    CSV_DELAY_FIELD_NUMBER: builtins.int
    RESERVE_SAT_FIELD_NUMBER: builtins.int
    IN_FLIGHT_MAX_MSAT_FIELD_NUMBER: builtins.int
    MAX_HTLC_COUNT_FIELD_NUMBER: builtins.int
    MIN_HTLC_IN_FIELD_NUMBER: builtins.int
    MIN_ACCEPT_DEPTH_FIELD_NUMBER: builtins.int
    ZERO_CONF_FIELD_NUMBER: builtins.int
    accept: builtins.bool
    """Whether or not the client accepts the channel."""
    pending_chan_id: builtins.bytes
    """The pending channel id to which this response applies."""
    error: builtins.str
    """
    An optional error to send the initiating party to indicate why the channel
    was rejected. This field *should not* contain sensitive information, it will
    be sent to the initiating party. This field should only be set if accept is
    false, the channel will be rejected if an error is set with accept=true
    because the meaning of this response is ambiguous. Limited to 500
    characters.
    """
    upfront_shutdown: builtins.str
    """
    The upfront shutdown address to use if the initiating peer supports option
    upfront shutdown script (see ListPeers for the features supported). Note
    that the channel open will fail if this value is set for a peer that does
    not support this feature bit.
    """
    csv_delay: builtins.int
    """
    The csv delay (in blocks) that we require for the remote party.
    """
    reserve_sat: builtins.int
    """
    The reserve amount in satoshis that we require the remote peer to adhere to.
    We require that the remote peer always have some reserve amount allocated to
    them so that there is always a disincentive to broadcast old state (if they
    hold 0 sats on their side of the channel, there is nothing to lose).
    """
    in_flight_max_msat: builtins.int
    """
    The maximum amount of funds in millisatoshis that we allow the remote peer
    to have in outstanding htlcs.
    """
    max_htlc_count: builtins.int
    """
    The maximum number of htlcs that the remote peer can offer us.
    """
    min_htlc_in: builtins.int
    """
    The minimum value in millisatoshis for incoming htlcs on the channel.
    """
    min_accept_depth: builtins.int
    """
    The number of confirmations we require before we consider the channel open.
    """
    zero_conf: builtins.bool
    """
    Whether the responder wants this to be a zero-conf channel. This will fail
    if either side does not have the scid-alias feature bit set. The minimum
    depth field must be zero if this is true.
    """
    def __init__(
        self,
        *,
        accept: builtins.bool = ...,
        pending_chan_id: builtins.bytes = ...,
        error: builtins.str = ...,
        upfront_shutdown: builtins.str = ...,
        csv_delay: builtins.int = ...,
        reserve_sat: builtins.int = ...,
        in_flight_max_msat: builtins.int = ...,
        max_htlc_count: builtins.int = ...,
        min_htlc_in: builtins.int = ...,
        min_accept_depth: builtins.int = ...,
        zero_conf: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["accept", b"accept", "csv_delay", b"csv_delay", "error", b"error", "in_flight_max_msat", b"in_flight_max_msat", "max_htlc_count", b"max_htlc_count", "min_accept_depth", b"min_accept_depth", "min_htlc_in", b"min_htlc_in", "pending_chan_id", b"pending_chan_id", "reserve_sat", b"reserve_sat", "upfront_shutdown", b"upfront_shutdown", "zero_conf", b"zero_conf"]) -> None: ...

global___ChannelAcceptResponse = ChannelAcceptResponse

@typing.final
class ChannelPoint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNDING_TXID_BYTES_FIELD_NUMBER: builtins.int
    FUNDING_TXID_STR_FIELD_NUMBER: builtins.int
    OUTPUT_INDEX_FIELD_NUMBER: builtins.int
    funding_txid_bytes: builtins.bytes
    """
    Txid of the funding transaction. When using REST, this field must be
    encoded as base64.
    """
    funding_txid_str: builtins.str
    """
    Hex-encoded string representing the byte-reversed hash of the funding
    transaction.
    """
    output_index: builtins.int
    """The index of the output of the funding transaction"""
    def __init__(
        self,
        *,
        funding_txid_bytes: builtins.bytes = ...,
        funding_txid_str: builtins.str = ...,
        output_index: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["funding_txid", b"funding_txid", "funding_txid_bytes", b"funding_txid_bytes", "funding_txid_str", b"funding_txid_str"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["funding_txid", b"funding_txid", "funding_txid_bytes", b"funding_txid_bytes", "funding_txid_str", b"funding_txid_str", "output_index", b"output_index"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["funding_txid", b"funding_txid"]) -> typing.Literal["funding_txid_bytes", "funding_txid_str"] | None: ...

global___ChannelPoint = ChannelPoint

@typing.final
class OutPoint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TXID_BYTES_FIELD_NUMBER: builtins.int
    TXID_STR_FIELD_NUMBER: builtins.int
    OUTPUT_INDEX_FIELD_NUMBER: builtins.int
    txid_bytes: builtins.bytes
    """Raw bytes representing the transaction id."""
    txid_str: builtins.str
    """Reversed, hex-encoded string representing the transaction id."""
    output_index: builtins.int
    """The index of the output on the transaction."""
    def __init__(
        self,
        *,
        txid_bytes: builtins.bytes = ...,
        txid_str: builtins.str = ...,
        output_index: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["output_index", b"output_index", "txid_bytes", b"txid_bytes", "txid_str", b"txid_str"]) -> None: ...

global___OutPoint = OutPoint

@typing.final
class PreviousOutPoint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPOINT_FIELD_NUMBER: builtins.int
    IS_OUR_OUTPUT_FIELD_NUMBER: builtins.int
    outpoint: builtins.str
    """The outpoint in format txid:n."""
    is_our_output: builtins.bool
    """Denotes if the outpoint is controlled by the internal wallet.
    The flag will only detect p2wkh, np2wkh and p2tr inputs as its own.
    """
    def __init__(
        self,
        *,
        outpoint: builtins.str = ...,
        is_our_output: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["is_our_output", b"is_our_output", "outpoint", b"outpoint"]) -> None: ...

global___PreviousOutPoint = PreviousOutPoint

@typing.final
class LightningAddress(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PUBKEY_FIELD_NUMBER: builtins.int
    HOST_FIELD_NUMBER: builtins.int
    pubkey: builtins.str
    """The identity pubkey of the Lightning node."""
    host: builtins.str
    """The network location of the lightning node, e.g. `69.69.69.69:1337` or
    `localhost:10011`.
    """
    def __init__(
        self,
        *,
        pubkey: builtins.str = ...,
        host: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["host", b"host", "pubkey", b"pubkey"]) -> None: ...

global___LightningAddress = LightningAddress

@typing.final
class EstimateFeeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AddrToAmountEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.int
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ADDRTOAMOUNT_FIELD_NUMBER: builtins.int
    TARGET_CONF_FIELD_NUMBER: builtins.int
    MIN_CONFS_FIELD_NUMBER: builtins.int
    SPEND_UNCONFIRMED_FIELD_NUMBER: builtins.int
    COIN_SELECTION_STRATEGY_FIELD_NUMBER: builtins.int
    target_conf: builtins.int
    """The target number of blocks that this transaction should be confirmed
    by.
    """
    min_confs: builtins.int
    """The minimum number of confirmations each one of your outputs used for
    the transaction must satisfy.
    """
    spend_unconfirmed: builtins.bool
    """Whether unconfirmed outputs should be used as inputs for the transaction."""
    coin_selection_strategy: global___CoinSelectionStrategy.ValueType
    """The strategy to use for selecting coins during fees estimation."""
    @property
    def AddrToAmount(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.int]:
        """The map from addresses to amounts for the transaction."""

    def __init__(
        self,
        *,
        AddrToAmount: collections.abc.Mapping[builtins.str, builtins.int] | None = ...,
        target_conf: builtins.int = ...,
        min_confs: builtins.int = ...,
        spend_unconfirmed: builtins.bool = ...,
        coin_selection_strategy: global___CoinSelectionStrategy.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["AddrToAmount", b"AddrToAmount", "coin_selection_strategy", b"coin_selection_strategy", "min_confs", b"min_confs", "spend_unconfirmed", b"spend_unconfirmed", "target_conf", b"target_conf"]) -> None: ...

global___EstimateFeeRequest = EstimateFeeRequest

@typing.final
class EstimateFeeResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEE_SAT_FIELD_NUMBER: builtins.int
    FEERATE_SAT_PER_BYTE_FIELD_NUMBER: builtins.int
    SAT_PER_VBYTE_FIELD_NUMBER: builtins.int
    fee_sat: builtins.int
    """The total fee in satoshis."""
    feerate_sat_per_byte: builtins.int
    """Deprecated, use sat_per_vbyte.
    The fee rate in satoshi/vbyte.
    """
    sat_per_vbyte: builtins.int
    """The fee rate in satoshi/vbyte."""
    def __init__(
        self,
        *,
        fee_sat: builtins.int = ...,
        feerate_sat_per_byte: builtins.int = ...,
        sat_per_vbyte: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["fee_sat", b"fee_sat", "feerate_sat_per_byte", b"feerate_sat_per_byte", "sat_per_vbyte", b"sat_per_vbyte"]) -> None: ...

global___EstimateFeeResponse = EstimateFeeResponse

@typing.final
class SendManyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AddrToAmountEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.int
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ADDRTOAMOUNT_FIELD_NUMBER: builtins.int
    TARGET_CONF_FIELD_NUMBER: builtins.int
    SAT_PER_VBYTE_FIELD_NUMBER: builtins.int
    SAT_PER_BYTE_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    MIN_CONFS_FIELD_NUMBER: builtins.int
    SPEND_UNCONFIRMED_FIELD_NUMBER: builtins.int
    COIN_SELECTION_STRATEGY_FIELD_NUMBER: builtins.int
    target_conf: builtins.int
    """The target number of blocks that this transaction should be confirmed
    by.
    """
    sat_per_vbyte: builtins.int
    """A manual fee rate set in sat/vbyte that should be used when crafting the
    transaction.
    """
    sat_per_byte: builtins.int
    """Deprecated, use sat_per_vbyte.
    A manual fee rate set in sat/vbyte that should be used when crafting the
    transaction.
    """
    label: builtins.str
    """An optional label for the transaction, limited to 500 characters."""
    min_confs: builtins.int
    """The minimum number of confirmations each one of your outputs used for
    the transaction must satisfy.
    """
    spend_unconfirmed: builtins.bool
    """Whether unconfirmed outputs should be used as inputs for the transaction."""
    coin_selection_strategy: global___CoinSelectionStrategy.ValueType
    """The strategy to use for selecting coins during sending many requests."""
    @property
    def AddrToAmount(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.int]:
        """The map from addresses to amounts"""

    def __init__(
        self,
        *,
        AddrToAmount: collections.abc.Mapping[builtins.str, builtins.int] | None = ...,
        target_conf: builtins.int = ...,
        sat_per_vbyte: builtins.int = ...,
        sat_per_byte: builtins.int = ...,
        label: builtins.str = ...,
        min_confs: builtins.int = ...,
        spend_unconfirmed: builtins.bool = ...,
        coin_selection_strategy: global___CoinSelectionStrategy.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["AddrToAmount", b"AddrToAmount", "coin_selection_strategy", b"coin_selection_strategy", "label", b"label", "min_confs", b"min_confs", "sat_per_byte", b"sat_per_byte", "sat_per_vbyte", b"sat_per_vbyte", "spend_unconfirmed", b"spend_unconfirmed", "target_conf", b"target_conf"]) -> None: ...

global___SendManyRequest = SendManyRequest

@typing.final
class SendManyResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TXID_FIELD_NUMBER: builtins.int
    txid: builtins.str
    """The id of the transaction"""
    def __init__(
        self,
        *,
        txid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["txid", b"txid"]) -> None: ...

global___SendManyResponse = SendManyResponse

@typing.final
class SendCoinsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDR_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    TARGET_CONF_FIELD_NUMBER: builtins.int
    SAT_PER_VBYTE_FIELD_NUMBER: builtins.int
    SAT_PER_BYTE_FIELD_NUMBER: builtins.int
    SEND_ALL_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    MIN_CONFS_FIELD_NUMBER: builtins.int
    SPEND_UNCONFIRMED_FIELD_NUMBER: builtins.int
    COIN_SELECTION_STRATEGY_FIELD_NUMBER: builtins.int
    addr: builtins.str
    """The address to send coins to"""
    amount: builtins.int
    """The amount in satoshis to send"""
    target_conf: builtins.int
    """The target number of blocks that this transaction should be confirmed
    by.
    """
    sat_per_vbyte: builtins.int
    """A manual fee rate set in sat/vbyte that should be used when crafting the
    transaction.
    """
    sat_per_byte: builtins.int
    """Deprecated, use sat_per_vbyte.
    A manual fee rate set in sat/vbyte that should be used when crafting the
    transaction.
    """
    send_all: builtins.bool
    """
    If set, then the amount field will be ignored, and lnd will attempt to
    send all the coins under control of the internal wallet to the specified
    address.
    """
    label: builtins.str
    """An optional label for the transaction, limited to 500 characters."""
    min_confs: builtins.int
    """The minimum number of confirmations each one of your outputs used for
    the transaction must satisfy.
    """
    spend_unconfirmed: builtins.bool
    """Whether unconfirmed outputs should be used as inputs for the transaction."""
    coin_selection_strategy: global___CoinSelectionStrategy.ValueType
    """The strategy to use for selecting coins."""
    def __init__(
        self,
        *,
        addr: builtins.str = ...,
        amount: builtins.int = ...,
        target_conf: builtins.int = ...,
        sat_per_vbyte: builtins.int = ...,
        sat_per_byte: builtins.int = ...,
        send_all: builtins.bool = ...,
        label: builtins.str = ...,
        min_confs: builtins.int = ...,
        spend_unconfirmed: builtins.bool = ...,
        coin_selection_strategy: global___CoinSelectionStrategy.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["addr", b"addr", "amount", b"amount", "coin_selection_strategy", b"coin_selection_strategy", "label", b"label", "min_confs", b"min_confs", "sat_per_byte", b"sat_per_byte", "sat_per_vbyte", b"sat_per_vbyte", "send_all", b"send_all", "spend_unconfirmed", b"spend_unconfirmed", "target_conf", b"target_conf"]) -> None: ...

global___SendCoinsRequest = SendCoinsRequest

@typing.final
class SendCoinsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TXID_FIELD_NUMBER: builtins.int
    txid: builtins.str
    """The transaction ID of the transaction"""
    def __init__(
        self,
        *,
        txid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["txid", b"txid"]) -> None: ...

global___SendCoinsResponse = SendCoinsResponse

@typing.final
class ListUnspentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_CONFS_FIELD_NUMBER: builtins.int
    MAX_CONFS_FIELD_NUMBER: builtins.int
    ACCOUNT_FIELD_NUMBER: builtins.int
    min_confs: builtins.int
    """The minimum number of confirmations to be included."""
    max_confs: builtins.int
    """The maximum number of confirmations to be included."""
    account: builtins.str
    """An optional filter to only include outputs belonging to an account."""
    def __init__(
        self,
        *,
        min_confs: builtins.int = ...,
        max_confs: builtins.int = ...,
        account: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["account", b"account", "max_confs", b"max_confs", "min_confs", b"min_confs"]) -> None: ...

global___ListUnspentRequest = ListUnspentRequest

@typing.final
class ListUnspentResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UTXOS_FIELD_NUMBER: builtins.int
    @property
    def utxos(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Utxo]:
        """A list of utxos"""

    def __init__(
        self,
        *,
        utxos: collections.abc.Iterable[global___Utxo] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["utxos", b"utxos"]) -> None: ...

global___ListUnspentResponse = ListUnspentResponse

@typing.final
class NewAddressRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    ACCOUNT_FIELD_NUMBER: builtins.int
    type: global___AddressType.ValueType
    """The type of address to generate."""
    account: builtins.str
    """
    The name of the account to generate a new address for. If empty, the
    default wallet account is used.
    """
    def __init__(
        self,
        *,
        type: global___AddressType.ValueType = ...,
        account: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["account", b"account", "type", b"type"]) -> None: ...

global___NewAddressRequest = NewAddressRequest

@typing.final
class NewAddressResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    address: builtins.str
    """The newly generated wallet address"""
    def __init__(
        self,
        *,
        address: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address"]) -> None: ...

global___NewAddressResponse = NewAddressResponse

@typing.final
class SignMessageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MSG_FIELD_NUMBER: builtins.int
    SINGLE_HASH_FIELD_NUMBER: builtins.int
    msg: builtins.bytes
    """
    The message to be signed. When using REST, this field must be encoded as
    base64.
    """
    single_hash: builtins.bool
    """
    Instead of the default double-SHA256 hashing of the message before signing,
    only use one round of hashing instead.
    """
    def __init__(
        self,
        *,
        msg: builtins.bytes = ...,
        single_hash: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["msg", b"msg", "single_hash", b"single_hash"]) -> None: ...

global___SignMessageRequest = SignMessageRequest

@typing.final
class SignMessageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNATURE_FIELD_NUMBER: builtins.int
    signature: builtins.str
    """The signature for the given message"""
    def __init__(
        self,
        *,
        signature: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["signature", b"signature"]) -> None: ...

global___SignMessageResponse = SignMessageResponse

@typing.final
class VerifyMessageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MSG_FIELD_NUMBER: builtins.int
    SIGNATURE_FIELD_NUMBER: builtins.int
    msg: builtins.bytes
    """
    The message over which the signature is to be verified. When using REST,
    this field must be encoded as base64.
    """
    signature: builtins.str
    """The signature to be verified over the given message"""
    def __init__(
        self,
        *,
        msg: builtins.bytes = ...,
        signature: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["msg", b"msg", "signature", b"signature"]) -> None: ...

global___VerifyMessageRequest = VerifyMessageRequest

@typing.final
class VerifyMessageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALID_FIELD_NUMBER: builtins.int
    PUBKEY_FIELD_NUMBER: builtins.int
    valid: builtins.bool
    """Whether the signature was valid over the given message"""
    pubkey: builtins.str
    """The pubkey recovered from the signature"""
    def __init__(
        self,
        *,
        valid: builtins.bool = ...,
        pubkey: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pubkey", b"pubkey", "valid", b"valid"]) -> None: ...

global___VerifyMessageResponse = VerifyMessageResponse

@typing.final
class ConnectPeerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDR_FIELD_NUMBER: builtins.int
    PERM_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    perm: builtins.bool
    """
    If set, the daemon will attempt to persistently connect to the target
    peer. Otherwise, the call will be synchronous.
    """
    timeout: builtins.int
    """
    The connection timeout value (in seconds) for this request. It won't affect
    other requests.
    """
    @property
    def addr(self) -> global___LightningAddress:
        """
        Lightning address of the peer to connect to.
        """

    def __init__(
        self,
        *,
        addr: global___LightningAddress | None = ...,
        perm: builtins.bool = ...,
        timeout: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["addr", b"addr"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["addr", b"addr", "perm", b"perm", "timeout", b"timeout"]) -> None: ...

global___ConnectPeerRequest = ConnectPeerRequest

@typing.final
class ConnectPeerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ConnectPeerResponse = ConnectPeerResponse

@typing.final
class DisconnectPeerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PUB_KEY_FIELD_NUMBER: builtins.int
    pub_key: builtins.str
    """The pubkey of the node to disconnect from"""
    def __init__(
        self,
        *,
        pub_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pub_key", b"pub_key"]) -> None: ...

global___DisconnectPeerRequest = DisconnectPeerRequest

@typing.final
class DisconnectPeerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DisconnectPeerResponse = DisconnectPeerResponse

@typing.final
class HTLC(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INCOMING_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    HASH_LOCK_FIELD_NUMBER: builtins.int
    EXPIRATION_HEIGHT_FIELD_NUMBER: builtins.int
    HTLC_INDEX_FIELD_NUMBER: builtins.int
    FORWARDING_CHANNEL_FIELD_NUMBER: builtins.int
    FORWARDING_HTLC_INDEX_FIELD_NUMBER: builtins.int
    incoming: builtins.bool
    amount: builtins.int
    hash_lock: builtins.bytes
    expiration_height: builtins.int
    htlc_index: builtins.int
    """Index identifying the htlc on the channel."""
    forwarding_channel: builtins.int
    """If this HTLC is involved in a forwarding operation, this field indicates
    the forwarding channel. For an outgoing htlc, it is the incoming channel.
    For an incoming htlc, it is the outgoing channel. When the htlc
    originates from this node or this node is the final destination,
    forwarding_channel will be zero. The forwarding channel will also be zero
    for htlcs that need to be forwarded but don't have a forwarding decision
    persisted yet.
    """
    forwarding_htlc_index: builtins.int
    """Index identifying the htlc on the forwarding channel."""
    def __init__(
        self,
        *,
        incoming: builtins.bool = ...,
        amount: builtins.int = ...,
        hash_lock: builtins.bytes = ...,
        expiration_height: builtins.int = ...,
        htlc_index: builtins.int = ...,
        forwarding_channel: builtins.int = ...,
        forwarding_htlc_index: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["amount", b"amount", "expiration_height", b"expiration_height", "forwarding_channel", b"forwarding_channel", "forwarding_htlc_index", b"forwarding_htlc_index", "hash_lock", b"hash_lock", "htlc_index", b"htlc_index", "incoming", b"incoming"]) -> None: ...

global___HTLC = HTLC

@typing.final
class ChannelConstraints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CSV_DELAY_FIELD_NUMBER: builtins.int
    CHAN_RESERVE_SAT_FIELD_NUMBER: builtins.int
    DUST_LIMIT_SAT_FIELD_NUMBER: builtins.int
    MAX_PENDING_AMT_MSAT_FIELD_NUMBER: builtins.int
    MIN_HTLC_MSAT_FIELD_NUMBER: builtins.int
    MAX_ACCEPTED_HTLCS_FIELD_NUMBER: builtins.int
    csv_delay: builtins.int
    """
    The CSV delay expressed in relative blocks. If the channel is force closed,
    we will need to wait for this many blocks before we can regain our funds.
    """
    chan_reserve_sat: builtins.int
    """The minimum satoshis this node is required to reserve in its balance."""
    dust_limit_sat: builtins.int
    """The dust limit (in satoshis) of the initiator's commitment tx."""
    max_pending_amt_msat: builtins.int
    """The maximum amount of coins in millisatoshis that can be pending in this
    channel.
    """
    min_htlc_msat: builtins.int
    """The smallest HTLC in millisatoshis that the initiator will accept."""
    max_accepted_htlcs: builtins.int
    """The total number of incoming HTLC's that the initiator will accept."""
    def __init__(
        self,
        *,
        csv_delay: builtins.int = ...,
        chan_reserve_sat: builtins.int = ...,
        dust_limit_sat: builtins.int = ...,
        max_pending_amt_msat: builtins.int = ...,
        min_htlc_msat: builtins.int = ...,
        max_accepted_htlcs: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["chan_reserve_sat", b"chan_reserve_sat", "csv_delay", b"csv_delay", "dust_limit_sat", b"dust_limit_sat", "max_accepted_htlcs", b"max_accepted_htlcs", "max_pending_amt_msat", b"max_pending_amt_msat", "min_htlc_msat", b"min_htlc_msat"]) -> None: ...

global___ChannelConstraints = ChannelConstraints

@typing.final
class Channel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTIVE_FIELD_NUMBER: builtins.int
    REMOTE_PUBKEY_FIELD_NUMBER: builtins.int
    CHANNEL_POINT_FIELD_NUMBER: builtins.int
    CHAN_ID_FIELD_NUMBER: builtins.int
    CAPACITY_FIELD_NUMBER: builtins.int
    LOCAL_BALANCE_FIELD_NUMBER: builtins.int
    REMOTE_BALANCE_FIELD_NUMBER: builtins.int
    COMMIT_FEE_FIELD_NUMBER: builtins.int
    COMMIT_WEIGHT_FIELD_NUMBER: builtins.int
    FEE_PER_KW_FIELD_NUMBER: builtins.int
    UNSETTLED_BALANCE_FIELD_NUMBER: builtins.int
    TOTAL_SATOSHIS_SENT_FIELD_NUMBER: builtins.int
    TOTAL_SATOSHIS_RECEIVED_FIELD_NUMBER: builtins.int
    NUM_UPDATES_FIELD_NUMBER: builtins.int
    PENDING_HTLCS_FIELD_NUMBER: builtins.int
    CSV_DELAY_FIELD_NUMBER: builtins.int
    PRIVATE_FIELD_NUMBER: builtins.int
    INITIATOR_FIELD_NUMBER: builtins.int
    CHAN_STATUS_FLAGS_FIELD_NUMBER: builtins.int
    LOCAL_CHAN_RESERVE_SAT_FIELD_NUMBER: builtins.int
    REMOTE_CHAN_RESERVE_SAT_FIELD_NUMBER: builtins.int
    STATIC_REMOTE_KEY_FIELD_NUMBER: builtins.int
    COMMITMENT_TYPE_FIELD_NUMBER: builtins.int
    LIFETIME_FIELD_NUMBER: builtins.int
    UPTIME_FIELD_NUMBER: builtins.int
    CLOSE_ADDRESS_FIELD_NUMBER: builtins.int
    PUSH_AMOUNT_SAT_FIELD_NUMBER: builtins.int
    THAW_HEIGHT_FIELD_NUMBER: builtins.int
    LOCAL_CONSTRAINTS_FIELD_NUMBER: builtins.int
    REMOTE_CONSTRAINTS_FIELD_NUMBER: builtins.int
    ALIAS_SCIDS_FIELD_NUMBER: builtins.int
    ZERO_CONF_FIELD_NUMBER: builtins.int
    ZERO_CONF_CONFIRMED_SCID_FIELD_NUMBER: builtins.int
    PEER_ALIAS_FIELD_NUMBER: builtins.int
    PEER_SCID_ALIAS_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    active: builtins.bool
    """Whether this channel is active or not"""
    remote_pubkey: builtins.str
    """The identity pubkey of the remote node"""
    channel_point: builtins.str
    """
    The outpoint (txid:index) of the funding transaction. With this value, Bob
    will be able to generate a signature for Alice's version of the commitment
    transaction.
    """
    chan_id: builtins.int
    """
    The unique channel ID for the channel. The first 3 bytes are the block
    height, the next 3 the index within the block, and the last 2 bytes are the
    output index for the channel.
    """
    capacity: builtins.int
    """The total amount of funds held in this channel"""
    local_balance: builtins.int
    """This node's current balance in this channel"""
    remote_balance: builtins.int
    """The counterparty's current balance in this channel"""
    commit_fee: builtins.int
    """
    The amount calculated to be paid in fees for the current set of commitment
    transactions. The fee amount is persisted with the channel in order to
    allow the fee amount to be removed and recalculated with each channel state
    update, including updates that happen after a system restart.
    """
    commit_weight: builtins.int
    """The weight of the commitment transaction"""
    fee_per_kw: builtins.int
    """
    The required number of satoshis per kilo-weight that the requester will pay
    at all times, for both the funding transaction and commitment transaction.
    This value can later be updated once the channel is open.
    """
    unsettled_balance: builtins.int
    """The unsettled balance in this channel"""
    total_satoshis_sent: builtins.int
    """
    The total number of satoshis we've sent within this channel.
    """
    total_satoshis_received: builtins.int
    """
    The total number of satoshis we've received within this channel.
    """
    num_updates: builtins.int
    """
    The total number of updates conducted within this channel.
    """
    csv_delay: builtins.int
    """
    Deprecated. The CSV delay expressed in relative blocks. If the channel is
    force closed, we will need to wait for this many blocks before we can regain
    our funds.
    """
    private: builtins.bool
    """Whether this channel is advertised to the network or not."""
    initiator: builtins.bool
    """True if we were the ones that created the channel."""
    chan_status_flags: builtins.str
    """A set of flags showing the current state of the channel."""
    local_chan_reserve_sat: builtins.int
    """Deprecated. The minimum satoshis this node is required to reserve in its
    balance.
    """
    remote_chan_reserve_sat: builtins.int
    """
    Deprecated. The minimum satoshis the other node is required to reserve in
    its balance.
    """
    static_remote_key: builtins.bool
    """Deprecated. Use commitment_type."""
    commitment_type: global___CommitmentType.ValueType
    """The commitment type used by this channel."""
    lifetime: builtins.int
    """
    The number of seconds that the channel has been monitored by the channel
    scoring system. Scores are currently not persisted, so this value may be
    less than the lifetime of the channel [EXPERIMENTAL].
    """
    uptime: builtins.int
    """
    The number of seconds that the remote peer has been observed as being online
    by the channel scoring system over the lifetime of the channel
    [EXPERIMENTAL].
    """
    close_address: builtins.str
    """
    Close address is the address that we will enforce payout to on cooperative
    close if the channel was opened utilizing option upfront shutdown. This
    value can be set on channel open by setting close_address in an open channel
    request. If this value is not set, you can still choose a payout address by
    cooperatively closing with the delivery_address field set.
    """
    push_amount_sat: builtins.int
    """
    The amount that the initiator of the channel optionally pushed to the remote
    party on channel open. This amount will be zero if the channel initiator did
    not push any funds to the remote peer. If the initiator field is true, we
    pushed this amount to our peer, if it is false, the remote peer pushed this
    amount to us.
    """
    thaw_height: builtins.int
    """
    This uint32 indicates if this channel is to be considered 'frozen'. A
    frozen channel doest not allow a cooperative channel close by the
    initiator. The thaw_height is the height that this restriction stops
    applying to the channel. This field is optional, not setting it or using a
    value of zero will mean the channel has no additional restrictions. The
    height can be interpreted in two ways: as a relative height if the value is
    less than 500,000, or as an absolute height otherwise.
    """
    zero_conf: builtins.bool
    """Whether or not this is a zero-conf channel."""
    zero_conf_confirmed_scid: builtins.int
    """This is the confirmed / on-chain zero-conf SCID."""
    peer_alias: builtins.str
    """The configured alias name of our peer."""
    peer_scid_alias: builtins.int
    """This is the peer SCID alias."""
    memo: builtins.str
    """
    An optional note-to-self to go along with the channel containing some
    useful information. This is only ever stored locally and in no way impacts
    the channel's operation.
    """
    @property
    def pending_htlcs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HTLC]:
        """
        The list of active, uncleared HTLCs currently pending within the channel.
        """

    @property
    def local_constraints(self) -> global___ChannelConstraints:
        """List constraints for the local node."""

    @property
    def remote_constraints(self) -> global___ChannelConstraints:
        """List constraints for the remote node."""

    @property
    def alias_scids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """
        This lists out the set of alias short channel ids that exist for a channel.
        This may be empty.
        """

    def __init__(
        self,
        *,
        active: builtins.bool = ...,
        remote_pubkey: builtins.str = ...,
        channel_point: builtins.str = ...,
        chan_id: builtins.int = ...,
        capacity: builtins.int = ...,
        local_balance: builtins.int = ...,
        remote_balance: builtins.int = ...,
        commit_fee: builtins.int = ...,
        commit_weight: builtins.int = ...,
        fee_per_kw: builtins.int = ...,
        unsettled_balance: builtins.int = ...,
        total_satoshis_sent: builtins.int = ...,
        total_satoshis_received: builtins.int = ...,
        num_updates: builtins.int = ...,
        pending_htlcs: collections.abc.Iterable[global___HTLC] | None = ...,
        csv_delay: builtins.int = ...,
        private: builtins.bool = ...,
        initiator: builtins.bool = ...,
        chan_status_flags: builtins.str = ...,
        local_chan_reserve_sat: builtins.int = ...,
        remote_chan_reserve_sat: builtins.int = ...,
        static_remote_key: builtins.bool = ...,
        commitment_type: global___CommitmentType.ValueType = ...,
        lifetime: builtins.int = ...,
        uptime: builtins.int = ...,
        close_address: builtins.str = ...,
        push_amount_sat: builtins.int = ...,
        thaw_height: builtins.int = ...,
        local_constraints: global___ChannelConstraints | None = ...,
        remote_constraints: global___ChannelConstraints | None = ...,
        alias_scids: collections.abc.Iterable[builtins.int] | None = ...,
        zero_conf: builtins.bool = ...,
        zero_conf_confirmed_scid: builtins.int = ...,
        peer_alias: builtins.str = ...,
        peer_scid_alias: builtins.int = ...,
        memo: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["local_constraints", b"local_constraints", "remote_constraints", b"remote_constraints"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "alias_scids", b"alias_scids", "capacity", b"capacity", "chan_id", b"chan_id", "chan_status_flags", b"chan_status_flags", "channel_point", b"channel_point", "close_address", b"close_address", "commit_fee", b"commit_fee", "commit_weight", b"commit_weight", "commitment_type", b"commitment_type", "csv_delay", b"csv_delay", "fee_per_kw", b"fee_per_kw", "initiator", b"initiator", "lifetime", b"lifetime", "local_balance", b"local_balance", "local_chan_reserve_sat", b"local_chan_reserve_sat", "local_constraints", b"local_constraints", "memo", b"memo", "num_updates", b"num_updates", "peer_alias", b"peer_alias", "peer_scid_alias", b"peer_scid_alias", "pending_htlcs", b"pending_htlcs", "private", b"private", "push_amount_sat", b"push_amount_sat", "remote_balance", b"remote_balance", "remote_chan_reserve_sat", b"remote_chan_reserve_sat", "remote_constraints", b"remote_constraints", "remote_pubkey", b"remote_pubkey", "static_remote_key", b"static_remote_key", "thaw_height", b"thaw_height", "total_satoshis_received", b"total_satoshis_received", "total_satoshis_sent", b"total_satoshis_sent", "unsettled_balance", b"unsettled_balance", "uptime", b"uptime", "zero_conf", b"zero_conf", "zero_conf_confirmed_scid", b"zero_conf_confirmed_scid"]) -> None: ...

global___Channel = Channel

@typing.final
class ListChannelsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTIVE_ONLY_FIELD_NUMBER: builtins.int
    INACTIVE_ONLY_FIELD_NUMBER: builtins.int
    PUBLIC_ONLY_FIELD_NUMBER: builtins.int
    PRIVATE_ONLY_FIELD_NUMBER: builtins.int
    PEER_FIELD_NUMBER: builtins.int
    PEER_ALIAS_LOOKUP_FIELD_NUMBER: builtins.int
    active_only: builtins.bool
    inactive_only: builtins.bool
    public_only: builtins.bool
    private_only: builtins.bool
    peer: builtins.bytes
    """
    Filters the response for channels with a target peer's pubkey. If peer is
    empty, all channels will be returned.
    """
    peer_alias_lookup: builtins.bool
    """Informs the server if the peer alias lookup per channel should be
    enabled. It is turned off by default in order to avoid degradation of
    performance for existing clients.
    """
    def __init__(
        self,
        *,
        active_only: builtins.bool = ...,
        inactive_only: builtins.bool = ...,
        public_only: builtins.bool = ...,
        private_only: builtins.bool = ...,
        peer: builtins.bytes = ...,
        peer_alias_lookup: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["active_only", b"active_only", "inactive_only", b"inactive_only", "peer", b"peer", "peer_alias_lookup", b"peer_alias_lookup", "private_only", b"private_only", "public_only", b"public_only"]) -> None: ...

global___ListChannelsRequest = ListChannelsRequest

@typing.final
class ListChannelsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNELS_FIELD_NUMBER: builtins.int
    @property
    def channels(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Channel]:
        """The list of active channels"""

    def __init__(
        self,
        *,
        channels: collections.abc.Iterable[global___Channel] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channels", b"channels"]) -> None: ...

global___ListChannelsResponse = ListChannelsResponse

@typing.final
class AliasMap(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BASE_SCID_FIELD_NUMBER: builtins.int
    ALIASES_FIELD_NUMBER: builtins.int
    base_scid: builtins.int
    """
    For non-zero-conf channels, this is the confirmed SCID. Otherwise, this is
    the first assigned "base" alias.
    """
    @property
    def aliases(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The set of all aliases stored for the base SCID."""

    def __init__(
        self,
        *,
        base_scid: builtins.int = ...,
        aliases: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["aliases", b"aliases", "base_scid", b"base_scid"]) -> None: ...

global___AliasMap = AliasMap

@typing.final
class ListAliasesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListAliasesRequest = ListAliasesRequest

@typing.final
class ListAliasesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALIAS_MAPS_FIELD_NUMBER: builtins.int
    @property
    def alias_maps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AliasMap]: ...
    def __init__(
        self,
        *,
        alias_maps: collections.abc.Iterable[global___AliasMap] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["alias_maps", b"alias_maps"]) -> None: ...

global___ListAliasesResponse = ListAliasesResponse

@typing.final
class ChannelCloseSummary(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ClosureType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ClosureTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ChannelCloseSummary._ClosureType.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        COOPERATIVE_CLOSE: ChannelCloseSummary._ClosureType.ValueType  # 0
        LOCAL_FORCE_CLOSE: ChannelCloseSummary._ClosureType.ValueType  # 1
        REMOTE_FORCE_CLOSE: ChannelCloseSummary._ClosureType.ValueType  # 2
        BREACH_CLOSE: ChannelCloseSummary._ClosureType.ValueType  # 3
        FUNDING_CANCELED: ChannelCloseSummary._ClosureType.ValueType  # 4
        ABANDONED: ChannelCloseSummary._ClosureType.ValueType  # 5

    class ClosureType(_ClosureType, metaclass=_ClosureTypeEnumTypeWrapper): ...
    COOPERATIVE_CLOSE: ChannelCloseSummary.ClosureType.ValueType  # 0
    LOCAL_FORCE_CLOSE: ChannelCloseSummary.ClosureType.ValueType  # 1
    REMOTE_FORCE_CLOSE: ChannelCloseSummary.ClosureType.ValueType  # 2
    BREACH_CLOSE: ChannelCloseSummary.ClosureType.ValueType  # 3
    FUNDING_CANCELED: ChannelCloseSummary.ClosureType.ValueType  # 4
    ABANDONED: ChannelCloseSummary.ClosureType.ValueType  # 5

    CHANNEL_POINT_FIELD_NUMBER: builtins.int
    CHAN_ID_FIELD_NUMBER: builtins.int
    CHAIN_HASH_FIELD_NUMBER: builtins.int
    CLOSING_TX_HASH_FIELD_NUMBER: builtins.int
    REMOTE_PUBKEY_FIELD_NUMBER: builtins.int
    CAPACITY_FIELD_NUMBER: builtins.int
    CLOSE_HEIGHT_FIELD_NUMBER: builtins.int
    SETTLED_BALANCE_FIELD_NUMBER: builtins.int
    TIME_LOCKED_BALANCE_FIELD_NUMBER: builtins.int
    CLOSE_TYPE_FIELD_NUMBER: builtins.int
    OPEN_INITIATOR_FIELD_NUMBER: builtins.int
    CLOSE_INITIATOR_FIELD_NUMBER: builtins.int
    RESOLUTIONS_FIELD_NUMBER: builtins.int
    ALIAS_SCIDS_FIELD_NUMBER: builtins.int
    ZERO_CONF_CONFIRMED_SCID_FIELD_NUMBER: builtins.int
    channel_point: builtins.str
    """The outpoint (txid:index) of the funding transaction."""
    chan_id: builtins.int
    """ The unique channel ID for the channel."""
    chain_hash: builtins.str
    """The hash of the genesis block that this channel resides within."""
    closing_tx_hash: builtins.str
    """The txid of the transaction which ultimately closed this channel."""
    remote_pubkey: builtins.str
    """Public key of the remote peer that we formerly had a channel with."""
    capacity: builtins.int
    """Total capacity of the channel."""
    close_height: builtins.int
    """Height at which the funding transaction was spent."""
    settled_balance: builtins.int
    """Settled balance at the time of channel closure"""
    time_locked_balance: builtins.int
    """The sum of all the time-locked outputs at the time of channel closure"""
    close_type: global___ChannelCloseSummary.ClosureType.ValueType
    """Details on how the channel was closed."""
    open_initiator: global___Initiator.ValueType
    """
    Open initiator is the party that initiated opening the channel. Note that
    this value may be unknown if the channel was closed before we migrated to
    store open channel information after close.
    """
    close_initiator: global___Initiator.ValueType
    """
    Close initiator indicates which party initiated the close. This value will
    be unknown for channels that were cooperatively closed before we started
    tracking cooperative close initiators. Note that this indicates which party
    initiated a close, and it is possible for both to initiate cooperative or
    force closes, although only one party's close will be confirmed on chain.
    """
    zero_conf_confirmed_scid: builtins.int
    """ The confirmed SCID for a zero-conf channel."""
    @property
    def resolutions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Resolution]: ...
    @property
    def alias_scids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """
        This lists out the set of alias short channel ids that existed for the
        closed channel. This may be empty.
        """

    def __init__(
        self,
        *,
        channel_point: builtins.str = ...,
        chan_id: builtins.int = ...,
        chain_hash: builtins.str = ...,
        closing_tx_hash: builtins.str = ...,
        remote_pubkey: builtins.str = ...,
        capacity: builtins.int = ...,
        close_height: builtins.int = ...,
        settled_balance: builtins.int = ...,
        time_locked_balance: builtins.int = ...,
        close_type: global___ChannelCloseSummary.ClosureType.ValueType = ...,
        open_initiator: global___Initiator.ValueType = ...,
        close_initiator: global___Initiator.ValueType = ...,
        resolutions: collections.abc.Iterable[global___Resolution] | None = ...,
        alias_scids: collections.abc.Iterable[builtins.int] | None = ...,
        zero_conf_confirmed_scid: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["alias_scids", b"alias_scids", "capacity", b"capacity", "chain_hash", b"chain_hash", "chan_id", b"chan_id", "channel_point", b"channel_point", "close_height", b"close_height", "close_initiator", b"close_initiator", "close_type", b"close_type", "closing_tx_hash", b"closing_tx_hash", "open_initiator", b"open_initiator", "remote_pubkey", b"remote_pubkey", "resolutions", b"resolutions", "settled_balance", b"settled_balance", "time_locked_balance", b"time_locked_balance", "zero_conf_confirmed_scid", b"zero_conf_confirmed_scid"]) -> None: ...

global___ChannelCloseSummary = ChannelCloseSummary

@typing.final
class Resolution(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOLUTION_TYPE_FIELD_NUMBER: builtins.int
    OUTCOME_FIELD_NUMBER: builtins.int
    OUTPOINT_FIELD_NUMBER: builtins.int
    AMOUNT_SAT_FIELD_NUMBER: builtins.int
    SWEEP_TXID_FIELD_NUMBER: builtins.int
    resolution_type: global___ResolutionType.ValueType
    """The type of output we are resolving."""
    outcome: global___ResolutionOutcome.ValueType
    """The outcome of our on chain action that resolved the outpoint."""
    amount_sat: builtins.int
    """The amount that was claimed by the resolution."""
    sweep_txid: builtins.str
    """The hex-encoded transaction ID of the sweep transaction that spent the
    output.
    """
    @property
    def outpoint(self) -> global___OutPoint:
        """The outpoint that was spent by the resolution."""

    def __init__(
        self,
        *,
        resolution_type: global___ResolutionType.ValueType = ...,
        outcome: global___ResolutionOutcome.ValueType = ...,
        outpoint: global___OutPoint | None = ...,
        amount_sat: builtins.int = ...,
        sweep_txid: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["outpoint", b"outpoint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["amount_sat", b"amount_sat", "outcome", b"outcome", "outpoint", b"outpoint", "resolution_type", b"resolution_type", "sweep_txid", b"sweep_txid"]) -> None: ...

global___Resolution = Resolution

@typing.final
class ClosedChannelsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COOPERATIVE_FIELD_NUMBER: builtins.int
    LOCAL_FORCE_FIELD_NUMBER: builtins.int
    REMOTE_FORCE_FIELD_NUMBER: builtins.int
    BREACH_FIELD_NUMBER: builtins.int
    FUNDING_CANCELED_FIELD_NUMBER: builtins.int
    ABANDONED_FIELD_NUMBER: builtins.int
    cooperative: builtins.bool
    local_force: builtins.bool
    remote_force: builtins.bool
    breach: builtins.bool
    funding_canceled: builtins.bool
    abandoned: builtins.bool
    def __init__(
        self,
        *,
        cooperative: builtins.bool = ...,
        local_force: builtins.bool = ...,
        remote_force: builtins.bool = ...,
        breach: builtins.bool = ...,
        funding_canceled: builtins.bool = ...,
        abandoned: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["abandoned", b"abandoned", "breach", b"breach", "cooperative", b"cooperative", "funding_canceled", b"funding_canceled", "local_force", b"local_force", "remote_force", b"remote_force"]) -> None: ...

global___ClosedChannelsRequest = ClosedChannelsRequest

@typing.final
class ClosedChannelsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNELS_FIELD_NUMBER: builtins.int
    @property
    def channels(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelCloseSummary]: ...
    def __init__(
        self,
        *,
        channels: collections.abc.Iterable[global___ChannelCloseSummary] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channels", b"channels"]) -> None: ...

global___ClosedChannelsResponse = ClosedChannelsResponse

@typing.final
class Peer(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SyncType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SyncTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Peer._SyncType.ValueType], builtins.type):   # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN_SYNC: Peer._SyncType.ValueType  # 0
        """
        Denotes that we cannot determine the peer's current sync type.
        """
        ACTIVE_SYNC: Peer._SyncType.ValueType  # 1
        """
        Denotes that we are actively receiving new graph updates from the peer.
        """
        PASSIVE_SYNC: Peer._SyncType.ValueType  # 2
        """
        Denotes that we are not receiving new graph updates from the peer.
        """
        PINNED_SYNC: Peer._SyncType.ValueType  # 3
        """
        Denotes that this peer is pinned into an active sync.
        """

    class SyncType(_SyncType, metaclass=_SyncTypeEnumTypeWrapper): ...
    UNKNOWN_SYNC: Peer.SyncType.ValueType  # 0
    """
    Denotes that we cannot determine the peer's current sync type.
    """
    ACTIVE_SYNC: Peer.SyncType.ValueType  # 1
    """
    Denotes that we are actively receiving new graph updates from the peer.
    """
    PASSIVE_SYNC: Peer.SyncType.ValueType  # 2
    """
    Denotes that we are not receiving new graph updates from the peer.
    """
    PINNED_SYNC: Peer.SyncType.ValueType  # 3
    """
    Denotes that this peer is pinned into an active sync.
    """

    @typing.final
    class FeaturesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> global___Feature: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: global___Feature | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    PUB_KEY_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    BYTES_SENT_FIELD_NUMBER: builtins.int
    BYTES_RECV_FIELD_NUMBER: builtins.int
    SAT_SENT_FIELD_NUMBER: builtins.int
    SAT_RECV_FIELD_NUMBER: builtins.int
    INBOUND_FIELD_NUMBER: builtins.int
    PING_TIME_FIELD_NUMBER: builtins.int
    SYNC_TYPE_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    ERRORS_FIELD_NUMBER: builtins.int
    FLAP_COUNT_FIELD_NUMBER: builtins.int
    LAST_FLAP_NS_FIELD_NUMBER: builtins.int
    LAST_PING_PAYLOAD_FIELD_NUMBER: builtins.int
    pub_key: builtins.str
    """The identity pubkey of the peer"""
    address: builtins.str
    """Network address of the peer; eg `127.0.0.1:10011`"""
    bytes_sent: builtins.int
    """Bytes of data transmitted to this peer"""
    bytes_recv: builtins.int
    """Bytes of data transmitted from this peer"""
    sat_sent: builtins.int
    """Satoshis sent to this peer"""
    sat_recv: builtins.int
    """Satoshis received from this peer"""
    inbound: builtins.bool
    """A channel is inbound if the counterparty initiated the channel"""
    ping_time: builtins.int
    """Ping time to this peer"""
    sync_type: global___Peer.SyncType.ValueType
    """The type of sync we are currently performing with this peer."""
    flap_count: builtins.int
    """
    The number of times we have recorded this peer going offline or coming
    online, recorded across restarts. Note that this value is decreased over
    time if the peer has not recently flapped, so that we can forgive peers
    with historically high flap counts.
    """
    last_flap_ns: builtins.int
    """
    The timestamp of the last flap we observed for this peer. If this value is
    zero, we have not observed any flaps for this peer.
    """
    last_ping_payload: builtins.bytes
    """
    The last ping payload the peer has sent to us.
    """
    @property
    def features(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, global___Feature]:
        """Features advertised by the remote peer in their init message."""

    @property
    def errors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TimestampedError]:
        """
        The latest errors received from our peer with timestamps, limited to the 10
        most recent errors. These errors are tracked across peer connections, but
        are not persisted across lnd restarts. Note that these errors are only
        stored for peers that we have channels open with, to prevent peers from
        spamming us with errors at no cost.
        """

    def __init__(
        self,
        *,
        pub_key: builtins.str = ...,
        address: builtins.str = ...,
        bytes_sent: builtins.int = ...,
        bytes_recv: builtins.int = ...,
        sat_sent: builtins.int = ...,
        sat_recv: builtins.int = ...,
        inbound: builtins.bool = ...,
        ping_time: builtins.int = ...,
        sync_type: global___Peer.SyncType.ValueType = ...,
        features: collections.abc.Mapping[builtins.int, global___Feature] | None = ...,
        errors: collections.abc.Iterable[global___TimestampedError] | None = ...,
        flap_count: builtins.int = ...,
        last_flap_ns: builtins.int = ...,
        last_ping_payload: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "bytes_recv", b"bytes_recv", "bytes_sent", b"bytes_sent", "errors", b"errors", "features", b"features", "flap_count", b"flap_count", "inbound", b"inbound", "last_flap_ns", b"last_flap_ns", "last_ping_payload", b"last_ping_payload", "ping_time", b"ping_time", "pub_key", b"pub_key", "sat_recv", b"sat_recv", "sat_sent", b"sat_sent", "sync_type", b"sync_type"]) -> None: ...

global___Peer = Peer

@typing.final
class TimestampedError(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """The unix timestamp in seconds when the error occurred."""
    error: builtins.str
    """The string representation of the error sent by our peer."""
    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        error: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["error", b"error", "timestamp", b"timestamp"]) -> None: ...

global___TimestampedError = TimestampedError

@typing.final
class ListPeersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LATEST_ERROR_FIELD_NUMBER: builtins.int
    latest_error: builtins.bool
    """
    If true, only the last error that our peer sent us will be returned with
    the peer's information, rather than the full set of historic errors we have
    stored.
    """
    def __init__(
        self,
        *,
        latest_error: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["latest_error", b"latest_error"]) -> None: ...

global___ListPeersRequest = ListPeersRequest

@typing.final
class ListPeersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PEERS_FIELD_NUMBER: builtins.int
    @property
    def peers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Peer]:
        """The list of currently connected peers"""

    def __init__(
        self,
        *,
        peers: collections.abc.Iterable[global___Peer] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["peers", b"peers"]) -> None: ...

global___ListPeersResponse = ListPeersResponse

@typing.final
class PeerEventSubscription(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PeerEventSubscription = PeerEventSubscription

@typing.final
class PeerEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _EventType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EventTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PeerEvent._EventType.ValueType], builtins.type):    # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PEER_ONLINE: PeerEvent._EventType.ValueType  # 0
        PEER_OFFLINE: PeerEvent._EventType.ValueType  # 1

    class EventType(_EventType, metaclass=_EventTypeEnumTypeWrapper): ...
    PEER_ONLINE: PeerEvent.EventType.ValueType  # 0
    PEER_OFFLINE: PeerEvent.EventType.ValueType  # 1

    PUB_KEY_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    pub_key: builtins.str
    """The identity pubkey of the peer."""
    type: global___PeerEvent.EventType.ValueType
    def __init__(
        self,
        *,
        pub_key: builtins.str = ...,
        type: global___PeerEvent.EventType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pub_key", b"pub_key", "type", b"type"]) -> None: ...

global___PeerEvent = PeerEvent

@typing.final
class GetInfoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetInfoRequest = GetInfoRequest

@typing.final
class GetInfoResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class FeaturesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> global___Feature: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: global___Feature | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    VERSION_FIELD_NUMBER: builtins.int
    COMMIT_HASH_FIELD_NUMBER: builtins.int
    IDENTITY_PUBKEY_FIELD_NUMBER: builtins.int
    ALIAS_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    NUM_PENDING_CHANNELS_FIELD_NUMBER: builtins.int
    NUM_ACTIVE_CHANNELS_FIELD_NUMBER: builtins.int
    NUM_INACTIVE_CHANNELS_FIELD_NUMBER: builtins.int
    NUM_PEERS_FIELD_NUMBER: builtins.int
    BLOCK_HEIGHT_FIELD_NUMBER: builtins.int
    BLOCK_HASH_FIELD_NUMBER: builtins.int
    BEST_HEADER_TIMESTAMP_FIELD_NUMBER: builtins.int
    SYNCED_TO_CHAIN_FIELD_NUMBER: builtins.int
    SYNCED_TO_GRAPH_FIELD_NUMBER: builtins.int
    TESTNET_FIELD_NUMBER: builtins.int
    CHAINS_FIELD_NUMBER: builtins.int
    URIS_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    REQUIRE_HTLC_INTERCEPTOR_FIELD_NUMBER: builtins.int
    STORE_FINAL_HTLC_RESOLUTIONS_FIELD_NUMBER: builtins.int
    version: builtins.str
    """The version of the LND software that the node is running."""
    commit_hash: builtins.str
    """The SHA1 commit hash that the daemon is compiled with."""
    identity_pubkey: builtins.str
    """The identity pubkey of the current node."""
    alias: builtins.str
    """If applicable, the alias of the current node, e.g. "bob" """
    color: builtins.str
    """The color of the current node in hex code format"""
    num_pending_channels: builtins.int
    """Number of pending channels"""
    num_active_channels: builtins.int
    """Number of active channels"""
    num_inactive_channels: builtins.int
    """Number of inactive channels"""
    num_peers: builtins.int
    """Number of peers"""
    block_height: builtins.int
    """The node's current view of the height of the best block"""
    block_hash: builtins.str
    """The node's current view of the hash of the best block"""
    best_header_timestamp: builtins.int
    """Timestamp of the block best known to the wallet"""
    synced_to_chain: builtins.bool
    """Whether the wallet's view is synced to the main chain"""
    synced_to_graph: builtins.bool
    """Whether we consider ourselves synced with the public channel graph."""
    testnet: builtins.bool
    """
    Whether the current node is connected to testnet. This field is
    deprecated and the network field should be used instead
    """
    require_htlc_interceptor: builtins.bool
    """
    Indicates whether the HTLC interceptor API is in always-on mode.
    """
    store_final_htlc_resolutions: builtins.bool
    """Indicates whether final htlc resolutions are stored on disk."""
    @property
    def chains(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Chain]:
        """
        A list of active chains the node is connected to. This will only
        ever contain a single entry since LND will only ever have a single
        chain backend during its lifetime.
        """

    @property
    def uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The URIs of the current node."""

    @property
    def features(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, global___Feature]:
        """
        Features that our node has advertised in our init message, node
        announcements and invoices.
        """

    def __init__(
        self,
        *,
        version: builtins.str = ...,
        commit_hash: builtins.str = ...,
        identity_pubkey: builtins.str = ...,
        alias: builtins.str = ...,
        color: builtins.str = ...,
        num_pending_channels: builtins.int = ...,
        num_active_channels: builtins.int = ...,
        num_inactive_channels: builtins.int = ...,
        num_peers: builtins.int = ...,
        block_height: builtins.int = ...,
        block_hash: builtins.str = ...,
        best_header_timestamp: builtins.int = ...,
        synced_to_chain: builtins.bool = ...,
        synced_to_graph: builtins.bool = ...,
        testnet: builtins.bool = ...,
        chains: collections.abc.Iterable[global___Chain] | None = ...,
        uris: collections.abc.Iterable[builtins.str] | None = ...,
        features: collections.abc.Mapping[builtins.int, global___Feature] | None = ...,
        require_htlc_interceptor: builtins.bool = ...,
        store_final_htlc_resolutions: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["alias", b"alias", "best_header_timestamp", b"best_header_timestamp", "block_hash", b"block_hash", "block_height", b"block_height", "chains", b"chains", "color", b"color", "commit_hash", b"commit_hash", "features", b"features", "identity_pubkey", b"identity_pubkey", "num_active_channels", b"num_active_channels", "num_inactive_channels", b"num_inactive_channels", "num_peers", b"num_peers", "num_pending_channels", b"num_pending_channels", "require_htlc_interceptor", b"require_htlc_interceptor", "store_final_htlc_resolutions", b"store_final_htlc_resolutions", "synced_to_chain", b"synced_to_chain", "synced_to_graph", b"synced_to_graph", "testnet", b"testnet", "uris", b"uris", "version", b"version"]) -> None: ...

global___GetInfoResponse = GetInfoResponse

@typing.final
class GetDebugInfoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetDebugInfoRequest = GetDebugInfoRequest

@typing.final
class GetDebugInfoResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ConfigEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CONFIG_FIELD_NUMBER: builtins.int
    LOG_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    @property
    def log(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        config: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        log: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["config", b"config", "log", b"log"]) -> None: ...

global___GetDebugInfoResponse = GetDebugInfoResponse

@typing.final
class GetRecoveryInfoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetRecoveryInfoRequest = GetRecoveryInfoRequest

@typing.final
class GetRecoveryInfoResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECOVERY_MODE_FIELD_NUMBER: builtins.int
    RECOVERY_FINISHED_FIELD_NUMBER: builtins.int
    PROGRESS_FIELD_NUMBER: builtins.int
    recovery_mode: builtins.bool
    """Whether the wallet is in recovery mode"""
    recovery_finished: builtins.bool
    """Whether the wallet recovery progress is finished"""
    progress: builtins.float
    """The recovery progress, ranging from 0 to 1."""
    def __init__(
        self,
        *,
        recovery_mode: builtins.bool = ...,
        recovery_finished: builtins.bool = ...,
        progress: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["progress", b"progress", "recovery_finished", b"recovery_finished", "recovery_mode", b"recovery_mode"]) -> None: ...

global___GetRecoveryInfoResponse = GetRecoveryInfoResponse

@typing.final
class Chain(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAIN_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    chain: builtins.str
    """Deprecated. The chain is now always assumed to be bitcoin.
    The blockchain the node is on (must be bitcoin)
    """
    network: builtins.str
    """The network the node is on (eg regtest, testnet, mainnet)"""
    def __init__(
        self,
        *,
        chain: builtins.str = ...,
        network: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["chain", b"chain", "network", b"network"]) -> None: ...

global___Chain = Chain

@typing.final
class ConfirmationUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BLOCK_SHA_FIELD_NUMBER: builtins.int
    BLOCK_HEIGHT_FIELD_NUMBER: builtins.int
    NUM_CONFS_LEFT_FIELD_NUMBER: builtins.int
    block_sha: builtins.bytes
    block_height: builtins.int
    num_confs_left: builtins.int
    def __init__(
        self,
        *,
        block_sha: builtins.bytes = ...,
        block_height: builtins.int = ...,
        num_confs_left: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["block_height", b"block_height", "block_sha", b"block_sha", "num_confs_left", b"num_confs_left"]) -> None: ...

global___ConfirmationUpdate = ConfirmationUpdate

@typing.final
class ChannelOpenUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_POINT_FIELD_NUMBER: builtins.int
    @property
    def channel_point(self) -> global___ChannelPoint: ...
    def __init__(
        self,
        *,
        channel_point: global___ChannelPoint | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["channel_point", b"channel_point"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_point", b"channel_point"]) -> None: ...

global___ChannelOpenUpdate = ChannelOpenUpdate

@typing.final
class ChannelCloseUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLOSING_TXID_FIELD_NUMBER: builtins.int
    SUCCESS_FIELD_NUMBER: builtins.int
    closing_txid: builtins.bytes
    success: builtins.bool
    def __init__(
        self,
        *,
        closing_txid: builtins.bytes = ...,
        success: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["closing_txid", b"closing_txid", "success", b"success"]) -> None: ...

global___ChannelCloseUpdate = ChannelCloseUpdate

@typing.final
class CloseChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_POINT_FIELD_NUMBER: builtins.int
    FORCE_FIELD_NUMBER: builtins.int
    TARGET_CONF_FIELD_NUMBER: builtins.int
    SAT_PER_BYTE_FIELD_NUMBER: builtins.int
    DELIVERY_ADDRESS_FIELD_NUMBER: builtins.int
    SAT_PER_VBYTE_FIELD_NUMBER: builtins.int
    MAX_FEE_PER_VBYTE_FIELD_NUMBER: builtins.int
    NO_WAIT_FIELD_NUMBER: builtins.int
    force: builtins.bool
    """If true, then the channel will be closed forcibly. This means the
    current commitment transaction will be signed and broadcast.
    """
    target_conf: builtins.int
    """The target number of blocks that the closure transaction should be
    confirmed by.
    """
    sat_per_byte: builtins.int
    """Deprecated, use sat_per_vbyte.
    A manual fee rate set in sat/vbyte that should be used when crafting the
    closure transaction.
    """
    delivery_address: builtins.str
    """
    An optional address to send funds to in the case of a cooperative close.
    If the channel was opened with an upfront shutdown script and this field
    is set, the request to close will fail because the channel must pay out
    to the upfront shutdown addresss.
    """
    sat_per_vbyte: builtins.int
    """A manual fee rate set in sat/vbyte that should be used when crafting the
    closure transaction.
    """
    max_fee_per_vbyte: builtins.int
    """The maximum fee rate the closer is willing to pay.

    NOTE: This field is only respected if we're the initiator of the channel.
    """
    no_wait: builtins.bool
    """If true, then the rpc call will not block while it awaits a closing txid.
    Consequently this RPC call will not return a closing txid if this value
    is set.
    """
    @property
    def channel_point(self) -> global___ChannelPoint:
        """
        The outpoint (txid:index) of the funding transaction. With this value, Bob
        will be able to generate a signature for Alice's version of the commitment
        transaction.
        """

    def __init__(
        self,
        *,
        channel_point: global___ChannelPoint | None = ...,
        force: builtins.bool = ...,
        target_conf: builtins.int = ...,
        sat_per_byte: builtins.int = ...,
        delivery_address: builtins.str = ...,
        sat_per_vbyte: builtins.int = ...,
        max_fee_per_vbyte: builtins.int = ...,
        no_wait: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["channel_point", b"channel_point"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_point", b"channel_point", "delivery_address", b"delivery_address", "force", b"force", "max_fee_per_vbyte", b"max_fee_per_vbyte", "no_wait", b"no_wait", "sat_per_byte", b"sat_per_byte", "sat_per_vbyte", b"sat_per_vbyte", "target_conf", b"target_conf"]) -> None: ...

global___CloseChannelRequest = CloseChannelRequest

@typing.final
class CloseStatusUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLOSE_PENDING_FIELD_NUMBER: builtins.int
    CHAN_CLOSE_FIELD_NUMBER: builtins.int
    CLOSE_INSTANT_FIELD_NUMBER: builtins.int
    @property
    def close_pending(self) -> global___PendingUpdate: ...
    @property
    def chan_close(self) -> global___ChannelCloseUpdate: ...
    @property
    def close_instant(self) -> global___InstantUpdate: ...
    def __init__(
        self,
        *,
        close_pending: global___PendingUpdate | None = ...,
        chan_close: global___ChannelCloseUpdate | None = ...,
        close_instant: global___InstantUpdate | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["chan_close", b"chan_close", "close_instant", b"close_instant", "close_pending", b"close_pending", "update", b"update"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["chan_close", b"chan_close", "close_instant", b"close_instant", "close_pending", b"close_pending", "update", b"update"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["update", b"update"]) -> typing.Literal["close_pending", "chan_close", "close_instant"] | None: ...

global___CloseStatusUpdate = CloseStatusUpdate

@typing.final
class PendingUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TXID_FIELD_NUMBER: builtins.int
    OUTPUT_INDEX_FIELD_NUMBER: builtins.int
    txid: builtins.bytes
    output_index: builtins.int
    def __init__(
        self,
        *,
        txid: builtins.bytes = ...,
        output_index: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["output_index", b"output_index", "txid", b"txid"]) -> None: ...

global___PendingUpdate = PendingUpdate

@typing.final
class InstantUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___InstantUpdate = InstantUpdate

@typing.final
class ReadyForPsbtFunding(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNDING_ADDRESS_FIELD_NUMBER: builtins.int
    FUNDING_AMOUNT_FIELD_NUMBER: builtins.int
    PSBT_FIELD_NUMBER: builtins.int
    funding_address: builtins.str
    """
    The P2WSH address of the channel funding multisig address that the below
    specified amount in satoshis needs to be sent to.
    """
    funding_amount: builtins.int
    """
    The exact amount in satoshis that needs to be sent to the above address to
    fund the pending channel.
    """
    psbt: builtins.bytes
    """
    A raw PSBT that contains the pending channel output. If a base PSBT was
    provided in the PsbtShim, this is the base PSBT with one additional output.
    If no base PSBT was specified, this is an otherwise empty PSBT with exactly
    one output.
    """
    def __init__(
        self,
        *,
        funding_address: builtins.str = ...,
        funding_amount: builtins.int = ...,
        psbt: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["funding_address", b"funding_address", "funding_amount", b"funding_amount", "psbt", b"psbt"]) -> None: ...

global___ReadyForPsbtFunding = ReadyForPsbtFunding

@typing.final
class BatchOpenChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNELS_FIELD_NUMBER: builtins.int
    TARGET_CONF_FIELD_NUMBER: builtins.int
    SAT_PER_VBYTE_FIELD_NUMBER: builtins.int
    MIN_CONFS_FIELD_NUMBER: builtins.int
    SPEND_UNCONFIRMED_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    COIN_SELECTION_STRATEGY_FIELD_NUMBER: builtins.int
    target_conf: builtins.int
    """The target number of blocks that the funding transaction should be
    confirmed by.
    """
    sat_per_vbyte: builtins.int
    """A manual fee rate set in sat/vByte that should be used when crafting the
    funding transaction.
    """
    min_confs: builtins.int
    """The minimum number of confirmations each one of your outputs used for
    the funding transaction must satisfy.
    """
    spend_unconfirmed: builtins.bool
    """Whether unconfirmed outputs should be used as inputs for the funding
    transaction.
    """
    label: builtins.str
    """An optional label for the batch transaction, limited to 500 characters."""
    coin_selection_strategy: global___CoinSelectionStrategy.ValueType
    """The strategy to use for selecting coins during batch opening channels."""
    @property
    def channels(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BatchOpenChannel]:
        """The list of channels to open."""

    def __init__(
        self,
        *,
        channels: collections.abc.Iterable[global___BatchOpenChannel] | None = ...,
        target_conf: builtins.int = ...,
        sat_per_vbyte: builtins.int = ...,
        min_confs: builtins.int = ...,
        spend_unconfirmed: builtins.bool = ...,
        label: builtins.str = ...,
        coin_selection_strategy: global___CoinSelectionStrategy.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channels", b"channels", "coin_selection_strategy", b"coin_selection_strategy", "label", b"label", "min_confs", b"min_confs", "sat_per_vbyte", b"sat_per_vbyte", "spend_unconfirmed", b"spend_unconfirmed", "target_conf", b"target_conf"]) -> None: ...

global___BatchOpenChannelRequest = BatchOpenChannelRequest

@typing.final
class BatchOpenChannel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODE_PUBKEY_FIELD_NUMBER: builtins.int
    LOCAL_FUNDING_AMOUNT_FIELD_NUMBER: builtins.int
    PUSH_SAT_FIELD_NUMBER: builtins.int
    PRIVATE_FIELD_NUMBER: builtins.int
    MIN_HTLC_MSAT_FIELD_NUMBER: builtins.int
    REMOTE_CSV_DELAY_FIELD_NUMBER: builtins.int
    CLOSE_ADDRESS_FIELD_NUMBER: builtins.int
    PENDING_CHAN_ID_FIELD_NUMBER: builtins.int
    COMMITMENT_TYPE_FIELD_NUMBER: builtins.int
    REMOTE_MAX_VALUE_IN_FLIGHT_MSAT_FIELD_NUMBER: builtins.int
    REMOTE_MAX_HTLCS_FIELD_NUMBER: builtins.int
    MAX_LOCAL_CSV_FIELD_NUMBER: builtins.int
    ZERO_CONF_FIELD_NUMBER: builtins.int
    SCID_ALIAS_FIELD_NUMBER: builtins.int
    BASE_FEE_FIELD_NUMBER: builtins.int
    FEE_RATE_FIELD_NUMBER: builtins.int
    USE_BASE_FEE_FIELD_NUMBER: builtins.int
    USE_FEE_RATE_FIELD_NUMBER: builtins.int
    REMOTE_CHAN_RESERVE_SAT_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    node_pubkey: builtins.bytes
    """The pubkey of the node to open a channel with. When using REST, this
    field must be encoded as base64.
    """
    local_funding_amount: builtins.int
    """The number of satoshis the wallet should commit to the channel."""
    push_sat: builtins.int
    """The number of satoshis to push to the remote side as part of the initial
    commitment state.
    """
    private: builtins.bool
    """Whether this channel should be private, not announced to the greater
    network.
    """
    min_htlc_msat: builtins.int
    """The minimum value in millisatoshi we will require for incoming HTLCs on
    the channel.
    """
    remote_csv_delay: builtins.int
    """The delay we require on the remote's commitment transaction. If this is
    not set, it will be scaled automatically with the channel size.
    """
    close_address: builtins.str
    """
    Close address is an optional address which specifies the address to which
    funds should be paid out to upon cooperative close. This field may only be
    set if the peer supports the option upfront feature bit (call listpeers
    to check). The remote peer will only accept cooperative closes to this
    address if it is set.

    Note: If this value is set on channel creation, you will *not* be able to
    cooperatively close out to a different address.
    """
    pending_chan_id: builtins.bytes
    """
    An optional, unique identifier of 32 random bytes that will be used as the
    pending channel ID to identify the channel while it is in the pre-pending
    state.
    """
    commitment_type: global___CommitmentType.ValueType
    """
    The explicit commitment type to use. Note this field will only be used if
    the remote peer supports explicit channel negotiation.
    """
    remote_max_value_in_flight_msat: builtins.int
    """
    The maximum amount of coins in millisatoshi that can be pending within
    the channel. It only applies to the remote party.
    """
    remote_max_htlcs: builtins.int
    """
    The maximum number of concurrent HTLCs we will allow the remote party to add
    to the commitment transaction.
    """
    max_local_csv: builtins.int
    """
    Max local csv is the maximum csv delay we will allow for our own commitment
    transaction.
    """
    zero_conf: builtins.bool
    """
    If this is true, then a zero-conf channel open will be attempted.
    """
    scid_alias: builtins.bool
    """
    If this is true, then an option-scid-alias channel-type open will be
    attempted.
    """
    base_fee: builtins.int
    """
    The base fee charged regardless of the number of milli-satoshis sent.
    """
    fee_rate: builtins.int
    """
    The fee rate in ppm (parts per million) that will be charged in
    proportion of the value of each forwarded HTLC.
    """
    use_base_fee: builtins.bool
    """
    If use_base_fee is true the open channel announcement will update the
    channel base fee with the value specified in base_fee. In the case of
    a base_fee of 0 use_base_fee is needed downstream to distinguish whether
    to use the default base fee value specified in the config or 0.
    """
    use_fee_rate: builtins.bool
    """
    If use_fee_rate is true the open channel announcement will update the
    channel fee rate with the value specified in fee_rate. In the case of
    a fee_rate of 0 use_fee_rate is needed downstream to distinguish whether
    to use the default fee rate value specified in the config or 0.
    """
    remote_chan_reserve_sat: builtins.int
    """
    The number of satoshis we require the remote peer to reserve. This value,
    if specified, must be above the dust limit and below 20% of the channel
    capacity.
    """
    memo: builtins.str
    """
    An optional note-to-self to go along with the channel containing some
    useful information. This is only ever stored locally and in no way impacts
    the channel's operation.
    """
    def __init__(
        self,
        *,
        node_pubkey: builtins.bytes = ...,
        local_funding_amount: builtins.int = ...,
        push_sat: builtins.int = ...,
        private: builtins.bool = ...,
        min_htlc_msat: builtins.int = ...,
        remote_csv_delay: builtins.int = ...,
        close_address: builtins.str = ...,
        pending_chan_id: builtins.bytes = ...,
        commitment_type: global___CommitmentType.ValueType = ...,
        remote_max_value_in_flight_msat: builtins.int = ...,
        remote_max_htlcs: builtins.int = ...,
        max_local_csv: builtins.int = ...,
        zero_conf: builtins.bool = ...,
        scid_alias: builtins.bool = ...,
        base_fee: builtins.int = ...,
        fee_rate: builtins.int = ...,
        use_base_fee: builtins.bool = ...,
        use_fee_rate: builtins.bool = ...,
        remote_chan_reserve_sat: builtins.int = ...,
        memo: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["base_fee", b"base_fee", "close_address", b"close_address", "commitment_type", b"commitment_type", "fee_rate", b"fee_rate", "local_funding_amount", b"local_funding_amount", "max_local_csv", b"max_local_csv", "memo", b"memo", "min_htlc_msat", b"min_htlc_msat", "node_pubkey", b"node_pubkey", "pending_chan_id", b"pending_chan_id", "private", b"private", "push_sat", b"push_sat", "remote_chan_reserve_sat", b"remote_chan_reserve_sat", "remote_csv_delay", b"remote_csv_delay", "remote_max_htlcs", b"remote_max_htlcs", "remote_max_value_in_flight_msat", b"remote_max_value_in_flight_msat", "scid_alias", b"scid_alias", "use_base_fee", b"use_base_fee", "use_fee_rate", b"use_fee_rate", "zero_conf", b"zero_conf"]) -> None: ...

global___BatchOpenChannel = BatchOpenChannel

@typing.final
class BatchOpenChannelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PENDING_CHANNELS_FIELD_NUMBER: builtins.int
    @property
    def pending_channels(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PendingUpdate]: ...
    def __init__(
        self,
        *,
        pending_channels: collections.abc.Iterable[global___PendingUpdate] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pending_channels", b"pending_channels"]) -> None: ...

global___BatchOpenChannelResponse = BatchOpenChannelResponse

@typing.final
class OpenChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SAT_PER_VBYTE_FIELD_NUMBER: builtins.int
    NODE_PUBKEY_FIELD_NUMBER: builtins.int
    NODE_PUBKEY_STRING_FIELD_NUMBER: builtins.int
    LOCAL_FUNDING_AMOUNT_FIELD_NUMBER: builtins.int
    PUSH_SAT_FIELD_NUMBER: builtins.int
    TARGET_CONF_FIELD_NUMBER: builtins.int
    SAT_PER_BYTE_FIELD_NUMBER: builtins.int
    PRIVATE_FIELD_NUMBER: builtins.int
    MIN_HTLC_MSAT_FIELD_NUMBER: builtins.int
    REMOTE_CSV_DELAY_FIELD_NUMBER: builtins.int
    MIN_CONFS_FIELD_NUMBER: builtins.int
    SPEND_UNCONFIRMED_FIELD_NUMBER: builtins.int
    CLOSE_ADDRESS_FIELD_NUMBER: builtins.int
    FUNDING_SHIM_FIELD_NUMBER: builtins.int
    REMOTE_MAX_VALUE_IN_FLIGHT_MSAT_FIELD_NUMBER: builtins.int
    REMOTE_MAX_HTLCS_FIELD_NUMBER: builtins.int
    MAX_LOCAL_CSV_FIELD_NUMBER: builtins.int
    COMMITMENT_TYPE_FIELD_NUMBER: builtins.int
    ZERO_CONF_FIELD_NUMBER: builtins.int
    SCID_ALIAS_FIELD_NUMBER: builtins.int
    BASE_FEE_FIELD_NUMBER: builtins.int
    FEE_RATE_FIELD_NUMBER: builtins.int
    USE_BASE_FEE_FIELD_NUMBER: builtins.int
    USE_FEE_RATE_FIELD_NUMBER: builtins.int
    REMOTE_CHAN_RESERVE_SAT_FIELD_NUMBER: builtins.int
    FUND_MAX_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    OUTPOINTS_FIELD_NUMBER: builtins.int
    sat_per_vbyte: builtins.int
    """A manual fee rate set in sat/vbyte that should be used when crafting the
    funding transaction.
    """
    node_pubkey: builtins.bytes
    """
    The pubkey of the node to open a channel with. When using REST, this field
    must be encoded as base64.
    """
    node_pubkey_string: builtins.str
    """
    The hex encoded pubkey of the node to open a channel with. Deprecated now
    that the REST gateway supports base64 encoding of bytes fields.
    """
    local_funding_amount: builtins.int
    """The number of satoshis the wallet should commit to the channel"""
    push_sat: builtins.int
    """The number of satoshis to push to the remote side as part of the initial
    commitment state
    """
    target_conf: builtins.int
    """The target number of blocks that the funding transaction should be
    confirmed by.
    """
    sat_per_byte: builtins.int
    """Deprecated, use sat_per_vbyte.
    A manual fee rate set in sat/vbyte that should be used when crafting the
    funding transaction.
    """
    private: builtins.bool
    """Whether this channel should be private, not announced to the greater
    network.
    """
    min_htlc_msat: builtins.int
    """The minimum value in millisatoshi we will require for incoming HTLCs on
    the channel.
    """
    remote_csv_delay: builtins.int
    """The delay we require on the remote's commitment transaction. If this is
    not set, it will be scaled automatically with the channel size.
    """
    min_confs: builtins.int
    """The minimum number of confirmations each one of your outputs used for
    the funding transaction must satisfy.
    """
    spend_unconfirmed: builtins.bool
    """Whether unconfirmed outputs should be used as inputs for the funding
    transaction.
    """
    close_address: builtins.str
    """
    Close address is an optional address which specifies the address to which
    funds should be paid out to upon cooperative close. This field may only be
    set if the peer supports the option upfront feature bit (call listpeers
    to check). The remote peer will only accept cooperative closes to this
    address if it is set.

    Note: If this value is set on channel creation, you will *not* be able to
    cooperatively close out to a different address.
    """
    remote_max_value_in_flight_msat: builtins.int
    """
    The maximum amount of coins in millisatoshi that can be pending within
    the channel. It only applies to the remote party.
    """
    remote_max_htlcs: builtins.int
    """
    The maximum number of concurrent HTLCs we will allow the remote party to add
    to the commitment transaction.
    """
    max_local_csv: builtins.int
    """
    Max local csv is the maximum csv delay we will allow for our own commitment
    transaction.
    """
    commitment_type: global___CommitmentType.ValueType
    """
    The explicit commitment type to use. Note this field will only be used if
    the remote peer supports explicit channel negotiation.
    """
    zero_conf: builtins.bool
    """
    If this is true, then a zero-conf channel open will be attempted.
    """
    scid_alias: builtins.bool
    """
    If this is true, then an option-scid-alias channel-type open will be
    attempted.
    """
    base_fee: builtins.int
    """
    The base fee charged regardless of the number of milli-satoshis sent.
    """
    fee_rate: builtins.int
    """
    The fee rate in ppm (parts per million) that will be charged in
    proportion of the value of each forwarded HTLC.
    """
    use_base_fee: builtins.bool
    """
    If use_base_fee is true the open channel announcement will update the
    channel base fee with the value specified in base_fee. In the case of
    a base_fee of 0 use_base_fee is needed downstream to distinguish whether
    to use the default base fee value specified in the config or 0.
    """
    use_fee_rate: builtins.bool
    """
    If use_fee_rate is true the open channel announcement will update the
    channel fee rate with the value specified in fee_rate. In the case of
    a fee_rate of 0 use_fee_rate is needed downstream to distinguish whether
    to use the default fee rate value specified in the config or 0.
    """
    remote_chan_reserve_sat: builtins.int
    """
    The number of satoshis we require the remote peer to reserve. This value,
    if specified, must be above the dust limit and below 20% of the channel
    capacity.
    """
    fund_max: builtins.bool
    """
    If set, then lnd will attempt to commit all the coins under control of the
    internal wallet to open the channel, and the LocalFundingAmount field must
    be zero and is ignored.
    """
    memo: builtins.str
    """
    An optional note-to-self to go along with the channel containing some
    useful information. This is only ever stored locally and in no way impacts
    the channel's operation.
    """
    @property
    def funding_shim(self) -> global___FundingShim:
        """
        Funding shims are an optional argument that allow the caller to intercept
        certain funding functionality. For example, a shim can be provided to use a
        particular key for the commitment key (ideally cold) rather than use one
        that is generated by the wallet as normal, or signal that signing will be
        carried out in an interactive manner (PSBT based).
        """

    @property
    def outpoints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OutPoint]:
        """
        A list of selected outpoints that are allocated for channel funding.
        """

    def __init__(
        self,
        *,
        sat_per_vbyte: builtins.int = ...,
        node_pubkey: builtins.bytes = ...,
        node_pubkey_string: builtins.str = ...,
        local_funding_amount: builtins.int = ...,
        push_sat: builtins.int = ...,
        target_conf: builtins.int = ...,
        sat_per_byte: builtins.int = ...,
        private: builtins.bool = ...,
        min_htlc_msat: builtins.int = ...,
        remote_csv_delay: builtins.int = ...,
        min_confs: builtins.int = ...,
        spend_unconfirmed: builtins.bool = ...,
        close_address: builtins.str = ...,
        funding_shim: global___FundingShim | None = ...,
        remote_max_value_in_flight_msat: builtins.int = ...,
        remote_max_htlcs: builtins.int = ...,
        max_local_csv: builtins.int = ...,
        commitment_type: global___CommitmentType.ValueType = ...,
        zero_conf: builtins.bool = ...,
        scid_alias: builtins.bool = ...,
        base_fee: builtins.int = ...,
        fee_rate: builtins.int = ...,
        use_base_fee: builtins.bool = ...,
        use_fee_rate: builtins.bool = ...,
        remote_chan_reserve_sat: builtins.int = ...,
        fund_max: builtins.bool = ...,
        memo: builtins.str = ...,
        outpoints: collections.abc.Iterable[global___OutPoint] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["funding_shim", b"funding_shim"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["base_fee", b"base_fee", "close_address", b"close_address", "commitment_type", b"commitment_type", "fee_rate", b"fee_rate", "fund_max", b"fund_max", "funding_shim", b"funding_shim", "local_funding_amount", b"local_funding_amount", "max_local_csv", b"max_local_csv", "memo", b"memo", "min_confs", b"min_confs", "min_htlc_msat", b"min_htlc_msat", "node_pubkey", b"node_pubkey", "node_pubkey_string", b"node_pubkey_string", "outpoints", b"outpoints", "private", b"private", "push_sat", b"push_sat", "remote_chan_reserve_sat", b"remote_chan_reserve_sat", "remote_csv_delay", b"remote_csv_delay", "remote_max_htlcs", b"remote_max_htlcs", "remote_max_value_in_flight_msat", b"remote_max_value_in_flight_msat", "sat_per_byte", b"sat_per_byte", "sat_per_vbyte", b"sat_per_vbyte", "scid_alias", b"scid_alias", "spend_unconfirmed", b"spend_unconfirmed", "target_conf", b"target_conf", "use_base_fee", b"use_base_fee", "use_fee_rate", b"use_fee_rate", "zero_conf", b"zero_conf"]) -> None: ...

global___OpenChannelRequest = OpenChannelRequest

@typing.final
class OpenStatusUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_PENDING_FIELD_NUMBER: builtins.int
    CHAN_OPEN_FIELD_NUMBER: builtins.int
    PSBT_FUND_FIELD_NUMBER: builtins.int
    PENDING_CHAN_ID_FIELD_NUMBER: builtins.int
    pending_chan_id: builtins.bytes
    """
    The pending channel ID of the created channel. This value may be used to
    further the funding flow manually via the FundingStateStep method.
    """
    @property
    def chan_pending(self) -> global___PendingUpdate:
        """
        Signals that the channel is now fully negotiated and the funding
        transaction published.
        """

    @property
    def chan_open(self) -> global___ChannelOpenUpdate:
        """
        Signals that the channel's funding transaction has now reached the
        required number of confirmations on chain and can be used.
        """

    @property
    def psbt_fund(self) -> global___ReadyForPsbtFunding:
        """
        Signals that the funding process has been suspended and the construction
        of a PSBT that funds the channel PK script is now required.
        """

    def __init__(
        self,
        *,
        chan_pending: global___PendingUpdate | None = ...,
        chan_open: global___ChannelOpenUpdate | None = ...,
        psbt_fund: global___ReadyForPsbtFunding | None = ...,
        pending_chan_id: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["chan_open", b"chan_open", "chan_pending", b"chan_pending", "psbt_fund", b"psbt_fund", "update", b"update"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["chan_open", b"chan_open", "chan_pending", b"chan_pending", "pending_chan_id", b"pending_chan_id", "psbt_fund", b"psbt_fund", "update", b"update"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["update", b"update"]) -> typing.Literal["chan_pending", "chan_open", "psbt_fund"] | None: ...

global___OpenStatusUpdate = OpenStatusUpdate

@typing.final
class KeyLocator(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FAMILY_FIELD_NUMBER: builtins.int
    KEY_INDEX_FIELD_NUMBER: builtins.int
    key_family: builtins.int
    """The family of key being identified."""
    key_index: builtins.int
    """The precise index of the key being identified."""
    def __init__(
        self,
        *,
        key_family: builtins.int = ...,
        key_index: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key_family", b"key_family", "key_index", b"key_index"]) -> None: ...

global___KeyLocator = KeyLocator

@typing.final
class KeyDescriptor(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RAW_KEY_BYTES_FIELD_NUMBER: builtins.int
    KEY_LOC_FIELD_NUMBER: builtins.int
    raw_key_bytes: builtins.bytes
    """
    The raw bytes of the key being identified.
    """
    @property
    def key_loc(self) -> global___KeyLocator:
        """
        The key locator that identifies which key to use for signing.
        """

    def __init__(
        self,
        *,
        raw_key_bytes: builtins.bytes = ...,
        key_loc: global___KeyLocator | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["key_loc", b"key_loc"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["key_loc", b"key_loc", "raw_key_bytes", b"raw_key_bytes"]) -> None: ...

global___KeyDescriptor = KeyDescriptor

@typing.final
class ChanPointShim(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AMT_FIELD_NUMBER: builtins.int
    CHAN_POINT_FIELD_NUMBER: builtins.int
    LOCAL_KEY_FIELD_NUMBER: builtins.int
    REMOTE_KEY_FIELD_NUMBER: builtins.int
    PENDING_CHAN_ID_FIELD_NUMBER: builtins.int
    THAW_HEIGHT_FIELD_NUMBER: builtins.int
    MUSIG2_FIELD_NUMBER: builtins.int
    amt: builtins.int
    """
    The size of the pre-crafted output to be used as the channel point for this
    channel funding.
    """
    remote_key: builtins.bytes
    """The key of the remote party to use when creating the multi-sig output."""
    pending_chan_id: builtins.bytes
    """
    If non-zero, then this will be used as the pending channel ID on the wire
    protocol to initate the funding request. This is an optional field, and
    should only be set if the responder is already expecting a specific pending
    channel ID.
    """
    thaw_height: builtins.int
    """
    This uint32 indicates if this channel is to be considered 'frozen'. A frozen
    channel does not allow a cooperative channel close by the initiator. The
    thaw_height is the height that this restriction stops applying to the
    channel. The height can be interpreted in two ways: as a relative height if
    the value is less than 500,000, or as an absolute height otherwise.
    """
    musig2: builtins.bool
    """
    Indicates that the funding output is using a MuSig2 multi-sig output.
    """
    @property
    def chan_point(self) -> global___ChannelPoint:
        """The target channel point to refrence in created commitment transactions."""

    @property
    def local_key(self) -> global___KeyDescriptor:
        """Our local key to use when creating the multi-sig output."""

    def __init__(
        self,
        *,
        amt: builtins.int = ...,
        chan_point: global___ChannelPoint | None = ...,
        local_key: global___KeyDescriptor | None = ...,
        remote_key: builtins.bytes = ...,
        pending_chan_id: builtins.bytes = ...,
        thaw_height: builtins.int = ...,
        musig2: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["chan_point", b"chan_point", "local_key", b"local_key"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["amt", b"amt", "chan_point", b"chan_point", "local_key", b"local_key", "musig2", b"musig2", "pending_chan_id", b"pending_chan_id", "remote_key", b"remote_key", "thaw_height", b"thaw_height"]) -> None: ...

global___ChanPointShim = ChanPointShim

@typing.final
class PsbtShim(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PENDING_CHAN_ID_FIELD_NUMBER: builtins.int
    BASE_PSBT_FIELD_NUMBER: builtins.int
    NO_PUBLISH_FIELD_NUMBER: builtins.int
    pending_chan_id: builtins.bytes
    """
    A unique identifier of 32 random bytes that will be used as the pending
    channel ID to identify the PSBT state machine when interacting with it and
    on the wire protocol to initiate the funding request.
    """
    base_psbt: builtins.bytes
    """
    An optional base PSBT the new channel output will be added to. If this is
    non-empty, it must be a binary serialized PSBT.
    """
    no_publish: builtins.bool
    """
    If a channel should be part of a batch (multiple channel openings in one
    transaction), it can be dangerous if the whole batch transaction is
    published too early before all channel opening negotiations are completed.
    This flag prevents this particular channel from broadcasting the transaction
    after the negotiation with the remote peer. In a batch of channel openings
    this flag should be set to true for every channel but the very last.
    """
    def __init__(
        self,
        *,
        pending_chan_id: builtins.bytes = ...,
        base_psbt: builtins.bytes = ...,
        no_publish: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["base_psbt", b"base_psbt", "no_publish", b"no_publish", "pending_chan_id", b"pending_chan_id"]) -> None: ...

global___PsbtShim = PsbtShim

@typing.final
class FundingShim(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_POINT_SHIM_FIELD_NUMBER: builtins.int
    PSBT_SHIM_FIELD_NUMBER: builtins.int
    @property
    def chan_point_shim(self) -> global___ChanPointShim:
        """
        A channel shim where the channel point was fully constructed outside
        of lnd's wallet and the transaction might already be published.
        """

    @property
    def psbt_shim(self) -> global___PsbtShim:
        """
        A channel shim that uses a PSBT to fund and sign the channel funding
        transaction.
        """

    def __init__(
        self,
        *,
        chan_point_shim: global___ChanPointShim | None = ...,
        psbt_shim: global___PsbtShim | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["chan_point_shim", b"chan_point_shim", "psbt_shim", b"psbt_shim", "shim", b"shim"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["chan_point_shim", b"chan_point_shim", "psbt_shim", b"psbt_shim", "shim", b"shim"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["shim", b"shim"]) -> typing.Literal["chan_point_shim", "psbt_shim"] | None: ...

global___FundingShim = FundingShim

@typing.final
class FundingShimCancel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PENDING_CHAN_ID_FIELD_NUMBER: builtins.int
    pending_chan_id: builtins.bytes
    """The pending channel ID of the channel to cancel the funding shim for."""
    def __init__(
        self,
        *,
        pending_chan_id: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pending_chan_id", b"pending_chan_id"]) -> None: ...

global___FundingShimCancel = FundingShimCancel

@typing.final
class FundingPsbtVerify(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNDED_PSBT_FIELD_NUMBER: builtins.int
    PENDING_CHAN_ID_FIELD_NUMBER: builtins.int
    SKIP_FINALIZE_FIELD_NUMBER: builtins.int
    funded_psbt: builtins.bytes
    """
    The funded but not yet signed PSBT that sends the exact channel capacity
    amount to the PK script returned in the open channel message in a previous
    step.
    """
    pending_chan_id: builtins.bytes
    """The pending channel ID of the channel to get the PSBT for."""
    skip_finalize: builtins.bool
    """
    Can only be used if the no_publish flag was set to true in the OpenChannel
    call meaning that the caller is solely responsible for publishing the final
    funding transaction. If skip_finalize is set to true then lnd will not wait
    for a FundingPsbtFinalize state step and instead assumes that a transaction
    with the same TXID as the passed in PSBT will eventually confirm.
    IT IS ABSOLUTELY IMPERATIVE that the TXID of the transaction that is
    eventually published does have the _same TXID_ as the verified PSBT. That
    means no inputs or outputs can change, only signatures can be added. If the
    TXID changes between this call and the publish step then the channel will
    never be created and the funds will be in limbo.
    """
    def __init__(
        self,
        *,
        funded_psbt: builtins.bytes = ...,
        pending_chan_id: builtins.bytes = ...,
        skip_finalize: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["funded_psbt", b"funded_psbt", "pending_chan_id", b"pending_chan_id", "skip_finalize", b"skip_finalize"]) -> None: ...

global___FundingPsbtVerify = FundingPsbtVerify

@typing.final
class FundingPsbtFinalize(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNED_PSBT_FIELD_NUMBER: builtins.int
    PENDING_CHAN_ID_FIELD_NUMBER: builtins.int
    FINAL_RAW_TX_FIELD_NUMBER: builtins.int
    signed_psbt: builtins.bytes
    """
    The funded PSBT that contains all witness data to send the exact channel
    capacity amount to the PK script returned in the open channel message in a
    previous step. Cannot be set at the same time as final_raw_tx.
    """
    pending_chan_id: builtins.bytes
    """The pending channel ID of the channel to get the PSBT for."""
    final_raw_tx: builtins.bytes
    """
    As an alternative to the signed PSBT with all witness data, the final raw
    wire format transaction can also be specified directly. Cannot be set at the
    same time as signed_psbt.
    """
    def __init__(
        self,
        *,
        signed_psbt: builtins.bytes = ...,
        pending_chan_id: builtins.bytes = ...,
        final_raw_tx: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["final_raw_tx", b"final_raw_tx", "pending_chan_id", b"pending_chan_id", "signed_psbt", b"signed_psbt"]) -> None: ...

global___FundingPsbtFinalize = FundingPsbtFinalize

@typing.final
class FundingTransitionMsg(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SHIM_REGISTER_FIELD_NUMBER: builtins.int
    SHIM_CANCEL_FIELD_NUMBER: builtins.int
    PSBT_VERIFY_FIELD_NUMBER: builtins.int
    PSBT_FINALIZE_FIELD_NUMBER: builtins.int
    @property
    def shim_register(self) -> global___FundingShim:
        """
        The funding shim to register. This should be used before any
        channel funding has began by the remote party, as it is intended as a
        preparatory step for the full channel funding.
        """

    @property
    def shim_cancel(self) -> global___FundingShimCancel:
        """Used to cancel an existing registered funding shim."""

    @property
    def psbt_verify(self) -> global___FundingPsbtVerify:
        """
        Used to continue a funding flow that was initiated to be executed
        through a PSBT. This step verifies that the PSBT contains the correct
        outputs to fund the channel.
        """

    @property
    def psbt_finalize(self) -> global___FundingPsbtFinalize:
        """
        Used to continue a funding flow that was initiated to be executed
        through a PSBT. This step finalizes the funded and signed PSBT, finishes
        negotiation with the peer and finally publishes the resulting funding
        transaction.
        """

    def __init__(
        self,
        *,
        shim_register: global___FundingShim | None = ...,
        shim_cancel: global___FundingShimCancel | None = ...,
        psbt_verify: global___FundingPsbtVerify | None = ...,
        psbt_finalize: global___FundingPsbtFinalize | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["psbt_finalize", b"psbt_finalize", "psbt_verify", b"psbt_verify", "shim_cancel", b"shim_cancel", "shim_register", b"shim_register", "trigger", b"trigger"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["psbt_finalize", b"psbt_finalize", "psbt_verify", b"psbt_verify", "shim_cancel", b"shim_cancel", "shim_register", b"shim_register", "trigger", b"trigger"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["trigger", b"trigger"]) -> typing.Literal["shim_register", "shim_cancel", "psbt_verify", "psbt_finalize"] | None: ...

global___FundingTransitionMsg = FundingTransitionMsg

@typing.final
class FundingStateStepResp(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___FundingStateStepResp = FundingStateStepResp

@typing.final
class PendingHTLC(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INCOMING_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    OUTPOINT_FIELD_NUMBER: builtins.int
    MATURITY_HEIGHT_FIELD_NUMBER: builtins.int
    BLOCKS_TIL_MATURITY_FIELD_NUMBER: builtins.int
    STAGE_FIELD_NUMBER: builtins.int
    incoming: builtins.bool
    """The direction within the channel that the htlc was sent"""
    amount: builtins.int
    """The total value of the htlc"""
    outpoint: builtins.str
    """The final output to be swept back to the user's wallet"""
    maturity_height: builtins.int
    """The next block height at which we can spend the current stage"""
    blocks_til_maturity: builtins.int
    """
    The number of blocks remaining until the current stage can be swept.
    Negative values indicate how many blocks have passed since becoming
    mature.
    """
    stage: builtins.int
    """Indicates whether the htlc is in its first or second stage of recovery"""
    def __init__(
        self,
        *,
        incoming: builtins.bool = ...,
        amount: builtins.int = ...,
        outpoint: builtins.str = ...,
        maturity_height: builtins.int = ...,
        blocks_til_maturity: builtins.int = ...,
        stage: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["amount", b"amount", "blocks_til_maturity", b"blocks_til_maturity", "incoming", b"incoming", "maturity_height", b"maturity_height", "outpoint", b"outpoint", "stage", b"stage"]) -> None: ...

global___PendingHTLC = PendingHTLC

@typing.final
class PendingChannelsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INCLUDE_RAW_TX_FIELD_NUMBER: builtins.int
    include_raw_tx: builtins.bool
    """Indicates whether to include the raw transaction hex for
    waiting_close_channels.
    """
    def __init__(
        self,
        *,
        include_raw_tx: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["include_raw_tx", b"include_raw_tx"]) -> None: ...

global___PendingChannelsRequest = PendingChannelsRequest

@typing.final
class PendingChannelsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class PendingChannel(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        REMOTE_NODE_PUB_FIELD_NUMBER: builtins.int
        CHANNEL_POINT_FIELD_NUMBER: builtins.int
        CAPACITY_FIELD_NUMBER: builtins.int
        LOCAL_BALANCE_FIELD_NUMBER: builtins.int
        REMOTE_BALANCE_FIELD_NUMBER: builtins.int
        LOCAL_CHAN_RESERVE_SAT_FIELD_NUMBER: builtins.int
        REMOTE_CHAN_RESERVE_SAT_FIELD_NUMBER: builtins.int
        INITIATOR_FIELD_NUMBER: builtins.int
        COMMITMENT_TYPE_FIELD_NUMBER: builtins.int
        NUM_FORWARDING_PACKAGES_FIELD_NUMBER: builtins.int
        CHAN_STATUS_FLAGS_FIELD_NUMBER: builtins.int
        PRIVATE_FIELD_NUMBER: builtins.int
        MEMO_FIELD_NUMBER: builtins.int
        remote_node_pub: builtins.str
        channel_point: builtins.str
        capacity: builtins.int
        local_balance: builtins.int
        remote_balance: builtins.int
        local_chan_reserve_sat: builtins.int
        """The minimum satoshis this node is required to reserve in its
        balance.
        """
        remote_chan_reserve_sat: builtins.int
        """
        The minimum satoshis the other node is required to reserve in its
        balance.
        """
        initiator: global___Initiator.ValueType
        """The party that initiated opening the channel."""
        commitment_type: global___CommitmentType.ValueType
        """The commitment type used by this channel."""
        num_forwarding_packages: builtins.int
        """Total number of forwarding packages created in this channel."""
        chan_status_flags: builtins.str
        """A set of flags showing the current state of the channel."""
        private: builtins.bool
        """Whether this channel is advertised to the network or not."""
        memo: builtins.str
        """
        An optional note-to-self to go along with the channel containing some
        useful information. This is only ever stored locally and in no way
        impacts the channel's operation.
        """
        def __init__(
            self,
            *,
            remote_node_pub: builtins.str = ...,
            channel_point: builtins.str = ...,
            capacity: builtins.int = ...,
            local_balance: builtins.int = ...,
            remote_balance: builtins.int = ...,
            local_chan_reserve_sat: builtins.int = ...,
            remote_chan_reserve_sat: builtins.int = ...,
            initiator: global___Initiator.ValueType = ...,
            commitment_type: global___CommitmentType.ValueType = ...,
            num_forwarding_packages: builtins.int = ...,
            chan_status_flags: builtins.str = ...,
            private: builtins.bool = ...,
            memo: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["capacity", b"capacity", "chan_status_flags", b"chan_status_flags", "channel_point", b"channel_point", "commitment_type", b"commitment_type", "initiator", b"initiator", "local_balance", b"local_balance", "local_chan_reserve_sat", b"local_chan_reserve_sat", "memo", b"memo", "num_forwarding_packages", b"num_forwarding_packages", "private", b"private", "remote_balance", b"remote_balance", "remote_chan_reserve_sat", b"remote_chan_reserve_sat", "remote_node_pub", b"remote_node_pub"]) -> None: ...

    @typing.final
    class PendingOpenChannel(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CHANNEL_FIELD_NUMBER: builtins.int
        COMMIT_FEE_FIELD_NUMBER: builtins.int
        COMMIT_WEIGHT_FIELD_NUMBER: builtins.int
        FEE_PER_KW_FIELD_NUMBER: builtins.int
        FUNDING_EXPIRY_BLOCKS_FIELD_NUMBER: builtins.int
        commit_fee: builtins.int
        """
        The amount calculated to be paid in fees for the current set of
        commitment transactions. The fee amount is persisted with the channel
        in order to allow the fee amount to be removed and recalculated with
        each channel state update, including updates that happen after a system
        restart.
        """
        commit_weight: builtins.int
        """The weight of the commitment transaction"""
        fee_per_kw: builtins.int
        """
        The required number of satoshis per kilo-weight that the requester will
        pay at all times, for both the funding transaction and commitment
        transaction. This value can later be updated once the channel is open.
        """
        funding_expiry_blocks: builtins.int
        """The number of blocks until the funding transaction is considered
        expired. If this value gets close to zero, there is a risk that the
        channel funding will be canceled by the channel responder. The
        channel should be fee bumped using CPFP (see walletrpc.BumpFee) to
        ensure that the channel confirms in time. Otherwise a force-close
        will be necessary if the channel confirms after the funding
        transaction expires. A negative value means the channel responder has
        very likely canceled the funding and the channel will never become
        fully operational.
        """
        @property
        def channel(self) -> global___PendingChannelsResponse.PendingChannel:
            """The pending channel"""

        def __init__(
            self,
            *,
            channel: global___PendingChannelsResponse.PendingChannel | None = ...,
            commit_fee: builtins.int = ...,
            commit_weight: builtins.int = ...,
            fee_per_kw: builtins.int = ...,
            funding_expiry_blocks: builtins.int = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["channel", b"channel"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["channel", b"channel", "commit_fee", b"commit_fee", "commit_weight", b"commit_weight", "fee_per_kw", b"fee_per_kw", "funding_expiry_blocks", b"funding_expiry_blocks"]) -> None: ...

    @typing.final
    class WaitingCloseChannel(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CHANNEL_FIELD_NUMBER: builtins.int
        LIMBO_BALANCE_FIELD_NUMBER: builtins.int
        COMMITMENTS_FIELD_NUMBER: builtins.int
        CLOSING_TXID_FIELD_NUMBER: builtins.int
        CLOSING_TX_HEX_FIELD_NUMBER: builtins.int
        limbo_balance: builtins.int
        """The balance in satoshis encumbered in this channel"""
        closing_txid: builtins.str
        """The transaction id of the closing transaction"""
        closing_tx_hex: builtins.str
        """The raw hex encoded bytes of the closing transaction. Included if
        include_raw_tx in the request is true.
        """
        @property
        def channel(self) -> global___PendingChannelsResponse.PendingChannel:
            """The pending channel waiting for closing tx to confirm"""

        @property
        def commitments(self) -> global___PendingChannelsResponse.Commitments:
            """
            A list of valid commitment transactions. Any of these can confirm at
            this point.
            """

        def __init__(
            self,
            *,
            channel: global___PendingChannelsResponse.PendingChannel | None = ...,
            limbo_balance: builtins.int = ...,
            commitments: global___PendingChannelsResponse.Commitments | None = ...,
            closing_txid: builtins.str = ...,
            closing_tx_hex: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["channel", b"channel", "commitments", b"commitments"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["channel", b"channel", "closing_tx_hex", b"closing_tx_hex", "closing_txid", b"closing_txid", "commitments", b"commitments", "limbo_balance", b"limbo_balance"]) -> None: ...

    @typing.final
    class Commitments(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LOCAL_TXID_FIELD_NUMBER: builtins.int
        REMOTE_TXID_FIELD_NUMBER: builtins.int
        REMOTE_PENDING_TXID_FIELD_NUMBER: builtins.int
        LOCAL_COMMIT_FEE_SAT_FIELD_NUMBER: builtins.int
        REMOTE_COMMIT_FEE_SAT_FIELD_NUMBER: builtins.int
        REMOTE_PENDING_COMMIT_FEE_SAT_FIELD_NUMBER: builtins.int
        local_txid: builtins.str
        """Hash of the local version of the commitment tx."""
        remote_txid: builtins.str
        """Hash of the remote version of the commitment tx."""
        remote_pending_txid: builtins.str
        """Hash of the remote pending version of the commitment tx."""
        local_commit_fee_sat: builtins.int
        """
        The amount in satoshis calculated to be paid in fees for the local
        commitment.
        """
        remote_commit_fee_sat: builtins.int
        """
        The amount in satoshis calculated to be paid in fees for the remote
        commitment.
        """
        remote_pending_commit_fee_sat: builtins.int
        """
        The amount in satoshis calculated to be paid in fees for the remote
        pending commitment.
        """
        def __init__(
            self,
            *,
            local_txid: builtins.str = ...,
            remote_txid: builtins.str = ...,
            remote_pending_txid: builtins.str = ...,
            local_commit_fee_sat: builtins.int = ...,
            remote_commit_fee_sat: builtins.int = ...,
            remote_pending_commit_fee_sat: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["local_commit_fee_sat", b"local_commit_fee_sat", "local_txid", b"local_txid", "remote_commit_fee_sat", b"remote_commit_fee_sat", "remote_pending_commit_fee_sat", b"remote_pending_commit_fee_sat", "remote_pending_txid", b"remote_pending_txid", "remote_txid", b"remote_txid"]) -> None: ...

    @typing.final
    class ClosedChannel(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CHANNEL_FIELD_NUMBER: builtins.int
        CLOSING_TXID_FIELD_NUMBER: builtins.int
        closing_txid: builtins.str
        """The transaction id of the closing transaction"""
        @property
        def channel(self) -> global___PendingChannelsResponse.PendingChannel:
            """The pending channel to be closed"""

        def __init__(
            self,
            *,
            channel: global___PendingChannelsResponse.PendingChannel | None = ...,
            closing_txid: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["channel", b"channel"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["channel", b"channel", "closing_txid", b"closing_txid"]) -> None: ...

    @typing.final
    class ForceClosedChannel(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _AnchorState:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _AnchorStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PendingChannelsResponse.ForceClosedChannel._AnchorState.ValueType], builtins.type):   # noqa: F821
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            LIMBO: PendingChannelsResponse.ForceClosedChannel._AnchorState.ValueType  # 0
            """The recovered_balance is zero and limbo_balance is non-zero."""
            RECOVERED: PendingChannelsResponse.ForceClosedChannel._AnchorState.ValueType  # 1
            """The recovered_balance is non-zero."""
            LOST: PendingChannelsResponse.ForceClosedChannel._AnchorState.ValueType  # 2
            """A state that is neither LIMBO nor RECOVERED."""

        class AnchorState(_AnchorState, metaclass=_AnchorStateEnumTypeWrapper):
            """
            There are three resolution states for the anchor:
            limbo, lost and recovered. Derive the current state
            from the limbo and recovered balances.
            """

        LIMBO: PendingChannelsResponse.ForceClosedChannel.AnchorState.ValueType  # 0
        """The recovered_balance is zero and limbo_balance is non-zero."""
        RECOVERED: PendingChannelsResponse.ForceClosedChannel.AnchorState.ValueType  # 1
        """The recovered_balance is non-zero."""
        LOST: PendingChannelsResponse.ForceClosedChannel.AnchorState.ValueType  # 2
        """A state that is neither LIMBO nor RECOVERED."""

        CHANNEL_FIELD_NUMBER: builtins.int
        CLOSING_TXID_FIELD_NUMBER: builtins.int
        LIMBO_BALANCE_FIELD_NUMBER: builtins.int
        MATURITY_HEIGHT_FIELD_NUMBER: builtins.int
        BLOCKS_TIL_MATURITY_FIELD_NUMBER: builtins.int
        RECOVERED_BALANCE_FIELD_NUMBER: builtins.int
        PENDING_HTLCS_FIELD_NUMBER: builtins.int
        ANCHOR_FIELD_NUMBER: builtins.int
        closing_txid: builtins.str
        """The transaction id of the closing transaction"""
        limbo_balance: builtins.int
        """The balance in satoshis encumbered in this pending channel"""
        maturity_height: builtins.int
        """The height at which funds can be swept into the wallet"""
        blocks_til_maturity: builtins.int
        """
        Remaining # of blocks until the commitment output can be swept.
        Negative values indicate how many blocks have passed since becoming
        mature.
        """
        recovered_balance: builtins.int
        """The total value of funds successfully recovered from this channel"""
        anchor: global___PendingChannelsResponse.ForceClosedChannel.AnchorState.ValueType
        @property
        def channel(self) -> global___PendingChannelsResponse.PendingChannel:
            """The pending channel to be force closed"""

        @property
        def pending_htlcs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PendingHTLC]: ...
        def __init__(
            self,
            *,
            channel: global___PendingChannelsResponse.PendingChannel | None = ...,
            closing_txid: builtins.str = ...,
            limbo_balance: builtins.int = ...,
            maturity_height: builtins.int = ...,
            blocks_til_maturity: builtins.int = ...,
            recovered_balance: builtins.int = ...,
            pending_htlcs: collections.abc.Iterable[global___PendingHTLC] | None = ...,
            anchor: global___PendingChannelsResponse.ForceClosedChannel.AnchorState.ValueType = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["channel", b"channel"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["anchor", b"anchor", "blocks_til_maturity", b"blocks_til_maturity", "channel", b"channel", "closing_txid", b"closing_txid", "limbo_balance", b"limbo_balance", "maturity_height", b"maturity_height", "pending_htlcs", b"pending_htlcs", "recovered_balance", b"recovered_balance"]) -> None: ...

    TOTAL_LIMBO_BALANCE_FIELD_NUMBER: builtins.int
    PENDING_OPEN_CHANNELS_FIELD_NUMBER: builtins.int
    PENDING_CLOSING_CHANNELS_FIELD_NUMBER: builtins.int
    PENDING_FORCE_CLOSING_CHANNELS_FIELD_NUMBER: builtins.int
    WAITING_CLOSE_CHANNELS_FIELD_NUMBER: builtins.int
    total_limbo_balance: builtins.int
    """The balance in satoshis encumbered in pending channels"""
    @property
    def pending_open_channels(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PendingChannelsResponse.PendingOpenChannel]:
        """Channels pending opening"""

    @property
    def pending_closing_channels(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PendingChannelsResponse.ClosedChannel]:
        """
        Deprecated: Channels pending closing previously contained cooperatively
        closed channels with a single confirmation. These channels are now
        considered closed from the time we see them on chain.
        """

    @property
    def pending_force_closing_channels(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PendingChannelsResponse.ForceClosedChannel]:
        """Channels pending force closing"""

    @property
    def waiting_close_channels(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PendingChannelsResponse.WaitingCloseChannel]:
        """Channels waiting for closing tx to confirm"""

    def __init__(
        self,
        *,
        total_limbo_balance: builtins.int = ...,
        pending_open_channels: collections.abc.Iterable[global___PendingChannelsResponse.PendingOpenChannel] | None = ...,
        pending_closing_channels: collections.abc.Iterable[global___PendingChannelsResponse.ClosedChannel] | None = ...,
        pending_force_closing_channels: collections.abc.Iterable[global___PendingChannelsResponse.ForceClosedChannel] | None = ...,
        waiting_close_channels: collections.abc.Iterable[global___PendingChannelsResponse.WaitingCloseChannel] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pending_closing_channels", b"pending_closing_channels", "pending_force_closing_channels", b"pending_force_closing_channels", "pending_open_channels", b"pending_open_channels", "total_limbo_balance", b"total_limbo_balance", "waiting_close_channels", b"waiting_close_channels"]) -> None: ...

global___PendingChannelsResponse = PendingChannelsResponse

@typing.final
class ChannelEventSubscription(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ChannelEventSubscription = ChannelEventSubscription

@typing.final
class ChannelEventUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _UpdateType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _UpdateTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ChannelEventUpdate._UpdateType.ValueType], builtins.type): # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OPEN_CHANNEL: ChannelEventUpdate._UpdateType.ValueType  # 0
        CLOSED_CHANNEL: ChannelEventUpdate._UpdateType.ValueType  # 1
        ACTIVE_CHANNEL: ChannelEventUpdate._UpdateType.ValueType  # 2
        INACTIVE_CHANNEL: ChannelEventUpdate._UpdateType.ValueType  # 3
        PENDING_OPEN_CHANNEL: ChannelEventUpdate._UpdateType.ValueType  # 4
        FULLY_RESOLVED_CHANNEL: ChannelEventUpdate._UpdateType.ValueType  # 5

    class UpdateType(_UpdateType, metaclass=_UpdateTypeEnumTypeWrapper): ...
    OPEN_CHANNEL: ChannelEventUpdate.UpdateType.ValueType  # 0
    CLOSED_CHANNEL: ChannelEventUpdate.UpdateType.ValueType  # 1
    ACTIVE_CHANNEL: ChannelEventUpdate.UpdateType.ValueType  # 2
    INACTIVE_CHANNEL: ChannelEventUpdate.UpdateType.ValueType  # 3
    PENDING_OPEN_CHANNEL: ChannelEventUpdate.UpdateType.ValueType  # 4
    FULLY_RESOLVED_CHANNEL: ChannelEventUpdate.UpdateType.ValueType  # 5

    OPEN_CHANNEL_FIELD_NUMBER: builtins.int
    CLOSED_CHANNEL_FIELD_NUMBER: builtins.int
    ACTIVE_CHANNEL_FIELD_NUMBER: builtins.int
    INACTIVE_CHANNEL_FIELD_NUMBER: builtins.int
    PENDING_OPEN_CHANNEL_FIELD_NUMBER: builtins.int
    FULLY_RESOLVED_CHANNEL_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    type: global___ChannelEventUpdate.UpdateType.ValueType
    @property
    def open_channel(self) -> global___Channel: ...
    @property
    def closed_channel(self) -> global___ChannelCloseSummary: ...
    @property
    def active_channel(self) -> global___ChannelPoint: ...
    @property
    def inactive_channel(self) -> global___ChannelPoint: ...
    @property
    def pending_open_channel(self) -> global___PendingUpdate: ...
    @property
    def fully_resolved_channel(self) -> global___ChannelPoint: ...
    def __init__(
        self,
        *,
        open_channel: global___Channel | None = ...,
        closed_channel: global___ChannelCloseSummary | None = ...,
        active_channel: global___ChannelPoint | None = ...,
        inactive_channel: global___ChannelPoint | None = ...,
        pending_open_channel: global___PendingUpdate | None = ...,
        fully_resolved_channel: global___ChannelPoint | None = ...,
        type: global___ChannelEventUpdate.UpdateType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["active_channel", b"active_channel", "channel", b"channel", "closed_channel", b"closed_channel", "fully_resolved_channel", b"fully_resolved_channel", "inactive_channel", b"inactive_channel", "open_channel", b"open_channel", "pending_open_channel", b"pending_open_channel"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active_channel", b"active_channel", "channel", b"channel", "closed_channel", b"closed_channel", "fully_resolved_channel", b"fully_resolved_channel", "inactive_channel", b"inactive_channel", "open_channel", b"open_channel", "pending_open_channel", b"pending_open_channel", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["channel", b"channel"]) -> typing.Literal["open_channel", "closed_channel", "active_channel", "inactive_channel", "pending_open_channel", "fully_resolved_channel"] | None: ...

global___ChannelEventUpdate = ChannelEventUpdate

@typing.final
class WalletAccountBalance(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIRMED_BALANCE_FIELD_NUMBER: builtins.int
    UNCONFIRMED_BALANCE_FIELD_NUMBER: builtins.int
    confirmed_balance: builtins.int
    """The confirmed balance of the account (with >= 1 confirmations)."""
    unconfirmed_balance: builtins.int
    """The unconfirmed balance of the account (with 0 confirmations)."""
    def __init__(
        self,
        *,
        confirmed_balance: builtins.int = ...,
        unconfirmed_balance: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["confirmed_balance", b"confirmed_balance", "unconfirmed_balance", b"unconfirmed_balance"]) -> None: ...

global___WalletAccountBalance = WalletAccountBalance

@typing.final
class WalletBalanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    MIN_CONFS_FIELD_NUMBER: builtins.int
    account: builtins.str
    """The wallet account the balance is shown for.
    If this is not specified, the balance of the "default" account is shown.
    """
    min_confs: builtins.int
    """The minimum number of confirmations each one of your outputs used for the
    funding transaction must satisfy. If this is not specified, the default
    value of 1 is used.
    """
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        min_confs: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["account", b"account", "min_confs", b"min_confs"]) -> None: ...

global___WalletBalanceRequest = WalletBalanceRequest

@typing.final
class WalletBalanceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AccountBalanceEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___WalletAccountBalance: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___WalletAccountBalance | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TOTAL_BALANCE_FIELD_NUMBER: builtins.int
    CONFIRMED_BALANCE_FIELD_NUMBER: builtins.int
    UNCONFIRMED_BALANCE_FIELD_NUMBER: builtins.int
    LOCKED_BALANCE_FIELD_NUMBER: builtins.int
    RESERVED_BALANCE_ANCHOR_CHAN_FIELD_NUMBER: builtins.int
    ACCOUNT_BALANCE_FIELD_NUMBER: builtins.int
    total_balance: builtins.int
    """The balance of the wallet"""
    confirmed_balance: builtins.int
    """The confirmed balance of a wallet(with >= 1 confirmations)"""
    unconfirmed_balance: builtins.int
    """The unconfirmed balance of a wallet(with 0 confirmations)"""
    locked_balance: builtins.int
    """The total amount of wallet UTXOs held in outputs that are locked for
    other usage.
    """
    reserved_balance_anchor_chan: builtins.int
    """The amount of reserve required."""
    @property
    def account_balance(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___WalletAccountBalance]:
        """A mapping of each wallet account's name to its balance."""

    def __init__(
        self,
        *,
        total_balance: builtins.int = ...,
        confirmed_balance: builtins.int = ...,
        unconfirmed_balance: builtins.int = ...,
        locked_balance: builtins.int = ...,
        reserved_balance_anchor_chan: builtins.int = ...,
        account_balance: collections.abc.Mapping[builtins.str, global___WalletAccountBalance] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["account_balance", b"account_balance", "confirmed_balance", b"confirmed_balance", "locked_balance", b"locked_balance", "reserved_balance_anchor_chan", b"reserved_balance_anchor_chan", "total_balance", b"total_balance", "unconfirmed_balance", b"unconfirmed_balance"]) -> None: ...

global___WalletBalanceResponse = WalletBalanceResponse

@typing.final
class Amount(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SAT_FIELD_NUMBER: builtins.int
    MSAT_FIELD_NUMBER: builtins.int
    sat: builtins.int
    """Value denominated in satoshis."""
    msat: builtins.int
    """Value denominated in milli-satoshis."""
    def __init__(
        self,
        *,
        sat: builtins.int = ...,
        msat: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["msat", b"msat", "sat", b"sat"]) -> None: ...

global___Amount = Amount

@typing.final
class ChannelBalanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ChannelBalanceRequest = ChannelBalanceRequest

@typing.final
class ChannelBalanceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BALANCE_FIELD_NUMBER: builtins.int
    PENDING_OPEN_BALANCE_FIELD_NUMBER: builtins.int
    LOCAL_BALANCE_FIELD_NUMBER: builtins.int
    REMOTE_BALANCE_FIELD_NUMBER: builtins.int
    UNSETTLED_LOCAL_BALANCE_FIELD_NUMBER: builtins.int
    UNSETTLED_REMOTE_BALANCE_FIELD_NUMBER: builtins.int
    PENDING_OPEN_LOCAL_BALANCE_FIELD_NUMBER: builtins.int
    PENDING_OPEN_REMOTE_BALANCE_FIELD_NUMBER: builtins.int
    balance: builtins.int
    """Deprecated. Sum of channels balances denominated in satoshis"""
    pending_open_balance: builtins.int
    """Deprecated. Sum of channels pending balances denominated in satoshis"""
    @property
    def local_balance(self) -> global___Amount:
        """Sum of channels local balances."""

    @property
    def remote_balance(self) -> global___Amount:
        """Sum of channels remote balances."""

    @property
    def unsettled_local_balance(self) -> global___Amount:
        """Sum of channels local unsettled balances."""

    @property
    def unsettled_remote_balance(self) -> global___Amount:
        """Sum of channels remote unsettled balances."""

    @property
    def pending_open_local_balance(self) -> global___Amount:
        """Sum of channels pending local balances."""

    @property
    def pending_open_remote_balance(self) -> global___Amount:
        """Sum of channels pending remote balances."""

    def __init__(
        self,
        *,
        balance: builtins.int = ...,
        pending_open_balance: builtins.int = ...,
        local_balance: global___Amount | None = ...,
        remote_balance: global___Amount | None = ...,
        unsettled_local_balance: global___Amount | None = ...,
        unsettled_remote_balance: global___Amount | None = ...,
        pending_open_local_balance: global___Amount | None = ...,
        pending_open_remote_balance: global___Amount | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["local_balance", b"local_balance", "pending_open_local_balance", b"pending_open_local_balance", "pending_open_remote_balance", b"pending_open_remote_balance", "remote_balance", b"remote_balance", "unsettled_local_balance", b"unsettled_local_balance", "unsettled_remote_balance", b"unsettled_remote_balance"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["balance", b"balance", "local_balance", b"local_balance", "pending_open_balance", b"pending_open_balance", "pending_open_local_balance", b"pending_open_local_balance", "pending_open_remote_balance", b"pending_open_remote_balance", "remote_balance", b"remote_balance", "unsettled_local_balance", b"unsettled_local_balance", "unsettled_remote_balance", b"unsettled_remote_balance"]) -> None: ...

global___ChannelBalanceResponse = ChannelBalanceResponse

@typing.final
class QueryRoutesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DestCustomRecordsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    PUB_KEY_FIELD_NUMBER: builtins.int
    AMT_FIELD_NUMBER: builtins.int
    AMT_MSAT_FIELD_NUMBER: builtins.int
    FINAL_CLTV_DELTA_FIELD_NUMBER: builtins.int
    FEE_LIMIT_FIELD_NUMBER: builtins.int
    IGNORED_NODES_FIELD_NUMBER: builtins.int
    IGNORED_EDGES_FIELD_NUMBER: builtins.int
    SOURCE_PUB_KEY_FIELD_NUMBER: builtins.int
    USE_MISSION_CONTROL_FIELD_NUMBER: builtins.int
    IGNORED_PAIRS_FIELD_NUMBER: builtins.int
    CLTV_LIMIT_FIELD_NUMBER: builtins.int
    DEST_CUSTOM_RECORDS_FIELD_NUMBER: builtins.int
    OUTGOING_CHAN_ID_FIELD_NUMBER: builtins.int
    LAST_HOP_PUBKEY_FIELD_NUMBER: builtins.int
    ROUTE_HINTS_FIELD_NUMBER: builtins.int
    BLINDED_PAYMENT_PATHS_FIELD_NUMBER: builtins.int
    DEST_FEATURES_FIELD_NUMBER: builtins.int
    TIME_PREF_FIELD_NUMBER: builtins.int
    pub_key: builtins.str
    """The 33-byte hex-encoded public key for the payment destination"""
    amt: builtins.int
    """
    The amount to send expressed in satoshis.

    The fields amt and amt_msat are mutually exclusive.
    """
    amt_msat: builtins.int
    """
    The amount to send expressed in millisatoshis.

    The fields amt and amt_msat are mutually exclusive.
    """
    final_cltv_delta: builtins.int
    """
    An optional CLTV delta from the current height that should be used for the
    timelock of the final hop. Note that unlike SendPayment, QueryRoutes does
    not add any additional block padding on top of final_ctlv_delta. This
    padding of a few blocks needs to be added manually or otherwise failures may
    happen when a block comes in while the payment is in flight.

    Note: must not be set if making a payment to a blinded path (delta is
    set by the aggregate parameters provided by blinded_payment_paths)
    """
    source_pub_key: builtins.str
    """
    The source node where the request route should originated from. If empty,
    self is assumed.
    """
    use_mission_control: builtins.bool
    """
    If set to true, edge probabilities from mission control will be used to get
    the optimal route.
    """
    cltv_limit: builtins.int
    """
    An optional maximum total time lock for the route. If the source is empty or
    ourselves, this should not exceed lnd's `--max-cltv-expiry` setting. If
    zero, then the value of `--max-cltv-expiry` is used as the limit.
    """
    outgoing_chan_id: builtins.int
    """
    The channel id of the channel that must be taken to the first hop. If zero,
    any channel may be used.
    """
    last_hop_pubkey: builtins.bytes
    """
    The pubkey of the last hop of the route. If empty, any hop may be used.
    """
    time_pref: builtins.float
    """
    The time preference for this payment. Set to -1 to optimize for fees
    only, to 1 to optimize for reliability only or a value inbetween for a mix.
    """
    @property
    def fee_limit(self) -> global___FeeLimit:
        """
        The maximum number of satoshis that will be paid as a fee of the payment.
        This value can be represented either as a percentage of the amount being
        sent, or as a fixed amount of the maximum fee the user is willing the pay to
        send the payment. If not specified, lnd will use a default value of 100%
        fees for small amounts (<=1k sat) or 5% fees for larger amounts.
        """

    @property
    def ignored_nodes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]:
        """
        A list of nodes to ignore during path finding. When using REST, these fields
        must be encoded as base64.
        """

    @property
    def ignored_edges(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EdgeLocator]:
        """
        Deprecated. A list of edges to ignore during path finding.
        """

    @property
    def ignored_pairs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NodePair]:
        """
        A list of directed node pairs that will be ignored during path finding.
        """

    @property
    def dest_custom_records(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.bytes]:
        """
        An optional field that can be used to pass an arbitrary set of TLV records
        to a peer which understands the new records. This can be used to pass
        application specific data during the payment attempt. If the destination
        does not support the specified records, an error will be returned.
        Record types are required to be in the custom range >= 65536. When using
        REST, the values must be encoded as base64.
        """

    @property
    def route_hints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RouteHint]:
        """
        Optional route hints to reach the destination through private channels.
        """

    @property
    def blinded_payment_paths(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BlindedPaymentPath]:
        """
        An optional blinded path(s) to reach the destination. Note that the
        introduction node must be provided as the first hop in the route.
        """

    @property
    def dest_features(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___FeatureBit.ValueType]:
        """
        Features assumed to be supported by the final node. All transitive feature
        dependencies must also be set properly. For a given feature bit pair, either
        optional or remote may be set, but not both. If this field is nil or empty,
        the router will try to load destination features from the graph as a
        fallback.

        Note: must not be set if making a payment to a blinded route (features
        are provided in blinded_payment_paths).
        """

    def __init__(
        self,
        *,
        pub_key: builtins.str = ...,
        amt: builtins.int = ...,
        amt_msat: builtins.int = ...,
        final_cltv_delta: builtins.int = ...,
        fee_limit: global___FeeLimit | None = ...,
        ignored_nodes: collections.abc.Iterable[builtins.bytes] | None = ...,
        ignored_edges: collections.abc.Iterable[global___EdgeLocator] | None = ...,
        source_pub_key: builtins.str = ...,
        use_mission_control: builtins.bool = ...,
        ignored_pairs: collections.abc.Iterable[global___NodePair] | None = ...,
        cltv_limit: builtins.int = ...,
        dest_custom_records: collections.abc.Mapping[builtins.int, builtins.bytes] | None = ...,
        outgoing_chan_id: builtins.int = ...,
        last_hop_pubkey: builtins.bytes = ...,
        route_hints: collections.abc.Iterable[global___RouteHint] | None = ...,
        blinded_payment_paths: collections.abc.Iterable[global___BlindedPaymentPath] | None = ...,
        dest_features: collections.abc.Iterable[global___FeatureBit.ValueType] | None = ...,
        time_pref: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["fee_limit", b"fee_limit"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["amt", b"amt", "amt_msat", b"amt_msat", "blinded_payment_paths", b"blinded_payment_paths", "cltv_limit", b"cltv_limit", "dest_custom_records", b"dest_custom_records", "dest_features", b"dest_features", "fee_limit", b"fee_limit", "final_cltv_delta", b"final_cltv_delta", "ignored_edges", b"ignored_edges", "ignored_nodes", b"ignored_nodes", "ignored_pairs", b"ignored_pairs", "last_hop_pubkey", b"last_hop_pubkey", "outgoing_chan_id", b"outgoing_chan_id", "pub_key", b"pub_key", "route_hints", b"route_hints", "source_pub_key", b"source_pub_key", "time_pref", b"time_pref", "use_mission_control", b"use_mission_control"]) -> None: ...

global___QueryRoutesRequest = QueryRoutesRequest

@typing.final
class NodePair(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    to: builtins.bytes
    """
    The receiving node of the pair. When using REST, this field must be encoded
    as base64.
    """
    def __init__(
        self,
        *,
        to: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["from", b"from", "to", b"to"]) -> None: ...

global___NodePair = NodePair

@typing.final
class EdgeLocator(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    DIRECTION_REVERSE_FIELD_NUMBER: builtins.int
    channel_id: builtins.int
    """The short channel id of this edge."""
    direction_reverse: builtins.bool
    """
    The direction of this edge. If direction_reverse is false, the direction
    of this edge is from the channel endpoint with the lexicographically smaller
    pub key to the endpoint with the larger pub key. If direction_reverse is
    is true, the edge goes the other way.
    """
    def __init__(
        self,
        *,
        channel_id: builtins.int = ...,
        direction_reverse: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "direction_reverse", b"direction_reverse"]) -> None: ...

global___EdgeLocator = EdgeLocator

@typing.final
class QueryRoutesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTES_FIELD_NUMBER: builtins.int
    SUCCESS_PROB_FIELD_NUMBER: builtins.int
    success_prob: builtins.float
    """
    The success probability of the returned route based on the current mission
    control state. [EXPERIMENTAL]
    """
    @property
    def routes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Route]:
        """
        The route that results from the path finding operation. This is still a
        repeated field to retain backwards compatibility.
        """

    def __init__(
        self,
        *,
        routes: collections.abc.Iterable[global___Route] | None = ...,
        success_prob: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["routes", b"routes", "success_prob", b"success_prob"]) -> None: ...

global___QueryRoutesResponse = QueryRoutesResponse

@typing.final
class Hop(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class CustomRecordsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CHAN_ID_FIELD_NUMBER: builtins.int
    CHAN_CAPACITY_FIELD_NUMBER: builtins.int
    AMT_TO_FORWARD_FIELD_NUMBER: builtins.int
    FEE_FIELD_NUMBER: builtins.int
    EXPIRY_FIELD_NUMBER: builtins.int
    AMT_TO_FORWARD_MSAT_FIELD_NUMBER: builtins.int
    FEE_MSAT_FIELD_NUMBER: builtins.int
    PUB_KEY_FIELD_NUMBER: builtins.int
    TLV_PAYLOAD_FIELD_NUMBER: builtins.int
    MPP_RECORD_FIELD_NUMBER: builtins.int
    AMP_RECORD_FIELD_NUMBER: builtins.int
    CUSTOM_RECORDS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    BLINDING_POINT_FIELD_NUMBER: builtins.int
    ENCRYPTED_DATA_FIELD_NUMBER: builtins.int
    TOTAL_AMT_MSAT_FIELD_NUMBER: builtins.int
    chan_id: builtins.int
    """
    The unique channel ID for the channel. The first 3 bytes are the block
    height, the next 3 the index within the block, and the last 2 bytes are the
    output index for the channel.
    """
    chan_capacity: builtins.int
    amt_to_forward: builtins.int
    fee: builtins.int
    expiry: builtins.int
    amt_to_forward_msat: builtins.int
    fee_msat: builtins.int
    pub_key: builtins.str
    """
    An optional public key of the hop. If the public key is given, the payment
    can be executed without relying on a copy of the channel graph.
    """
    tlv_payload: builtins.bool
    """
    If set to true, then this hop will be encoded using the new variable length
    TLV format. Note that if any custom tlv_records below are specified, then
    this field MUST be set to true for them to be encoded properly.
    """
    metadata: builtins.bytes
    """The payment metadata to send along with the payment to the payee."""
    blinding_point: builtins.bytes
    """
    Blinding point is an optional blinding point included for introduction
    nodes in blinded paths. This field is mandatory for hops that represents
    the introduction point in a blinded path.
    """
    encrypted_data: builtins.bytes
    """
    Encrypted data is a receiver-produced blob of data that provides hops
    in a blinded route with forwarding data. As this data is encrypted by
    the recipient, we will not be able to parse it - it is essentially an
    arbitrary blob of data from our node's perspective. This field is
    mandatory for all hops in a blinded path, including the introduction
    node.
    """
    total_amt_msat: builtins.int
    """
    The total amount that is sent to the recipient (possibly across multiple
    HTLCs), as specified by the sender when making a payment to a blinded path.
    This value is only set in the final hop payload of a blinded payment. This
    value is analogous to the MPPRecord that is used for regular (non-blinded)
    MPP payments.
    """
    @property
    def mpp_record(self) -> global___MPPRecord:
        """
        An optional TLV record that signals the use of an MPP payment. If present,
        the receiver will enforce that the same mpp_record is included in the final
        hop payload of all non-zero payments in the HTLC set. If empty, a regular
        single-shot payment is or was attempted.
        """

    @property
    def amp_record(self) -> global___AMPRecord:
        """
        An optional TLV record that signals the use of an AMP payment. If present,
        the receiver will treat all received payments including the same
        (payment_addr, set_id) pair  as being part of one logical payment. The
        payment will be settled by XORing the root_share's together and deriving the
        child hashes and preimages according to BOLT XX. Must be used in conjunction
        with mpp_record.
        """

    @property
    def custom_records(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.bytes]:
        """
        An optional set of key-value TLV records. This is useful within the context
        of the SendToRoute call as it allows callers to specify arbitrary K-V pairs
        to drop off at each hop within the onion.
        """

    def __init__(
        self,
        *,
        chan_id: builtins.int = ...,
        chan_capacity: builtins.int = ...,
        amt_to_forward: builtins.int = ...,
        fee: builtins.int = ...,
        expiry: builtins.int = ...,
        amt_to_forward_msat: builtins.int = ...,
        fee_msat: builtins.int = ...,
        pub_key: builtins.str = ...,
        tlv_payload: builtins.bool = ...,
        mpp_record: global___MPPRecord | None = ...,
        amp_record: global___AMPRecord | None = ...,
        custom_records: collections.abc.Mapping[builtins.int, builtins.bytes] | None = ...,
        metadata: builtins.bytes = ...,
        blinding_point: builtins.bytes = ...,
        encrypted_data: builtins.bytes = ...,
        total_amt_msat: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["amp_record", b"amp_record", "mpp_record", b"mpp_record"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["amp_record", b"amp_record", "amt_to_forward", b"amt_to_forward", "amt_to_forward_msat", b"amt_to_forward_msat", "blinding_point", b"blinding_point", "chan_capacity", b"chan_capacity", "chan_id", b"chan_id", "custom_records", b"custom_records", "encrypted_data", b"encrypted_data", "expiry", b"expiry", "fee", b"fee", "fee_msat", b"fee_msat", "metadata", b"metadata", "mpp_record", b"mpp_record", "pub_key", b"pub_key", "tlv_payload", b"tlv_payload", "total_amt_msat", b"total_amt_msat"]) -> None: ...

global___Hop = Hop

@typing.final
class MPPRecord(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYMENT_ADDR_FIELD_NUMBER: builtins.int
    TOTAL_AMT_MSAT_FIELD_NUMBER: builtins.int
    payment_addr: builtins.bytes
    """
    A unique, random identifier used to authenticate the sender as the intended
    payer of a multi-path payment. The payment_addr must be the same for all
    subpayments, and match the payment_addr provided in the receiver's invoice.
    The same payment_addr must be used on all subpayments. This is also called
    payment secret in specifications (e.g. BOLT 11).
    """
    total_amt_msat: builtins.int
    """
    The total amount in milli-satoshis being sent as part of a larger multi-path
    payment. The caller is responsible for ensuring subpayments to the same node
    and payment_hash sum exactly to total_amt_msat. The same
    total_amt_msat must be used on all subpayments.
    """
    def __init__(
        self,
        *,
        payment_addr: builtins.bytes = ...,
        total_amt_msat: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["payment_addr", b"payment_addr", "total_amt_msat", b"total_amt_msat"]) -> None: ...

global___MPPRecord = MPPRecord

@typing.final
class AMPRecord(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROOT_SHARE_FIELD_NUMBER: builtins.int
    SET_ID_FIELD_NUMBER: builtins.int
    CHILD_INDEX_FIELD_NUMBER: builtins.int
    root_share: builtins.bytes
    set_id: builtins.bytes
    child_index: builtins.int
    def __init__(
        self,
        *,
        root_share: builtins.bytes = ...,
        set_id: builtins.bytes = ...,
        child_index: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["child_index", b"child_index", "root_share", b"root_share", "set_id", b"set_id"]) -> None: ...

global___AMPRecord = AMPRecord

@typing.final
class Route(google.protobuf.message.Message):
    """
    A path through the channel graph which runs over one or more channels in
    succession. This struct carries all the information required to craft the
    Sphinx onion packet, and send the payment along the first hop in the path. A
    route is only selected as valid if all the channels have sufficient capacity to
    carry the initial payment amount after fees are accounted for.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOTAL_TIME_LOCK_FIELD_NUMBER: builtins.int
    TOTAL_FEES_FIELD_NUMBER: builtins.int
    TOTAL_AMT_FIELD_NUMBER: builtins.int
    HOPS_FIELD_NUMBER: builtins.int
    TOTAL_FEES_MSAT_FIELD_NUMBER: builtins.int
    TOTAL_AMT_MSAT_FIELD_NUMBER: builtins.int
    total_time_lock: builtins.int
    """
    The cumulative (final) time lock across the entire route. This is the CLTV
    value that should be extended to the first hop in the route. All other hops
    will decrement the time-lock as advertised, leaving enough time for all
    hops to wait for or present the payment preimage to complete the payment.
    """
    total_fees: builtins.int
    """
    The sum of the fees paid at each hop within the final route. In the case
    of a one-hop payment, this value will be zero as we don't need to pay a fee
    to ourselves.
    """
    total_amt: builtins.int
    """
    The total amount of funds required to complete a payment over this route.
    This value includes the cumulative fees at each hop. As a result, the HTLC
    extended to the first-hop in the route will need to have at least this many
    satoshis, otherwise the route will fail at an intermediate node due to an
    insufficient amount of fees.
    """
    total_fees_msat: builtins.int
    """
    The total fees in millisatoshis.
    """
    total_amt_msat: builtins.int
    """
    The total amount in millisatoshis.
    """
    @property
    def hops(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Hop]:
        """
        Contains details concerning the specific forwarding details at each hop.
        """

    def __init__(
        self,
        *,
        total_time_lock: builtins.int = ...,
        total_fees: builtins.int = ...,
        total_amt: builtins.int = ...,
        hops: collections.abc.Iterable[global___Hop] | None = ...,
        total_fees_msat: builtins.int = ...,
        total_amt_msat: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hops", b"hops", "total_amt", b"total_amt", "total_amt_msat", b"total_amt_msat", "total_fees", b"total_fees", "total_fees_msat", b"total_fees_msat", "total_time_lock", b"total_time_lock"]) -> None: ...

global___Route = Route

@typing.final
class NodeInfoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PUB_KEY_FIELD_NUMBER: builtins.int
    INCLUDE_CHANNELS_FIELD_NUMBER: builtins.int
    pub_key: builtins.str
    """The 33-byte hex-encoded compressed public of the target node"""
    include_channels: builtins.bool
    """If true, will include all known channels associated with the node."""
    def __init__(
        self,
        *,
        pub_key: builtins.str = ...,
        include_channels: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["include_channels", b"include_channels", "pub_key", b"pub_key"]) -> None: ...

global___NodeInfoRequest = NodeInfoRequest

@typing.final
class NodeInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODE_FIELD_NUMBER: builtins.int
    NUM_CHANNELS_FIELD_NUMBER: builtins.int
    TOTAL_CAPACITY_FIELD_NUMBER: builtins.int
    CHANNELS_FIELD_NUMBER: builtins.int
    num_channels: builtins.int
    """The total number of channels for the node."""
    total_capacity: builtins.int
    """The sum of all channels capacity for the node, denominated in satoshis."""
    @property
    def node(self) -> global___LightningNode:
        """
        An individual vertex/node within the channel graph. A node is
        connected to other nodes by one or more channel edges emanating from it. As
        the graph is directed, a node will also have an incoming edge attached to
        it for each outgoing edge.
        """

    @property
    def channels(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelEdge]:
        """A list of all public channels for the node."""

    def __init__(
        self,
        *,
        node: global___LightningNode | None = ...,
        num_channels: builtins.int = ...,
        total_capacity: builtins.int = ...,
        channels: collections.abc.Iterable[global___ChannelEdge] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["node", b"node"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channels", b"channels", "node", b"node", "num_channels", b"num_channels", "total_capacity", b"total_capacity"]) -> None: ...

global___NodeInfo = NodeInfo

@typing.final
class LightningNode(google.protobuf.message.Message):
    """
    An individual vertex/node within the channel graph. A node is
    connected to other nodes by one or more channel edges emanating from it. As the
    graph is directed, a node will also have an incoming edge attached to it for
    each outgoing edge.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class FeaturesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> global___Feature: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: global___Feature | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class CustomRecordsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    LAST_UPDATE_FIELD_NUMBER: builtins.int
    PUB_KEY_FIELD_NUMBER: builtins.int
    ALIAS_FIELD_NUMBER: builtins.int
    ADDRESSES_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    CUSTOM_RECORDS_FIELD_NUMBER: builtins.int
    last_update: builtins.int
    pub_key: builtins.str
    alias: builtins.str
    color: builtins.str
    @property
    def addresses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NodeAddress]: ...
    @property
    def features(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, global___Feature]: ...
    @property
    def custom_records(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.bytes]:
        """Custom node announcement tlv records."""

    def __init__(
        self,
        *,
        last_update: builtins.int = ...,
        pub_key: builtins.str = ...,
        alias: builtins.str = ...,
        addresses: collections.abc.Iterable[global___NodeAddress] | None = ...,
        color: builtins.str = ...,
        features: collections.abc.Mapping[builtins.int, global___Feature] | None = ...,
        custom_records: collections.abc.Mapping[builtins.int, builtins.bytes] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["addresses", b"addresses", "alias", b"alias", "color", b"color", "custom_records", b"custom_records", "features", b"features", "last_update", b"last_update", "pub_key", b"pub_key"]) -> None: ...

global___LightningNode = LightningNode

@typing.final
class NodeAddress(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_FIELD_NUMBER: builtins.int
    ADDR_FIELD_NUMBER: builtins.int
    network: builtins.str
    addr: builtins.str
    def __init__(
        self,
        *,
        network: builtins.str = ...,
        addr: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["addr", b"addr", "network", b"network"]) -> None: ...

global___NodeAddress = NodeAddress

@typing.final
class RoutingPolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class CustomRecordsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TIME_LOCK_DELTA_FIELD_NUMBER: builtins.int
    MIN_HTLC_FIELD_NUMBER: builtins.int
    FEE_BASE_MSAT_FIELD_NUMBER: builtins.int
    FEE_RATE_MILLI_MSAT_FIELD_NUMBER: builtins.int
    DISABLED_FIELD_NUMBER: builtins.int
    MAX_HTLC_MSAT_FIELD_NUMBER: builtins.int
    LAST_UPDATE_FIELD_NUMBER: builtins.int
    CUSTOM_RECORDS_FIELD_NUMBER: builtins.int
    INBOUND_FEE_BASE_MSAT_FIELD_NUMBER: builtins.int
    INBOUND_FEE_RATE_MILLI_MSAT_FIELD_NUMBER: builtins.int
    time_lock_delta: builtins.int
    min_htlc: builtins.int
    fee_base_msat: builtins.int
    fee_rate_milli_msat: builtins.int
    disabled: builtins.bool
    max_htlc_msat: builtins.int
    last_update: builtins.int
    inbound_fee_base_msat: builtins.int
    inbound_fee_rate_milli_msat: builtins.int
    @property
    def custom_records(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.bytes]:
        """Custom channel update tlv records."""

    def __init__(
        self,
        *,
        time_lock_delta: builtins.int = ...,
        min_htlc: builtins.int = ...,
        fee_base_msat: builtins.int = ...,
        fee_rate_milli_msat: builtins.int = ...,
        disabled: builtins.bool = ...,
        max_htlc_msat: builtins.int = ...,
        last_update: builtins.int = ...,
        custom_records: collections.abc.Mapping[builtins.int, builtins.bytes] | None = ...,
        inbound_fee_base_msat: builtins.int = ...,
        inbound_fee_rate_milli_msat: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["custom_records", b"custom_records", "disabled", b"disabled", "fee_base_msat", b"fee_base_msat", "fee_rate_milli_msat", b"fee_rate_milli_msat", "inbound_fee_base_msat", b"inbound_fee_base_msat", "inbound_fee_rate_milli_msat", b"inbound_fee_rate_milli_msat", "last_update", b"last_update", "max_htlc_msat", b"max_htlc_msat", "min_htlc", b"min_htlc", "time_lock_delta", b"time_lock_delta"]) -> None: ...

global___RoutingPolicy = RoutingPolicy

@typing.final
class ChannelEdge(google.protobuf.message.Message):
    """
    A fully authenticated channel along with all its unique attributes.
    Once an authenticated channel announcement has been processed on the network,
    then an instance of ChannelEdgeInfo encapsulating the channels attributes is
    stored. The other portions relevant to routing policy of a channel are stored
    within a ChannelEdgePolicy for each direction of the channel.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class CustomRecordsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHAN_POINT_FIELD_NUMBER: builtins.int
    LAST_UPDATE_FIELD_NUMBER: builtins.int
    NODE1_PUB_FIELD_NUMBER: builtins.int
    NODE2_PUB_FIELD_NUMBER: builtins.int
    CAPACITY_FIELD_NUMBER: builtins.int
    NODE1_POLICY_FIELD_NUMBER: builtins.int
    NODE2_POLICY_FIELD_NUMBER: builtins.int
    CUSTOM_RECORDS_FIELD_NUMBER: builtins.int
    channel_id: builtins.int
    """
    The unique channel ID for the channel. The first 3 bytes are the block
    height, the next 3 the index within the block, and the last 2 bytes are the
    output index for the channel.
    """
    chan_point: builtins.str
    last_update: builtins.int
    node1_pub: builtins.str
    node2_pub: builtins.str
    capacity: builtins.int
    @property
    def node1_policy(self) -> global___RoutingPolicy: ...
    @property
    def node2_policy(self) -> global___RoutingPolicy: ...
    @property
    def custom_records(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.bytes]:
        """Custom channel announcement tlv records."""

    def __init__(
        self,
        *,
        channel_id: builtins.int = ...,
        chan_point: builtins.str = ...,
        last_update: builtins.int = ...,
        node1_pub: builtins.str = ...,
        node2_pub: builtins.str = ...,
        capacity: builtins.int = ...,
        node1_policy: global___RoutingPolicy | None = ...,
        node2_policy: global___RoutingPolicy | None = ...,
        custom_records: collections.abc.Mapping[builtins.int, builtins.bytes] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["node1_policy", b"node1_policy", "node2_policy", b"node2_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["capacity", b"capacity", "chan_point", b"chan_point", "channel_id", b"channel_id", "custom_records", b"custom_records", "last_update", b"last_update", "node1_policy", b"node1_policy", "node1_pub", b"node1_pub", "node2_policy", b"node2_policy", "node2_pub", b"node2_pub"]) -> None: ...

global___ChannelEdge = ChannelEdge

@typing.final
class ChannelGraphRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INCLUDE_UNANNOUNCED_FIELD_NUMBER: builtins.int
    include_unannounced: builtins.bool
    """
    Whether unannounced channels are included in the response or not. If set,
    unannounced channels are included. Unannounced channels are both private
    channels, and public channels that are not yet announced to the network.
    """
    def __init__(
        self,
        *,
        include_unannounced: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["include_unannounced", b"include_unannounced"]) -> None: ...

global___ChannelGraphRequest = ChannelGraphRequest

@typing.final
class ChannelGraph(google.protobuf.message.Message):
    """Returns a new instance of the directed channel graph."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODES_FIELD_NUMBER: builtins.int
    EDGES_FIELD_NUMBER: builtins.int
    @property
    def nodes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LightningNode]:
        """The list of `LightningNode`s in this channel graph"""

    @property
    def edges(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelEdge]:
        """The list of `ChannelEdge`s in this channel graph"""

    def __init__(
        self,
        *,
        nodes: collections.abc.Iterable[global___LightningNode] | None = ...,
        edges: collections.abc.Iterable[global___ChannelEdge] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["edges", b"edges", "nodes", b"nodes"]) -> None: ...

global___ChannelGraph = ChannelGraph

@typing.final
class NodeMetricsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPES_FIELD_NUMBER: builtins.int
    @property
    def types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___NodeMetricType.ValueType]:
        """The requested node metrics."""

    def __init__(
        self,
        *,
        types: collections.abc.Iterable[global___NodeMetricType.ValueType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["types", b"types"]) -> None: ...

global___NodeMetricsRequest = NodeMetricsRequest

@typing.final
class NodeMetricsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class BetweennessCentralityEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___FloatMetric: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___FloatMetric | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    BETWEENNESS_CENTRALITY_FIELD_NUMBER: builtins.int
    @property
    def betweenness_centrality(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___FloatMetric]:
        """
        Betweenness centrality is the sum of the ratio of shortest paths that pass
        through the node for each pair of nodes in the graph (not counting paths
        starting or ending at this node).
        Map of node pubkey to betweenness centrality of the node. Normalized
        values are in the [0,1] closed interval.
        """

    def __init__(
        self,
        *,
        betweenness_centrality: collections.abc.Mapping[builtins.str, global___FloatMetric] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["betweenness_centrality", b"betweenness_centrality"]) -> None: ...

global___NodeMetricsResponse = NodeMetricsResponse

@typing.final
class FloatMetric(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    NORMALIZED_VALUE_FIELD_NUMBER: builtins.int
    value: builtins.float
    """Arbitrary float value."""
    normalized_value: builtins.float
    """The value normalized to [0,1] or [-1,1]."""
    def __init__(
        self,
        *,
        value: builtins.float = ...,
        normalized_value: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["normalized_value", b"normalized_value", "value", b"value"]) -> None: ...

global___FloatMetric = FloatMetric

@typing.final
class ChanInfoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_ID_FIELD_NUMBER: builtins.int
    CHAN_POINT_FIELD_NUMBER: builtins.int
    chan_id: builtins.int
    """
    The unique channel ID for the channel. The first 3 bytes are the block
    height, the next 3 the index within the block, and the last 2 bytes are the
    output index for the channel.
    """
    chan_point: builtins.str
    """The channel point of the channel in format funding_txid:output_index. If
    chan_id is specified, this field is ignored.
    """
    def __init__(
        self,
        *,
        chan_id: builtins.int = ...,
        chan_point: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["chan_id", b"chan_id", "chan_point", b"chan_point"]) -> None: ...

global___ChanInfoRequest = ChanInfoRequest

@typing.final
class NetworkInfoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___NetworkInfoRequest = NetworkInfoRequest

@typing.final
class NetworkInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GRAPH_DIAMETER_FIELD_NUMBER: builtins.int
    AVG_OUT_DEGREE_FIELD_NUMBER: builtins.int
    MAX_OUT_DEGREE_FIELD_NUMBER: builtins.int
    NUM_NODES_FIELD_NUMBER: builtins.int
    NUM_CHANNELS_FIELD_NUMBER: builtins.int
    TOTAL_NETWORK_CAPACITY_FIELD_NUMBER: builtins.int
    AVG_CHANNEL_SIZE_FIELD_NUMBER: builtins.int
    MIN_CHANNEL_SIZE_FIELD_NUMBER: builtins.int
    MAX_CHANNEL_SIZE_FIELD_NUMBER: builtins.int
    MEDIAN_CHANNEL_SIZE_SAT_FIELD_NUMBER: builtins.int
    NUM_ZOMBIE_CHANS_FIELD_NUMBER: builtins.int
    graph_diameter: builtins.int
    avg_out_degree: builtins.float
    max_out_degree: builtins.int
    num_nodes: builtins.int
    num_channels: builtins.int
    total_network_capacity: builtins.int
    avg_channel_size: builtins.float
    min_channel_size: builtins.int
    max_channel_size: builtins.int
    median_channel_size_sat: builtins.int
    num_zombie_chans: builtins.int
    """The number of edges marked as zombies."""
    def __init__(
        self,
        *,
        graph_diameter: builtins.int = ...,
        avg_out_degree: builtins.float = ...,
        max_out_degree: builtins.int = ...,
        num_nodes: builtins.int = ...,
        num_channels: builtins.int = ...,
        total_network_capacity: builtins.int = ...,
        avg_channel_size: builtins.float = ...,
        min_channel_size: builtins.int = ...,
        max_channel_size: builtins.int = ...,
        median_channel_size_sat: builtins.int = ...,
        num_zombie_chans: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avg_channel_size", b"avg_channel_size", "avg_out_degree", b"avg_out_degree", "graph_diameter", b"graph_diameter", "max_channel_size", b"max_channel_size", "max_out_degree", b"max_out_degree", "median_channel_size_sat", b"median_channel_size_sat", "min_channel_size", b"min_channel_size", "num_channels", b"num_channels", "num_nodes", b"num_nodes", "num_zombie_chans", b"num_zombie_chans", "total_network_capacity", b"total_network_capacity"]) -> None: ...

global___NetworkInfo = NetworkInfo

@typing.final
class StopRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StopRequest = StopRequest

@typing.final
class StopResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StopResponse = StopResponse

@typing.final
class GraphTopologySubscription(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GraphTopologySubscription = GraphTopologySubscription

@typing.final
class GraphTopologyUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODE_UPDATES_FIELD_NUMBER: builtins.int
    CHANNEL_UPDATES_FIELD_NUMBER: builtins.int
    CLOSED_CHANS_FIELD_NUMBER: builtins.int
    @property
    def node_updates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NodeUpdate]: ...
    @property
    def channel_updates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelEdgeUpdate]: ...
    @property
    def closed_chans(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ClosedChannelUpdate]: ...
    def __init__(
        self,
        *,
        node_updates: collections.abc.Iterable[global___NodeUpdate] | None = ...,
        channel_updates: collections.abc.Iterable[global___ChannelEdgeUpdate] | None = ...,
        closed_chans: collections.abc.Iterable[global___ClosedChannelUpdate] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_updates", b"channel_updates", "closed_chans", b"closed_chans", "node_updates", b"node_updates"]) -> None: ...

global___GraphTopologyUpdate = GraphTopologyUpdate

@typing.final
class NodeUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class FeaturesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> global___Feature: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: global___Feature | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ADDRESSES_FIELD_NUMBER: builtins.int
    IDENTITY_KEY_FIELD_NUMBER: builtins.int
    GLOBAL_FEATURES_FIELD_NUMBER: builtins.int
    ALIAS_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    NODE_ADDRESSES_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    identity_key: builtins.str
    global_features: builtins.bytes
    """
    Deprecated, use features.
    """
    alias: builtins.str
    color: builtins.str
    @property
    def addresses(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """
        Deprecated, use node_addresses.
        """

    @property
    def node_addresses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NodeAddress]: ...
    @property
    def features(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, global___Feature]:
        """
        Features that the node has advertised in the init message, node
        announcements and invoices.
        """

    def __init__(
        self,
        *,
        addresses: collections.abc.Iterable[builtins.str] | None = ...,
        identity_key: builtins.str = ...,
        global_features: builtins.bytes = ...,
        alias: builtins.str = ...,
        color: builtins.str = ...,
        node_addresses: collections.abc.Iterable[global___NodeAddress] | None = ...,
        features: collections.abc.Mapping[builtins.int, global___Feature] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["addresses", b"addresses", "alias", b"alias", "color", b"color", "features", b"features", "global_features", b"global_features", "identity_key", b"identity_key", "node_addresses", b"node_addresses"]) -> None: ...

global___NodeUpdate = NodeUpdate

@typing.final
class ChannelEdgeUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_ID_FIELD_NUMBER: builtins.int
    CHAN_POINT_FIELD_NUMBER: builtins.int
    CAPACITY_FIELD_NUMBER: builtins.int
    ROUTING_POLICY_FIELD_NUMBER: builtins.int
    ADVERTISING_NODE_FIELD_NUMBER: builtins.int
    CONNECTING_NODE_FIELD_NUMBER: builtins.int
    chan_id: builtins.int
    """
    The unique channel ID for the channel. The first 3 bytes are the block
    height, the next 3 the index within the block, and the last 2 bytes are the
    output index for the channel.
    """
    capacity: builtins.int
    advertising_node: builtins.str
    connecting_node: builtins.str
    @property
    def chan_point(self) -> global___ChannelPoint: ...
    @property
    def routing_policy(self) -> global___RoutingPolicy: ...
    def __init__(
        self,
        *,
        chan_id: builtins.int = ...,
        chan_point: global___ChannelPoint | None = ...,
        capacity: builtins.int = ...,
        routing_policy: global___RoutingPolicy | None = ...,
        advertising_node: builtins.str = ...,
        connecting_node: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["chan_point", b"chan_point", "routing_policy", b"routing_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["advertising_node", b"advertising_node", "capacity", b"capacity", "chan_id", b"chan_id", "chan_point", b"chan_point", "connecting_node", b"connecting_node", "routing_policy", b"routing_policy"]) -> None: ...

global___ChannelEdgeUpdate = ChannelEdgeUpdate

@typing.final
class ClosedChannelUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_ID_FIELD_NUMBER: builtins.int
    CAPACITY_FIELD_NUMBER: builtins.int
    CLOSED_HEIGHT_FIELD_NUMBER: builtins.int
    CHAN_POINT_FIELD_NUMBER: builtins.int
    chan_id: builtins.int
    """
    The unique channel ID for the channel. The first 3 bytes are the block
    height, the next 3 the index within the block, and the last 2 bytes are the
    output index for the channel.
    """
    capacity: builtins.int
    closed_height: builtins.int
    @property
    def chan_point(self) -> global___ChannelPoint: ...
    def __init__(
        self,
        *,
        chan_id: builtins.int = ...,
        capacity: builtins.int = ...,
        closed_height: builtins.int = ...,
        chan_point: global___ChannelPoint | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["chan_point", b"chan_point"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["capacity", b"capacity", "chan_id", b"chan_id", "chan_point", b"chan_point", "closed_height", b"closed_height"]) -> None: ...

global___ClosedChannelUpdate = ClosedChannelUpdate

@typing.final
class HopHint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODE_ID_FIELD_NUMBER: builtins.int
    CHAN_ID_FIELD_NUMBER: builtins.int
    FEE_BASE_MSAT_FIELD_NUMBER: builtins.int
    FEE_PROPORTIONAL_MILLIONTHS_FIELD_NUMBER: builtins.int
    CLTV_EXPIRY_DELTA_FIELD_NUMBER: builtins.int
    node_id: builtins.str
    """The public key of the node at the start of the channel."""
    chan_id: builtins.int
    """The unique identifier of the channel."""
    fee_base_msat: builtins.int
    """The base fee of the channel denominated in millisatoshis."""
    fee_proportional_millionths: builtins.int
    """
    The fee rate of the channel for sending one satoshi across it denominated in
    millionths of a satoshi.
    """
    cltv_expiry_delta: builtins.int
    """The time-lock delta of the channel."""
    def __init__(
        self,
        *,
        node_id: builtins.str = ...,
        chan_id: builtins.int = ...,
        fee_base_msat: builtins.int = ...,
        fee_proportional_millionths: builtins.int = ...,
        cltv_expiry_delta: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["chan_id", b"chan_id", "cltv_expiry_delta", b"cltv_expiry_delta", "fee_base_msat", b"fee_base_msat", "fee_proportional_millionths", b"fee_proportional_millionths", "node_id", b"node_id"]) -> None: ...

global___HopHint = HopHint

@typing.final
class SetID(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SET_ID_FIELD_NUMBER: builtins.int
    set_id: builtins.bytes
    def __init__(
        self,
        *,
        set_id: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["set_id", b"set_id"]) -> None: ...

global___SetID = SetID

@typing.final
class RouteHint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOP_HINTS_FIELD_NUMBER: builtins.int
    @property
    def hop_hints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HopHint]:
        """
        A list of hop hints that when chained together can assist in reaching a
        specific destination.
        """

    def __init__(
        self,
        *,
        hop_hints: collections.abc.Iterable[global___HopHint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hop_hints", b"hop_hints"]) -> None: ...

global___RouteHint = RouteHint

@typing.final
class BlindedPaymentPath(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BLINDED_PATH_FIELD_NUMBER: builtins.int
    BASE_FEE_MSAT_FIELD_NUMBER: builtins.int
    PROPORTIONAL_FEE_RATE_FIELD_NUMBER: builtins.int
    TOTAL_CLTV_DELTA_FIELD_NUMBER: builtins.int
    HTLC_MIN_MSAT_FIELD_NUMBER: builtins.int
    HTLC_MAX_MSAT_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    base_fee_msat: builtins.int
    """The base fee for the blinded path provided, expressed in msat."""
    proportional_fee_rate: builtins.int
    """
    The proportional fee for the blinded path provided, expressed in parts
    per million.
    """
    total_cltv_delta: builtins.int
    """
    The total CLTV delta for the blinded path provided, including the
    final CLTV delta for the receiving node.
    """
    htlc_min_msat: builtins.int
    """
    The minimum hltc size that may be sent over the blinded path, expressed
    in msat.
    """
    htlc_max_msat: builtins.int
    """
    The maximum htlc size that may be sent over the blinded path, expressed
    in msat.
    """
    @property
    def blinded_path(self) -> global___BlindedPath:
        """The blinded path to send the payment to."""

    @property
    def features(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___FeatureBit.ValueType]:
        """The feature bits for the route."""

    def __init__(
        self,
        *,
        blinded_path: global___BlindedPath | None = ...,
        base_fee_msat: builtins.int = ...,
        proportional_fee_rate: builtins.int = ...,
        total_cltv_delta: builtins.int = ...,
        htlc_min_msat: builtins.int = ...,
        htlc_max_msat: builtins.int = ...,
        features: collections.abc.Iterable[global___FeatureBit.ValueType] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["blinded_path", b"blinded_path"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["base_fee_msat", b"base_fee_msat", "blinded_path", b"blinded_path", "features", b"features", "htlc_max_msat", b"htlc_max_msat", "htlc_min_msat", b"htlc_min_msat", "proportional_fee_rate", b"proportional_fee_rate", "total_cltv_delta", b"total_cltv_delta"]) -> None: ...

global___BlindedPaymentPath = BlindedPaymentPath

@typing.final
class BlindedPath(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INTRODUCTION_NODE_FIELD_NUMBER: builtins.int
    BLINDING_POINT_FIELD_NUMBER: builtins.int
    BLINDED_HOPS_FIELD_NUMBER: builtins.int
    introduction_node: builtins.bytes
    """The unblinded pubkey of the introduction node for the route."""
    blinding_point: builtins.bytes
    """The ephemeral pubkey used by nodes in the blinded route."""
    @property
    def blinded_hops(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BlindedHop]:
        """
        A set of blinded node keys and data blobs for the blinded portion of the
        route. Note that the first hop is expected to be the introduction node,
        so the route is always expected to have at least one hop.
        """

    def __init__(
        self,
        *,
        introduction_node: builtins.bytes = ...,
        blinding_point: builtins.bytes = ...,
        blinded_hops: collections.abc.Iterable[global___BlindedHop] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["blinded_hops", b"blinded_hops", "blinding_point", b"blinding_point", "introduction_node", b"introduction_node"]) -> None: ...

global___BlindedPath = BlindedPath

@typing.final
class BlindedHop(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BLINDED_NODE_FIELD_NUMBER: builtins.int
    ENCRYPTED_DATA_FIELD_NUMBER: builtins.int
    blinded_node: builtins.bytes
    """The blinded public key of the node."""
    encrypted_data: builtins.bytes
    """An encrypted blob of data provided to the blinded node."""
    def __init__(
        self,
        *,
        blinded_node: builtins.bytes = ...,
        encrypted_data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["blinded_node", b"blinded_node", "encrypted_data", b"encrypted_data"]) -> None: ...

global___BlindedHop = BlindedHop

@typing.final
class AMPInvoiceState(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    SETTLE_INDEX_FIELD_NUMBER: builtins.int
    SETTLE_TIME_FIELD_NUMBER: builtins.int
    AMT_PAID_MSAT_FIELD_NUMBER: builtins.int
    state: global___InvoiceHTLCState.ValueType
    """The state the HTLCs associated with this setID are in."""
    settle_index: builtins.int
    """The settle index of this HTLC set, if the invoice state is settled."""
    settle_time: builtins.int
    """The time this HTLC set was settled expressed in unix epoch."""
    amt_paid_msat: builtins.int
    """The total amount paid for the sub-invoice expressed in milli satoshis."""
    def __init__(
        self,
        *,
        state: global___InvoiceHTLCState.ValueType = ...,
        settle_index: builtins.int = ...,
        settle_time: builtins.int = ...,
        amt_paid_msat: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["amt_paid_msat", b"amt_paid_msat", "settle_index", b"settle_index", "settle_time", b"settle_time", "state", b"state"]) -> None: ...

global___AMPInvoiceState = AMPInvoiceState

@typing.final
class Invoice(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _InvoiceState:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _InvoiceStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Invoice._InvoiceState.ValueType], builtins.type):    # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OPEN: Invoice._InvoiceState.ValueType  # 0
        SETTLED: Invoice._InvoiceState.ValueType  # 1
        CANCELED: Invoice._InvoiceState.ValueType  # 2
        ACCEPTED: Invoice._InvoiceState.ValueType  # 3

    class InvoiceState(_InvoiceState, metaclass=_InvoiceStateEnumTypeWrapper): ...
    OPEN: Invoice.InvoiceState.ValueType  # 0
    SETTLED: Invoice.InvoiceState.ValueType  # 1
    CANCELED: Invoice.InvoiceState.ValueType  # 2
    ACCEPTED: Invoice.InvoiceState.ValueType  # 3

    @typing.final
    class FeaturesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> global___Feature: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: global___Feature | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class AmpInvoiceStateEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___AMPInvoiceState: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___AMPInvoiceState | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    MEMO_FIELD_NUMBER: builtins.int
    R_PREIMAGE_FIELD_NUMBER: builtins.int
    R_HASH_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    VALUE_MSAT_FIELD_NUMBER: builtins.int
    SETTLED_FIELD_NUMBER: builtins.int
    CREATION_DATE_FIELD_NUMBER: builtins.int
    SETTLE_DATE_FIELD_NUMBER: builtins.int
    PAYMENT_REQUEST_FIELD_NUMBER: builtins.int
    DESCRIPTION_HASH_FIELD_NUMBER: builtins.int
    EXPIRY_FIELD_NUMBER: builtins.int
    FALLBACK_ADDR_FIELD_NUMBER: builtins.int
    CLTV_EXPIRY_FIELD_NUMBER: builtins.int
    ROUTE_HINTS_FIELD_NUMBER: builtins.int
    PRIVATE_FIELD_NUMBER: builtins.int
    ADD_INDEX_FIELD_NUMBER: builtins.int
    SETTLE_INDEX_FIELD_NUMBER: builtins.int
    AMT_PAID_FIELD_NUMBER: builtins.int
    AMT_PAID_SAT_FIELD_NUMBER: builtins.int
    AMT_PAID_MSAT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    HTLCS_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    IS_KEYSEND_FIELD_NUMBER: builtins.int
    PAYMENT_ADDR_FIELD_NUMBER: builtins.int
    IS_AMP_FIELD_NUMBER: builtins.int
    AMP_INVOICE_STATE_FIELD_NUMBER: builtins.int
    memo: builtins.str
    """
    An optional memo to attach along with the invoice. Used for record keeping
    purposes for the invoice's creator, and will also be set in the description
    field of the encoded payment request if the description_hash field is not
    being used.
    """
    r_preimage: builtins.bytes
    """
    The hex-encoded preimage (32 byte) which will allow settling an incoming
    HTLC payable to this preimage. When using REST, this field must be encoded
    as base64.
    """
    r_hash: builtins.bytes
    """
    The hash of the preimage. When using REST, this field must be encoded as
    base64.
    Note: Output only, don't specify for creating an invoice.
    """
    value: builtins.int
    """
    The value of this invoice in satoshis

    The fields value and value_msat are mutually exclusive.
    """
    value_msat: builtins.int
    """
    The value of this invoice in millisatoshis

    The fields value and value_msat are mutually exclusive.
    """
    settled: builtins.bool
    """
    Whether this invoice has been fulfilled.

    The field is deprecated. Use the state field instead (compare to SETTLED).
    """
    creation_date: builtins.int
    """
    When this invoice was created.
    Measured in seconds since the unix epoch.
    Note: Output only, don't specify for creating an invoice.
    """
    settle_date: builtins.int
    """
    When this invoice was settled.
    Measured in seconds since the unix epoch.
    Note: Output only, don't specify for creating an invoice.
    """
    payment_request: builtins.str
    """
    A bare-bones invoice for a payment within the Lightning Network. With the
    details of the invoice, the sender has all the data necessary to send a
    payment to the recipient.
    Note: Output only, don't specify for creating an invoice.
    """
    description_hash: builtins.bytes
    """
    Hash (SHA-256) of a description of the payment. Used if the description of
    payment (memo) is too long to naturally fit within the description field
    of an encoded payment request. When using REST, this field must be encoded
    as base64.
    """
    expiry: builtins.int
    """Payment request expiry time in seconds. Default is 86400 (24 hours)."""
    fallback_addr: builtins.str
    """Fallback on-chain address."""
    cltv_expiry: builtins.int
    """Delta to use for the time-lock of the CLTV extended to the final hop."""
    private: builtins.bool
    """Whether this invoice should include routing hints for private channels.
    Note: When enabled, if value and value_msat are zero, a large number of
    hints with these channels can be included, which might not be desirable.
    """
    add_index: builtins.int
    """
    The "add" index of this invoice. Each newly created invoice will increment
    this index making it monotonically increasing. Callers to the
    SubscribeInvoices call can use this to instantly get notified of all added
    invoices with an add_index greater than this one.
    Note: Output only, don't specify for creating an invoice.
    """
    settle_index: builtins.int
    """
    The "settle" index of this invoice. Each newly settled invoice will
    increment this index making it monotonically increasing. Callers to the
    SubscribeInvoices call can use this to instantly get notified of all
    settled invoices with an settle_index greater than this one.
    Note: Output only, don't specify for creating an invoice.
    """
    amt_paid: builtins.int
    """Deprecated, use amt_paid_sat or amt_paid_msat."""
    amt_paid_sat: builtins.int
    """
    The amount that was accepted for this invoice, in satoshis. This will ONLY
    be set if this invoice has been settled or accepted. We provide this field
    as if the invoice was created with a zero value, then we need to record what
    amount was ultimately accepted. Additionally, it's possible that the sender
    paid MORE that was specified in the original invoice. So we'll record that
    here as well.
    Note: Output only, don't specify for creating an invoice.
    """
    amt_paid_msat: builtins.int
    """
    The amount that was accepted for this invoice, in millisatoshis. This will
    ONLY be set if this invoice has been settled or accepted. We provide this
    field as if the invoice was created with a zero value, then we need to
    record what amount was ultimately accepted. Additionally, it's possible that
    the sender paid MORE that was specified in the original invoice. So we'll
    record that here as well.
    Note: Output only, don't specify for creating an invoice.
    """
    state: global___Invoice.InvoiceState.ValueType
    """
    The state the invoice is in.
    Note: Output only, don't specify for creating an invoice.
    """
    is_keysend: builtins.bool
    """
    Indicates if this invoice was a spontaneous payment that arrived via keysend
    [EXPERIMENTAL].
    Note: Output only, don't specify for creating an invoice.
    """
    payment_addr: builtins.bytes
    """
    The payment address of this invoice. This is also called payment secret in
    specifications (e.g. BOLT 11). This value will be used in MPP payments, and
    also for newer invoices that always require the MPP payload for added
    end-to-end security.
    Note: Output only, don't specify for creating an invoice.
    """
    is_amp: builtins.bool
    """
    Signals whether or not this is an AMP invoice.
    """
    @property
    def route_hints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RouteHint]:
        """
        Route hints that can each be individually used to assist in reaching the
        invoice's destination.
        """

    @property
    def htlcs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InvoiceHTLC]:
        """
        List of HTLCs paying to this invoice [EXPERIMENTAL].
        Note: Output only, don't specify for creating an invoice.
        """

    @property
    def features(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, global___Feature]:
        """
        List of features advertised on the invoice.
        Note: Output only, don't specify for creating an invoice.
        """

    @property
    def amp_invoice_state(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___AMPInvoiceState]:
        """
        [EXPERIMENTAL]:

        Maps a 32-byte hex-encoded set ID to the sub-invoice AMP state for the
        given set ID. This field is always populated for AMP invoices, and can be
        used along side LookupInvoice to obtain the HTLC information related to a
        given sub-invoice.
        Note: Output only, don't specify for creating an invoice.
        """

    def __init__(
        self,
        *,
        memo: builtins.str = ...,
        r_preimage: builtins.bytes = ...,
        r_hash: builtins.bytes = ...,
        value: builtins.int = ...,
        value_msat: builtins.int = ...,
        settled: builtins.bool = ...,
        creation_date: builtins.int = ...,
        settle_date: builtins.int = ...,
        payment_request: builtins.str = ...,
        description_hash: builtins.bytes = ...,
        expiry: builtins.int = ...,
        fallback_addr: builtins.str = ...,
        cltv_expiry: builtins.int = ...,
        route_hints: collections.abc.Iterable[global___RouteHint] | None = ...,
        private: builtins.bool = ...,
        add_index: builtins.int = ...,
        settle_index: builtins.int = ...,
        amt_paid: builtins.int = ...,
        amt_paid_sat: builtins.int = ...,
        amt_paid_msat: builtins.int = ...,
        state: global___Invoice.InvoiceState.ValueType = ...,
        htlcs: collections.abc.Iterable[global___InvoiceHTLC] | None = ...,
        features: collections.abc.Mapping[builtins.int, global___Feature] | None = ...,
        is_keysend: builtins.bool = ...,
        payment_addr: builtins.bytes = ...,
        is_amp: builtins.bool = ...,
        amp_invoice_state: collections.abc.Mapping[builtins.str, global___AMPInvoiceState] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["add_index", b"add_index", "amp_invoice_state", b"amp_invoice_state", "amt_paid", b"amt_paid", "amt_paid_msat", b"amt_paid_msat", "amt_paid_sat", b"amt_paid_sat", "cltv_expiry", b"cltv_expiry", "creation_date", b"creation_date", "description_hash", b"description_hash", "expiry", b"expiry", "fallback_addr", b"fallback_addr", "features", b"features", "htlcs", b"htlcs", "is_amp", b"is_amp", "is_keysend", b"is_keysend", "memo", b"memo", "payment_addr", b"payment_addr", "payment_request", b"payment_request", "private", b"private", "r_hash", b"r_hash", "r_preimage", b"r_preimage", "route_hints", b"route_hints", "settle_date", b"settle_date", "settle_index", b"settle_index", "settled", b"settled", "state", b"state", "value", b"value", "value_msat", b"value_msat"]) -> None: ...

global___Invoice = Invoice

@typing.final
class InvoiceHTLC(google.protobuf.message.Message):
    """Details of an HTLC that paid to an invoice"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class CustomRecordsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CHAN_ID_FIELD_NUMBER: builtins.int
    HTLC_INDEX_FIELD_NUMBER: builtins.int
    AMT_MSAT_FIELD_NUMBER: builtins.int
    ACCEPT_HEIGHT_FIELD_NUMBER: builtins.int
    ACCEPT_TIME_FIELD_NUMBER: builtins.int
    RESOLVE_TIME_FIELD_NUMBER: builtins.int
    EXPIRY_HEIGHT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CUSTOM_RECORDS_FIELD_NUMBER: builtins.int
    MPP_TOTAL_AMT_MSAT_FIELD_NUMBER: builtins.int
    AMP_FIELD_NUMBER: builtins.int
    chan_id: builtins.int
    """Short channel id over which the htlc was received."""
    htlc_index: builtins.int
    """Index identifying the htlc on the channel."""
    amt_msat: builtins.int
    """The amount of the htlc in msat."""
    accept_height: builtins.int
    """Block height at which this htlc was accepted."""
    accept_time: builtins.int
    """Time at which this htlc was accepted."""
    resolve_time: builtins.int
    """Time at which this htlc was settled or canceled."""
    expiry_height: builtins.int
    """Block height at which this htlc expires."""
    state: global___InvoiceHTLCState.ValueType
    """Current state the htlc is in."""
    mpp_total_amt_msat: builtins.int
    """The total amount of the mpp payment in msat."""
    @property
    def custom_records(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.bytes]:
        """Custom tlv records."""

    @property
    def amp(self) -> global___AMP:
        """Details relevant to AMP HTLCs, only populated if this is an AMP HTLC."""

    def __init__(
        self,
        *,
        chan_id: builtins.int = ...,
        htlc_index: builtins.int = ...,
        amt_msat: builtins.int = ...,
        accept_height: builtins.int = ...,
        accept_time: builtins.int = ...,
        resolve_time: builtins.int = ...,
        expiry_height: builtins.int = ...,
        state: global___InvoiceHTLCState.ValueType = ...,
        custom_records: collections.abc.Mapping[builtins.int, builtins.bytes] | None = ...,
        mpp_total_amt_msat: builtins.int = ...,
        amp: global___AMP | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["amp", b"amp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["accept_height", b"accept_height", "accept_time", b"accept_time", "amp", b"amp", "amt_msat", b"amt_msat", "chan_id", b"chan_id", "custom_records", b"custom_records", "expiry_height", b"expiry_height", "htlc_index", b"htlc_index", "mpp_total_amt_msat", b"mpp_total_amt_msat", "resolve_time", b"resolve_time", "state", b"state"]) -> None: ...

global___InvoiceHTLC = InvoiceHTLC

@typing.final
class AMP(google.protobuf.message.Message):
    """Details specific to AMP HTLCs."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROOT_SHARE_FIELD_NUMBER: builtins.int
    SET_ID_FIELD_NUMBER: builtins.int
    CHILD_INDEX_FIELD_NUMBER: builtins.int
    HASH_FIELD_NUMBER: builtins.int
    PREIMAGE_FIELD_NUMBER: builtins.int
    root_share: builtins.bytes
    """An n-of-n secret share of the root seed from which child payment hashes
    and preimages are derived.
    """
    set_id: builtins.bytes
    """An identifier for the HTLC set that this HTLC belongs to."""
    child_index: builtins.int
    """A nonce used to randomize the child preimage and child hash from a given
    root_share.
    """
    hash: builtins.bytes
    """The payment hash of the AMP HTLC."""
    preimage: builtins.bytes
    """The preimage used to settle this AMP htlc. This field will only be
    populated if the invoice is in InvoiceState_ACCEPTED or
    InvoiceState_SETTLED.
    """
    def __init__(
        self,
        *,
        root_share: builtins.bytes = ...,
        set_id: builtins.bytes = ...,
        child_index: builtins.int = ...,
        hash: builtins.bytes = ...,
        preimage: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["child_index", b"child_index", "hash", b"hash", "preimage", b"preimage", "root_share", b"root_share", "set_id", b"set_id"]) -> None: ...

global___AMP = AMP

@typing.final
class AddInvoiceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    R_HASH_FIELD_NUMBER: builtins.int
    PAYMENT_REQUEST_FIELD_NUMBER: builtins.int
    ADD_INDEX_FIELD_NUMBER: builtins.int
    PAYMENT_ADDR_FIELD_NUMBER: builtins.int
    r_hash: builtins.bytes
    payment_request: builtins.str
    """
    A bare-bones invoice for a payment within the Lightning Network. With the
    details of the invoice, the sender has all the data necessary to send a
    payment to the recipient.
    """
    add_index: builtins.int
    """
    The "add" index of this invoice. Each newly created invoice will increment
    this index making it monotonically increasing. Callers to the
    SubscribeInvoices call can use this to instantly get notified of all added
    invoices with an add_index greater than this one.
    """
    payment_addr: builtins.bytes
    """
    The payment address of the generated invoice. This is also called
    payment secret in specifications (e.g. BOLT 11). This value should be used
    in all payments for this invoice as we require it for end to end security.
    """
    def __init__(
        self,
        *,
        r_hash: builtins.bytes = ...,
        payment_request: builtins.str = ...,
        add_index: builtins.int = ...,
        payment_addr: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["add_index", b"add_index", "payment_addr", b"payment_addr", "payment_request", b"payment_request", "r_hash", b"r_hash"]) -> None: ...

global___AddInvoiceResponse = AddInvoiceResponse

@typing.final
class PaymentHash(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    R_HASH_STR_FIELD_NUMBER: builtins.int
    R_HASH_FIELD_NUMBER: builtins.int
    r_hash_str: builtins.str
    """
    The hex-encoded payment hash of the invoice to be looked up. The passed
    payment hash must be exactly 32 bytes, otherwise an error is returned.
    Deprecated now that the REST gateway supports base64 encoding of bytes
    fields.
    """
    r_hash: builtins.bytes
    """
    The payment hash of the invoice to be looked up. When using REST, this field
    must be encoded as base64.
    """
    def __init__(
        self,
        *,
        r_hash_str: builtins.str = ...,
        r_hash: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["r_hash", b"r_hash", "r_hash_str", b"r_hash_str"]) -> None: ...

global___PaymentHash = PaymentHash

@typing.final
class ListInvoiceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PENDING_ONLY_FIELD_NUMBER: builtins.int
    INDEX_OFFSET_FIELD_NUMBER: builtins.int
    NUM_MAX_INVOICES_FIELD_NUMBER: builtins.int
    REVERSED_FIELD_NUMBER: builtins.int
    CREATION_DATE_START_FIELD_NUMBER: builtins.int
    CREATION_DATE_END_FIELD_NUMBER: builtins.int
    pending_only: builtins.bool
    """
    If set, only invoices that are not settled and not canceled will be returned
    in the response.
    """
    index_offset: builtins.int
    """
    The index of an invoice that will be used as either the start or end of a
    query to determine which invoices should be returned in the response.
    """
    num_max_invoices: builtins.int
    """The max number of invoices to return in the response to this query."""
    reversed: builtins.bool
    """
    If set, the invoices returned will result from seeking backwards from the
    specified index offset. This can be used to paginate backwards.
    """
    creation_date_start: builtins.int
    """If set, returns all invoices with a creation date greater than or equal
    to it. Measured in seconds since the unix epoch.
    """
    creation_date_end: builtins.int
    """If set, returns all invoices with a creation date less than or equal to
    it. Measured in seconds since the unix epoch.
    """
    def __init__(
        self,
        *,
        pending_only: builtins.bool = ...,
        index_offset: builtins.int = ...,
        num_max_invoices: builtins.int = ...,
        reversed: builtins.bool = ...,
        creation_date_start: builtins.int = ...,
        creation_date_end: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["creation_date_end", b"creation_date_end", "creation_date_start", b"creation_date_start", "index_offset", b"index_offset", "num_max_invoices", b"num_max_invoices", "pending_only", b"pending_only", "reversed", b"reversed"]) -> None: ...

global___ListInvoiceRequest = ListInvoiceRequest

@typing.final
class ListInvoiceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INVOICES_FIELD_NUMBER: builtins.int
    LAST_INDEX_OFFSET_FIELD_NUMBER: builtins.int
    FIRST_INDEX_OFFSET_FIELD_NUMBER: builtins.int
    last_index_offset: builtins.int
    """
    The index of the last item in the set of returned invoices. This can be used
    to seek further, pagination style.
    """
    first_index_offset: builtins.int
    """
    The index of the last item in the set of returned invoices. This can be used
    to seek backwards, pagination style.
    """
    @property
    def invoices(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Invoice]:
        """
        A list of invoices from the time slice of the time series specified in the
        request.
        """

    def __init__(
        self,
        *,
        invoices: collections.abc.Iterable[global___Invoice] | None = ...,
        last_index_offset: builtins.int = ...,
        first_index_offset: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["first_index_offset", b"first_index_offset", "invoices", b"invoices", "last_index_offset", b"last_index_offset"]) -> None: ...

global___ListInvoiceResponse = ListInvoiceResponse

@typing.final
class InvoiceSubscription(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADD_INDEX_FIELD_NUMBER: builtins.int
    SETTLE_INDEX_FIELD_NUMBER: builtins.int
    add_index: builtins.int
    """
    If specified (non-zero), then we'll first start by sending out
    notifications for all added indexes with an add_index greater than this
    value. This allows callers to catch up on any events they missed while they
    weren't connected to the streaming RPC.
    """
    settle_index: builtins.int
    """
    If specified (non-zero), then we'll first start by sending out
    notifications for all settled indexes with an settle_index greater than
    this value. This allows callers to catch up on any events they missed while
    they weren't connected to the streaming RPC.
    """
    def __init__(
        self,
        *,
        add_index: builtins.int = ...,
        settle_index: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["add_index", b"add_index", "settle_index", b"settle_index"]) -> None: ...

global___InvoiceSubscription = InvoiceSubscription

@typing.final
class Payment(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _PaymentStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PaymentStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Payment._PaymentStatus.ValueType], builtins.type): # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: Payment._PaymentStatus.ValueType  # 0
        """Deprecated. This status will never be returned."""
        IN_FLIGHT: Payment._PaymentStatus.ValueType  # 1
        """Payment has inflight HTLCs."""
        SUCCEEDED: Payment._PaymentStatus.ValueType  # 2
        """Payment is settled."""
        FAILED: Payment._PaymentStatus.ValueType  # 3
        """Payment is failed."""
        INITIATED: Payment._PaymentStatus.ValueType  # 4
        """Payment is created and has not attempted any HTLCs."""

    class PaymentStatus(_PaymentStatus, metaclass=_PaymentStatusEnumTypeWrapper): ...
    UNKNOWN: Payment.PaymentStatus.ValueType  # 0
    """Deprecated. This status will never be returned."""
    IN_FLIGHT: Payment.PaymentStatus.ValueType  # 1
    """Payment has inflight HTLCs."""
    SUCCEEDED: Payment.PaymentStatus.ValueType  # 2
    """Payment is settled."""
    FAILED: Payment.PaymentStatus.ValueType  # 3
    """Payment is failed."""
    INITIATED: Payment.PaymentStatus.ValueType  # 4
    """Payment is created and has not attempted any HTLCs."""

    PAYMENT_HASH_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    CREATION_DATE_FIELD_NUMBER: builtins.int
    FEE_FIELD_NUMBER: builtins.int
    PAYMENT_PREIMAGE_FIELD_NUMBER: builtins.int
    VALUE_SAT_FIELD_NUMBER: builtins.int
    VALUE_MSAT_FIELD_NUMBER: builtins.int
    PAYMENT_REQUEST_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    FEE_SAT_FIELD_NUMBER: builtins.int
    FEE_MSAT_FIELD_NUMBER: builtins.int
    CREATION_TIME_NS_FIELD_NUMBER: builtins.int
    HTLCS_FIELD_NUMBER: builtins.int
    PAYMENT_INDEX_FIELD_NUMBER: builtins.int
    FAILURE_REASON_FIELD_NUMBER: builtins.int
    payment_hash: builtins.str
    """The payment hash"""
    value: builtins.int
    """Deprecated, use value_sat or value_msat."""
    creation_date: builtins.int
    """Deprecated, use creation_time_ns"""
    fee: builtins.int
    """Deprecated, use fee_sat or fee_msat."""
    payment_preimage: builtins.str
    """The payment preimage"""
    value_sat: builtins.int
    """The value of the payment in satoshis"""
    value_msat: builtins.int
    """The value of the payment in milli-satoshis"""
    payment_request: builtins.str
    """The optional payment request being fulfilled."""
    status: global___Payment.PaymentStatus.ValueType
    """The status of the payment."""
    fee_sat: builtins.int
    """ The fee paid for this payment in satoshis"""
    fee_msat: builtins.int
    """ The fee paid for this payment in milli-satoshis"""
    creation_time_ns: builtins.int
    """The time in UNIX nanoseconds at which the payment was created."""
    payment_index: builtins.int
    """
    The creation index of this payment. Each payment can be uniquely identified
    by this index, which may not strictly increment by 1 for payments made in
    older versions of lnd.
    """
    failure_reason: global___PaymentFailureReason.ValueType
    @property
    def htlcs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HTLCAttempt]:
        """The HTLCs made in attempt to settle the payment."""

    def __init__(
        self,
        *,
        payment_hash: builtins.str = ...,
        value: builtins.int = ...,
        creation_date: builtins.int = ...,
        fee: builtins.int = ...,
        payment_preimage: builtins.str = ...,
        value_sat: builtins.int = ...,
        value_msat: builtins.int = ...,
        payment_request: builtins.str = ...,
        status: global___Payment.PaymentStatus.ValueType = ...,
        fee_sat: builtins.int = ...,
        fee_msat: builtins.int = ...,
        creation_time_ns: builtins.int = ...,
        htlcs: collections.abc.Iterable[global___HTLCAttempt] | None = ...,
        payment_index: builtins.int = ...,
        failure_reason: global___PaymentFailureReason.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["creation_date", b"creation_date", "creation_time_ns", b"creation_time_ns", "failure_reason", b"failure_reason", "fee", b"fee", "fee_msat", b"fee_msat", "fee_sat", b"fee_sat", "htlcs", b"htlcs", "payment_hash", b"payment_hash", "payment_index", b"payment_index", "payment_preimage", b"payment_preimage", "payment_request", b"payment_request", "status", b"status", "value", b"value", "value_msat", b"value_msat", "value_sat", b"value_sat"]) -> None: ...

global___Payment = Payment

@typing.final
class HTLCAttempt(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _HTLCStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HTLCStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[HTLCAttempt._HTLCStatus.ValueType], builtins.type):    # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        IN_FLIGHT: HTLCAttempt._HTLCStatus.ValueType  # 0
        SUCCEEDED: HTLCAttempt._HTLCStatus.ValueType  # 1
        FAILED: HTLCAttempt._HTLCStatus.ValueType  # 2

    class HTLCStatus(_HTLCStatus, metaclass=_HTLCStatusEnumTypeWrapper): ...
    IN_FLIGHT: HTLCAttempt.HTLCStatus.ValueType  # 0
    SUCCEEDED: HTLCAttempt.HTLCStatus.ValueType  # 1
    FAILED: HTLCAttempt.HTLCStatus.ValueType  # 2

    ATTEMPT_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ROUTE_FIELD_NUMBER: builtins.int
    ATTEMPT_TIME_NS_FIELD_NUMBER: builtins.int
    RESOLVE_TIME_NS_FIELD_NUMBER: builtins.int
    FAILURE_FIELD_NUMBER: builtins.int
    PREIMAGE_FIELD_NUMBER: builtins.int
    attempt_id: builtins.int
    """The unique ID that is used for this attempt."""
    status: global___HTLCAttempt.HTLCStatus.ValueType
    """The status of the HTLC."""
    attempt_time_ns: builtins.int
    """The time in UNIX nanoseconds at which this HTLC was sent."""
    resolve_time_ns: builtins.int
    """
    The time in UNIX nanoseconds at which this HTLC was settled or failed.
    This value will not be set if the HTLC is still IN_FLIGHT.
    """
    preimage: builtins.bytes
    """The preimage that was used to settle the HTLC."""
    @property
    def route(self) -> global___Route:
        """The route taken by this HTLC."""

    @property
    def failure(self) -> global___Failure:
        """Detailed htlc failure info."""

    def __init__(
        self,
        *,
        attempt_id: builtins.int = ...,
        status: global___HTLCAttempt.HTLCStatus.ValueType = ...,
        route: global___Route | None = ...,
        attempt_time_ns: builtins.int = ...,
        resolve_time_ns: builtins.int = ...,
        failure: global___Failure | None = ...,
        preimage: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["failure", b"failure", "route", b"route"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attempt_id", b"attempt_id", "attempt_time_ns", b"attempt_time_ns", "failure", b"failure", "preimage", b"preimage", "resolve_time_ns", b"resolve_time_ns", "route", b"route", "status", b"status"]) -> None: ...

global___HTLCAttempt = HTLCAttempt

@typing.final
class ListPaymentsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INCLUDE_INCOMPLETE_FIELD_NUMBER: builtins.int
    INDEX_OFFSET_FIELD_NUMBER: builtins.int
    MAX_PAYMENTS_FIELD_NUMBER: builtins.int
    REVERSED_FIELD_NUMBER: builtins.int
    COUNT_TOTAL_PAYMENTS_FIELD_NUMBER: builtins.int
    CREATION_DATE_START_FIELD_NUMBER: builtins.int
    CREATION_DATE_END_FIELD_NUMBER: builtins.int
    include_incomplete: builtins.bool
    """
    If true, then return payments that have not yet fully completed. This means
    that pending payments, as well as failed payments will show up if this
    field is set to true. This flag doesn't change the meaning of the indices,
    which are tied to individual payments.
    """
    index_offset: builtins.int
    """
    The index of a payment that will be used as either the start or end of a
    query to determine which payments should be returned in the response. The
    index_offset is exclusive. In the case of a zero index_offset, the query
    will start with the oldest payment when paginating forwards, or will end
    with the most recent payment when paginating backwards.
    """
    max_payments: builtins.int
    """The maximal number of payments returned in the response to this query."""
    reversed: builtins.bool
    """
    If set, the payments returned will result from seeking backwards from the
    specified index offset. This can be used to paginate backwards. The order
    of the returned payments is always oldest first (ascending index order).
    """
    count_total_payments: builtins.bool
    """
    If set, all payments (complete and incomplete, independent of the
    max_payments parameter) will be counted. Note that setting this to true will
    increase the run time of the call significantly on systems that have a lot
    of payments, as all of them have to be iterated through to be counted.
    """
    creation_date_start: builtins.int
    """If set, returns all payments with a creation date greater than or equal
    to it. Measured in seconds since the unix epoch.
    """
    creation_date_end: builtins.int
    """If set, returns all payments with a creation date less than or equal to
    it. Measured in seconds since the unix epoch.
    """
    def __init__(
        self,
        *,
        include_incomplete: builtins.bool = ...,
        index_offset: builtins.int = ...,
        max_payments: builtins.int = ...,
        reversed: builtins.bool = ...,
        count_total_payments: builtins.bool = ...,
        creation_date_start: builtins.int = ...,
        creation_date_end: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["count_total_payments", b"count_total_payments", "creation_date_end", b"creation_date_end", "creation_date_start", b"creation_date_start", "include_incomplete", b"include_incomplete", "index_offset", b"index_offset", "max_payments", b"max_payments", "reversed", b"reversed"]) -> None: ...

global___ListPaymentsRequest = ListPaymentsRequest

@typing.final
class ListPaymentsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYMENTS_FIELD_NUMBER: builtins.int
    FIRST_INDEX_OFFSET_FIELD_NUMBER: builtins.int
    LAST_INDEX_OFFSET_FIELD_NUMBER: builtins.int
    TOTAL_NUM_PAYMENTS_FIELD_NUMBER: builtins.int
    first_index_offset: builtins.int
    """
    The index of the first item in the set of returned payments. This can be
    used as the index_offset to continue seeking backwards in the next request.
    """
    last_index_offset: builtins.int
    """
    The index of the last item in the set of returned payments. This can be used
    as the index_offset to continue seeking forwards in the next request.
    """
    total_num_payments: builtins.int
    """
    Will only be set if count_total_payments in the request was set. Represents
    the total number of payments (complete and incomplete, independent of the
    number of payments requested in the query) currently present in the payments
    database.
    """
    @property
    def payments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Payment]:
        """The list of payments"""

    def __init__(
        self,
        *,
        payments: collections.abc.Iterable[global___Payment] | None = ...,
        first_index_offset: builtins.int = ...,
        last_index_offset: builtins.int = ...,
        total_num_payments: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["first_index_offset", b"first_index_offset", "last_index_offset", b"last_index_offset", "payments", b"payments", "total_num_payments", b"total_num_payments"]) -> None: ...

global___ListPaymentsResponse = ListPaymentsResponse

@typing.final
class DeletePaymentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYMENT_HASH_FIELD_NUMBER: builtins.int
    FAILED_HTLCS_ONLY_FIELD_NUMBER: builtins.int
    payment_hash: builtins.bytes
    """Payment hash to delete."""
    failed_htlcs_only: builtins.bool
    """
    Only delete failed HTLCs from the payment, not the payment itself.
    """
    def __init__(
        self,
        *,
        payment_hash: builtins.bytes = ...,
        failed_htlcs_only: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["failed_htlcs_only", b"failed_htlcs_only", "payment_hash", b"payment_hash"]) -> None: ...

global___DeletePaymentRequest = DeletePaymentRequest

@typing.final
class DeleteAllPaymentsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FAILED_PAYMENTS_ONLY_FIELD_NUMBER: builtins.int
    FAILED_HTLCS_ONLY_FIELD_NUMBER: builtins.int
    ALL_PAYMENTS_FIELD_NUMBER: builtins.int
    failed_payments_only: builtins.bool
    """Only delete failed payments."""
    failed_htlcs_only: builtins.bool
    """
    Only delete failed HTLCs from payments, not the payment itself.
    """
    all_payments: builtins.bool
    """Delete all payments. NOTE: Using this option requires careful
    consideration as it is a destructive operation.
    """
    def __init__(
        self,
        *,
        failed_payments_only: builtins.bool = ...,
        failed_htlcs_only: builtins.bool = ...,
        all_payments: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["all_payments", b"all_payments", "failed_htlcs_only", b"failed_htlcs_only", "failed_payments_only", b"failed_payments_only"]) -> None: ...

global___DeleteAllPaymentsRequest = DeleteAllPaymentsRequest

@typing.final
class DeletePaymentResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeletePaymentResponse = DeletePaymentResponse

@typing.final
class DeleteAllPaymentsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteAllPaymentsResponse = DeleteAllPaymentsResponse

@typing.final
class AbandonChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_POINT_FIELD_NUMBER: builtins.int
    PENDING_FUNDING_SHIM_ONLY_FIELD_NUMBER: builtins.int
    I_KNOW_WHAT_I_AM_DOING_FIELD_NUMBER: builtins.int
    pending_funding_shim_only: builtins.bool
    i_know_what_i_am_doing: builtins.bool
    """
    Override the requirement for being in dev mode by setting this to true and
    confirming the user knows what they are doing and this is a potential foot
    gun to lose funds if used on active channels.
    """
    @property
    def channel_point(self) -> global___ChannelPoint: ...
    def __init__(
        self,
        *,
        channel_point: global___ChannelPoint | None = ...,
        pending_funding_shim_only: builtins.bool = ...,
        i_know_what_i_am_doing: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["channel_point", b"channel_point"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_point", b"channel_point", "i_know_what_i_am_doing", b"i_know_what_i_am_doing", "pending_funding_shim_only", b"pending_funding_shim_only"]) -> None: ...

global___AbandonChannelRequest = AbandonChannelRequest

@typing.final
class AbandonChannelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___AbandonChannelResponse = AbandonChannelResponse

@typing.final
class DebugLevelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SHOW_FIELD_NUMBER: builtins.int
    LEVEL_SPEC_FIELD_NUMBER: builtins.int
    show: builtins.bool
    level_spec: builtins.str
    def __init__(
        self,
        *,
        show: builtins.bool = ...,
        level_spec: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["level_spec", b"level_spec", "show", b"show"]) -> None: ...

global___DebugLevelRequest = DebugLevelRequest

@typing.final
class DebugLevelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUB_SYSTEMS_FIELD_NUMBER: builtins.int
    sub_systems: builtins.str
    def __init__(
        self,
        *,
        sub_systems: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["sub_systems", b"sub_systems"]) -> None: ...

global___DebugLevelResponse = DebugLevelResponse

@typing.final
class PayReqString(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAY_REQ_FIELD_NUMBER: builtins.int
    pay_req: builtins.str
    """The payment request string to be decoded"""
    def __init__(
        self,
        *,
        pay_req: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pay_req", b"pay_req"]) -> None: ...

global___PayReqString = PayReqString

@typing.final
class PayReq(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class FeaturesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> global___Feature: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: global___Feature | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DESTINATION_FIELD_NUMBER: builtins.int
    PAYMENT_HASH_FIELD_NUMBER: builtins.int
    NUM_SATOSHIS_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    EXPIRY_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    DESCRIPTION_HASH_FIELD_NUMBER: builtins.int
    FALLBACK_ADDR_FIELD_NUMBER: builtins.int
    CLTV_EXPIRY_FIELD_NUMBER: builtins.int
    ROUTE_HINTS_FIELD_NUMBER: builtins.int
    PAYMENT_ADDR_FIELD_NUMBER: builtins.int
    NUM_MSAT_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    BLINDED_PATHS_FIELD_NUMBER: builtins.int
    destination: builtins.str
    payment_hash: builtins.str
    num_satoshis: builtins.int
    timestamp: builtins.int
    expiry: builtins.int
    description: builtins.str
    description_hash: builtins.str
    fallback_addr: builtins.str
    cltv_expiry: builtins.int
    payment_addr: builtins.bytes
    num_msat: builtins.int
    @property
    def route_hints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RouteHint]: ...
    @property
    def features(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, global___Feature]: ...
    @property
    def blinded_paths(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BlindedPaymentPath]: ...
    def __init__(
        self,
        *,
        destination: builtins.str = ...,
        payment_hash: builtins.str = ...,
        num_satoshis: builtins.int = ...,
        timestamp: builtins.int = ...,
        expiry: builtins.int = ...,
        description: builtins.str = ...,
        description_hash: builtins.str = ...,
        fallback_addr: builtins.str = ...,
        cltv_expiry: builtins.int = ...,
        route_hints: collections.abc.Iterable[global___RouteHint] | None = ...,
        payment_addr: builtins.bytes = ...,
        num_msat: builtins.int = ...,
        features: collections.abc.Mapping[builtins.int, global___Feature] | None = ...,
        blinded_paths: collections.abc.Iterable[global___BlindedPaymentPath] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["blinded_paths", b"blinded_paths", "cltv_expiry", b"cltv_expiry", "description", b"description", "description_hash", b"description_hash", "destination", b"destination", "expiry", b"expiry", "fallback_addr", b"fallback_addr", "features", b"features", "num_msat", b"num_msat", "num_satoshis", b"num_satoshis", "payment_addr", b"payment_addr", "payment_hash", b"payment_hash", "route_hints", b"route_hints", "timestamp", b"timestamp"]) -> None: ...

global___PayReq = PayReq

@typing.final
class Feature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    IS_REQUIRED_FIELD_NUMBER: builtins.int
    IS_KNOWN_FIELD_NUMBER: builtins.int
    name: builtins.str
    is_required: builtins.bool
    is_known: builtins.bool
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        is_required: builtins.bool = ...,
        is_known: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["is_known", b"is_known", "is_required", b"is_required", "name", b"name"]) -> None: ...

global___Feature = Feature

@typing.final
class FeeReportRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___FeeReportRequest = FeeReportRequest

@typing.final
class ChannelFeeReport(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_POINT_FIELD_NUMBER: builtins.int
    BASE_FEE_MSAT_FIELD_NUMBER: builtins.int
    FEE_PER_MIL_FIELD_NUMBER: builtins.int
    FEE_RATE_FIELD_NUMBER: builtins.int
    INBOUND_BASE_FEE_MSAT_FIELD_NUMBER: builtins.int
    INBOUND_FEE_PER_MIL_FIELD_NUMBER: builtins.int
    chan_id: builtins.int
    """The short channel id that this fee report belongs to."""
    channel_point: builtins.str
    """The channel that this fee report belongs to."""
    base_fee_msat: builtins.int
    """The base fee charged regardless of the number of milli-satoshis sent."""
    fee_per_mil: builtins.int
    """The amount charged per milli-satoshis transferred expressed in
    millionths of a satoshi.
    """
    fee_rate: builtins.float
    """The effective fee rate in milli-satoshis. Computed by dividing the
    fee_per_mil value by 1 million.
    """
    inbound_base_fee_msat: builtins.int
    """The base fee charged regardless of the number of milli-satoshis sent."""
    inbound_fee_per_mil: builtins.int
    """The amount charged per milli-satoshis transferred expressed in
    millionths of a satoshi.
    """
    def __init__(
        self,
        *,
        chan_id: builtins.int = ...,
        channel_point: builtins.str = ...,
        base_fee_msat: builtins.int = ...,
        fee_per_mil: builtins.int = ...,
        fee_rate: builtins.float = ...,
        inbound_base_fee_msat: builtins.int = ...,
        inbound_fee_per_mil: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["base_fee_msat", b"base_fee_msat", "chan_id", b"chan_id", "channel_point", b"channel_point", "fee_per_mil", b"fee_per_mil", "fee_rate", b"fee_rate", "inbound_base_fee_msat", b"inbound_base_fee_msat", "inbound_fee_per_mil", b"inbound_fee_per_mil"]) -> None: ...

global___ChannelFeeReport = ChannelFeeReport

@typing.final
class FeeReportResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_FEES_FIELD_NUMBER: builtins.int
    DAY_FEE_SUM_FIELD_NUMBER: builtins.int
    WEEK_FEE_SUM_FIELD_NUMBER: builtins.int
    MONTH_FEE_SUM_FIELD_NUMBER: builtins.int
    day_fee_sum: builtins.int
    """The total amount of fee revenue (in satoshis) the switch has collected
    over the past 24 hrs.
    """
    week_fee_sum: builtins.int
    """The total amount of fee revenue (in satoshis) the switch has collected
    over the past 1 week.
    """
    month_fee_sum: builtins.int
    """The total amount of fee revenue (in satoshis) the switch has collected
    over the past 1 month.
    """
    @property
    def channel_fees(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelFeeReport]:
        """An array of channel fee reports which describes the current fee schedule
        for each channel.
        """

    def __init__(
        self,
        *,
        channel_fees: collections.abc.Iterable[global___ChannelFeeReport] | None = ...,
        day_fee_sum: builtins.int = ...,
        week_fee_sum: builtins.int = ...,
        month_fee_sum: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_fees", b"channel_fees", "day_fee_sum", b"day_fee_sum", "month_fee_sum", b"month_fee_sum", "week_fee_sum", b"week_fee_sum"]) -> None: ...

global___FeeReportResponse = FeeReportResponse

@typing.final
class InboundFee(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BASE_FEE_MSAT_FIELD_NUMBER: builtins.int
    FEE_RATE_PPM_FIELD_NUMBER: builtins.int
    base_fee_msat: builtins.int
    """The inbound base fee charged regardless of the number of milli-satoshis
    received in the channel. By default, only negative values are accepted.
    """
    fee_rate_ppm: builtins.int
    """The effective inbound fee rate in micro-satoshis (parts per million).
    By default, only negative values are accepted.
    """
    def __init__(
        self,
        *,
        base_fee_msat: builtins.int = ...,
        fee_rate_ppm: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["base_fee_msat", b"base_fee_msat", "fee_rate_ppm", b"fee_rate_ppm"]) -> None: ...

global___InboundFee = InboundFee

@typing.final
class PolicyUpdateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GLOBAL_FIELD_NUMBER: builtins.int
    CHAN_POINT_FIELD_NUMBER: builtins.int
    BASE_FEE_MSAT_FIELD_NUMBER: builtins.int
    FEE_RATE_FIELD_NUMBER: builtins.int
    FEE_RATE_PPM_FIELD_NUMBER: builtins.int
    TIME_LOCK_DELTA_FIELD_NUMBER: builtins.int
    MAX_HTLC_MSAT_FIELD_NUMBER: builtins.int
    MIN_HTLC_MSAT_FIELD_NUMBER: builtins.int
    MIN_HTLC_MSAT_SPECIFIED_FIELD_NUMBER: builtins.int
    INBOUND_FEE_FIELD_NUMBER: builtins.int
    base_fee_msat: builtins.int
    """The base fee charged regardless of the number of milli-satoshis sent."""
    fee_rate: builtins.float
    """The effective fee rate in milli-satoshis. The precision of this value
    goes up to 6 decimal places, so 1e-6.
    """
    fee_rate_ppm: builtins.int
    """The effective fee rate in micro-satoshis (parts per million)."""
    time_lock_delta: builtins.int
    """The required timelock delta for HTLCs forwarded over the channel."""
    max_htlc_msat: builtins.int
    """If set, the maximum HTLC size in milli-satoshis. If unset, the maximum
    HTLC will be unchanged.
    """
    min_htlc_msat: builtins.int
    """The minimum HTLC size in milli-satoshis. Only applied if
    min_htlc_msat_specified is true.
    """
    min_htlc_msat_specified: builtins.bool
    """If true, min_htlc_msat is applied."""
    @property
    def chan_point(self) -> global___ChannelPoint:
        """If set, this update will target a specific channel."""

    @property
    def inbound_fee(self) -> global___InboundFee:
        """Optional inbound fee. If unset, the previously set value will be
        retained [EXPERIMENTAL].
        """

    def __init__(
        self,
        *,
        chan_point: global___ChannelPoint | None = ...,
        base_fee_msat: builtins.int = ...,
        fee_rate: builtins.float = ...,
        fee_rate_ppm: builtins.int = ...,
        time_lock_delta: builtins.int = ...,
        max_htlc_msat: builtins.int = ...,
        min_htlc_msat: builtins.int = ...,
        min_htlc_msat_specified: builtins.bool = ...,
        inbound_fee: global___InboundFee | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["chan_point", b"chan_point", "global", b"global", "inbound_fee", b"inbound_fee", "scope", b"scope"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["base_fee_msat", b"base_fee_msat", "chan_point", b"chan_point", "fee_rate", b"fee_rate", "fee_rate_ppm", b"fee_rate_ppm", "global", b"global", "inbound_fee", b"inbound_fee", "max_htlc_msat", b"max_htlc_msat", "min_htlc_msat", b"min_htlc_msat", "min_htlc_msat_specified", b"min_htlc_msat_specified", "scope", b"scope", "time_lock_delta", b"time_lock_delta"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["scope", b"scope"]) -> typing.Literal["global", "chan_point"] | None: ...

global___PolicyUpdateRequest = PolicyUpdateRequest

@typing.final
class FailedUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPOINT_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    UPDATE_ERROR_FIELD_NUMBER: builtins.int
    reason: global___UpdateFailure.ValueType
    """Reason for the policy update failure."""
    update_error: builtins.str
    """A string representation of the policy update error."""
    @property
    def outpoint(self) -> global___OutPoint:
        """The outpoint in format txid:n"""

    def __init__(
        self,
        *,
        outpoint: global___OutPoint | None = ...,
        reason: global___UpdateFailure.ValueType = ...,
        update_error: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["outpoint", b"outpoint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["outpoint", b"outpoint", "reason", b"reason", "update_error", b"update_error"]) -> None: ...

global___FailedUpdate = FailedUpdate

@typing.final
class PolicyUpdateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FAILED_UPDATES_FIELD_NUMBER: builtins.int
    @property
    def failed_updates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FailedUpdate]:
        """List of failed policy updates."""

    def __init__(
        self,
        *,
        failed_updates: collections.abc.Iterable[global___FailedUpdate] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["failed_updates", b"failed_updates"]) -> None: ...

global___PolicyUpdateResponse = PolicyUpdateResponse

@typing.final
class ForwardingHistoryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    INDEX_OFFSET_FIELD_NUMBER: builtins.int
    NUM_MAX_EVENTS_FIELD_NUMBER: builtins.int
    PEER_ALIAS_LOOKUP_FIELD_NUMBER: builtins.int
    start_time: builtins.int
    """Start time is the starting point of the forwarding history request. All
    records beyond this point will be included, respecting the end time, and
    the index offset.
    """
    end_time: builtins.int
    """End time is the end point of the forwarding history request. The
    response will carry at most 50k records between the start time and the
    end time. The index offset can be used to implement pagination.
    """
    index_offset: builtins.int
    """Index offset is the offset in the time series to start at. As each
    response can only contain 50k records, callers can use this to skip
    around within a packed time series.
    """
    num_max_events: builtins.int
    """The max number of events to return in the response to this query."""
    peer_alias_lookup: builtins.bool
    """Informs the server if the peer alias should be looked up for each
    forwarding event.
    """
    def __init__(
        self,
        *,
        start_time: builtins.int = ...,
        end_time: builtins.int = ...,
        index_offset: builtins.int = ...,
        num_max_events: builtins.int = ...,
        peer_alias_lookup: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["end_time", b"end_time", "index_offset", b"index_offset", "num_max_events", b"num_max_events", "peer_alias_lookup", b"peer_alias_lookup", "start_time", b"start_time"]) -> None: ...

global___ForwardingHistoryRequest = ForwardingHistoryRequest

@typing.final
class ForwardingEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    CHAN_ID_IN_FIELD_NUMBER: builtins.int
    CHAN_ID_OUT_FIELD_NUMBER: builtins.int
    AMT_IN_FIELD_NUMBER: builtins.int
    AMT_OUT_FIELD_NUMBER: builtins.int
    FEE_FIELD_NUMBER: builtins.int
    FEE_MSAT_FIELD_NUMBER: builtins.int
    AMT_IN_MSAT_FIELD_NUMBER: builtins.int
    AMT_OUT_MSAT_FIELD_NUMBER: builtins.int
    TIMESTAMP_NS_FIELD_NUMBER: builtins.int
    PEER_ALIAS_IN_FIELD_NUMBER: builtins.int
    PEER_ALIAS_OUT_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp is the time (unix epoch offset) that this circuit was
    completed. Deprecated by timestamp_ns.
    """
    chan_id_in: builtins.int
    """The incoming channel ID that carried the HTLC that created the circuit."""
    chan_id_out: builtins.int
    """The outgoing channel ID that carried the preimage that completed the
    circuit.
    """
    amt_in: builtins.int
    """The total amount (in satoshis) of the incoming HTLC that created half
    the circuit.
    """
    amt_out: builtins.int
    """The total amount (in satoshis) of the outgoing HTLC that created the
    second half of the circuit.
    """
    fee: builtins.int
    """The total fee (in satoshis) that this payment circuit carried."""
    fee_msat: builtins.int
    """The total fee (in milli-satoshis) that this payment circuit carried."""
    amt_in_msat: builtins.int
    """The total amount (in milli-satoshis) of the incoming HTLC that created
    half the circuit.
    """
    amt_out_msat: builtins.int
    """The total amount (in milli-satoshis) of the outgoing HTLC that created
    the second half of the circuit.
    """
    timestamp_ns: builtins.int
    """The number of nanoseconds elapsed since January 1, 1970 UTC when this
    circuit was completed.
    """
    peer_alias_in: builtins.str
    """The peer alias of the incoming channel."""
    peer_alias_out: builtins.str
    """The peer alias of the outgoing channel."""
    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        chan_id_in: builtins.int = ...,
        chan_id_out: builtins.int = ...,
        amt_in: builtins.int = ...,
        amt_out: builtins.int = ...,
        fee: builtins.int = ...,
        fee_msat: builtins.int = ...,
        amt_in_msat: builtins.int = ...,
        amt_out_msat: builtins.int = ...,
        timestamp_ns: builtins.int = ...,
        peer_alias_in: builtins.str = ...,
        peer_alias_out: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["amt_in", b"amt_in", "amt_in_msat", b"amt_in_msat", "amt_out", b"amt_out", "amt_out_msat", b"amt_out_msat", "chan_id_in", b"chan_id_in", "chan_id_out", b"chan_id_out", "fee", b"fee", "fee_msat", b"fee_msat", "peer_alias_in", b"peer_alias_in", "peer_alias_out", b"peer_alias_out", "timestamp", b"timestamp", "timestamp_ns", b"timestamp_ns"]) -> None: ...

global___ForwardingEvent = ForwardingEvent

@typing.final
class ForwardingHistoryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FORWARDING_EVENTS_FIELD_NUMBER: builtins.int
    LAST_OFFSET_INDEX_FIELD_NUMBER: builtins.int
    last_offset_index: builtins.int
    """The index of the last time in the set of returned forwarding events. Can
    be used to seek further, pagination style.
    """
    @property
    def forwarding_events(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ForwardingEvent]:
        """A list of forwarding events from the time slice of the time series
        specified in the request.
        """

    def __init__(
        self,
        *,
        forwarding_events: collections.abc.Iterable[global___ForwardingEvent] | None = ...,
        last_offset_index: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["forwarding_events", b"forwarding_events", "last_offset_index", b"last_offset_index"]) -> None: ...

global___ForwardingHistoryResponse = ForwardingHistoryResponse

@typing.final
class ExportChannelBackupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_POINT_FIELD_NUMBER: builtins.int
    @property
    def chan_point(self) -> global___ChannelPoint:
        """The target channel point to obtain a back up for."""

    def __init__(
        self,
        *,
        chan_point: global___ChannelPoint | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["chan_point", b"chan_point"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["chan_point", b"chan_point"]) -> None: ...

global___ExportChannelBackupRequest = ExportChannelBackupRequest

@typing.final
class ChannelBackup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_POINT_FIELD_NUMBER: builtins.int
    CHAN_BACKUP_FIELD_NUMBER: builtins.int
    chan_backup: builtins.bytes
    """
    Is an encrypted single-chan backup. this can be passed to
    RestoreChannelBackups, or the WalletUnlocker Init and Unlock methods in
    order to trigger the recovery protocol. When using REST, this field must be
    encoded as base64.
    """
    @property
    def chan_point(self) -> global___ChannelPoint:
        """
        Identifies the channel that this backup belongs to.
        """

    def __init__(
        self,
        *,
        chan_point: global___ChannelPoint | None = ...,
        chan_backup: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["chan_point", b"chan_point"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["chan_backup", b"chan_backup", "chan_point", b"chan_point"]) -> None: ...

global___ChannelBackup = ChannelBackup

@typing.final
class MultiChanBackup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_POINTS_FIELD_NUMBER: builtins.int
    MULTI_CHAN_BACKUP_FIELD_NUMBER: builtins.int
    multi_chan_backup: builtins.bytes
    """
    A single encrypted blob containing all the static channel backups of the
    channel listed above. This can be stored as a single file or blob, and
    safely be replaced with any prior/future versions. When using REST, this
    field must be encoded as base64.
    """
    @property
    def chan_points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelPoint]:
        """
        Is the set of all channels that are included in this multi-channel backup.
        """

    def __init__(
        self,
        *,
        chan_points: collections.abc.Iterable[global___ChannelPoint] | None = ...,
        multi_chan_backup: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["chan_points", b"chan_points", "multi_chan_backup", b"multi_chan_backup"]) -> None: ...

global___MultiChanBackup = MultiChanBackup

@typing.final
class ChanBackupExportRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ChanBackupExportRequest = ChanBackupExportRequest

@typing.final
class ChanBackupSnapshot(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SINGLE_CHAN_BACKUPS_FIELD_NUMBER: builtins.int
    MULTI_CHAN_BACKUP_FIELD_NUMBER: builtins.int
    @property
    def single_chan_backups(self) -> global___ChannelBackups:
        """
        The set of new channels that have been added since the last channel backup
        snapshot was requested.
        """

    @property
    def multi_chan_backup(self) -> global___MultiChanBackup:
        """
        A multi-channel backup that covers all open channels currently known to
        lnd.
        """

    def __init__(
        self,
        *,
        single_chan_backups: global___ChannelBackups | None = ...,
        multi_chan_backup: global___MultiChanBackup | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["multi_chan_backup", b"multi_chan_backup", "single_chan_backups", b"single_chan_backups"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["multi_chan_backup", b"multi_chan_backup", "single_chan_backups", b"single_chan_backups"]) -> None: ...

global___ChanBackupSnapshot = ChanBackupSnapshot

@typing.final
class ChannelBackups(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_BACKUPS_FIELD_NUMBER: builtins.int
    @property
    def chan_backups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelBackup]:
        """
        A set of single-chan static channel backups.
        """

    def __init__(
        self,
        *,
        chan_backups: collections.abc.Iterable[global___ChannelBackup] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["chan_backups", b"chan_backups"]) -> None: ...

global___ChannelBackups = ChannelBackups

@typing.final
class RestoreChanBackupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_BACKUPS_FIELD_NUMBER: builtins.int
    MULTI_CHAN_BACKUP_FIELD_NUMBER: builtins.int
    multi_chan_backup: builtins.bytes
    """
    The channels to restore in the packed multi backup format. When using
    REST, this field must be encoded as base64.
    """
    @property
    def chan_backups(self) -> global___ChannelBackups:
        """
        The channels to restore as a list of channel/backup pairs.
        """

    def __init__(
        self,
        *,
        chan_backups: global___ChannelBackups | None = ...,
        multi_chan_backup: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["backup", b"backup", "chan_backups", b"chan_backups", "multi_chan_backup", b"multi_chan_backup"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backup", b"backup", "chan_backups", b"chan_backups", "multi_chan_backup", b"multi_chan_backup"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["backup", b"backup"]) -> typing.Literal["chan_backups", "multi_chan_backup"] | None: ...

global___RestoreChanBackupRequest = RestoreChanBackupRequest

@typing.final
class RestoreBackupResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RestoreBackupResponse = RestoreBackupResponse

@typing.final
class ChannelBackupSubscription(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ChannelBackupSubscription = ChannelBackupSubscription

@typing.final
class VerifyChanBackupResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___VerifyChanBackupResponse = VerifyChanBackupResponse

@typing.final
class MacaroonPermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    entity: builtins.str
    """The entity a permission grants access to."""
    action: builtins.str
    """The action that is granted."""
    def __init__(
        self,
        *,
        entity: builtins.str = ...,
        action: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "entity", b"entity"]) -> None: ...

global___MacaroonPermission = MacaroonPermission

@typing.final
class BakeMacaroonRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMISSIONS_FIELD_NUMBER: builtins.int
    ROOT_KEY_ID_FIELD_NUMBER: builtins.int
    ALLOW_EXTERNAL_PERMISSIONS_FIELD_NUMBER: builtins.int
    root_key_id: builtins.int
    """The root key ID used to create the macaroon, must be a positive integer."""
    allow_external_permissions: builtins.bool
    """
    Informs the RPC on whether to allow external permissions that LND is not
    aware of.
    """
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MacaroonPermission]:
        """The list of permissions the new macaroon should grant."""

    def __init__(
        self,
        *,
        permissions: collections.abc.Iterable[global___MacaroonPermission] | None = ...,
        root_key_id: builtins.int = ...,
        allow_external_permissions: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["allow_external_permissions", b"allow_external_permissions", "permissions", b"permissions", "root_key_id", b"root_key_id"]) -> None: ...

global___BakeMacaroonRequest = BakeMacaroonRequest

@typing.final
class BakeMacaroonResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MACAROON_FIELD_NUMBER: builtins.int
    macaroon: builtins.str
    """The hex encoded macaroon, serialized in binary format."""
    def __init__(
        self,
        *,
        macaroon: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["macaroon", b"macaroon"]) -> None: ...

global___BakeMacaroonResponse = BakeMacaroonResponse

@typing.final
class ListMacaroonIDsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListMacaroonIDsRequest = ListMacaroonIDsRequest

@typing.final
class ListMacaroonIDsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROOT_KEY_IDS_FIELD_NUMBER: builtins.int
    @property
    def root_key_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The list of root key IDs that are in use."""

    def __init__(
        self,
        *,
        root_key_ids: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["root_key_ids", b"root_key_ids"]) -> None: ...

global___ListMacaroonIDsResponse = ListMacaroonIDsResponse

@typing.final
class DeleteMacaroonIDRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROOT_KEY_ID_FIELD_NUMBER: builtins.int
    root_key_id: builtins.int
    """The root key ID to be removed."""
    def __init__(
        self,
        *,
        root_key_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["root_key_id", b"root_key_id"]) -> None: ...

global___DeleteMacaroonIDRequest = DeleteMacaroonIDRequest

@typing.final
class DeleteMacaroonIDResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DELETED_FIELD_NUMBER: builtins.int
    deleted: builtins.bool
    """A boolean indicates that the deletion is successful."""
    def __init__(
        self,
        *,
        deleted: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deleted", b"deleted"]) -> None: ...

global___DeleteMacaroonIDResponse = DeleteMacaroonIDResponse

@typing.final
class MacaroonPermissionList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMISSIONS_FIELD_NUMBER: builtins.int
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MacaroonPermission]:
        """A list of macaroon permissions."""

    def __init__(
        self,
        *,
        permissions: collections.abc.Iterable[global___MacaroonPermission] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["permissions", b"permissions"]) -> None: ...

global___MacaroonPermissionList = MacaroonPermissionList

@typing.final
class ListPermissionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListPermissionsRequest = ListPermissionsRequest

@typing.final
class ListPermissionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MethodPermissionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___MacaroonPermissionList: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___MacaroonPermissionList | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    METHOD_PERMISSIONS_FIELD_NUMBER: builtins.int
    @property
    def method_permissions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___MacaroonPermissionList]:
        """
        A map between all RPC method URIs and their required macaroon permissions to
        access them.
        """

    def __init__(
        self,
        *,
        method_permissions: collections.abc.Mapping[builtins.str, global___MacaroonPermissionList] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["method_permissions", b"method_permissions"]) -> None: ...

global___ListPermissionsResponse = ListPermissionsResponse

@typing.final
class Failure(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _FailureCode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _FailureCodeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Failure._FailureCode.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        RESERVED: Failure._FailureCode.ValueType  # 0
        """
        The numbers assigned in this enumeration match the failure codes as
        defined in BOLT #4. Because protobuf 3 requires enums to start with 0,
        a RESERVED value is added.
        """
        INCORRECT_OR_UNKNOWN_PAYMENT_DETAILS: Failure._FailureCode.ValueType  # 1
        INCORRECT_PAYMENT_AMOUNT: Failure._FailureCode.ValueType  # 2
        FINAL_INCORRECT_CLTV_EXPIRY: Failure._FailureCode.ValueType  # 3
        FINAL_INCORRECT_HTLC_AMOUNT: Failure._FailureCode.ValueType  # 4
        FINAL_EXPIRY_TOO_SOON: Failure._FailureCode.ValueType  # 5
        INVALID_REALM: Failure._FailureCode.ValueType  # 6
        EXPIRY_TOO_SOON: Failure._FailureCode.ValueType  # 7
        INVALID_ONION_VERSION: Failure._FailureCode.ValueType  # 8
        INVALID_ONION_HMAC: Failure._FailureCode.ValueType  # 9
        INVALID_ONION_KEY: Failure._FailureCode.ValueType  # 10
        AMOUNT_BELOW_MINIMUM: Failure._FailureCode.ValueType  # 11
        FEE_INSUFFICIENT: Failure._FailureCode.ValueType  # 12
        INCORRECT_CLTV_EXPIRY: Failure._FailureCode.ValueType  # 13
        CHANNEL_DISABLED: Failure._FailureCode.ValueType  # 14
        TEMPORARY_CHANNEL_FAILURE: Failure._FailureCode.ValueType  # 15
        REQUIRED_NODE_FEATURE_MISSING: Failure._FailureCode.ValueType  # 16
        REQUIRED_CHANNEL_FEATURE_MISSING: Failure._FailureCode.ValueType  # 17
        UNKNOWN_NEXT_PEER: Failure._FailureCode.ValueType  # 18
        TEMPORARY_NODE_FAILURE: Failure._FailureCode.ValueType  # 19
        PERMANENT_NODE_FAILURE: Failure._FailureCode.ValueType  # 20
        PERMANENT_CHANNEL_FAILURE: Failure._FailureCode.ValueType  # 21
        EXPIRY_TOO_FAR: Failure._FailureCode.ValueType  # 22
        MPP_TIMEOUT: Failure._FailureCode.ValueType  # 23
        INVALID_ONION_PAYLOAD: Failure._FailureCode.ValueType  # 24
        INVALID_ONION_BLINDING: Failure._FailureCode.ValueType  # 25
        INTERNAL_FAILURE: Failure._FailureCode.ValueType  # 997
        """
        An internal error occurred.
        """
        UNKNOWN_FAILURE: Failure._FailureCode.ValueType  # 998
        """
        The error source is known, but the failure itself couldn't be decoded.
        """
        UNREADABLE_FAILURE: Failure._FailureCode.ValueType  # 999
        """
        An unreadable failure result is returned if the received failure message
        cannot be decrypted. In that case the error source is unknown.
        """

    class FailureCode(_FailureCode, metaclass=_FailureCodeEnumTypeWrapper): ...
    RESERVED: Failure.FailureCode.ValueType  # 0
    """
    The numbers assigned in this enumeration match the failure codes as
    defined in BOLT #4. Because protobuf 3 requires enums to start with 0,
    a RESERVED value is added.
    """
    INCORRECT_OR_UNKNOWN_PAYMENT_DETAILS: Failure.FailureCode.ValueType  # 1
    INCORRECT_PAYMENT_AMOUNT: Failure.FailureCode.ValueType  # 2
    FINAL_INCORRECT_CLTV_EXPIRY: Failure.FailureCode.ValueType  # 3
    FINAL_INCORRECT_HTLC_AMOUNT: Failure.FailureCode.ValueType  # 4
    FINAL_EXPIRY_TOO_SOON: Failure.FailureCode.ValueType  # 5
    INVALID_REALM: Failure.FailureCode.ValueType  # 6
    EXPIRY_TOO_SOON: Failure.FailureCode.ValueType  # 7
    INVALID_ONION_VERSION: Failure.FailureCode.ValueType  # 8
    INVALID_ONION_HMAC: Failure.FailureCode.ValueType  # 9
    INVALID_ONION_KEY: Failure.FailureCode.ValueType  # 10
    AMOUNT_BELOW_MINIMUM: Failure.FailureCode.ValueType  # 11
    FEE_INSUFFICIENT: Failure.FailureCode.ValueType  # 12
    INCORRECT_CLTV_EXPIRY: Failure.FailureCode.ValueType  # 13
    CHANNEL_DISABLED: Failure.FailureCode.ValueType  # 14
    TEMPORARY_CHANNEL_FAILURE: Failure.FailureCode.ValueType  # 15
    REQUIRED_NODE_FEATURE_MISSING: Failure.FailureCode.ValueType  # 16
    REQUIRED_CHANNEL_FEATURE_MISSING: Failure.FailureCode.ValueType  # 17
    UNKNOWN_NEXT_PEER: Failure.FailureCode.ValueType  # 18
    TEMPORARY_NODE_FAILURE: Failure.FailureCode.ValueType  # 19
    PERMANENT_NODE_FAILURE: Failure.FailureCode.ValueType  # 20
    PERMANENT_CHANNEL_FAILURE: Failure.FailureCode.ValueType  # 21
    EXPIRY_TOO_FAR: Failure.FailureCode.ValueType  # 22
    MPP_TIMEOUT: Failure.FailureCode.ValueType  # 23
    INVALID_ONION_PAYLOAD: Failure.FailureCode.ValueType  # 24
    INVALID_ONION_BLINDING: Failure.FailureCode.ValueType  # 25
    INTERNAL_FAILURE: Failure.FailureCode.ValueType  # 997
    """
    An internal error occurred.
    """
    UNKNOWN_FAILURE: Failure.FailureCode.ValueType  # 998
    """
    The error source is known, but the failure itself couldn't be decoded.
    """
    UNREADABLE_FAILURE: Failure.FailureCode.ValueType  # 999
    """
    An unreadable failure result is returned if the received failure message
    cannot be decrypted. In that case the error source is unknown.
    """

    CODE_FIELD_NUMBER: builtins.int
    CHANNEL_UPDATE_FIELD_NUMBER: builtins.int
    HTLC_MSAT_FIELD_NUMBER: builtins.int
    ONION_SHA_256_FIELD_NUMBER: builtins.int
    CLTV_EXPIRY_FIELD_NUMBER: builtins.int
    FLAGS_FIELD_NUMBER: builtins.int
    FAILURE_SOURCE_INDEX_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    code: global___Failure.FailureCode.ValueType
    """Failure code as defined in the Lightning spec"""
    htlc_msat: builtins.int
    """A failure type-dependent htlc value."""
    onion_sha_256: builtins.bytes
    """The sha256 sum of the onion payload."""
    cltv_expiry: builtins.int
    """A failure type-dependent cltv expiry value."""
    flags: builtins.int
    """A failure type-dependent flags value."""
    failure_source_index: builtins.int
    """
    The position in the path of the intermediate or final node that generated
    the failure message. Position zero is the sender node.
    """
    height: builtins.int
    """A failure type-dependent block height."""
    @property
    def channel_update(self) -> global___ChannelUpdate:
        """An optional channel update message."""

    def __init__(
        self,
        *,
        code: global___Failure.FailureCode.ValueType = ...,
        channel_update: global___ChannelUpdate | None = ...,
        htlc_msat: builtins.int = ...,
        onion_sha_256: builtins.bytes = ...,
        cltv_expiry: builtins.int = ...,
        flags: builtins.int = ...,
        failure_source_index: builtins.int = ...,
        height: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["channel_update", b"channel_update"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_update", b"channel_update", "cltv_expiry", b"cltv_expiry", "code", b"code", "failure_source_index", b"failure_source_index", "flags", b"flags", "height", b"height", "htlc_msat", b"htlc_msat", "onion_sha_256", b"onion_sha_256"]) -> None: ...

global___Failure = Failure

@typing.final
class ChannelUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNATURE_FIELD_NUMBER: builtins.int
    CHAIN_HASH_FIELD_NUMBER: builtins.int
    CHAN_ID_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    MESSAGE_FLAGS_FIELD_NUMBER: builtins.int
    CHANNEL_FLAGS_FIELD_NUMBER: builtins.int
    TIME_LOCK_DELTA_FIELD_NUMBER: builtins.int
    HTLC_MINIMUM_MSAT_FIELD_NUMBER: builtins.int
    BASE_FEE_FIELD_NUMBER: builtins.int
    FEE_RATE_FIELD_NUMBER: builtins.int
    HTLC_MAXIMUM_MSAT_FIELD_NUMBER: builtins.int
    EXTRA_OPAQUE_DATA_FIELD_NUMBER: builtins.int
    signature: builtins.bytes
    """
    The signature that validates the announced data and proves the ownership
    of node id.
    """
    chain_hash: builtins.bytes
    """
    The target chain that this channel was opened within. This value
    should be the genesis hash of the target chain. Along with the short
    channel ID, this uniquely identifies the channel globally in a
    blockchain.
    """
    chan_id: builtins.int
    """
    The unique description of the funding transaction.
    """
    timestamp: builtins.int
    """
    A timestamp that allows ordering in the case of multiple announcements.
    We should ignore the message if timestamp is not greater than the
    last-received.
    """
    message_flags: builtins.int
    """
    The bitfield that describes whether optional fields are present in this
    update. Currently, the least-significant bit must be set to 1 if the
    optional field MaxHtlc is present.
    """
    channel_flags: builtins.int
    """
    The bitfield that describes additional meta-data concerning how the
    update is to be interpreted. Currently, the least-significant bit must be
    set to 0 if the creating node corresponds to the first node in the
    previously sent channel announcement and 1 otherwise. If the second bit
    is set, then the channel is set to be disabled.
    """
    time_lock_delta: builtins.int
    """
    The minimum number of blocks this node requires to be added to the expiry
    of HTLCs. This is a security parameter determined by the node operator.
    This value represents the required gap between the time locks of the
    incoming and outgoing HTLC's set to this node.
    """
    htlc_minimum_msat: builtins.int
    """
    The minimum HTLC value which will be accepted.
    """
    base_fee: builtins.int
    """
    The base fee that must be used for incoming HTLC's to this particular
    channel. This value will be tacked onto the required for a payment
    independent of the size of the payment.
    """
    fee_rate: builtins.int
    """
    The fee rate that will be charged per millionth of a satoshi.
    """
    htlc_maximum_msat: builtins.int
    """
    The maximum HTLC value which will be accepted.
    """
    extra_opaque_data: builtins.bytes
    """
    The set of data that was appended to this message, some of which we may
    not actually know how to iterate or parse. By holding onto this data, we
    ensure that we're able to properly validate the set of signatures that
    cover these new fields, and ensure we're able to make upgrades to the
    network in a forwards compatible manner.
    """
    def __init__(
        self,
        *,
        signature: builtins.bytes = ...,
        chain_hash: builtins.bytes = ...,
        chan_id: builtins.int = ...,
        timestamp: builtins.int = ...,
        message_flags: builtins.int = ...,
        channel_flags: builtins.int = ...,
        time_lock_delta: builtins.int = ...,
        htlc_minimum_msat: builtins.int = ...,
        base_fee: builtins.int = ...,
        fee_rate: builtins.int = ...,
        htlc_maximum_msat: builtins.int = ...,
        extra_opaque_data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["base_fee", b"base_fee", "chain_hash", b"chain_hash", "chan_id", b"chan_id", "channel_flags", b"channel_flags", "extra_opaque_data", b"extra_opaque_data", "fee_rate", b"fee_rate", "htlc_maximum_msat", b"htlc_maximum_msat", "htlc_minimum_msat", b"htlc_minimum_msat", "message_flags", b"message_flags", "signature", b"signature", "time_lock_delta", b"time_lock_delta", "timestamp", b"timestamp"]) -> None: ...

global___ChannelUpdate = ChannelUpdate

@typing.final
class MacaroonId(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NONCE_FIELD_NUMBER: builtins.int
    STORAGEID_FIELD_NUMBER: builtins.int
    OPS_FIELD_NUMBER: builtins.int
    nonce: builtins.bytes
    storageId: builtins.bytes
    @property
    def ops(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Op]: ...
    def __init__(
        self,
        *,
        nonce: builtins.bytes = ...,
        storageId: builtins.bytes = ...,
        ops: collections.abc.Iterable[global___Op] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["nonce", b"nonce", "ops", b"ops", "storageId", b"storageId"]) -> None: ...

global___MacaroonId = MacaroonId

@typing.final
class Op(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    ACTIONS_FIELD_NUMBER: builtins.int
    entity: builtins.str
    @property
    def actions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        entity: builtins.str = ...,
        actions: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["actions", b"actions", "entity", b"entity"]) -> None: ...

global___Op = Op

@typing.final
class CheckMacPermRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MACAROON_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    FULLMETHOD_FIELD_NUMBER: builtins.int
    macaroon: builtins.bytes
    fullMethod: builtins.str
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MacaroonPermission]: ...
    def __init__(
        self,
        *,
        macaroon: builtins.bytes = ...,
        permissions: collections.abc.Iterable[global___MacaroonPermission] | None = ...,
        fullMethod: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["fullMethod", b"fullMethod", "macaroon", b"macaroon", "permissions", b"permissions"]) -> None: ...

global___CheckMacPermRequest = CheckMacPermRequest

@typing.final
class CheckMacPermResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALID_FIELD_NUMBER: builtins.int
    valid: builtins.bool
    def __init__(
        self,
        *,
        valid: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["valid", b"valid"]) -> None: ...

global___CheckMacPermResponse = CheckMacPermResponse

@typing.final
class RPCMiddlewareRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    RAW_MACAROON_FIELD_NUMBER: builtins.int
    CUSTOM_CAVEAT_CONDITION_FIELD_NUMBER: builtins.int
    STREAM_AUTH_FIELD_NUMBER: builtins.int
    REQUEST_FIELD_NUMBER: builtins.int
    RESPONSE_FIELD_NUMBER: builtins.int
    REG_COMPLETE_FIELD_NUMBER: builtins.int
    MSG_ID_FIELD_NUMBER: builtins.int
    request_id: builtins.int
    """
    The unique ID of the intercepted original gRPC request. Useful for mapping
    request to response when implementing full duplex message interception. For
    streaming requests, this will be the same ID for all incoming and outgoing
    middleware intercept messages of the _same_ stream.
    """
    raw_macaroon: builtins.bytes
    """
    The raw bytes of the complete macaroon as sent by the gRPC client in the
    original request. This might be empty for a request that doesn't require
    macaroons such as the wallet unlocker RPCs.
    """
    custom_caveat_condition: builtins.str
    """
    The parsed condition of the macaroon's custom caveat for convenient access.
    This field only contains the value of the custom caveat that the handling
    middleware has registered itself for. The condition _must_ be validated for
    messages of intercept_type stream_auth and request!
    """
    reg_complete: builtins.bool
    """
    This is used to indicate to the client that the server has successfully
    registered the interceptor. This is only used in the very first message
    that the server sends to the client after the client sends the server
    the middleware registration message.
    """
    msg_id: builtins.int
    """
    The unique message ID of this middleware intercept message. There can be
    multiple middleware intercept messages per single gRPC request (one for the
    incoming request and one for the outgoing response) or gRPC stream (one for
    each incoming message and one for each outgoing response). This message ID
    must be referenced when responding (accepting/rejecting/modifying) to an
    intercept message.
    """
    @property
    def stream_auth(self) -> global___StreamAuth:
        """
        Intercept stream authentication: each new streaming RPC call that is
        initiated against lnd and contains the middleware's custom macaroon
        caveat can be approved or denied based upon the macaroon in the stream
        header. This message will only be sent for streaming RPCs, unary RPCs
        must handle the macaroon authentication in the request interception to
        avoid an additional message round trip between lnd and the middleware.
        """

    @property
    def request(self) -> global___RPCMessage:
        """
        Intercept incoming gRPC client request message: all incoming messages,
        both on streaming and unary RPCs, are forwarded to the middleware for
        inspection. For unary RPC messages the middleware is also expected to
        validate the custom macaroon caveat of the request.
        """

    @property
    def response(self) -> global___RPCMessage:
        """
        Intercept outgoing gRPC response message: all outgoing messages, both on
        streaming and unary RPCs, are forwarded to the middleware for inspection
        and amendment. The response in this message is the original response as
        it was generated by the main RPC server. It can either be accepted
        (=forwarded to the client), replaced/overwritten with a new message of
        the same type, or replaced by an error message.
        """

    def __init__(
        self,
        *,
        request_id: builtins.int = ...,
        raw_macaroon: builtins.bytes = ...,
        custom_caveat_condition: builtins.str = ...,
        stream_auth: global___StreamAuth | None = ...,
        request: global___RPCMessage | None = ...,
        response: global___RPCMessage | None = ...,
        reg_complete: builtins.bool = ...,
        msg_id: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["intercept_type", b"intercept_type", "reg_complete", b"reg_complete", "request", b"request", "response", b"response", "stream_auth", b"stream_auth"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["custom_caveat_condition", b"custom_caveat_condition", "intercept_type", b"intercept_type", "msg_id", b"msg_id", "raw_macaroon", b"raw_macaroon", "reg_complete", b"reg_complete", "request", b"request", "request_id", b"request_id", "response", b"response", "stream_auth", b"stream_auth"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["intercept_type", b"intercept_type"]) -> typing.Literal["stream_auth", "request", "response", "reg_complete"] | None: ...

global___RPCMiddlewareRequest = RPCMiddlewareRequest

@typing.final
class StreamAuth(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METHOD_FULL_URI_FIELD_NUMBER: builtins.int
    method_full_uri: builtins.str
    """
    The full URI (in the format /<rpcpackage>.<ServiceName>/MethodName, for
    example /lnrpc.Lightning/GetInfo) of the streaming RPC method that was just
    established.
    """
    def __init__(
        self,
        *,
        method_full_uri: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["method_full_uri", b"method_full_uri"]) -> None: ...

global___StreamAuth = StreamAuth

@typing.final
class RPCMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METHOD_FULL_URI_FIELD_NUMBER: builtins.int
    STREAM_RPC_FIELD_NUMBER: builtins.int
    TYPE_NAME_FIELD_NUMBER: builtins.int
    SERIALIZED_FIELD_NUMBER: builtins.int
    IS_ERROR_FIELD_NUMBER: builtins.int
    method_full_uri: builtins.str
    """
    The full URI (in the format /<rpcpackage>.<ServiceName>/MethodName, for
    example /lnrpc.Lightning/GetInfo) of the RPC method the message was sent
    to/from.
    """
    stream_rpc: builtins.bool
    """
    Indicates whether the message was sent over a streaming RPC method or not.
    """
    type_name: builtins.str
    """
    The full canonical gRPC name of the message type (in the format
    <rpcpackage>.TypeName, for example lnrpc.GetInfoRequest). In case of an
    error being returned from lnd, this simply contains the string "error".
    """
    serialized: builtins.bytes
    """
    The full content of the gRPC message, serialized in the binary protobuf
    format.
    """
    is_error: builtins.bool
    """
    Indicates that the response from lnd was an error, not a gRPC response. If
    this is set to true then the type_name contains the string "error" and
    serialized contains the error string.
    """
    def __init__(
        self,
        *,
        method_full_uri: builtins.str = ...,
        stream_rpc: builtins.bool = ...,
        type_name: builtins.str = ...,
        serialized: builtins.bytes = ...,
        is_error: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["is_error", b"is_error", "method_full_uri", b"method_full_uri", "serialized", b"serialized", "stream_rpc", b"stream_rpc", "type_name", b"type_name"]) -> None: ...

global___RPCMessage = RPCMessage

@typing.final
class RPCMiddlewareResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REF_MSG_ID_FIELD_NUMBER: builtins.int
    REGISTER_FIELD_NUMBER: builtins.int
    FEEDBACK_FIELD_NUMBER: builtins.int
    ref_msg_id: builtins.int
    """
    The request message ID this response refers to. Must always be set when
    giving feedback to an intercept but is ignored for the initial registration
    message.
    """
    @property
    def register(self) -> global___MiddlewareRegistration:
        """
        The registration message identifies the middleware that's being
        registered in lnd. The registration message must be sent immediately
        after initiating the RegisterRpcMiddleware stream, otherwise lnd will
        time out the attempt and terminate the request. NOTE: The middleware
        will only receive interception messages for requests that contain a
        macaroon with the custom caveat that the middleware declares it is
        responsible for handling in the registration message! As a security
        measure, _no_ middleware can intercept requests made with _unencumbered_
        macaroons!
        """

    @property
    def feedback(self) -> global___InterceptFeedback:
        """
        The middleware received an interception request and gives feedback to
        it. The request_id indicates what message the feedback refers to.
        """

    def __init__(
        self,
        *,
        ref_msg_id: builtins.int = ...,
        register: global___MiddlewareRegistration | None = ...,
        feedback: global___InterceptFeedback | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["feedback", b"feedback", "middleware_message", b"middleware_message", "register", b"register"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["feedback", b"feedback", "middleware_message", b"middleware_message", "ref_msg_id", b"ref_msg_id", "register", b"register"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["middleware_message", b"middleware_message"]) -> typing.Literal["register", "feedback"] | None: ...

global___RPCMiddlewareResponse = RPCMiddlewareResponse

@typing.final
class MiddlewareRegistration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIDDLEWARE_NAME_FIELD_NUMBER: builtins.int
    CUSTOM_MACAROON_CAVEAT_NAME_FIELD_NUMBER: builtins.int
    READ_ONLY_MODE_FIELD_NUMBER: builtins.int
    middleware_name: builtins.str
    """
    The name of the middleware to register. The name should be as informative
    as possible and is logged on registration.
    """
    custom_macaroon_caveat_name: builtins.str
    """
    The name of the custom macaroon caveat that this middleware is responsible
    for. Only requests/responses that contain a macaroon with the registered
    custom caveat are forwarded for interception to the middleware. The
    exception being the read-only mode: All requests/responses are forwarded to
    a middleware that requests read-only access but such a middleware won't be
    allowed to _alter_ responses. As a security measure, _no_ middleware can
    change responses to requests made with _unencumbered_ macaroons!
    NOTE: Cannot be used at the same time as read_only_mode.
    """
    read_only_mode: builtins.bool
    """
    Instead of defining a custom macaroon caveat name a middleware can register
    itself for read-only access only. In that mode all requests/responses are
    forwarded to the middleware but the middleware isn't allowed to alter any of
    the responses.
    NOTE: Cannot be used at the same time as custom_macaroon_caveat_name.
    """
    def __init__(
        self,
        *,
        middleware_name: builtins.str = ...,
        custom_macaroon_caveat_name: builtins.str = ...,
        read_only_mode: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["custom_macaroon_caveat_name", b"custom_macaroon_caveat_name", "middleware_name", b"middleware_name", "read_only_mode", b"read_only_mode"]) -> None: ...

global___MiddlewareRegistration = MiddlewareRegistration

@typing.final
class InterceptFeedback(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ERROR_FIELD_NUMBER: builtins.int
    REPLACE_RESPONSE_FIELD_NUMBER: builtins.int
    REPLACEMENT_SERIALIZED_FIELD_NUMBER: builtins.int
    error: builtins.str
    """
    The error to return to the user. If this is non-empty, the incoming gRPC
    stream/request is aborted and the error is returned to the gRPC client. If
    this value is empty, it means the middleware accepts the stream/request/
    response and the processing of it can continue.
    """
    replace_response: builtins.bool
    """
    A boolean indicating that the gRPC message should be replaced/overwritten.
    This boolean is needed because in protobuf an empty message is serialized as
    a 0-length or nil byte slice and we wouldn't be able to distinguish between
    an empty replacement message and the "don't replace anything" case.
    """
    replacement_serialized: builtins.bytes
    """
    If the replace_response field is set to true, this field must contain the
    binary serialized gRPC message in the protobuf format.
    """
    def __init__(
        self,
        *,
        error: builtins.str = ...,
        replace_response: builtins.bool = ...,
        replacement_serialized: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["error", b"error", "replace_response", b"replace_response", "replacement_serialized", b"replacement_serialized"]) -> None: ...

global___InterceptFeedback = InterceptFeedback
