"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import collections.abc
import typing

import grpc
import grpc.aio

import cashu.lightning.lnd_grpc.protos.lightning_pb2

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class LightningStub:
    """
    Comments in this file will be directly parsed into the API
    Documentation as descriptions of the associated method, message, or field.
    These descriptions should go right above the definition of the object, and
    can be in either block or // comment format.

    An RPC method can be matched to an lncli command by placing a line in the
    beginning of the description in exactly the following format:
    lncli: `methodname`

    Failure to specify the exact name of the command will cause documentation
    generation to fail.

    More information on how exactly the gRPC documentation is generated from
    this proto file can be found here:
    https://github.com/lightninglabs/lightning-api

    Lightning is the main RPC server of the daemon.
    """

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    WalletBalance: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.WalletBalanceRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.WalletBalanceResponse,
    ]
    """lncli: `walletbalance`
    WalletBalance returns total unspent outputs(confirmed and unconfirmed), all
    confirmed unspent outputs and all unconfirmed unspent outputs under control
    of the wallet.
    """

    ChannelBalance: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBalanceRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBalanceResponse,
    ]
    """lncli: `channelbalance`
    ChannelBalance returns a report on the total funds across all open channels,
    categorized in local/remote, pending local/remote and unsettled local/remote
    balances.
    """

    GetTransactions: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetTransactionsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.TransactionDetails,
    ]
    """lncli: `listchaintxns`
    GetTransactions returns a list describing all the known transactions
    relevant to the wallet.
    """

    EstimateFee: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.EstimateFeeRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.EstimateFeeResponse,
    ]
    """lncli: `estimatefee`
    EstimateFee asks the chain backend to estimate the fee rate and total fees
    for a transaction that pays to multiple specified outputs.

    When using REST, the `AddrToAmount` map type can be set by appending
    `&AddrToAmount[<address>]=<amount_to_send>` to the URL. Unfortunately this
    map type doesn't appear in the REST API documentation because of a bug in
    the grpc-gateway library.
    """

    SendCoins: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCoinsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCoinsResponse,
    ]
    """lncli: `sendcoins`
    SendCoins executes a request to send coins to a particular address. Unlike
    SendMany, this RPC call only allows creating a single output at a time. If
    neither target_conf, or sat_per_vbyte are set, then the internal wallet will
    consult its fee model to determine a fee for the default confirmation
    target.
    """

    ListUnspent: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListUnspentRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListUnspentResponse,
    ]
    """lncli: `listunspent`
    Deprecated, use walletrpc.ListUnspent instead.

    ListUnspent returns a list of all utxos spendable by the wallet with a
    number of confirmations between the specified minimum and maximum.
    """

    SubscribeTransactions: grpc.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetTransactionsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.Transaction,
    ]
    """
    SubscribeTransactions creates a uni-directional stream from the server to
    the client in which any newly discovered transactions relevant to the
    wallet are sent over.
    """

    SendMany: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendManyRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendManyResponse,
    ]
    """lncli: `sendmany`
    SendMany handles a request for a transaction that creates multiple specified
    outputs in parallel. If neither target_conf, or sat_per_vbyte are set, then
    the internal wallet will consult its fee model to determine a fee for the
    default confirmation target.
    """

    NewAddress: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NewAddressRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NewAddressResponse,
    ]
    """lncli: `newaddress`
    NewAddress creates a new address under control of the local wallet.
    """

    SignMessage: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SignMessageRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SignMessageResponse,
    ]
    """lncli: `signmessage`
    SignMessage signs a message with this node's private key. The returned
    signature string is `zbase32` encoded and pubkey recoverable, meaning that
    only the message digest and signature are needed for verification.
    """

    VerifyMessage: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.VerifyMessageRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.VerifyMessageResponse,
    ]
    """lncli: `verifymessage`
    VerifyMessage verifies a signature over a message and recovers the signer's
    public key. The signature is only deemed valid if the recovered public key
    corresponds to a node key in the public Lightning network. The signature
    must be zbase32 encoded and signed by an active node in the resident node's
    channel database. In addition to returning the validity of the signature,
    VerifyMessage also returns the recovered pubkey from the signature.
    """

    ConnectPeer: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ConnectPeerRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ConnectPeerResponse,
    ]
    """lncli: `connect`
    ConnectPeer attempts to establish a connection to a remote peer. This is at
    the networking level, and is used for communication between nodes. This is
    distinct from establishing a channel with a peer.
    """

    DisconnectPeer: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DisconnectPeerRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DisconnectPeerResponse,
    ]
    """lncli: `disconnect`
    DisconnectPeer attempts to disconnect one peer from another identified by a
    given pubKey. In the case that we currently have a pending or active channel
    with the target peer, then this action will be not be allowed.
    """

    ListPeers: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPeersRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPeersResponse,
    ]
    """lncli: `listpeers`
    ListPeers returns a verbose listing of all currently active peers.
    """

    SubscribePeerEvents: grpc.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PeerEventSubscription,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PeerEvent,
    ]
    """
    SubscribePeerEvents creates a uni-directional stream from the server to
    the client in which any events relevant to the state of peers are sent
    over. Events include peers going online and offline.
    """

    GetInfo: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetInfoRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetInfoResponse,
    ]
    """lncli: `getinfo`
    GetInfo returns general information concerning the lightning node including
    it's identity pubkey, alias, the chains it is connected to, and information
    concerning the number of open+pending channels.
    """

    GetDebugInfo: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetDebugInfoRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetDebugInfoResponse,
    ]
    """lncli: 'getdebuginfo'
    GetDebugInfo returns debug information concerning the state of the daemon
    and its subsystems. This includes the full configuration and the latest log
    entries from the log file.
    """

    GetRecoveryInfo: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetRecoveryInfoRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetRecoveryInfoResponse,
    ]
    """* lncli: `getrecoveryinfo`
    GetRecoveryInfo returns information concerning the recovery mode including
    whether it's in a recovery mode, whether the recovery is finished, and the
    progress made so far.
    """

    PendingChannels: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PendingChannelsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PendingChannelsResponse,
    ]
    """TODO(roasbeef): merge with below with bool?

    lncli: `pendingchannels`
    PendingChannels returns a list of all the channels that are currently
    considered "pending". A channel is pending if it has finished the funding
    workflow and is waiting for confirmations for the funding txn, or is in the
    process of closure, either initiated cooperatively or non-cooperatively.
    """

    ListChannels: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListChannelsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListChannelsResponse,
    ]
    """lncli: `listchannels`
    ListChannels returns a description of all the open channels that this node
    is a participant in.
    """

    SubscribeChannelEvents: grpc.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelEventSubscription,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelEventUpdate,
    ]
    """
    SubscribeChannelEvents creates a uni-directional stream from the server to
    the client in which any updates relevant to the state of the channels are
    sent over. Events include new active channels, inactive channels, and closed
    channels.
    """

    ClosedChannels: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ClosedChannelsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ClosedChannelsResponse,
    ]
    """lncli: `closedchannels`
    ClosedChannels returns a description of all the closed channels that
    this node was a participant in.
    """

    OpenChannelSync: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.OpenChannelRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelPoint,
    ]
    """
    OpenChannelSync is a synchronous version of the OpenChannel RPC call. This
    call is meant to be consumed by clients to the REST proxy. As with all
    other sync calls, all byte slices are intended to be populated as hex
    encoded strings.
    """

    OpenChannel: grpc.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.OpenChannelRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.OpenStatusUpdate,
    ]
    """lncli: `openchannel`
    OpenChannel attempts to open a singly funded channel specified in the
    request to a remote peer. Users are able to specify a target number of
    blocks that the funding transaction should be confirmed in, or a manual fee
    rate to us for the funding transaction. If neither are specified, then a
    lax block confirmation target is used. Each OpenStatusUpdate will return
    the pending channel ID of the in-progress channel. Depending on the
    arguments specified in the OpenChannelRequest, this pending channel ID can
    then be used to manually progress the channel funding flow.
    """

    BatchOpenChannel: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.BatchOpenChannelRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.BatchOpenChannelResponse,
    ]
    """lncli: `batchopenchannel`
    BatchOpenChannel attempts to open multiple single-funded channels in a
    single transaction in an atomic way. This means either all channel open
    requests succeed at once or all attempts are aborted if any of them fail.
    This is the safer variant of using PSBTs to manually fund a batch of
    channels through the OpenChannel RPC.
    """

    FundingStateStep: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.FundingTransitionMsg,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.FundingStateStepResp,
    ]
    """
    FundingStateStep is an advanced funding related call that allows the caller
    to either execute some preparatory steps for a funding workflow, or
    manually progress a funding workflow. The primary way a funding flow is
    identified is via its pending channel ID. As an example, this method can be
    used to specify that we're expecting a funding flow for a particular
    pending channel ID, for which we need to use specific parameters.
    Alternatively, this can be used to interactively drive PSBT signing for
    funding for partially complete funding transactions.
    """

    ChannelAcceptor: grpc.StreamStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelAcceptResponse,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelAcceptRequest,
    ]
    """
    ChannelAcceptor dispatches a bi-directional streaming RPC in which
    OpenChannel requests are sent to the client and the client responds with
    a boolean that tells LND whether or not to accept the channel. This allows
    node operators to specify their own criteria for accepting inbound channels
    through a single persistent connection.
    """

    CloseChannel: grpc.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.CloseChannelRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.CloseStatusUpdate,
    ]
    """lncli: `closechannel`
    CloseChannel attempts to close an active channel identified by its channel
    outpoint (ChannelPoint). The actions of this method can additionally be
    augmented to attempt a force close after a timeout period in the case of an
    inactive peer. If a non-force close (cooperative closure) is requested,
    then the user can specify either a target number of blocks until the
    closure transaction is confirmed, or a manual fee rate. If neither are
    specified, then a default lax, block confirmation target is used.
    """

    AbandonChannel: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.AbandonChannelRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.AbandonChannelResponse,
    ]
    """lncli: `abandonchannel`
    AbandonChannel removes all channel state from the database except for a
    close summary. This method can be used to get rid of permanently unusable
    channels due to bugs fixed in newer versions of lnd. This method can also be
    used to remove externally funded channels where the funding transaction was
    never broadcast. Only available for non-externally funded channels in dev
    build.
    """

    SendPayment: grpc.StreamStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse,
    ]
    """lncli: `sendpayment`
    Deprecated, use routerrpc.SendPaymentV2. SendPayment dispatches a
    bi-directional streaming RPC for sending payments through the Lightning
    Network. A single RPC invocation creates a persistent bi-directional
    stream allowing clients to rapidly send payments through the Lightning
    Network with a single persistent connection.
    """

    SendPaymentSync: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse,
    ]
    """
    SendPaymentSync is the synchronous non-streaming version of SendPayment.
    This RPC is intended to be consumed by clients of the REST proxy.
    Additionally, this RPC expects the destination's public key and the payment
    hash (if any) to be encoded as hex strings.
    """

    SendToRoute: grpc.StreamStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendToRouteRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse,
    ]
    """lncli: `sendtoroute`
    Deprecated, use routerrpc.SendToRouteV2. SendToRoute is a bi-directional
    streaming RPC for sending payment through the Lightning Network. This
    method differs from SendPayment in that it allows users to specify a full
    route manually. This can be used for things like rebalancing, and atomic
    swaps.
    """

    SendToRouteSync: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendToRouteRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse,
    ]
    """
    SendToRouteSync is a synchronous version of SendToRoute. It Will block
    until the payment either fails or succeeds.
    """

    AddInvoice: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.Invoice,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.AddInvoiceResponse,
    ]
    """lncli: `addinvoice`
    AddInvoice attempts to add a new invoice to the invoice database. Any
    duplicated invoices are rejected, therefore all invoices *must* have a
    unique payment preimage.
    """

    ListInvoices: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListInvoiceRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListInvoiceResponse,
    ]
    """lncli: `listinvoices`
    ListInvoices returns a list of all the invoices currently stored within the
    database. Any active debug invoices are ignored. It has full support for
    paginated responses, allowing users to query for specific invoices through
    their add_index. This can be done by using either the first_index_offset or
    last_index_offset fields included in the response as the index_offset of the
    next request. By default, the first 100 invoices created will be returned.
    Backwards pagination is also supported through the Reversed flag.
    """

    LookupInvoice: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PaymentHash,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.Invoice,
    ]
    """lncli: `lookupinvoice`
    LookupInvoice attempts to look up an invoice according to its payment hash.
    The passed payment hash *must* be exactly 32 bytes, if not, an error is
    returned.
    """

    SubscribeInvoices: grpc.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.InvoiceSubscription,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.Invoice,
    ]
    """
    SubscribeInvoices returns a uni-directional stream (server -> client) for
    notifying the client of newly added/settled invoices. The caller can
    optionally specify the add_index and/or the settle_index. If the add_index
    is specified, then we'll first start by sending add invoice events for all
    invoices with an add_index greater than the specified value. If the
    settle_index is specified, then next, we'll send out all settle events for
    invoices with a settle_index greater than the specified value. One or both
    of these fields can be set. If no fields are set, then we'll only send out
    the latest add/settle events.
    """

    DecodePayReq: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PayReqString,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PayReq,
    ]
    """lncli: `decodepayreq`
    DecodePayReq takes an encoded payment request string and attempts to decode
    it, returning a full description of the conditions encoded within the
    payment request.
    """

    ListPayments: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPaymentsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPaymentsResponse,
    ]
    """lncli: `listpayments`
    ListPayments returns a list of all outgoing payments.
    """

    DeletePayment: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DeletePaymentRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DeletePaymentResponse,
    ]
    """lncli: `deletepayments`
    DeletePayment deletes an outgoing payment from DB. Note that it will not
    attempt to delete an In-Flight payment, since that would be unsafe.
    """

    DeleteAllPayments: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteAllPaymentsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteAllPaymentsResponse,
    ]
    """lncli: `deletepayments --all`
    DeleteAllPayments deletes all outgoing payments from DB. Note that it will
    not attempt to delete In-Flight payments, since that would be unsafe.
    """

    DescribeGraph: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelGraphRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelGraph,
    ]
    """lncli: `describegraph`
    DescribeGraph returns a description of the latest graph state from the
    point of view of the node. The graph information is partitioned into two
    components: all the nodes/vertexes, and all the edges that connect the
    vertexes themselves. As this is a directed graph, the edges also contain
    the node directional specific routing policy which includes: the time lock
    delta, fee information, etc.
    """

    GetNodeMetrics: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeMetricsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeMetricsResponse,
    ]
    """lncli: `getnodemetrics`
    GetNodeMetrics returns node metrics calculated from the graph. Currently
    the only supported metric is betweenness centrality of individual nodes.
    """

    GetChanInfo: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanInfoRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelEdge,
    ]
    """lncli: `getchaninfo`
    GetChanInfo returns the latest authenticated network announcement for the
    given channel identified by its channel ID: an 8-byte integer which
    uniquely identifies the location of transaction's funding output within the
    blockchain.
    """

    GetNodeInfo: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeInfoRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeInfo,
    ]
    """lncli: `getnodeinfo`
    GetNodeInfo returns the latest advertised, aggregated, and authenticated
    channel information for the specified node identified by its public key.
    """

    QueryRoutes: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.QueryRoutesRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.QueryRoutesResponse,
    ]
    """lncli: `queryroutes`
    QueryRoutes attempts to query the daemon's Channel Router for a possible
    route to a target destination capable of carrying a specific amount of
    satoshis. The returned route contains the full details required to craft and
    send an HTLC, also including the necessary information that should be
    present within the Sphinx packet encapsulated within the HTLC.

    When using REST, the `dest_custom_records` map type can be set by appending
    `&dest_custom_records[<record_number>]=<record_data_base64_url_encoded>`
    to the URL. Unfortunately this map type doesn't appear in the REST API
    documentation because of a bug in the grpc-gateway library.
    """

    GetNetworkInfo: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NetworkInfoRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NetworkInfo,
    ]
    """lncli: `getnetworkinfo`
    GetNetworkInfo returns some basic stats about the known channel graph from
    the point of view of the node.
    """

    StopDaemon: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.StopRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.StopResponse,
    ]
    """lncli: `stop`
    StopDaemon will send a shutdown request to the interrupt handler, triggering
    a graceful shutdown of the daemon.
    """

    SubscribeChannelGraph: grpc.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GraphTopologySubscription,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GraphTopologyUpdate,
    ]
    """
    SubscribeChannelGraph launches a streaming RPC that allows the caller to
    receive notifications upon any changes to the channel graph topology from
    the point of view of the responding node. Events notified include: new
    nodes coming online, nodes updating their authenticated attributes, new
    channels being advertised, updates in the routing policy for a directional
    channel edge, and when channels are closed on-chain.
    """

    DebugLevel: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DebugLevelRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DebugLevelResponse,
    ]
    """lncli: `debuglevel`
    DebugLevel allows a caller to programmatically set the logging verbosity of
    lnd. The logging can be targeted according to a coarse daemon-wide logging
    level, or in a granular fashion to specify the logging for a target
    sub-system.
    """

    FeeReport: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.FeeReportRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.FeeReportResponse,
    ]
    """lncli: `feereport`
    FeeReport allows the caller to obtain a report detailing the current fee
    schedule enforced by the node globally for each channel.
    """

    UpdateChannelPolicy: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PolicyUpdateRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PolicyUpdateResponse,
    ]
    """lncli: `updatechanpolicy`
    UpdateChannelPolicy allows the caller to update the fee schedule and
    channel policies for all channels globally, or a particular channel.
    """

    ForwardingHistory: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ForwardingHistoryRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ForwardingHistoryResponse,
    ]
    """lncli: `fwdinghistory`
    ForwardingHistory allows the caller to query the htlcswitch for a record of
    all HTLCs forwarded within the target time range, and integer offset
    within that time range, for a maximum number of events. If no maximum number
    of events is specified, up to 100 events will be returned. If no time-range
    is specified, then events will be returned in the order that they occured.

    A list of forwarding events are returned. The size of each forwarding event
    is 40 bytes, and the max message size able to be returned in gRPC is 4 MiB.
    As a result each message can only contain 50k entries. Each response has
    the index offset of the last entry. The index offset can be provided to the
    request to allow the caller to skip a series of records.
    """

    ExportChannelBackup: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ExportChannelBackupRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBackup,
    ]
    """lncli: `exportchanbackup`
    ExportChannelBackup attempts to return an encrypted static channel backup
    for the target channel identified by it channel point. The backup is
    encrypted with a key generated from the aezeed seed of the user. The
    returned backup can either be restored using the RestoreChannelBackup
    method once lnd is running, or via the InitWallet and UnlockWallet methods
    from the WalletUnlocker service.
    """

    ExportAllChannelBackups: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupExportRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupSnapshot,
    ]
    """
    ExportAllChannelBackups returns static channel backups for all existing
    channels known to lnd. A set of regular singular static channel backups for
    each channel are returned. Additionally, a multi-channel backup is returned
    as well, which contains a single encrypted blob containing the backups of
    each channel.
    """

    VerifyChanBackup: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupSnapshot,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.VerifyChanBackupResponse,
    ]
    """lncli: `verifychanbackup`
    VerifyChanBackup allows a caller to verify the integrity of a channel backup
    snapshot. This method will accept either a packed Single or a packed Multi.
    Specifying both will result in an error.
    """

    RestoreChannelBackups: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.RestoreChanBackupRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.RestoreBackupResponse,
    ]
    """lncli: `restorechanbackup`
    RestoreChannelBackups accepts a set of singular channel backups, or a
    single encrypted multi-chan backup and attempts to recover any funds
    remaining within the channel. If we are able to unpack the backup, then the
    new channel will be shown under listchannels, as well as pending channels.
    """

    SubscribeChannelBackups: grpc.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBackupSubscription,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupSnapshot,
    ]
    """
    SubscribeChannelBackups allows a client to sub-subscribe to the most up to
    date information concerning the state of all channel backups. Each time a
    new channel is added, we return the new set of channels, along with a
    multi-chan backup containing the backup info for all channels. Each time a
    channel is closed, we send a new update, which contains new new chan back
    ups, but the updated set of encrypted multi-chan backups with the closed
    channel(s) removed.
    """

    BakeMacaroon: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.BakeMacaroonRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.BakeMacaroonResponse,
    ]
    """lncli: `bakemacaroon`
    BakeMacaroon allows the creation of a new macaroon with custom read and
    write permissions. No first-party caveats are added since this can be done
    offline.
    """

    ListMacaroonIDs: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListMacaroonIDsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListMacaroonIDsResponse,
    ]
    """lncli: `listmacaroonids`
    ListMacaroonIDs returns all root key IDs that are in use.
    """

    DeleteMacaroonID: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteMacaroonIDRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteMacaroonIDResponse,
    ]
    """lncli: `deletemacaroonid`
    DeleteMacaroonID deletes the specified macaroon ID and invalidates all
    macaroons derived from that ID.
    """

    ListPermissions: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPermissionsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPermissionsResponse,
    ]
    """lncli: `listpermissions`
    ListPermissions lists all RPC method URIs and their required macaroon
    permissions to access them.
    """

    CheckMacaroonPermissions: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.CheckMacPermRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.CheckMacPermResponse,
    ]
    """
    CheckMacaroonPermissions checks whether a request follows the constraints
    imposed on the macaroon and that the macaroon is authorized to follow the
    provided permissions.
    """

    RegisterRPCMiddleware: grpc.StreamStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.RPCMiddlewareResponse,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.RPCMiddlewareRequest,
    ]
    """
    RegisterRPCMiddleware adds a new gRPC middleware to the interceptor chain. A
    gRPC middleware is software component external to lnd that aims to add
    additional business logic to lnd by observing/intercepting/validating
    incoming gRPC client requests and (if needed) replacing/overwriting outgoing
    messages before they're sent to the client. When registering the middleware
    must identify itself and indicate what custom macaroon caveats it wants to
    be responsible for. Only requests that contain a macaroon with that specific
    custom caveat are then sent to the middleware for inspection. The other
    option is to register for the read-only mode in which all requests/responses
    are forwarded for interception to the middleware but the middleware is not
    allowed to modify any responses. As a security measure, _no_ middleware can
    modify responses for requests made with _unencumbered_ macaroons!
    """

    SendCustomMessage: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCustomMessageRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCustomMessageResponse,
    ]
    """lncli: `sendcustom`
    SendCustomMessage sends a custom peer message.
    """

    SubscribeCustomMessages: grpc.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SubscribeCustomMessagesRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.CustomMessage,
    ]
    """lncli: `subscribecustom`
    SubscribeCustomMessages subscribes to a stream of incoming custom peer
    messages.

    To include messages with type outside of the custom range (>= 32768) lnd
    needs to be compiled with  the `dev` build tag, and the message type to
    override should be specified in lnd's experimental protocol configuration.
    """

    ListAliases: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListAliasesRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListAliasesResponse,
    ]
    """lncli: `listaliases`
    ListAliases returns the set of all aliases that have ever existed with
    their confirmed SCID (if it exists) and/or the base SCID (in the case of
    zero conf).
    """

    LookupHtlcResolution: grpc.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.LookupHtlcResolutionRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.LookupHtlcResolutionResponse,
    ]
    """
    LookupHtlcResolution retrieves a final htlc resolution from the database.
    If the htlc has no final resolution yet, a NotFound grpc status code is
    returned.
    """

class LightningAsyncStub:
    """
    Comments in this file will be directly parsed into the API
    Documentation as descriptions of the associated method, message, or field.
    These descriptions should go right above the definition of the object, and
    can be in either block or // comment format.

    An RPC method can be matched to an lncli command by placing a line in the
    beginning of the description in exactly the following format:
    lncli: `methodname`

    Failure to specify the exact name of the command will cause documentation
    generation to fail.

    More information on how exactly the gRPC documentation is generated from
    this proto file can be found here:
    https://github.com/lightninglabs/lightning-api

    Lightning is the main RPC server of the daemon.
    """

    WalletBalance: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.WalletBalanceRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.WalletBalanceResponse,
    ]
    """lncli: `walletbalance`
    WalletBalance returns total unspent outputs(confirmed and unconfirmed), all
    confirmed unspent outputs and all unconfirmed unspent outputs under control
    of the wallet.
    """

    ChannelBalance: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBalanceRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBalanceResponse,
    ]
    """lncli: `channelbalance`
    ChannelBalance returns a report on the total funds across all open channels,
    categorized in local/remote, pending local/remote and unsettled local/remote
    balances.
    """

    GetTransactions: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetTransactionsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.TransactionDetails,
    ]
    """lncli: `listchaintxns`
    GetTransactions returns a list describing all the known transactions
    relevant to the wallet.
    """

    EstimateFee: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.EstimateFeeRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.EstimateFeeResponse,
    ]
    """lncli: `estimatefee`
    EstimateFee asks the chain backend to estimate the fee rate and total fees
    for a transaction that pays to multiple specified outputs.

    When using REST, the `AddrToAmount` map type can be set by appending
    `&AddrToAmount[<address>]=<amount_to_send>` to the URL. Unfortunately this
    map type doesn't appear in the REST API documentation because of a bug in
    the grpc-gateway library.
    """

    SendCoins: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCoinsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCoinsResponse,
    ]
    """lncli: `sendcoins`
    SendCoins executes a request to send coins to a particular address. Unlike
    SendMany, this RPC call only allows creating a single output at a time. If
    neither target_conf, or sat_per_vbyte are set, then the internal wallet will
    consult its fee model to determine a fee for the default confirmation
    target.
    """

    ListUnspent: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListUnspentRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListUnspentResponse,
    ]
    """lncli: `listunspent`
    Deprecated, use walletrpc.ListUnspent instead.

    ListUnspent returns a list of all utxos spendable by the wallet with a
    number of confirmations between the specified minimum and maximum.
    """

    SubscribeTransactions: grpc.aio.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetTransactionsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.Transaction,
    ]
    """
    SubscribeTransactions creates a uni-directional stream from the server to
    the client in which any newly discovered transactions relevant to the
    wallet are sent over.
    """

    SendMany: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendManyRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendManyResponse,
    ]
    """lncli: `sendmany`
    SendMany handles a request for a transaction that creates multiple specified
    outputs in parallel. If neither target_conf, or sat_per_vbyte are set, then
    the internal wallet will consult its fee model to determine a fee for the
    default confirmation target.
    """

    NewAddress: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NewAddressRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NewAddressResponse,
    ]
    """lncli: `newaddress`
    NewAddress creates a new address under control of the local wallet.
    """

    SignMessage: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SignMessageRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SignMessageResponse,
    ]
    """lncli: `signmessage`
    SignMessage signs a message with this node's private key. The returned
    signature string is `zbase32` encoded and pubkey recoverable, meaning that
    only the message digest and signature are needed for verification.
    """

    VerifyMessage: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.VerifyMessageRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.VerifyMessageResponse,
    ]
    """lncli: `verifymessage`
    VerifyMessage verifies a signature over a message and recovers the signer's
    public key. The signature is only deemed valid if the recovered public key
    corresponds to a node key in the public Lightning network. The signature
    must be zbase32 encoded and signed by an active node in the resident node's
    channel database. In addition to returning the validity of the signature,
    VerifyMessage also returns the recovered pubkey from the signature.
    """

    ConnectPeer: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ConnectPeerRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ConnectPeerResponse,
    ]
    """lncli: `connect`
    ConnectPeer attempts to establish a connection to a remote peer. This is at
    the networking level, and is used for communication between nodes. This is
    distinct from establishing a channel with a peer.
    """

    DisconnectPeer: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DisconnectPeerRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DisconnectPeerResponse,
    ]
    """lncli: `disconnect`
    DisconnectPeer attempts to disconnect one peer from another identified by a
    given pubKey. In the case that we currently have a pending or active channel
    with the target peer, then this action will be not be allowed.
    """

    ListPeers: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPeersRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPeersResponse,
    ]
    """lncli: `listpeers`
    ListPeers returns a verbose listing of all currently active peers.
    """

    SubscribePeerEvents: grpc.aio.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PeerEventSubscription,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PeerEvent,
    ]
    """
    SubscribePeerEvents creates a uni-directional stream from the server to
    the client in which any events relevant to the state of peers are sent
    over. Events include peers going online and offline.
    """

    GetInfo: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetInfoRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetInfoResponse,
    ]
    """lncli: `getinfo`
    GetInfo returns general information concerning the lightning node including
    it's identity pubkey, alias, the chains it is connected to, and information
    concerning the number of open+pending channels.
    """

    GetDebugInfo: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetDebugInfoRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetDebugInfoResponse,
    ]
    """lncli: 'getdebuginfo'
    GetDebugInfo returns debug information concerning the state of the daemon
    and its subsystems. This includes the full configuration and the latest log
    entries from the log file.
    """

    GetRecoveryInfo: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetRecoveryInfoRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GetRecoveryInfoResponse,
    ]
    """* lncli: `getrecoveryinfo`
    GetRecoveryInfo returns information concerning the recovery mode including
    whether it's in a recovery mode, whether the recovery is finished, and the
    progress made so far.
    """

    PendingChannels: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PendingChannelsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PendingChannelsResponse,
    ]
    """TODO(roasbeef): merge with below with bool?

    lncli: `pendingchannels`
    PendingChannels returns a list of all the channels that are currently
    considered "pending". A channel is pending if it has finished the funding
    workflow and is waiting for confirmations for the funding txn, or is in the
    process of closure, either initiated cooperatively or non-cooperatively.
    """

    ListChannels: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListChannelsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListChannelsResponse,
    ]
    """lncli: `listchannels`
    ListChannels returns a description of all the open channels that this node
    is a participant in.
    """

    SubscribeChannelEvents: grpc.aio.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelEventSubscription,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelEventUpdate,
    ]
    """
    SubscribeChannelEvents creates a uni-directional stream from the server to
    the client in which any updates relevant to the state of the channels are
    sent over. Events include new active channels, inactive channels, and closed
    channels.
    """

    ClosedChannels: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ClosedChannelsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ClosedChannelsResponse,
    ]
    """lncli: `closedchannels`
    ClosedChannels returns a description of all the closed channels that
    this node was a participant in.
    """

    OpenChannelSync: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.OpenChannelRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelPoint,
    ]
    """
    OpenChannelSync is a synchronous version of the OpenChannel RPC call. This
    call is meant to be consumed by clients to the REST proxy. As with all
    other sync calls, all byte slices are intended to be populated as hex
    encoded strings.
    """

    OpenChannel: grpc.aio.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.OpenChannelRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.OpenStatusUpdate,
    ]
    """lncli: `openchannel`
    OpenChannel attempts to open a singly funded channel specified in the
    request to a remote peer. Users are able to specify a target number of
    blocks that the funding transaction should be confirmed in, or a manual fee
    rate to us for the funding transaction. If neither are specified, then a
    lax block confirmation target is used. Each OpenStatusUpdate will return
    the pending channel ID of the in-progress channel. Depending on the
    arguments specified in the OpenChannelRequest, this pending channel ID can
    then be used to manually progress the channel funding flow.
    """

    BatchOpenChannel: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.BatchOpenChannelRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.BatchOpenChannelResponse,
    ]
    """lncli: `batchopenchannel`
    BatchOpenChannel attempts to open multiple single-funded channels in a
    single transaction in an atomic way. This means either all channel open
    requests succeed at once or all attempts are aborted if any of them fail.
    This is the safer variant of using PSBTs to manually fund a batch of
    channels through the OpenChannel RPC.
    """

    FundingStateStep: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.FundingTransitionMsg,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.FundingStateStepResp,
    ]
    """
    FundingStateStep is an advanced funding related call that allows the caller
    to either execute some preparatory steps for a funding workflow, or
    manually progress a funding workflow. The primary way a funding flow is
    identified is via its pending channel ID. As an example, this method can be
    used to specify that we're expecting a funding flow for a particular
    pending channel ID, for which we need to use specific parameters.
    Alternatively, this can be used to interactively drive PSBT signing for
    funding for partially complete funding transactions.
    """

    ChannelAcceptor: grpc.aio.StreamStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelAcceptResponse,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelAcceptRequest,
    ]
    """
    ChannelAcceptor dispatches a bi-directional streaming RPC in which
    OpenChannel requests are sent to the client and the client responds with
    a boolean that tells LND whether or not to accept the channel. This allows
    node operators to specify their own criteria for accepting inbound channels
    through a single persistent connection.
    """

    CloseChannel: grpc.aio.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.CloseChannelRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.CloseStatusUpdate,
    ]
    """lncli: `closechannel`
    CloseChannel attempts to close an active channel identified by its channel
    outpoint (ChannelPoint). The actions of this method can additionally be
    augmented to attempt a force close after a timeout period in the case of an
    inactive peer. If a non-force close (cooperative closure) is requested,
    then the user can specify either a target number of blocks until the
    closure transaction is confirmed, or a manual fee rate. If neither are
    specified, then a default lax, block confirmation target is used.
    """

    AbandonChannel: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.AbandonChannelRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.AbandonChannelResponse,
    ]
    """lncli: `abandonchannel`
    AbandonChannel removes all channel state from the database except for a
    close summary. This method can be used to get rid of permanently unusable
    channels due to bugs fixed in newer versions of lnd. This method can also be
    used to remove externally funded channels where the funding transaction was
    never broadcast. Only available for non-externally funded channels in dev
    build.
    """

    SendPayment: grpc.aio.StreamStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse,
    ]
    """lncli: `sendpayment`
    Deprecated, use routerrpc.SendPaymentV2. SendPayment dispatches a
    bi-directional streaming RPC for sending payments through the Lightning
    Network. A single RPC invocation creates a persistent bi-directional
    stream allowing clients to rapidly send payments through the Lightning
    Network with a single persistent connection.
    """

    SendPaymentSync: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse,
    ]
    """
    SendPaymentSync is the synchronous non-streaming version of SendPayment.
    This RPC is intended to be consumed by clients of the REST proxy.
    Additionally, this RPC expects the destination's public key and the payment
    hash (if any) to be encoded as hex strings.
    """

    SendToRoute: grpc.aio.StreamStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendToRouteRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse,
    ]
    """lncli: `sendtoroute`
    Deprecated, use routerrpc.SendToRouteV2. SendToRoute is a bi-directional
    streaming RPC for sending payment through the Lightning Network. This
    method differs from SendPayment in that it allows users to specify a full
    route manually. This can be used for things like rebalancing, and atomic
    swaps.
    """

    SendToRouteSync: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendToRouteRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse,
    ]
    """
    SendToRouteSync is a synchronous version of SendToRoute. It Will block
    until the payment either fails or succeeds.
    """

    AddInvoice: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.Invoice,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.AddInvoiceResponse,
    ]
    """lncli: `addinvoice`
    AddInvoice attempts to add a new invoice to the invoice database. Any
    duplicated invoices are rejected, therefore all invoices *must* have a
    unique payment preimage.
    """

    ListInvoices: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListInvoiceRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListInvoiceResponse,
    ]
    """lncli: `listinvoices`
    ListInvoices returns a list of all the invoices currently stored within the
    database. Any active debug invoices are ignored. It has full support for
    paginated responses, allowing users to query for specific invoices through
    their add_index. This can be done by using either the first_index_offset or
    last_index_offset fields included in the response as the index_offset of the
    next request. By default, the first 100 invoices created will be returned.
    Backwards pagination is also supported through the Reversed flag.
    """

    LookupInvoice: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PaymentHash,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.Invoice,
    ]
    """lncli: `lookupinvoice`
    LookupInvoice attempts to look up an invoice according to its payment hash.
    The passed payment hash *must* be exactly 32 bytes, if not, an error is
    returned.
    """

    SubscribeInvoices: grpc.aio.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.InvoiceSubscription,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.Invoice,
    ]
    """
    SubscribeInvoices returns a uni-directional stream (server -> client) for
    notifying the client of newly added/settled invoices. The caller can
    optionally specify the add_index and/or the settle_index. If the add_index
    is specified, then we'll first start by sending add invoice events for all
    invoices with an add_index greater than the specified value. If the
    settle_index is specified, then next, we'll send out all settle events for
    invoices with a settle_index greater than the specified value. One or both
    of these fields can be set. If no fields are set, then we'll only send out
    the latest add/settle events.
    """

    DecodePayReq: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PayReqString,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PayReq,
    ]
    """lncli: `decodepayreq`
    DecodePayReq takes an encoded payment request string and attempts to decode
    it, returning a full description of the conditions encoded within the
    payment request.
    """

    ListPayments: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPaymentsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPaymentsResponse,
    ]
    """lncli: `listpayments`
    ListPayments returns a list of all outgoing payments.
    """

    DeletePayment: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DeletePaymentRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DeletePaymentResponse,
    ]
    """lncli: `deletepayments`
    DeletePayment deletes an outgoing payment from DB. Note that it will not
    attempt to delete an In-Flight payment, since that would be unsafe.
    """

    DeleteAllPayments: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteAllPaymentsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteAllPaymentsResponse,
    ]
    """lncli: `deletepayments --all`
    DeleteAllPayments deletes all outgoing payments from DB. Note that it will
    not attempt to delete In-Flight payments, since that would be unsafe.
    """

    DescribeGraph: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelGraphRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelGraph,
    ]
    """lncli: `describegraph`
    DescribeGraph returns a description of the latest graph state from the
    point of view of the node. The graph information is partitioned into two
    components: all the nodes/vertexes, and all the edges that connect the
    vertexes themselves. As this is a directed graph, the edges also contain
    the node directional specific routing policy which includes: the time lock
    delta, fee information, etc.
    """

    GetNodeMetrics: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeMetricsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeMetricsResponse,
    ]
    """lncli: `getnodemetrics`
    GetNodeMetrics returns node metrics calculated from the graph. Currently
    the only supported metric is betweenness centrality of individual nodes.
    """

    GetChanInfo: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanInfoRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelEdge,
    ]
    """lncli: `getchaninfo`
    GetChanInfo returns the latest authenticated network announcement for the
    given channel identified by its channel ID: an 8-byte integer which
    uniquely identifies the location of transaction's funding output within the
    blockchain.
    """

    GetNodeInfo: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeInfoRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeInfo,
    ]
    """lncli: `getnodeinfo`
    GetNodeInfo returns the latest advertised, aggregated, and authenticated
    channel information for the specified node identified by its public key.
    """

    QueryRoutes: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.QueryRoutesRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.QueryRoutesResponse,
    ]
    """lncli: `queryroutes`
    QueryRoutes attempts to query the daemon's Channel Router for a possible
    route to a target destination capable of carrying a specific amount of
    satoshis. The returned route contains the full details required to craft and
    send an HTLC, also including the necessary information that should be
    present within the Sphinx packet encapsulated within the HTLC.

    When using REST, the `dest_custom_records` map type can be set by appending
    `&dest_custom_records[<record_number>]=<record_data_base64_url_encoded>`
    to the URL. Unfortunately this map type doesn't appear in the REST API
    documentation because of a bug in the grpc-gateway library.
    """

    GetNetworkInfo: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NetworkInfoRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.NetworkInfo,
    ]
    """lncli: `getnetworkinfo`
    GetNetworkInfo returns some basic stats about the known channel graph from
    the point of view of the node.
    """

    StopDaemon: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.StopRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.StopResponse,
    ]
    """lncli: `stop`
    StopDaemon will send a shutdown request to the interrupt handler, triggering
    a graceful shutdown of the daemon.
    """

    SubscribeChannelGraph: grpc.aio.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GraphTopologySubscription,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.GraphTopologyUpdate,
    ]
    """
    SubscribeChannelGraph launches a streaming RPC that allows the caller to
    receive notifications upon any changes to the channel graph topology from
    the point of view of the responding node. Events notified include: new
    nodes coming online, nodes updating their authenticated attributes, new
    channels being advertised, updates in the routing policy for a directional
    channel edge, and when channels are closed on-chain.
    """

    DebugLevel: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DebugLevelRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DebugLevelResponse,
    ]
    """lncli: `debuglevel`
    DebugLevel allows a caller to programmatically set the logging verbosity of
    lnd. The logging can be targeted according to a coarse daemon-wide logging
    level, or in a granular fashion to specify the logging for a target
    sub-system.
    """

    FeeReport: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.FeeReportRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.FeeReportResponse,
    ]
    """lncli: `feereport`
    FeeReport allows the caller to obtain a report detailing the current fee
    schedule enforced by the node globally for each channel.
    """

    UpdateChannelPolicy: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PolicyUpdateRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.PolicyUpdateResponse,
    ]
    """lncli: `updatechanpolicy`
    UpdateChannelPolicy allows the caller to update the fee schedule and
    channel policies for all channels globally, or a particular channel.
    """

    ForwardingHistory: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ForwardingHistoryRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ForwardingHistoryResponse,
    ]
    """lncli: `fwdinghistory`
    ForwardingHistory allows the caller to query the htlcswitch for a record of
    all HTLCs forwarded within the target time range, and integer offset
    within that time range, for a maximum number of events. If no maximum number
    of events is specified, up to 100 events will be returned. If no time-range
    is specified, then events will be returned in the order that they occured.

    A list of forwarding events are returned. The size of each forwarding event
    is 40 bytes, and the max message size able to be returned in gRPC is 4 MiB.
    As a result each message can only contain 50k entries. Each response has
    the index offset of the last entry. The index offset can be provided to the
    request to allow the caller to skip a series of records.
    """

    ExportChannelBackup: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ExportChannelBackupRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBackup,
    ]
    """lncli: `exportchanbackup`
    ExportChannelBackup attempts to return an encrypted static channel backup
    for the target channel identified by it channel point. The backup is
    encrypted with a key generated from the aezeed seed of the user. The
    returned backup can either be restored using the RestoreChannelBackup
    method once lnd is running, or via the InitWallet and UnlockWallet methods
    from the WalletUnlocker service.
    """

    ExportAllChannelBackups: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupExportRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupSnapshot,
    ]
    """
    ExportAllChannelBackups returns static channel backups for all existing
    channels known to lnd. A set of regular singular static channel backups for
    each channel are returned. Additionally, a multi-channel backup is returned
    as well, which contains a single encrypted blob containing the backups of
    each channel.
    """

    VerifyChanBackup: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupSnapshot,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.VerifyChanBackupResponse,
    ]
    """lncli: `verifychanbackup`
    VerifyChanBackup allows a caller to verify the integrity of a channel backup
    snapshot. This method will accept either a packed Single or a packed Multi.
    Specifying both will result in an error.
    """

    RestoreChannelBackups: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.RestoreChanBackupRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.RestoreBackupResponse,
    ]
    """lncli: `restorechanbackup`
    RestoreChannelBackups accepts a set of singular channel backups, or a
    single encrypted multi-chan backup and attempts to recover any funds
    remaining within the channel. If we are able to unpack the backup, then the
    new channel will be shown under listchannels, as well as pending channels.
    """

    SubscribeChannelBackups: grpc.aio.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBackupSubscription,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupSnapshot,
    ]
    """
    SubscribeChannelBackups allows a client to sub-subscribe to the most up to
    date information concerning the state of all channel backups. Each time a
    new channel is added, we return the new set of channels, along with a
    multi-chan backup containing the backup info for all channels. Each time a
    channel is closed, we send a new update, which contains new new chan back
    ups, but the updated set of encrypted multi-chan backups with the closed
    channel(s) removed.
    """

    BakeMacaroon: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.BakeMacaroonRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.BakeMacaroonResponse,
    ]
    """lncli: `bakemacaroon`
    BakeMacaroon allows the creation of a new macaroon with custom read and
    write permissions. No first-party caveats are added since this can be done
    offline.
    """

    ListMacaroonIDs: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListMacaroonIDsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListMacaroonIDsResponse,
    ]
    """lncli: `listmacaroonids`
    ListMacaroonIDs returns all root key IDs that are in use.
    """

    DeleteMacaroonID: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteMacaroonIDRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteMacaroonIDResponse,
    ]
    """lncli: `deletemacaroonid`
    DeleteMacaroonID deletes the specified macaroon ID and invalidates all
    macaroons derived from that ID.
    """

    ListPermissions: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPermissionsRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPermissionsResponse,
    ]
    """lncli: `listpermissions`
    ListPermissions lists all RPC method URIs and their required macaroon
    permissions to access them.
    """

    CheckMacaroonPermissions: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.CheckMacPermRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.CheckMacPermResponse,
    ]
    """
    CheckMacaroonPermissions checks whether a request follows the constraints
    imposed on the macaroon and that the macaroon is authorized to follow the
    provided permissions.
    """

    RegisterRPCMiddleware: grpc.aio.StreamStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.RPCMiddlewareResponse,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.RPCMiddlewareRequest,
    ]
    """
    RegisterRPCMiddleware adds a new gRPC middleware to the interceptor chain. A
    gRPC middleware is software component external to lnd that aims to add
    additional business logic to lnd by observing/intercepting/validating
    incoming gRPC client requests and (if needed) replacing/overwriting outgoing
    messages before they're sent to the client. When registering the middleware
    must identify itself and indicate what custom macaroon caveats it wants to
    be responsible for. Only requests that contain a macaroon with that specific
    custom caveat are then sent to the middleware for inspection. The other
    option is to register for the read-only mode in which all requests/responses
    are forwarded for interception to the middleware but the middleware is not
    allowed to modify any responses. As a security measure, _no_ middleware can
    modify responses for requests made with _unencumbered_ macaroons!
    """

    SendCustomMessage: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCustomMessageRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCustomMessageResponse,
    ]
    """lncli: `sendcustom`
    SendCustomMessage sends a custom peer message.
    """

    SubscribeCustomMessages: grpc.aio.UnaryStreamMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.SubscribeCustomMessagesRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.CustomMessage,
    ]
    """lncli: `subscribecustom`
    SubscribeCustomMessages subscribes to a stream of incoming custom peer
    messages.

    To include messages with type outside of the custom range (>= 32768) lnd
    needs to be compiled with  the `dev` build tag, and the message type to
    override should be specified in lnd's experimental protocol configuration.
    """

    ListAliases: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListAliasesRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.ListAliasesResponse,
    ]
    """lncli: `listaliases`
    ListAliases returns the set of all aliases that have ever existed with
    their confirmed SCID (if it exists) and/or the base SCID (in the case of
    zero conf).
    """

    LookupHtlcResolution: grpc.aio.UnaryUnaryMultiCallable[
        cashu.lightning.lnd_grpc.protos.lightning_pb2.LookupHtlcResolutionRequest,
        cashu.lightning.lnd_grpc.protos.lightning_pb2.LookupHtlcResolutionResponse,
    ]
    """
    LookupHtlcResolution retrieves a final htlc resolution from the database.
    If the htlc has no final resolution yet, a NotFound grpc status code is
    returned.
    """

class LightningServicer(metaclass=abc.ABCMeta):
    """
    Comments in this file will be directly parsed into the API
    Documentation as descriptions of the associated method, message, or field.
    These descriptions should go right above the definition of the object, and
    can be in either block or // comment format.

    An RPC method can be matched to an lncli command by placing a line in the
    beginning of the description in exactly the following format:
    lncli: `methodname`

    Failure to specify the exact name of the command will cause documentation
    generation to fail.

    More information on how exactly the gRPC documentation is generated from
    this proto file can be found here:
    https://github.com/lightninglabs/lightning-api

    Lightning is the main RPC server of the daemon.
    """

    @abc.abstractmethod
    def WalletBalance(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.WalletBalanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.WalletBalanceResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.WalletBalanceResponse]]:
        """lncli: `walletbalance`
        WalletBalance returns total unspent outputs(confirmed and unconfirmed), all
        confirmed unspent outputs and all unconfirmed unspent outputs under control
        of the wallet.
        """

    @abc.abstractmethod
    def ChannelBalance(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBalanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBalanceResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBalanceResponse]]:
        """lncli: `channelbalance`
        ChannelBalance returns a report on the total funds across all open channels,
        categorized in local/remote, pending local/remote and unsettled local/remote
        balances.
        """

    @abc.abstractmethod
    def GetTransactions(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.GetTransactionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.TransactionDetails, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.TransactionDetails]]:
        """lncli: `listchaintxns`
        GetTransactions returns a list describing all the known transactions
        relevant to the wallet.
        """

    @abc.abstractmethod
    def EstimateFee(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.EstimateFeeRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.EstimateFeeResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.EstimateFeeResponse]]:
        """lncli: `estimatefee`
        EstimateFee asks the chain backend to estimate the fee rate and total fees
        for a transaction that pays to multiple specified outputs.

        When using REST, the `AddrToAmount` map type can be set by appending
        `&AddrToAmount[<address>]=<amount_to_send>` to the URL. Unfortunately this
        map type doesn't appear in the REST API documentation because of a bug in
        the grpc-gateway library.
        """

    @abc.abstractmethod
    def SendCoins(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCoinsRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCoinsResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCoinsResponse]]:
        """lncli: `sendcoins`
        SendCoins executes a request to send coins to a particular address. Unlike
        SendMany, this RPC call only allows creating a single output at a time. If
        neither target_conf, or sat_per_vbyte are set, then the internal wallet will
        consult its fee model to determine a fee for the default confirmation
        target.
        """

    @abc.abstractmethod
    def ListUnspent(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ListUnspentRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListUnspentResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListUnspentResponse]]:
        """lncli: `listunspent`
        Deprecated, use walletrpc.ListUnspent instead.

        ListUnspent returns a list of all utxos spendable by the wallet with a
        number of confirmations between the specified minimum and maximum.
        """

    @abc.abstractmethod
    def SubscribeTransactions(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.GetTransactionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.Transaction], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.Transaction]]:
        """
        SubscribeTransactions creates a uni-directional stream from the server to
        the client in which any newly discovered transactions relevant to the
        wallet are sent over.
        """

    @abc.abstractmethod
    def SendMany(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.SendManyRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendManyResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendManyResponse]]:
        """lncli: `sendmany`
        SendMany handles a request for a transaction that creates multiple specified
        outputs in parallel. If neither target_conf, or sat_per_vbyte are set, then
        the internal wallet will consult its fee model to determine a fee for the
        default confirmation target.
        """

    @abc.abstractmethod
    def NewAddress(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.NewAddressRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.NewAddressResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.NewAddressResponse]]:
        """lncli: `newaddress`
        NewAddress creates a new address under control of the local wallet.
        """

    @abc.abstractmethod
    def SignMessage(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.SignMessageRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.SignMessageResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.SignMessageResponse]]:
        """lncli: `signmessage`
        SignMessage signs a message with this node's private key. The returned
        signature string is `zbase32` encoded and pubkey recoverable, meaning that
        only the message digest and signature are needed for verification.
        """

    @abc.abstractmethod
    def VerifyMessage(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.VerifyMessageRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.VerifyMessageResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.VerifyMessageResponse]]:
        """lncli: `verifymessage`
        VerifyMessage verifies a signature over a message and recovers the signer's
        public key. The signature is only deemed valid if the recovered public key
        corresponds to a node key in the public Lightning network. The signature
        must be zbase32 encoded and signed by an active node in the resident node's
        channel database. In addition to returning the validity of the signature,
        VerifyMessage also returns the recovered pubkey from the signature.
        """

    @abc.abstractmethod
    def ConnectPeer(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ConnectPeerRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ConnectPeerResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ConnectPeerResponse]]:
        """lncli: `connect`
        ConnectPeer attempts to establish a connection to a remote peer. This is at
        the networking level, and is used for communication between nodes. This is
        distinct from establishing a channel with a peer.
        """

    @abc.abstractmethod
    def DisconnectPeer(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.DisconnectPeerRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.DisconnectPeerResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.DisconnectPeerResponse]]:
        """lncli: `disconnect`
        DisconnectPeer attempts to disconnect one peer from another identified by a
        given pubKey. In the case that we currently have a pending or active channel
        with the target peer, then this action will be not be allowed.
        """

    @abc.abstractmethod
    def ListPeers(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPeersRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPeersResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPeersResponse]]:
        """lncli: `listpeers`
        ListPeers returns a verbose listing of all currently active peers.
        """

    @abc.abstractmethod
    def SubscribePeerEvents(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.PeerEventSubscription,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.PeerEvent], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.PeerEvent]]:
        """
        SubscribePeerEvents creates a uni-directional stream from the server to
        the client in which any events relevant to the state of peers are sent
        over. Events include peers going online and offline.
        """

    @abc.abstractmethod
    def GetInfo(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.GetInfoRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.GetInfoResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.GetInfoResponse]]:
        """lncli: `getinfo`
        GetInfo returns general information concerning the lightning node including
        it's identity pubkey, alias, the chains it is connected to, and information
        concerning the number of open+pending channels.
        """

    @abc.abstractmethod
    def GetDebugInfo(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.GetDebugInfoRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.GetDebugInfoResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.GetDebugInfoResponse]]:
        """lncli: 'getdebuginfo'
        GetDebugInfo returns debug information concerning the state of the daemon
        and its subsystems. This includes the full configuration and the latest log
        entries from the log file.
        """

    @abc.abstractmethod
    def GetRecoveryInfo(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.GetRecoveryInfoRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.GetRecoveryInfoResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.GetRecoveryInfoResponse]]:
        """* lncli: `getrecoveryinfo`
        GetRecoveryInfo returns information concerning the recovery mode including
        whether it's in a recovery mode, whether the recovery is finished, and the
        progress made so far.
        """

    @abc.abstractmethod
    def PendingChannels(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.PendingChannelsRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.PendingChannelsResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.PendingChannelsResponse]]:
        """TODO(roasbeef): merge with below with bool?

        lncli: `pendingchannels`
        PendingChannels returns a list of all the channels that are currently
        considered "pending". A channel is pending if it has finished the funding
        workflow and is waiting for confirmations for the funding txn, or is in the
        process of closure, either initiated cooperatively or non-cooperatively.
        """

    @abc.abstractmethod
    def ListChannels(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ListChannelsRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListChannelsResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListChannelsResponse]]:
        """lncli: `listchannels`
        ListChannels returns a description of all the open channels that this node
        is a participant in.
        """

    @abc.abstractmethod
    def SubscribeChannelEvents(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelEventSubscription,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelEventUpdate], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelEventUpdate]]:
        """
        SubscribeChannelEvents creates a uni-directional stream from the server to
        the client in which any updates relevant to the state of the channels are
        sent over. Events include new active channels, inactive channels, and closed
        channels.
        """

    @abc.abstractmethod
    def ClosedChannels(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ClosedChannelsRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ClosedChannelsResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ClosedChannelsResponse]]:
        """lncli: `closedchannels`
        ClosedChannels returns a description of all the closed channels that
        this node was a participant in.
        """

    @abc.abstractmethod
    def OpenChannelSync(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.OpenChannelRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelPoint, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelPoint]]:
        """
        OpenChannelSync is a synchronous version of the OpenChannel RPC call. This
        call is meant to be consumed by clients to the REST proxy. As with all
        other sync calls, all byte slices are intended to be populated as hex
        encoded strings.
        """

    @abc.abstractmethod
    def OpenChannel(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.OpenChannelRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.OpenStatusUpdate], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.OpenStatusUpdate]]:
        """lncli: `openchannel`
        OpenChannel attempts to open a singly funded channel specified in the
        request to a remote peer. Users are able to specify a target number of
        blocks that the funding transaction should be confirmed in, or a manual fee
        rate to us for the funding transaction. If neither are specified, then a
        lax block confirmation target is used. Each OpenStatusUpdate will return
        the pending channel ID of the in-progress channel. Depending on the
        arguments specified in the OpenChannelRequest, this pending channel ID can
        then be used to manually progress the channel funding flow.
        """

    @abc.abstractmethod
    def BatchOpenChannel(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.BatchOpenChannelRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.BatchOpenChannelResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.BatchOpenChannelResponse]]:
        """lncli: `batchopenchannel`
        BatchOpenChannel attempts to open multiple single-funded channels in a
        single transaction in an atomic way. This means either all channel open
        requests succeed at once or all attempts are aborted if any of them fail.
        This is the safer variant of using PSBTs to manually fund a batch of
        channels through the OpenChannel RPC.
        """

    @abc.abstractmethod
    def FundingStateStep(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.FundingTransitionMsg,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.FundingStateStepResp, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.FundingStateStepResp]]:
        """
        FundingStateStep is an advanced funding related call that allows the caller
        to either execute some preparatory steps for a funding workflow, or
        manually progress a funding workflow. The primary way a funding flow is
        identified is via its pending channel ID. As an example, this method can be
        used to specify that we're expecting a funding flow for a particular
        pending channel ID, for which we need to use specific parameters.
        Alternatively, this can be used to interactively drive PSBT signing for
        funding for partially complete funding transactions.
        """

    @abc.abstractmethod
    def ChannelAcceptor(
        self,
        request_iterator: _MaybeAsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelAcceptResponse],
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelAcceptRequest], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelAcceptRequest]]:
        """
        ChannelAcceptor dispatches a bi-directional streaming RPC in which
        OpenChannel requests are sent to the client and the client responds with
        a boolean that tells LND whether or not to accept the channel. This allows
        node operators to specify their own criteria for accepting inbound channels
        through a single persistent connection.
        """

    @abc.abstractmethod
    def CloseChannel(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.CloseChannelRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.CloseStatusUpdate], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.CloseStatusUpdate]]:
        """lncli: `closechannel`
        CloseChannel attempts to close an active channel identified by its channel
        outpoint (ChannelPoint). The actions of this method can additionally be
        augmented to attempt a force close after a timeout period in the case of an
        inactive peer. If a non-force close (cooperative closure) is requested,
        then the user can specify either a target number of blocks until the
        closure transaction is confirmed, or a manual fee rate. If neither are
        specified, then a default lax, block confirmation target is used.
        """

    @abc.abstractmethod
    def AbandonChannel(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.AbandonChannelRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.AbandonChannelResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.AbandonChannelResponse]]:
        """lncli: `abandonchannel`
        AbandonChannel removes all channel state from the database except for a
        close summary. This method can be used to get rid of permanently unusable
        channels due to bugs fixed in newer versions of lnd. This method can also be
        used to remove externally funded channels where the funding transaction was
        never broadcast. Only available for non-externally funded channels in dev
        build.
        """

    @abc.abstractmethod
    def SendPayment(
        self,
        request_iterator: _MaybeAsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendRequest],
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse]]:
        """lncli: `sendpayment`
        Deprecated, use routerrpc.SendPaymentV2. SendPayment dispatches a
        bi-directional streaming RPC for sending payments through the Lightning
        Network. A single RPC invocation creates a persistent bi-directional
        stream allowing clients to rapidly send payments through the Lightning
        Network with a single persistent connection.
        """

    @abc.abstractmethod
    def SendPaymentSync(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.SendRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse]]:
        """
        SendPaymentSync is the synchronous non-streaming version of SendPayment.
        This RPC is intended to be consumed by clients of the REST proxy.
        Additionally, this RPC expects the destination's public key and the payment
        hash (if any) to be encoded as hex strings.
        """

    @abc.abstractmethod
    def SendToRoute(
        self,
        request_iterator: _MaybeAsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendToRouteRequest],
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse]]:
        """lncli: `sendtoroute`
        Deprecated, use routerrpc.SendToRouteV2. SendToRoute is a bi-directional
        streaming RPC for sending payment through the Lightning Network. This
        method differs from SendPayment in that it allows users to specify a full
        route manually. This can be used for things like rebalancing, and atomic
        swaps.
        """

    @abc.abstractmethod
    def SendToRouteSync(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.SendToRouteRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendResponse]]:
        """
        SendToRouteSync is a synchronous version of SendToRoute. It Will block
        until the payment either fails or succeeds.
        """

    @abc.abstractmethod
    def AddInvoice(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.Invoice,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.AddInvoiceResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.AddInvoiceResponse]]:
        """lncli: `addinvoice`
        AddInvoice attempts to add a new invoice to the invoice database. Any
        duplicated invoices are rejected, therefore all invoices *must* have a
        unique payment preimage.
        """

    @abc.abstractmethod
    def ListInvoices(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ListInvoiceRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListInvoiceResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListInvoiceResponse]]:
        """lncli: `listinvoices`
        ListInvoices returns a list of all the invoices currently stored within the
        database. Any active debug invoices are ignored. It has full support for
        paginated responses, allowing users to query for specific invoices through
        their add_index. This can be done by using either the first_index_offset or
        last_index_offset fields included in the response as the index_offset of the
        next request. By default, the first 100 invoices created will be returned.
        Backwards pagination is also supported through the Reversed flag.
        """

    @abc.abstractmethod
    def LookupInvoice(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.PaymentHash,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.Invoice, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.Invoice]]:
        """lncli: `lookupinvoice`
        LookupInvoice attempts to look up an invoice according to its payment hash.
        The passed payment hash *must* be exactly 32 bytes, if not, an error is
        returned.
        """

    @abc.abstractmethod
    def SubscribeInvoices(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.InvoiceSubscription,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.Invoice], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.Invoice]]:
        """
        SubscribeInvoices returns a uni-directional stream (server -> client) for
        notifying the client of newly added/settled invoices. The caller can
        optionally specify the add_index and/or the settle_index. If the add_index
        is specified, then we'll first start by sending add invoice events for all
        invoices with an add_index greater than the specified value. If the
        settle_index is specified, then next, we'll send out all settle events for
        invoices with a settle_index greater than the specified value. One or both
        of these fields can be set. If no fields are set, then we'll only send out
        the latest add/settle events.
        """

    @abc.abstractmethod
    def DecodePayReq(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.PayReqString,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.PayReq, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.PayReq]]:
        """lncli: `decodepayreq`
        DecodePayReq takes an encoded payment request string and attempts to decode
        it, returning a full description of the conditions encoded within the
        payment request.
        """

    @abc.abstractmethod
    def ListPayments(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPaymentsRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPaymentsResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPaymentsResponse]]:
        """lncli: `listpayments`
        ListPayments returns a list of all outgoing payments.
        """

    @abc.abstractmethod
    def DeletePayment(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.DeletePaymentRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.DeletePaymentResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.DeletePaymentResponse]]:
        """lncli: `deletepayments`
        DeletePayment deletes an outgoing payment from DB. Note that it will not
        attempt to delete an In-Flight payment, since that would be unsafe.
        """

    @abc.abstractmethod
    def DeleteAllPayments(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteAllPaymentsRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteAllPaymentsResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteAllPaymentsResponse]]:
        """lncli: `deletepayments --all`
        DeleteAllPayments deletes all outgoing payments from DB. Note that it will
        not attempt to delete In-Flight payments, since that would be unsafe.
        """

    @abc.abstractmethod
    def DescribeGraph(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelGraphRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelGraph, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelGraph]]:
        """lncli: `describegraph`
        DescribeGraph returns a description of the latest graph state from the
        point of view of the node. The graph information is partitioned into two
        components: all the nodes/vertexes, and all the edges that connect the
        vertexes themselves. As this is a directed graph, the edges also contain
        the node directional specific routing policy which includes: the time lock
        delta, fee information, etc.
        """

    @abc.abstractmethod
    def GetNodeMetrics(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeMetricsRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeMetricsResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeMetricsResponse]]:
        """lncli: `getnodemetrics`
        GetNodeMetrics returns node metrics calculated from the graph. Currently
        the only supported metric is betweenness centrality of individual nodes.
        """

    @abc.abstractmethod
    def GetChanInfo(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanInfoRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelEdge, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelEdge]]:
        """lncli: `getchaninfo`
        GetChanInfo returns the latest authenticated network announcement for the
        given channel identified by its channel ID: an 8-byte integer which
        uniquely identifies the location of transaction's funding output within the
        blockchain.
        """

    @abc.abstractmethod
    def GetNodeInfo(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeInfoRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeInfo, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.NodeInfo]]:
        """lncli: `getnodeinfo`
        GetNodeInfo returns the latest advertised, aggregated, and authenticated
        channel information for the specified node identified by its public key.
        """

    @abc.abstractmethod
    def QueryRoutes(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.QueryRoutesRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.QueryRoutesResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.QueryRoutesResponse]]:
        """lncli: `queryroutes`
        QueryRoutes attempts to query the daemon's Channel Router for a possible
        route to a target destination capable of carrying a specific amount of
        satoshis. The returned route contains the full details required to craft and
        send an HTLC, also including the necessary information that should be
        present within the Sphinx packet encapsulated within the HTLC.

        When using REST, the `dest_custom_records` map type can be set by appending
        `&dest_custom_records[<record_number>]=<record_data_base64_url_encoded>`
        to the URL. Unfortunately this map type doesn't appear in the REST API
        documentation because of a bug in the grpc-gateway library.
        """

    @abc.abstractmethod
    def GetNetworkInfo(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.NetworkInfoRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.NetworkInfo, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.NetworkInfo]]:
        """lncli: `getnetworkinfo`
        GetNetworkInfo returns some basic stats about the known channel graph from
        the point of view of the node.
        """

    @abc.abstractmethod
    def StopDaemon(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.StopRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.StopResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.StopResponse]]:
        """lncli: `stop`
        StopDaemon will send a shutdown request to the interrupt handler, triggering
        a graceful shutdown of the daemon.
        """

    @abc.abstractmethod
    def SubscribeChannelGraph(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.GraphTopologySubscription,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.GraphTopologyUpdate], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.GraphTopologyUpdate]]:
        """
        SubscribeChannelGraph launches a streaming RPC that allows the caller to
        receive notifications upon any changes to the channel graph topology from
        the point of view of the responding node. Events notified include: new
        nodes coming online, nodes updating their authenticated attributes, new
        channels being advertised, updates in the routing policy for a directional
        channel edge, and when channels are closed on-chain.
        """

    @abc.abstractmethod
    def DebugLevel(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.DebugLevelRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.DebugLevelResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.DebugLevelResponse]]:
        """lncli: `debuglevel`
        DebugLevel allows a caller to programmatically set the logging verbosity of
        lnd. The logging can be targeted according to a coarse daemon-wide logging
        level, or in a granular fashion to specify the logging for a target
        sub-system.
        """

    @abc.abstractmethod
    def FeeReport(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.FeeReportRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.FeeReportResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.FeeReportResponse]]:
        """lncli: `feereport`
        FeeReport allows the caller to obtain a report detailing the current fee
        schedule enforced by the node globally for each channel.
        """

    @abc.abstractmethod
    def UpdateChannelPolicy(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.PolicyUpdateRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.PolicyUpdateResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.PolicyUpdateResponse]]:
        """lncli: `updatechanpolicy`
        UpdateChannelPolicy allows the caller to update the fee schedule and
        channel policies for all channels globally, or a particular channel.
        """

    @abc.abstractmethod
    def ForwardingHistory(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ForwardingHistoryRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ForwardingHistoryResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ForwardingHistoryResponse]]:
        """lncli: `fwdinghistory`
        ForwardingHistory allows the caller to query the htlcswitch for a record of
        all HTLCs forwarded within the target time range, and integer offset
        within that time range, for a maximum number of events. If no maximum number
        of events is specified, up to 100 events will be returned. If no time-range
        is specified, then events will be returned in the order that they occured.

        A list of forwarding events are returned. The size of each forwarding event
        is 40 bytes, and the max message size able to be returned in gRPC is 4 MiB.
        As a result each message can only contain 50k entries. Each response has
        the index offset of the last entry. The index offset can be provided to the
        request to allow the caller to skip a series of records.
        """

    @abc.abstractmethod
    def ExportChannelBackup(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ExportChannelBackupRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBackup, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBackup]]:
        """lncli: `exportchanbackup`
        ExportChannelBackup attempts to return an encrypted static channel backup
        for the target channel identified by it channel point. The backup is
        encrypted with a key generated from the aezeed seed of the user. The
        returned backup can either be restored using the RestoreChannelBackup
        method once lnd is running, or via the InitWallet and UnlockWallet methods
        from the WalletUnlocker service.
        """

    @abc.abstractmethod
    def ExportAllChannelBackups(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupExportRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupSnapshot, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupSnapshot]]:
        """
        ExportAllChannelBackups returns static channel backups for all existing
        channels known to lnd. A set of regular singular static channel backups for
        each channel are returned. Additionally, a multi-channel backup is returned
        as well, which contains a single encrypted blob containing the backups of
        each channel.
        """

    @abc.abstractmethod
    def VerifyChanBackup(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupSnapshot,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.VerifyChanBackupResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.VerifyChanBackupResponse]]:
        """lncli: `verifychanbackup`
        VerifyChanBackup allows a caller to verify the integrity of a channel backup
        snapshot. This method will accept either a packed Single or a packed Multi.
        Specifying both will result in an error.
        """

    @abc.abstractmethod
    def RestoreChannelBackups(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.RestoreChanBackupRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.RestoreBackupResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.RestoreBackupResponse]]:
        """lncli: `restorechanbackup`
        RestoreChannelBackups accepts a set of singular channel backups, or a
        single encrypted multi-chan backup and attempts to recover any funds
        remaining within the channel. If we are able to unpack the backup, then the
        new channel will be shown under listchannels, as well as pending channels.
        """

    @abc.abstractmethod
    def SubscribeChannelBackups(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelBackupSubscription,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupSnapshot], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.ChanBackupSnapshot]]:
        """
        SubscribeChannelBackups allows a client to sub-subscribe to the most up to
        date information concerning the state of all channel backups. Each time a
        new channel is added, we return the new set of channels, along with a
        multi-chan backup containing the backup info for all channels. Each time a
        channel is closed, we send a new update, which contains new new chan back
        ups, but the updated set of encrypted multi-chan backups with the closed
        channel(s) removed.
        """

    @abc.abstractmethod
    def BakeMacaroon(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.BakeMacaroonRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.BakeMacaroonResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.BakeMacaroonResponse]]:
        """lncli: `bakemacaroon`
        BakeMacaroon allows the creation of a new macaroon with custom read and
        write permissions. No first-party caveats are added since this can be done
        offline.
        """

    @abc.abstractmethod
    def ListMacaroonIDs(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ListMacaroonIDsRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListMacaroonIDsResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListMacaroonIDsResponse]]:
        """lncli: `listmacaroonids`
        ListMacaroonIDs returns all root key IDs that are in use.
        """

    @abc.abstractmethod
    def DeleteMacaroonID(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteMacaroonIDRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteMacaroonIDResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.DeleteMacaroonIDResponse]]:
        """lncli: `deletemacaroonid`
        DeleteMacaroonID deletes the specified macaroon ID and invalidates all
        macaroons derived from that ID.
        """

    @abc.abstractmethod
    def ListPermissions(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPermissionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPermissionsResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListPermissionsResponse]]:
        """lncli: `listpermissions`
        ListPermissions lists all RPC method URIs and their required macaroon
        permissions to access them.
        """

    @abc.abstractmethod
    def CheckMacaroonPermissions(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.CheckMacPermRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.CheckMacPermResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.CheckMacPermResponse]]:
        """
        CheckMacaroonPermissions checks whether a request follows the constraints
        imposed on the macaroon and that the macaroon is authorized to follow the
        provided permissions.
        """

    @abc.abstractmethod
    def RegisterRPCMiddleware(
        self,
        request_iterator: _MaybeAsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.RPCMiddlewareResponse],
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.RPCMiddlewareRequest], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.RPCMiddlewareRequest]]:
        """
        RegisterRPCMiddleware adds a new gRPC middleware to the interceptor chain. A
        gRPC middleware is software component external to lnd that aims to add
        additional business logic to lnd by observing/intercepting/validating
        incoming gRPC client requests and (if needed) replacing/overwriting outgoing
        messages before they're sent to the client. When registering the middleware
        must identify itself and indicate what custom macaroon caveats it wants to
        be responsible for. Only requests that contain a macaroon with that specific
        custom caveat are then sent to the middleware for inspection. The other
        option is to register for the read-only mode in which all requests/responses
        are forwarded for interception to the middleware but the middleware is not
        allowed to modify any responses. As a security measure, _no_ middleware can
        modify responses for requests made with _unencumbered_ macaroons!
        """

    @abc.abstractmethod
    def SendCustomMessage(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCustomMessageRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCustomMessageResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.SendCustomMessageResponse]]:
        """lncli: `sendcustom`
        SendCustomMessage sends a custom peer message.
        """

    @abc.abstractmethod
    def SubscribeCustomMessages(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.SubscribeCustomMessagesRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.CustomMessage], collections.abc.AsyncIterator[cashu.lightning.lnd_grpc.protos.lightning_pb2.CustomMessage]]:
        """lncli: `subscribecustom`
        SubscribeCustomMessages subscribes to a stream of incoming custom peer
        messages.

        To include messages with type outside of the custom range (>= 32768) lnd
        needs to be compiled with  the `dev` build tag, and the message type to
        override should be specified in lnd's experimental protocol configuration.
        """

    @abc.abstractmethod
    def ListAliases(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.ListAliasesRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListAliasesResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.ListAliasesResponse]]:
        """lncli: `listaliases`
        ListAliases returns the set of all aliases that have ever existed with
        their confirmed SCID (if it exists) and/or the base SCID (in the case of
        zero conf).
        """

    @abc.abstractmethod
    def LookupHtlcResolution(
        self,
        request: cashu.lightning.lnd_grpc.protos.lightning_pb2.LookupHtlcResolutionRequest,
        context: _ServicerContext,
    ) -> typing.Union[cashu.lightning.lnd_grpc.protos.lightning_pb2.LookupHtlcResolutionResponse, collections.abc.Awaitable[cashu.lightning.lnd_grpc.protos.lightning_pb2.LookupHtlcResolutionResponse]]:
        """
        LookupHtlcResolution retrieves a final htlc resolution from the database.
        If the htlc has no final resolution yet, a NotFound grpc status code is
        returned.
        """

def add_LightningServicer_to_server(servicer: LightningServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
