"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import sys
import typing

import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message

import cashu.lightning.lnd_grpc.protos.lightning_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _FailureDetail:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FailureDetailEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FailureDetail.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN: _FailureDetail.ValueType  # 0
    NO_DETAIL: _FailureDetail.ValueType  # 1
    ONION_DECODE: _FailureDetail.ValueType  # 2
    LINK_NOT_ELIGIBLE: _FailureDetail.ValueType  # 3
    ON_CHAIN_TIMEOUT: _FailureDetail.ValueType  # 4
    HTLC_EXCEEDS_MAX: _FailureDetail.ValueType  # 5
    INSUFFICIENT_BALANCE: _FailureDetail.ValueType  # 6
    INCOMPLETE_FORWARD: _FailureDetail.ValueType  # 7
    HTLC_ADD_FAILED: _FailureDetail.ValueType  # 8
    FORWARDS_DISABLED: _FailureDetail.ValueType  # 9
    INVOICE_CANCELED: _FailureDetail.ValueType  # 10
    INVOICE_UNDERPAID: _FailureDetail.ValueType  # 11
    INVOICE_EXPIRY_TOO_SOON: _FailureDetail.ValueType  # 12
    INVOICE_NOT_OPEN: _FailureDetail.ValueType  # 13
    MPP_INVOICE_TIMEOUT: _FailureDetail.ValueType  # 14
    ADDRESS_MISMATCH: _FailureDetail.ValueType  # 15
    SET_TOTAL_MISMATCH: _FailureDetail.ValueType  # 16
    SET_TOTAL_TOO_LOW: _FailureDetail.ValueType  # 17
    SET_OVERPAID: _FailureDetail.ValueType  # 18
    UNKNOWN_INVOICE: _FailureDetail.ValueType  # 19
    INVALID_KEYSEND: _FailureDetail.ValueType  # 20
    MPP_IN_PROGRESS: _FailureDetail.ValueType  # 21
    CIRCULAR_ROUTE: _FailureDetail.ValueType  # 22

class FailureDetail(_FailureDetail, metaclass=_FailureDetailEnumTypeWrapper): ...

UNKNOWN: FailureDetail.ValueType  # 0
NO_DETAIL: FailureDetail.ValueType  # 1
ONION_DECODE: FailureDetail.ValueType  # 2
LINK_NOT_ELIGIBLE: FailureDetail.ValueType  # 3
ON_CHAIN_TIMEOUT: FailureDetail.ValueType  # 4
HTLC_EXCEEDS_MAX: FailureDetail.ValueType  # 5
INSUFFICIENT_BALANCE: FailureDetail.ValueType  # 6
INCOMPLETE_FORWARD: FailureDetail.ValueType  # 7
HTLC_ADD_FAILED: FailureDetail.ValueType  # 8
FORWARDS_DISABLED: FailureDetail.ValueType  # 9
INVOICE_CANCELED: FailureDetail.ValueType  # 10
INVOICE_UNDERPAID: FailureDetail.ValueType  # 11
INVOICE_EXPIRY_TOO_SOON: FailureDetail.ValueType  # 12
INVOICE_NOT_OPEN: FailureDetail.ValueType  # 13
MPP_INVOICE_TIMEOUT: FailureDetail.ValueType  # 14
ADDRESS_MISMATCH: FailureDetail.ValueType  # 15
SET_TOTAL_MISMATCH: FailureDetail.ValueType  # 16
SET_TOTAL_TOO_LOW: FailureDetail.ValueType  # 17
SET_OVERPAID: FailureDetail.ValueType  # 18
UNKNOWN_INVOICE: FailureDetail.ValueType  # 19
INVALID_KEYSEND: FailureDetail.ValueType  # 20
MPP_IN_PROGRESS: FailureDetail.ValueType  # 21
CIRCULAR_ROUTE: FailureDetail.ValueType  # 22
global___FailureDetail = FailureDetail

class _PaymentState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PaymentStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PaymentState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    IN_FLIGHT: _PaymentState.ValueType  # 0
    """
    Payment is still in flight.
    """
    SUCCEEDED: _PaymentState.ValueType  # 1
    """
    Payment completed successfully.
    """
    FAILED_TIMEOUT: _PaymentState.ValueType  # 2
    """
    There are more routes to try, but the payment timeout was exceeded.
    """
    FAILED_NO_ROUTE: _PaymentState.ValueType  # 3
    """
    All possible routes were tried and failed permanently. Or were no
    routes to the destination at all.
    """
    FAILED_ERROR: _PaymentState.ValueType  # 4
    """
    A non-recoverable error has occurred.
    """
    FAILED_INCORRECT_PAYMENT_DETAILS: _PaymentState.ValueType  # 5
    """
    Payment details incorrect (unknown hash, invalid amt or
    invalid final cltv delta)
    """
    FAILED_INSUFFICIENT_BALANCE: _PaymentState.ValueType  # 6
    """
    Insufficient local balance.
    """

class PaymentState(_PaymentState, metaclass=_PaymentStateEnumTypeWrapper): ...

IN_FLIGHT: PaymentState.ValueType  # 0
"""
Payment is still in flight.
"""
SUCCEEDED: PaymentState.ValueType  # 1
"""
Payment completed successfully.
"""
FAILED_TIMEOUT: PaymentState.ValueType  # 2
"""
There are more routes to try, but the payment timeout was exceeded.
"""
FAILED_NO_ROUTE: PaymentState.ValueType  # 3
"""
All possible routes were tried and failed permanently. Or were no
routes to the destination at all.
"""
FAILED_ERROR: PaymentState.ValueType  # 4
"""
A non-recoverable error has occurred.
"""
FAILED_INCORRECT_PAYMENT_DETAILS: PaymentState.ValueType  # 5
"""
Payment details incorrect (unknown hash, invalid amt or
invalid final cltv delta)
"""
FAILED_INSUFFICIENT_BALANCE: PaymentState.ValueType  # 6
"""
Insufficient local balance.
"""
global___PaymentState = PaymentState

class _ResolveHoldForwardAction:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ResolveHoldForwardActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ResolveHoldForwardAction.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SETTLE: _ResolveHoldForwardAction.ValueType  # 0
    FAIL: _ResolveHoldForwardAction.ValueType  # 1
    RESUME: _ResolveHoldForwardAction.ValueType  # 2

class ResolveHoldForwardAction(_ResolveHoldForwardAction, metaclass=_ResolveHoldForwardActionEnumTypeWrapper): ...

SETTLE: ResolveHoldForwardAction.ValueType  # 0
FAIL: ResolveHoldForwardAction.ValueType  # 1
RESUME: ResolveHoldForwardAction.ValueType  # 2
global___ResolveHoldForwardAction = ResolveHoldForwardAction

class _ChanStatusAction:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ChanStatusActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ChanStatusAction.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ENABLE: _ChanStatusAction.ValueType  # 0
    DISABLE: _ChanStatusAction.ValueType  # 1
    AUTO: _ChanStatusAction.ValueType  # 2

class ChanStatusAction(_ChanStatusAction, metaclass=_ChanStatusActionEnumTypeWrapper): ...

ENABLE: ChanStatusAction.ValueType  # 0
DISABLE: ChanStatusAction.ValueType  # 1
AUTO: ChanStatusAction.ValueType  # 2
global___ChanStatusAction = ChanStatusAction

@typing.final
class SendPaymentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DestCustomRecordsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DEST_FIELD_NUMBER: builtins.int
    AMT_FIELD_NUMBER: builtins.int
    PAYMENT_HASH_FIELD_NUMBER: builtins.int
    FINAL_CLTV_DELTA_FIELD_NUMBER: builtins.int
    PAYMENT_REQUEST_FIELD_NUMBER: builtins.int
    TIMEOUT_SECONDS_FIELD_NUMBER: builtins.int
    FEE_LIMIT_SAT_FIELD_NUMBER: builtins.int
    OUTGOING_CHAN_ID_FIELD_NUMBER: builtins.int
    CLTV_LIMIT_FIELD_NUMBER: builtins.int
    ROUTE_HINTS_FIELD_NUMBER: builtins.int
    DEST_CUSTOM_RECORDS_FIELD_NUMBER: builtins.int
    AMT_MSAT_FIELD_NUMBER: builtins.int
    FEE_LIMIT_MSAT_FIELD_NUMBER: builtins.int
    LAST_HOP_PUBKEY_FIELD_NUMBER: builtins.int
    ALLOW_SELF_PAYMENT_FIELD_NUMBER: builtins.int
    DEST_FEATURES_FIELD_NUMBER: builtins.int
    MAX_PARTS_FIELD_NUMBER: builtins.int
    NO_INFLIGHT_UPDATES_FIELD_NUMBER: builtins.int
    OUTGOING_CHAN_IDS_FIELD_NUMBER: builtins.int
    PAYMENT_ADDR_FIELD_NUMBER: builtins.int
    MAX_SHARD_SIZE_MSAT_FIELD_NUMBER: builtins.int
    AMP_FIELD_NUMBER: builtins.int
    TIME_PREF_FIELD_NUMBER: builtins.int
    CANCELABLE_FIELD_NUMBER: builtins.int
    dest: builtins.bytes
    """The identity pubkey of the payment recipient"""
    amt: builtins.int
    """
    Number of satoshis to send.

    The fields amt and amt_msat are mutually exclusive.
    """
    payment_hash: builtins.bytes
    """The hash to use within the payment's HTLC"""
    final_cltv_delta: builtins.int
    """
    The CLTV delta from the current height that should be used to set the
    timelock for the final hop.
    """
    payment_request: builtins.str
    """
    A bare-bones invoice for a payment within the Lightning Network.  With the
    details of the invoice, the sender has all the data necessary to send a
    payment to the recipient. The amount in the payment request may be zero. In
    that case it is required to set the amt field as well. If no payment request
    is specified, the following fields are required: dest, amt and payment_hash.
    """
    timeout_seconds: builtins.int
    """
    An upper limit on the amount of time we should spend when attempting to
    fulfill the payment. This is expressed in seconds. If we cannot make a
    successful payment within this time frame, an error will be returned.
    This field must be non-zero.
    """
    fee_limit_sat: builtins.int
    """
    The maximum number of satoshis that will be paid as a fee of the payment.
    If this field is left to the default value of 0, only zero-fee routes will
    be considered. This usually means single hop routes connecting directly to
    the destination. To send the payment without a fee limit, use max int here.

    The fields fee_limit_sat and fee_limit_msat are mutually exclusive.
    """
    outgoing_chan_id: builtins.int
    """
    Deprecated, use outgoing_chan_ids. The channel id of the channel that must
    be taken to the first hop. If zero, any channel may be used (unless
    outgoing_chan_ids are set).
    """
    cltv_limit: builtins.int
    """
    An optional maximum total time lock for the route. This should not
    exceed lnd's `--max-cltv-expiry` setting. If zero, then the value of
    `--max-cltv-expiry` is enforced.
    """
    amt_msat: builtins.int
    """
    Number of millisatoshis to send.

    The fields amt and amt_msat are mutually exclusive.
    """
    fee_limit_msat: builtins.int
    """
    The maximum number of millisatoshis that will be paid as a fee of the
    payment. If this field is left to the default value of 0, only zero-fee
    routes will be considered. This usually means single hop routes connecting
    directly to the destination. To send the payment without a fee limit, use
    max int here.

    The fields fee_limit_sat and fee_limit_msat are mutually exclusive.
    """
    last_hop_pubkey: builtins.bytes
    """
    The pubkey of the last hop of the route. If empty, any hop may be used.
    """
    allow_self_payment: builtins.bool
    """If set, circular payments to self are permitted."""
    max_parts: builtins.int
    """
    The maximum number of partial payments that may be use to complete the full
    amount.
    """
    no_inflight_updates: builtins.bool
    """
    If set, only the final payment update is streamed back. Intermediate updates
    that show which htlcs are still in flight are suppressed.
    """
    payment_addr: builtins.bytes
    """
    An optional payment addr to be included within the last hop of the route.
    This is also called payment secret in specifications (e.g. BOLT 11).
    """
    max_shard_size_msat: builtins.int
    """
    The largest payment split that should be attempted when making a payment if
    splitting is necessary. Setting this value will effectively cause lnd to
    split more aggressively, vs only when it thinks it needs to. Note that this
    value is in milli-satoshis.
    """
    amp: builtins.bool
    """
    If set, an AMP-payment will be attempted.
    """
    time_pref: builtins.float
    """
    The time preference for this payment. Set to -1 to optimize for fees
    only, to 1 to optimize for reliability only or a value inbetween for a mix.
    """
    cancelable: builtins.bool
    """
    If set, the payment loop can be interrupted by manually canceling the
    payment context, even before the payment timeout is reached. Note that the
    payment may still succeed after cancellation, as in-flight attempts can
    still settle afterwards. Canceling will only prevent further attempts from
    being sent.
    """
    @property
    def route_hints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[cashu.lightning.lnd_grpc.protos.lightning_pb2.RouteHint]:
        """
        Optional route hints to reach the destination through private channels.
        """

    @property
    def dest_custom_records(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.bytes]:
        """
        An optional field that can be used to pass an arbitrary set of TLV records
        to a peer which understands the new records. This can be used to pass
        application specific data during the payment attempt. Record types are
        required to be in the custom range >= 65536. When using REST, the values
        must be encoded as base64.
        """

    @property
    def dest_features(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[cashu.lightning.lnd_grpc.protos.lightning_pb2.FeatureBit.ValueType]:
        """
        Features assumed to be supported by the final node. All transitive feature
        dependencies must also be set properly. For a given feature bit pair, either
        optional or remote may be set, but not both. If this field is nil or empty,
        the router will try to load destination features from the graph as a
        fallback.
        """

    @property
    def outgoing_chan_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """
        The channel ids of the channels are allowed for the first hop. If empty,
        any channel may be used.
        """

    def __init__(
        self,
        *,
        dest: builtins.bytes = ...,
        amt: builtins.int = ...,
        payment_hash: builtins.bytes = ...,
        final_cltv_delta: builtins.int = ...,
        payment_request: builtins.str = ...,
        timeout_seconds: builtins.int = ...,
        fee_limit_sat: builtins.int = ...,
        outgoing_chan_id: builtins.int = ...,
        cltv_limit: builtins.int = ...,
        route_hints: collections.abc.Iterable[cashu.lightning.lnd_grpc.protos.lightning_pb2.RouteHint] | None = ...,
        dest_custom_records: collections.abc.Mapping[builtins.int, builtins.bytes] | None = ...,
        amt_msat: builtins.int = ...,
        fee_limit_msat: builtins.int = ...,
        last_hop_pubkey: builtins.bytes = ...,
        allow_self_payment: builtins.bool = ...,
        dest_features: collections.abc.Iterable[cashu.lightning.lnd_grpc.protos.lightning_pb2.FeatureBit.ValueType] | None = ...,
        max_parts: builtins.int = ...,
        no_inflight_updates: builtins.bool = ...,
        outgoing_chan_ids: collections.abc.Iterable[builtins.int] | None = ...,
        payment_addr: builtins.bytes = ...,
        max_shard_size_msat: builtins.int = ...,
        amp: builtins.bool = ...,
        time_pref: builtins.float = ...,
        cancelable: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["allow_self_payment", b"allow_self_payment", "amp", b"amp", "amt", b"amt", "amt_msat", b"amt_msat", "cancelable", b"cancelable", "cltv_limit", b"cltv_limit", "dest", b"dest", "dest_custom_records", b"dest_custom_records", "dest_features", b"dest_features", "fee_limit_msat", b"fee_limit_msat", "fee_limit_sat", b"fee_limit_sat", "final_cltv_delta", b"final_cltv_delta", "last_hop_pubkey", b"last_hop_pubkey", "max_parts", b"max_parts", "max_shard_size_msat", b"max_shard_size_msat", "no_inflight_updates", b"no_inflight_updates", "outgoing_chan_id", b"outgoing_chan_id", "outgoing_chan_ids", b"outgoing_chan_ids", "payment_addr", b"payment_addr", "payment_hash", b"payment_hash", "payment_request", b"payment_request", "route_hints", b"route_hints", "time_pref", b"time_pref", "timeout_seconds", b"timeout_seconds"]) -> None: ...

global___SendPaymentRequest = SendPaymentRequest

@typing.final
class TrackPaymentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYMENT_HASH_FIELD_NUMBER: builtins.int
    NO_INFLIGHT_UPDATES_FIELD_NUMBER: builtins.int
    payment_hash: builtins.bytes
    """The hash of the payment to look up."""
    no_inflight_updates: builtins.bool
    """
    If set, only the final payment update is streamed back. Intermediate updates
    that show which htlcs are still in flight are suppressed.
    """
    def __init__(
        self,
        *,
        payment_hash: builtins.bytes = ...,
        no_inflight_updates: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["no_inflight_updates", b"no_inflight_updates", "payment_hash", b"payment_hash"]) -> None: ...

global___TrackPaymentRequest = TrackPaymentRequest

@typing.final
class TrackPaymentsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NO_INFLIGHT_UPDATES_FIELD_NUMBER: builtins.int
    no_inflight_updates: builtins.bool
    """
    If set, only the final payment updates are streamed back. Intermediate
    updates that show which htlcs are still in flight are suppressed.
    """
    def __init__(
        self,
        *,
        no_inflight_updates: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["no_inflight_updates", b"no_inflight_updates"]) -> None: ...

global___TrackPaymentsRequest = TrackPaymentsRequest

@typing.final
class RouteFeeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEST_FIELD_NUMBER: builtins.int
    AMT_SAT_FIELD_NUMBER: builtins.int
    PAYMENT_REQUEST_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    dest: builtins.bytes
    """
    The destination one wishes to obtain a routing fee quote to. If set, this
    parameter requires the amt_sat parameter also to be set. This parameter
    combination triggers a graph based routing fee estimation as opposed to a
    payment probe based estimate in case a payment request is provided. The
    graph based estimation is an algorithm that is executed on the in memory
    graph. Hence its runtime is significantly shorter than a payment probe
    estimation that sends out actual payments to the network.
    """
    amt_sat: builtins.int
    """
    The amount one wishes to send to the target destination. It is only to be
    used in combination with the dest parameter.
    """
    payment_request: builtins.str
    """
    A payment request of the target node that the route fee request is intended
    for. Its parameters are input to probe payments that estimate routing fees.
    The timeout parameter can be specified to set a maximum time on the probing
    attempt. Cannot be used in combination with dest and amt_sat.
    """
    timeout: builtins.int
    """
    A user preference of how long a probe payment should maximally be allowed to
    take, denoted in seconds. The probing payment loop is aborted if this
    timeout is reached. Note that the probing process itself can take longer
    than the timeout if the HTLC becomes delayed or stuck. Canceling the context
    of this call will not cancel the payment loop, the duration is only
    controlled by the timeout parameter.
    """
    def __init__(
        self,
        *,
        dest: builtins.bytes = ...,
        amt_sat: builtins.int = ...,
        payment_request: builtins.str = ...,
        timeout: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["amt_sat", b"amt_sat", "dest", b"dest", "payment_request", b"payment_request", "timeout", b"timeout"]) -> None: ...

global___RouteFeeRequest = RouteFeeRequest

@typing.final
class RouteFeeResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTING_FEE_MSAT_FIELD_NUMBER: builtins.int
    TIME_LOCK_DELAY_FIELD_NUMBER: builtins.int
    FAILURE_REASON_FIELD_NUMBER: builtins.int
    routing_fee_msat: builtins.int
    """
    A lower bound of the estimated fee to the target destination within the
    network, expressed in milli-satoshis.
    """
    time_lock_delay: builtins.int
    """
    An estimate of the worst case time delay that can occur. Note that callers
    will still need to factor in the final CLTV delta of the last hop into this
    value.
    """
    failure_reason: cashu.lightning.lnd_grpc.protos.lightning_pb2.PaymentFailureReason.ValueType
    """
    An indication whether a probing payment succeeded or whether and why it
    failed. FAILURE_REASON_NONE indicates success.
    """
    def __init__(
        self,
        *,
        routing_fee_msat: builtins.int = ...,
        time_lock_delay: builtins.int = ...,
        failure_reason: cashu.lightning.lnd_grpc.protos.lightning_pb2.PaymentFailureReason.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["failure_reason", b"failure_reason", "routing_fee_msat", b"routing_fee_msat", "time_lock_delay", b"time_lock_delay"]) -> None: ...

global___RouteFeeResponse = RouteFeeResponse

@typing.final
class SendToRouteRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYMENT_HASH_FIELD_NUMBER: builtins.int
    ROUTE_FIELD_NUMBER: builtins.int
    SKIP_TEMP_ERR_FIELD_NUMBER: builtins.int
    payment_hash: builtins.bytes
    """The payment hash to use for the HTLC."""
    skip_temp_err: builtins.bool
    """
    Whether the payment should be marked as failed when a temporary error is
    returned from the given route. Set it to true so the payment won't be
    failed unless a terminal error is occurred, such as payment timeout, no
    routes, incorrect payment details, or insufficient funds.
    """
    @property
    def route(self) -> cashu.lightning.lnd_grpc.protos.lightning_pb2.Route:
        """Route that should be used to attempt to complete the payment."""

    def __init__(
        self,
        *,
        payment_hash: builtins.bytes = ...,
        route: cashu.lightning.lnd_grpc.protos.lightning_pb2.Route | None = ...,
        skip_temp_err: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["route", b"route"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["payment_hash", b"payment_hash", "route", b"route", "skip_temp_err", b"skip_temp_err"]) -> None: ...

global___SendToRouteRequest = SendToRouteRequest

@typing.final
class SendToRouteResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREIMAGE_FIELD_NUMBER: builtins.int
    FAILURE_FIELD_NUMBER: builtins.int
    preimage: builtins.bytes
    """The preimage obtained by making the payment."""
    @property
    def failure(self) -> cashu.lightning.lnd_grpc.protos.lightning_pb2.Failure:
        """The failure message in case the payment failed."""

    def __init__(
        self,
        *,
        preimage: builtins.bytes = ...,
        failure: cashu.lightning.lnd_grpc.protos.lightning_pb2.Failure | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["failure", b"failure"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["failure", b"failure", "preimage", b"preimage"]) -> None: ...

global___SendToRouteResponse = SendToRouteResponse

@typing.final
class ResetMissionControlRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ResetMissionControlRequest = ResetMissionControlRequest

@typing.final
class ResetMissionControlResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ResetMissionControlResponse = ResetMissionControlResponse

@typing.final
class QueryMissionControlRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___QueryMissionControlRequest = QueryMissionControlRequest

@typing.final
class QueryMissionControlResponse(google.protobuf.message.Message):
    """QueryMissionControlResponse contains mission control state."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAIRS_FIELD_NUMBER: builtins.int
    @property
    def pairs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PairHistory]:
        """Node pair-level mission control state."""

    def __init__(
        self,
        *,
        pairs: collections.abc.Iterable[global___PairHistory] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pairs", b"pairs"]) -> None: ...

global___QueryMissionControlResponse = QueryMissionControlResponse

@typing.final
class XImportMissionControlRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAIRS_FIELD_NUMBER: builtins.int
    FORCE_FIELD_NUMBER: builtins.int
    force: builtins.bool
    """Whether to force override MC pair history. Note that even with force
    override the failure pair is imported before the success pair and both
    still clamp existing failure/success amounts.
    """
    @property
    def pairs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PairHistory]:
        """Node pair-level mission control state to be imported."""

    def __init__(
        self,
        *,
        pairs: collections.abc.Iterable[global___PairHistory] | None = ...,
        force: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["force", b"force", "pairs", b"pairs"]) -> None: ...

global___XImportMissionControlRequest = XImportMissionControlRequest

@typing.final
class XImportMissionControlResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___XImportMissionControlResponse = XImportMissionControlResponse

@typing.final
class PairHistory(google.protobuf.message.Message):
    """PairHistory contains the mission control state for a particular node pair."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODE_FROM_FIELD_NUMBER: builtins.int
    NODE_TO_FIELD_NUMBER: builtins.int
    HISTORY_FIELD_NUMBER: builtins.int
    node_from: builtins.bytes
    """The source node pubkey of the pair."""
    node_to: builtins.bytes
    """The destination node pubkey of the pair."""
    @property
    def history(self) -> global___PairData: ...
    def __init__(
        self,
        *,
        node_from: builtins.bytes = ...,
        node_to: builtins.bytes = ...,
        history: global___PairData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["history", b"history"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["history", b"history", "node_from", b"node_from", "node_to", b"node_to"]) -> None: ...

global___PairHistory = PairHistory

@typing.final
class PairData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FAIL_TIME_FIELD_NUMBER: builtins.int
    FAIL_AMT_SAT_FIELD_NUMBER: builtins.int
    FAIL_AMT_MSAT_FIELD_NUMBER: builtins.int
    SUCCESS_TIME_FIELD_NUMBER: builtins.int
    SUCCESS_AMT_SAT_FIELD_NUMBER: builtins.int
    SUCCESS_AMT_MSAT_FIELD_NUMBER: builtins.int
    fail_time: builtins.int
    """Time of last failure."""
    fail_amt_sat: builtins.int
    """
    Lowest amount that failed to forward rounded to whole sats. This may be
    set to zero if the failure is independent of amount.
    """
    fail_amt_msat: builtins.int
    """
    Lowest amount that failed to forward in millisats. This may be
    set to zero if the failure is independent of amount.
    """
    success_time: builtins.int
    """Time of last success."""
    success_amt_sat: builtins.int
    """Highest amount that we could successfully forward rounded to whole sats."""
    success_amt_msat: builtins.int
    """Highest amount that we could successfully forward in millisats."""
    def __init__(
        self,
        *,
        fail_time: builtins.int = ...,
        fail_amt_sat: builtins.int = ...,
        fail_amt_msat: builtins.int = ...,
        success_time: builtins.int = ...,
        success_amt_sat: builtins.int = ...,
        success_amt_msat: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["fail_amt_msat", b"fail_amt_msat", "fail_amt_sat", b"fail_amt_sat", "fail_time", b"fail_time", "success_amt_msat", b"success_amt_msat", "success_amt_sat", b"success_amt_sat", "success_time", b"success_time"]) -> None: ...

global___PairData = PairData

@typing.final
class GetMissionControlConfigRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetMissionControlConfigRequest = GetMissionControlConfigRequest

@typing.final
class GetMissionControlConfigResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> global___MissionControlConfig:
        """
        Mission control's currently active config.
        """

    def __init__(
        self,
        *,
        config: global___MissionControlConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config"]) -> None: ...

global___GetMissionControlConfigResponse = GetMissionControlConfigResponse

@typing.final
class SetMissionControlConfigRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> global___MissionControlConfig:
        """
        The config to set for mission control. Note that all values *must* be set,
        because the full config will be applied.
        """

    def __init__(
        self,
        *,
        config: global___MissionControlConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config"]) -> None: ...

global___SetMissionControlConfigRequest = SetMissionControlConfigRequest

@typing.final
class SetMissionControlConfigResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SetMissionControlConfigResponse = SetMissionControlConfigResponse

@typing.final
class MissionControlConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ProbabilityModel:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ProbabilityModelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MissionControlConfig._ProbabilityModel.ValueType], builtins.type):   # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        APRIORI: MissionControlConfig._ProbabilityModel.ValueType  # 0
        BIMODAL: MissionControlConfig._ProbabilityModel.ValueType  # 1

    class ProbabilityModel(_ProbabilityModel, metaclass=_ProbabilityModelEnumTypeWrapper): ...
    APRIORI: MissionControlConfig.ProbabilityModel.ValueType  # 0
    BIMODAL: MissionControlConfig.ProbabilityModel.ValueType  # 1

    HALF_LIFE_SECONDS_FIELD_NUMBER: builtins.int
    HOP_PROBABILITY_FIELD_NUMBER: builtins.int
    WEIGHT_FIELD_NUMBER: builtins.int
    MAXIMUM_PAYMENT_RESULTS_FIELD_NUMBER: builtins.int
    MINIMUM_FAILURE_RELAX_INTERVAL_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    APRIORI_FIELD_NUMBER: builtins.int
    BIMODAL_FIELD_NUMBER: builtins.int
    half_life_seconds: builtins.int
    """
    Deprecated, use AprioriParameters. The amount of time mission control will
    take to restore a penalized node or channel back to 50% success probability,
    expressed in seconds. Setting this value to a higher value will penalize
    failures for longer, making mission control less likely to route through
    nodes and channels that we have previously recorded failures for.
    """
    hop_probability: builtins.float
    """
    Deprecated, use AprioriParameters. The probability of success mission
    control should assign to hop in a route where it has no other information
    available. Higher values will make mission control more willing to try hops
    that we have no information about, lower values will discourage trying these
    hops.
    """
    weight: builtins.float
    """
    Deprecated, use AprioriParameters. The importance that mission control
    should place on historical results, expressed as a value in [0;1]. Setting
    this value to 1 will ignore all historical payments and just use the hop
    probability to assess the probability of success for each hop. A zero value
    ignores hop probability completely and relies entirely on historical
    results, unless none are available.
    """
    maximum_payment_results: builtins.int
    """
    The maximum number of payment results that mission control will store.
    """
    minimum_failure_relax_interval: builtins.int
    """
    The minimum time that must have passed since the previously recorded failure
    before we raise the failure amount.
    """
    model: global___MissionControlConfig.ProbabilityModel.ValueType
    """
    ProbabilityModel defines which probability estimator should be used in
    pathfinding. Note that the bimodal estimator is experimental.
    """
    @property
    def apriori(self) -> global___AprioriParameters: ...
    @property
    def bimodal(self) -> global___BimodalParameters: ...
    def __init__(
        self,
        *,
        half_life_seconds: builtins.int = ...,
        hop_probability: builtins.float = ...,
        weight: builtins.float = ...,
        maximum_payment_results: builtins.int = ...,
        minimum_failure_relax_interval: builtins.int = ...,
        model: global___MissionControlConfig.ProbabilityModel.ValueType = ...,
        apriori: global___AprioriParameters | None = ...,
        bimodal: global___BimodalParameters | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["EstimatorConfig", b"EstimatorConfig", "apriori", b"apriori", "bimodal", b"bimodal"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["EstimatorConfig", b"EstimatorConfig", "apriori", b"apriori", "bimodal", b"bimodal", "half_life_seconds", b"half_life_seconds", "hop_probability", b"hop_probability", "maximum_payment_results", b"maximum_payment_results", "minimum_failure_relax_interval", b"minimum_failure_relax_interval", "model", b"model", "weight", b"weight"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["EstimatorConfig", b"EstimatorConfig"]) -> typing.Literal["apriori", "bimodal"] | None: ...

global___MissionControlConfig = MissionControlConfig

@typing.final
class BimodalParameters(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODE_WEIGHT_FIELD_NUMBER: builtins.int
    SCALE_MSAT_FIELD_NUMBER: builtins.int
    DECAY_TIME_FIELD_NUMBER: builtins.int
    node_weight: builtins.float
    """
    NodeWeight defines how strongly other previous forwardings on channels of a
    router should be taken into account when computing a channel's probability
    to route. The allowed values are in the range [0, 1], where a value of 0
    means that only direct information about a channel is taken into account.
    """
    scale_msat: builtins.int
    """
    ScaleMsat describes the scale over which channels statistically have some
    liquidity left. The value determines how quickly the bimodal distribution
    drops off from the edges of a channel. A larger value (compared to typical
    channel capacities) means that the drop off is slow and that channel
    balances are distributed more uniformly. A small value leads to the
    assumption of very unbalanced channels.
    """
    decay_time: builtins.int
    """
    DecayTime describes the information decay of knowledge about previous
    successes and failures in channels. The smaller the decay time, the quicker
    we forget about past forwardings.
    """
    def __init__(
        self,
        *,
        node_weight: builtins.float = ...,
        scale_msat: builtins.int = ...,
        decay_time: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["decay_time", b"decay_time", "node_weight", b"node_weight", "scale_msat", b"scale_msat"]) -> None: ...

global___BimodalParameters = BimodalParameters

@typing.final
class AprioriParameters(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HALF_LIFE_SECONDS_FIELD_NUMBER: builtins.int
    HOP_PROBABILITY_FIELD_NUMBER: builtins.int
    WEIGHT_FIELD_NUMBER: builtins.int
    CAPACITY_FRACTION_FIELD_NUMBER: builtins.int
    half_life_seconds: builtins.int
    """
    The amount of time mission control will take to restore a penalized node
    or channel back to 50% success probability, expressed in seconds. Setting
    this value to a higher value will penalize failures for longer, making
    mission control less likely to route through nodes and channels that we
    have previously recorded failures for.
    """
    hop_probability: builtins.float
    """
    The probability of success mission control should assign to hop in a route
    where it has no other information available. Higher values will make mission
    control more willing to try hops that we have no information about, lower
    values will discourage trying these hops.
    """
    weight: builtins.float
    """
    The importance that mission control should place on historical results,
    expressed as a value in [0;1]. Setting this value to 1 will ignore all
    historical payments and just use the hop probability to assess the
    probability of success for each hop. A zero value ignores hop probability
    completely and relies entirely on historical results, unless none are
    available.
    """
    capacity_fraction: builtins.float
    """
    The fraction of a channel's capacity that we consider to have liquidity. For
    amounts that come close to or exceed the fraction, an additional penalty is
    applied. A value of 1.0 disables the capacity factor. Allowed values are in
    [0.75, 1.0].
    """
    def __init__(
        self,
        *,
        half_life_seconds: builtins.int = ...,
        hop_probability: builtins.float = ...,
        weight: builtins.float = ...,
        capacity_fraction: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["capacity_fraction", b"capacity_fraction", "half_life_seconds", b"half_life_seconds", "hop_probability", b"hop_probability", "weight", b"weight"]) -> None: ...

global___AprioriParameters = AprioriParameters

@typing.final
class QueryProbabilityRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FROM_NODE_FIELD_NUMBER: builtins.int
    TO_NODE_FIELD_NUMBER: builtins.int
    AMT_MSAT_FIELD_NUMBER: builtins.int
    from_node: builtins.bytes
    """The source node pubkey of the pair."""
    to_node: builtins.bytes
    """The destination node pubkey of the pair."""
    amt_msat: builtins.int
    """The amount for which to calculate a probability."""
    def __init__(
        self,
        *,
        from_node: builtins.bytes = ...,
        to_node: builtins.bytes = ...,
        amt_msat: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["amt_msat", b"amt_msat", "from_node", b"from_node", "to_node", b"to_node"]) -> None: ...

global___QueryProbabilityRequest = QueryProbabilityRequest

@typing.final
class QueryProbabilityResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROBABILITY_FIELD_NUMBER: builtins.int
    HISTORY_FIELD_NUMBER: builtins.int
    probability: builtins.float
    """The success probability for the requested pair."""
    @property
    def history(self) -> global___PairData:
        """The historical data for the requested pair."""

    def __init__(
        self,
        *,
        probability: builtins.float = ...,
        history: global___PairData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["history", b"history"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["history", b"history", "probability", b"probability"]) -> None: ...

global___QueryProbabilityResponse = QueryProbabilityResponse

@typing.final
class BuildRouteRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AMT_MSAT_FIELD_NUMBER: builtins.int
    FINAL_CLTV_DELTA_FIELD_NUMBER: builtins.int
    OUTGOING_CHAN_ID_FIELD_NUMBER: builtins.int
    HOP_PUBKEYS_FIELD_NUMBER: builtins.int
    PAYMENT_ADDR_FIELD_NUMBER: builtins.int
    amt_msat: builtins.int
    """
    The amount to send expressed in msat. If set to zero, the minimum routable
    amount is used.
    """
    final_cltv_delta: builtins.int
    """
    CLTV delta from the current height that should be used for the timelock
    of the final hop
    """
    outgoing_chan_id: builtins.int
    """
    The channel id of the channel that must be taken to the first hop. If zero,
    any channel may be used.
    """
    payment_addr: builtins.bytes
    """
    An optional payment addr to be included within the last hop of the route.
    This is also called payment secret in specifications (e.g. BOLT 11).
    """
    @property
    def hop_pubkeys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]:
        """
        A list of hops that defines the route. This does not include the source hop
        pubkey.
        """

    def __init__(
        self,
        *,
        amt_msat: builtins.int = ...,
        final_cltv_delta: builtins.int = ...,
        outgoing_chan_id: builtins.int = ...,
        hop_pubkeys: collections.abc.Iterable[builtins.bytes] | None = ...,
        payment_addr: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["amt_msat", b"amt_msat", "final_cltv_delta", b"final_cltv_delta", "hop_pubkeys", b"hop_pubkeys", "outgoing_chan_id", b"outgoing_chan_id", "payment_addr", b"payment_addr"]) -> None: ...

global___BuildRouteRequest = BuildRouteRequest

@typing.final
class BuildRouteResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTE_FIELD_NUMBER: builtins.int
    @property
    def route(self) -> cashu.lightning.lnd_grpc.protos.lightning_pb2.Route:
        """
        Fully specified route that can be used to execute the payment.
        """

    def __init__(
        self,
        *,
        route: cashu.lightning.lnd_grpc.protos.lightning_pb2.Route | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["route", b"route"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["route", b"route"]) -> None: ...

global___BuildRouteResponse = BuildRouteResponse

@typing.final
class SubscribeHtlcEventsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SubscribeHtlcEventsRequest = SubscribeHtlcEventsRequest

@typing.final
class HtlcEvent(google.protobuf.message.Message):
    """
    HtlcEvent contains the htlc event that was processed. These are served on a
    best-effort basis; events are not persisted, delivery is not guaranteed
    (in the event of a crash in the switch, forward events may be lost) and
    some events may be replayed upon restart. Events consumed from this package
    should be de-duplicated by the htlc's unique combination of incoming and
    outgoing channel id and htlc id. [EXPERIMENTAL]
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _EventType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EventTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[HtlcEvent._EventType.ValueType], builtins.type):    # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: HtlcEvent._EventType.ValueType  # 0
        SEND: HtlcEvent._EventType.ValueType  # 1
        RECEIVE: HtlcEvent._EventType.ValueType  # 2
        FORWARD: HtlcEvent._EventType.ValueType  # 3

    class EventType(_EventType, metaclass=_EventTypeEnumTypeWrapper): ...
    UNKNOWN: HtlcEvent.EventType.ValueType  # 0
    SEND: HtlcEvent.EventType.ValueType  # 1
    RECEIVE: HtlcEvent.EventType.ValueType  # 2
    FORWARD: HtlcEvent.EventType.ValueType  # 3

    INCOMING_CHANNEL_ID_FIELD_NUMBER: builtins.int
    OUTGOING_CHANNEL_ID_FIELD_NUMBER: builtins.int
    INCOMING_HTLC_ID_FIELD_NUMBER: builtins.int
    OUTGOING_HTLC_ID_FIELD_NUMBER: builtins.int
    TIMESTAMP_NS_FIELD_NUMBER: builtins.int
    EVENT_TYPE_FIELD_NUMBER: builtins.int
    FORWARD_EVENT_FIELD_NUMBER: builtins.int
    FORWARD_FAIL_EVENT_FIELD_NUMBER: builtins.int
    SETTLE_EVENT_FIELD_NUMBER: builtins.int
    LINK_FAIL_EVENT_FIELD_NUMBER: builtins.int
    SUBSCRIBED_EVENT_FIELD_NUMBER: builtins.int
    FINAL_HTLC_EVENT_FIELD_NUMBER: builtins.int
    incoming_channel_id: builtins.int
    """
    The short channel id that the incoming htlc arrived at our node on. This
    value is zero for sends.
    """
    outgoing_channel_id: builtins.int
    """
    The short channel id that the outgoing htlc left our node on. This value
    is zero for receives.
    """
    incoming_htlc_id: builtins.int
    """
    Incoming id is the index of the incoming htlc in the incoming channel.
    This value is zero for sends.
    """
    outgoing_htlc_id: builtins.int
    """
    Outgoing id is the index of the outgoing htlc in the outgoing channel.
    This value is zero for receives.
    """
    timestamp_ns: builtins.int
    """
    The time in unix nanoseconds that the event occurred.
    """
    event_type: global___HtlcEvent.EventType.ValueType
    """
    The event type indicates whether the htlc was part of a send, receive or
    forward.
    """
    @property
    def forward_event(self) -> global___ForwardEvent: ...
    @property
    def forward_fail_event(self) -> global___ForwardFailEvent: ...
    @property
    def settle_event(self) -> global___SettleEvent: ...
    @property
    def link_fail_event(self) -> global___LinkFailEvent: ...
    @property
    def subscribed_event(self) -> global___SubscribedEvent: ...
    @property
    def final_htlc_event(self) -> global___FinalHtlcEvent: ...
    def __init__(
        self,
        *,
        incoming_channel_id: builtins.int = ...,
        outgoing_channel_id: builtins.int = ...,
        incoming_htlc_id: builtins.int = ...,
        outgoing_htlc_id: builtins.int = ...,
        timestamp_ns: builtins.int = ...,
        event_type: global___HtlcEvent.EventType.ValueType = ...,
        forward_event: global___ForwardEvent | None = ...,
        forward_fail_event: global___ForwardFailEvent | None = ...,
        settle_event: global___SettleEvent | None = ...,
        link_fail_event: global___LinkFailEvent | None = ...,
        subscribed_event: global___SubscribedEvent | None = ...,
        final_htlc_event: global___FinalHtlcEvent | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["event", b"event", "final_htlc_event", b"final_htlc_event", "forward_event", b"forward_event", "forward_fail_event", b"forward_fail_event", "link_fail_event", b"link_fail_event", "settle_event", b"settle_event", "subscribed_event", b"subscribed_event"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["event", b"event", "event_type", b"event_type", "final_htlc_event", b"final_htlc_event", "forward_event", b"forward_event", "forward_fail_event", b"forward_fail_event", "incoming_channel_id", b"incoming_channel_id", "incoming_htlc_id", b"incoming_htlc_id", "link_fail_event", b"link_fail_event", "outgoing_channel_id", b"outgoing_channel_id", "outgoing_htlc_id", b"outgoing_htlc_id", "settle_event", b"settle_event", "subscribed_event", b"subscribed_event", "timestamp_ns", b"timestamp_ns"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["event", b"event"]) -> typing.Literal["forward_event", "forward_fail_event", "settle_event", "link_fail_event", "subscribed_event", "final_htlc_event"] | None: ...

global___HtlcEvent = HtlcEvent

@typing.final
class HtlcInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INCOMING_TIMELOCK_FIELD_NUMBER: builtins.int
    OUTGOING_TIMELOCK_FIELD_NUMBER: builtins.int
    INCOMING_AMT_MSAT_FIELD_NUMBER: builtins.int
    OUTGOING_AMT_MSAT_FIELD_NUMBER: builtins.int
    incoming_timelock: builtins.int
    """The timelock on the incoming htlc."""
    outgoing_timelock: builtins.int
    """The timelock on the outgoing htlc."""
    incoming_amt_msat: builtins.int
    """The amount of the incoming htlc."""
    outgoing_amt_msat: builtins.int
    """The amount of the outgoing htlc."""
    def __init__(
        self,
        *,
        incoming_timelock: builtins.int = ...,
        outgoing_timelock: builtins.int = ...,
        incoming_amt_msat: builtins.int = ...,
        outgoing_amt_msat: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["incoming_amt_msat", b"incoming_amt_msat", "incoming_timelock", b"incoming_timelock", "outgoing_amt_msat", b"outgoing_amt_msat", "outgoing_timelock", b"outgoing_timelock"]) -> None: ...

global___HtlcInfo = HtlcInfo

@typing.final
class ForwardEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INFO_FIELD_NUMBER: builtins.int
    @property
    def info(self) -> global___HtlcInfo:
        """Info contains details about the htlc that was forwarded."""

    def __init__(
        self,
        *,
        info: global___HtlcInfo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["info", b"info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["info", b"info"]) -> None: ...

global___ForwardEvent = ForwardEvent

@typing.final
class ForwardFailEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ForwardFailEvent = ForwardFailEvent

@typing.final
class SettleEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREIMAGE_FIELD_NUMBER: builtins.int
    preimage: builtins.bytes
    """The revealed preimage."""
    def __init__(
        self,
        *,
        preimage: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["preimage", b"preimage"]) -> None: ...

global___SettleEvent = SettleEvent

@typing.final
class FinalHtlcEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SETTLED_FIELD_NUMBER: builtins.int
    OFFCHAIN_FIELD_NUMBER: builtins.int
    settled: builtins.bool
    offchain: builtins.bool
    def __init__(
        self,
        *,
        settled: builtins.bool = ...,
        offchain: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["offchain", b"offchain", "settled", b"settled"]) -> None: ...

global___FinalHtlcEvent = FinalHtlcEvent

@typing.final
class SubscribedEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SubscribedEvent = SubscribedEvent

@typing.final
class LinkFailEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INFO_FIELD_NUMBER: builtins.int
    WIRE_FAILURE_FIELD_NUMBER: builtins.int
    FAILURE_DETAIL_FIELD_NUMBER: builtins.int
    FAILURE_STRING_FIELD_NUMBER: builtins.int
    wire_failure: cashu.lightning.lnd_grpc.protos.lightning_pb2.Failure.FailureCode.ValueType
    """FailureCode is the BOLT error code for the failure."""
    failure_detail: global___FailureDetail.ValueType
    """
    FailureDetail provides additional information about the reason for the
    failure. This detail enriches the information provided by the wire message
    and may be 'no detail' if the wire message requires no additional metadata.
    """
    failure_string: builtins.str
    """A string representation of the link failure."""
    @property
    def info(self) -> global___HtlcInfo:
        """Info contains details about the htlc that we failed."""

    def __init__(
        self,
        *,
        info: global___HtlcInfo | None = ...,
        wire_failure: cashu.lightning.lnd_grpc.protos.lightning_pb2.Failure.FailureCode.ValueType = ...,
        failure_detail: global___FailureDetail.ValueType = ...,
        failure_string: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["info", b"info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["failure_detail", b"failure_detail", "failure_string", b"failure_string", "info", b"info", "wire_failure", b"wire_failure"]) -> None: ...

global___LinkFailEvent = LinkFailEvent

@typing.final
class PaymentStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    PREIMAGE_FIELD_NUMBER: builtins.int
    HTLCS_FIELD_NUMBER: builtins.int
    state: global___PaymentState.ValueType
    """Current state the payment is in."""
    preimage: builtins.bytes
    """
    The pre-image of the payment when state is SUCCEEDED.
    """
    @property
    def htlcs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[cashu.lightning.lnd_grpc.protos.lightning_pb2.HTLCAttempt]:
        """
        The HTLCs made in attempt to settle the payment [EXPERIMENTAL].
        """

    def __init__(
        self,
        *,
        state: global___PaymentState.ValueType = ...,
        preimage: builtins.bytes = ...,
        htlcs: collections.abc.Iterable[cashu.lightning.lnd_grpc.protos.lightning_pb2.HTLCAttempt] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["htlcs", b"htlcs", "preimage", b"preimage", "state", b"state"]) -> None: ...

global___PaymentStatus = PaymentStatus

@typing.final
class CircuitKey(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_ID_FIELD_NUMBER: builtins.int
    HTLC_ID_FIELD_NUMBER: builtins.int
    chan_id: builtins.int
    """/ The id of the channel that the is part of this circuit."""
    htlc_id: builtins.int
    """/ The index of the incoming htlc in the incoming channel."""
    def __init__(
        self,
        *,
        chan_id: builtins.int = ...,
        htlc_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["chan_id", b"chan_id", "htlc_id", b"htlc_id"]) -> None: ...

global___CircuitKey = CircuitKey

@typing.final
class ForwardHtlcInterceptRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class CustomRecordsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    INCOMING_CIRCUIT_KEY_FIELD_NUMBER: builtins.int
    INCOMING_AMOUNT_MSAT_FIELD_NUMBER: builtins.int
    INCOMING_EXPIRY_FIELD_NUMBER: builtins.int
    PAYMENT_HASH_FIELD_NUMBER: builtins.int
    OUTGOING_REQUESTED_CHAN_ID_FIELD_NUMBER: builtins.int
    OUTGOING_AMOUNT_MSAT_FIELD_NUMBER: builtins.int
    OUTGOING_EXPIRY_FIELD_NUMBER: builtins.int
    CUSTOM_RECORDS_FIELD_NUMBER: builtins.int
    ONION_BLOB_FIELD_NUMBER: builtins.int
    AUTO_FAIL_HEIGHT_FIELD_NUMBER: builtins.int
    incoming_amount_msat: builtins.int
    """The incoming htlc amount."""
    incoming_expiry: builtins.int
    """The incoming htlc expiry."""
    payment_hash: builtins.bytes
    """
    The htlc payment hash. This value is not guaranteed to be unique per
    request.
    """
    outgoing_requested_chan_id: builtins.int
    """The requested outgoing channel id for this forwarded htlc. Because of
    non-strict forwarding, this isn't necessarily the channel over which the
    packet will be forwarded eventually. A different channel to the same peer
    may be selected as well.
    """
    outgoing_amount_msat: builtins.int
    """The outgoing htlc amount."""
    outgoing_expiry: builtins.int
    """The outgoing htlc expiry."""
    onion_blob: builtins.bytes
    """The onion blob for the next hop"""
    auto_fail_height: builtins.int
    """The block height at which this htlc will be auto-failed to prevent the
    channel from force-closing.
    """
    @property
    def incoming_circuit_key(self) -> global___CircuitKey:
        """
        The key of this forwarded htlc. It defines the incoming channel id and
        the index in this channel.
        """

    @property
    def custom_records(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.bytes]:
        """Any custom records that were present in the payload."""

    def __init__(
        self,
        *,
        incoming_circuit_key: global___CircuitKey | None = ...,
        incoming_amount_msat: builtins.int = ...,
        incoming_expiry: builtins.int = ...,
        payment_hash: builtins.bytes = ...,
        outgoing_requested_chan_id: builtins.int = ...,
        outgoing_amount_msat: builtins.int = ...,
        outgoing_expiry: builtins.int = ...,
        custom_records: collections.abc.Mapping[builtins.int, builtins.bytes] | None = ...,
        onion_blob: builtins.bytes = ...,
        auto_fail_height: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["incoming_circuit_key", b"incoming_circuit_key"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_fail_height", b"auto_fail_height", "custom_records", b"custom_records", "incoming_amount_msat", b"incoming_amount_msat", "incoming_circuit_key", b"incoming_circuit_key", "incoming_expiry", b"incoming_expiry", "onion_blob", b"onion_blob", "outgoing_amount_msat", b"outgoing_amount_msat", "outgoing_expiry", b"outgoing_expiry", "outgoing_requested_chan_id", b"outgoing_requested_chan_id", "payment_hash", b"payment_hash"]) -> None: ...

global___ForwardHtlcInterceptRequest = ForwardHtlcInterceptRequest

@typing.final
class ForwardHtlcInterceptResponse(google.protobuf.message.Message):
    """*
    ForwardHtlcInterceptResponse enables the caller to resolve a previously hold
    forward. The caller can choose either to:
    - `Resume`: Execute the default behavior (usually forward).
    - `Reject`: Fail the htlc backwards.
    - `Settle`: Settle this htlc with a given preimage.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INCOMING_CIRCUIT_KEY_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    PREIMAGE_FIELD_NUMBER: builtins.int
    FAILURE_MESSAGE_FIELD_NUMBER: builtins.int
    FAILURE_CODE_FIELD_NUMBER: builtins.int
    action: global___ResolveHoldForwardAction.ValueType
    """The resolve action for this intercepted htlc."""
    preimage: builtins.bytes
    """The preimage in case the resolve action is Settle."""
    failure_message: builtins.bytes
    """Encrypted failure message in case the resolve action is Fail.

    If failure_message is specified, the failure_code field must be set
    to zero.
    """
    failure_code: cashu.lightning.lnd_grpc.protos.lightning_pb2.Failure.FailureCode.ValueType
    """Return the specified failure code in case the resolve action is Fail. The
    message data fields are populated automatically.

    If a non-zero failure_code is specified, failure_message must not be set.

    For backwards-compatibility reasons, TEMPORARY_CHANNEL_FAILURE is the
    default value for this field.
    """
    @property
    def incoming_circuit_key(self) -> global___CircuitKey:
        """*
        The key of this forwarded htlc. It defines the incoming channel id and
        the index in this channel.
        """

    def __init__(
        self,
        *,
        incoming_circuit_key: global___CircuitKey | None = ...,
        action: global___ResolveHoldForwardAction.ValueType = ...,
        preimage: builtins.bytes = ...,
        failure_message: builtins.bytes = ...,
        failure_code: cashu.lightning.lnd_grpc.protos.lightning_pb2.Failure.FailureCode.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["incoming_circuit_key", b"incoming_circuit_key"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "failure_code", b"failure_code", "failure_message", b"failure_message", "incoming_circuit_key", b"incoming_circuit_key", "preimage", b"preimage"]) -> None: ...

global___ForwardHtlcInterceptResponse = ForwardHtlcInterceptResponse

@typing.final
class UpdateChanStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAN_POINT_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    action: global___ChanStatusAction.ValueType
    @property
    def chan_point(self) -> cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelPoint: ...
    def __init__(
        self,
        *,
        chan_point: cashu.lightning.lnd_grpc.protos.lightning_pb2.ChannelPoint | None = ...,
        action: global___ChanStatusAction.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["chan_point", b"chan_point"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "chan_point", b"chan_point"]) -> None: ...

global___UpdateChanStatusRequest = UpdateChanStatusRequest

@typing.final
class UpdateChanStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateChanStatusResponse = UpdateChanStatusResponse
