#!/bin/bash

# *** RUN THIS FROM THE ROOT OF THE PROJECT ***

BASE_DIR=./cashu/mint/management_rpc/protos

# Check if the googleapis directory exists
if [ -d "$BASE_DIR/googleapis" ]; then
  echo "$BASE_DIR/googleapis directory already exists. Skipping clone."
else
  echo "Cloning googleapis..."
  echo "If this doesn't work, clone it manually."
  git clone https://github.com/googleapis/googleapis.git $BASE_DIR/googleapis
fi

echo "Ensuring grpcio is installed..."
poetry add grpcio grpcio-tools

echo "Compiling proto files..."
poetry run python3 -m grpc_tools.protoc --proto_path=$BASE_DIR/googleapis:$BASE_DIR --mypy_out=$BASE_DIR --python_out=$BASE_DIR --grpc_python_out=$BASE_DIR $BASE_DIR/management.proto

echo "fixing imports on autogenerated files..."
for file in $BASE_DIR/*.{py,pyi}; do
  if [ -f "$file" ]; then
    sed -i -e 's/import management_pb2/import cashu.mint.management_rpc.protos.management_pb2/g' $file
  fi
done

echo "Finished!"