"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import typing

import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetInfoRequest(google.protobuf.message.Message):
    """GetInfoRequest is an empty message used to request general mint information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetInfoRequest = GetInfoRequest

@typing.final
class InfoContact(google.protobuf.message.Message):
    """InfoContact represents a contact method for the mint."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METHOD_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    method: builtins.str
    """The method of contact (e.g., "email", "telegram", "twitter")."""
    info: builtins.str
    """The contact information itself (e.g., "info@example.com", "@mint_support")."""
    def __init__(
        self,
        *,
        method: builtins.str = ...,
        info: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["info", b"info", "method", b"method"]) -> None: ...

global___InfoContact = InfoContact

@typing.final
class GetInfoResponse(google.protobuf.message.Message):
    """GetInfoResponse contains general information about the mint."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    PUBKEY_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LONG_DESCRIPTION_FIELD_NUMBER: builtins.int
    CONTACT_FIELD_NUMBER: builtins.int
    MOTD_FIELD_NUMBER: builtins.int
    ICON_URL_FIELD_NUMBER: builtins.int
    URLS_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    TOS_URL_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the mint."""
    pubkey: builtins.str
    """The public key of the mint."""
    version: builtins.str
    """The version of the mint software."""
    description: builtins.str
    """A short description of the mint."""
    long_description: builtins.str
    """A longer, more detailed description of the mint."""
    motd: builtins.str
    """The Message of the Day (MOTD) displayed by the mint."""
    icon_url: builtins.str
    """The URL to the mint's icon."""
    time: builtins.int
    """The current time on the mint server (Unix timestamp)."""
    tos_url: builtins.str
    """The URL to the mint's Terms of Service."""
    @property
    def contact(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InfoContact]:
        """A list of contact methods for the mint."""

    @property
    def urls(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of URLs associated with the mint."""

    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        pubkey: builtins.str | None = ...,
        version: builtins.str | None = ...,
        description: builtins.str | None = ...,
        long_description: builtins.str | None = ...,
        contact: collections.abc.Iterable[global___InfoContact] | None = ...,
        motd: builtins.str | None = ...,
        icon_url: builtins.str | None = ...,
        urls: collections.abc.Iterable[builtins.str] | None = ...,
        time: builtins.int | None = ...,
        tos_url: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_description", b"_description", "_icon_url", b"_icon_url", "_long_description", b"_long_description", "_motd", b"_motd", "_name", b"_name", "_pubkey", b"_pubkey", "_time", b"_time", "_tos_url", b"_tos_url", "_version", b"_version", "description", b"description", "icon_url", b"icon_url", "long_description", b"long_description", "motd", b"motd", "name", b"name", "pubkey", b"pubkey", "time", b"time", "tos_url", b"tos_url", "version", b"version"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_description", b"_description", "_icon_url", b"_icon_url", "_long_description", b"_long_description", "_motd", b"_motd", "_name", b"_name", "_pubkey", b"_pubkey", "_time", b"_time", "_tos_url", b"_tos_url", "_version", b"_version", "contact", b"contact", "description", b"description", "icon_url", b"icon_url", "long_description", b"long_description", "motd", b"motd", "name", b"name", "pubkey", b"pubkey", "time", b"time", "tos_url", b"tos_url", "urls", b"urls", "version", b"version"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_description", b"_description"]) -> typing.Literal["description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_icon_url", b"_icon_url"]) -> typing.Literal["icon_url"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_long_description", b"_long_description"]) -> typing.Literal["long_description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_motd", b"_motd"]) -> typing.Literal["motd"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_name", b"_name"]) -> typing.Literal["name"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pubkey", b"_pubkey"]) -> typing.Literal["pubkey"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_time", b"_time"]) -> typing.Literal["time"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_tos_url", b"_tos_url"]) -> typing.Literal["tos_url"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_version", b"_version"]) -> typing.Literal["version"] | None: ...

global___GetInfoResponse = GetInfoResponse

@typing.final
class UpdateResponse(google.protobuf.message.Message):
    """UpdateResponse is a generic empty message returned for successful update operations."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateResponse = UpdateResponse

@typing.final
class UpdateMotdRequest(google.protobuf.message.Message):
    """UpdateMotdRequest is used to update the Message of the Day (MOTD)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MOTD_FIELD_NUMBER: builtins.int
    motd: builtins.str
    """The new MOTD string."""
    def __init__(
        self,
        *,
        motd: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["motd", b"motd"]) -> None: ...

global___UpdateMotdRequest = UpdateMotdRequest

@typing.final
class UpdateDescriptionRequest(google.protobuf.message.Message):
    """UpdateDescriptionRequest is used to update either the short or long description."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESCRIPTION_FIELD_NUMBER: builtins.int
    description: builtins.str
    """The new description string."""
    def __init__(
        self,
        *,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description"]) -> None: ...

global___UpdateDescriptionRequest = UpdateDescriptionRequest

@typing.final
class UpdateIconUrlRequest(google.protobuf.message.Message):
    """UpdateIconUrlRequest is used to update the mint's icon URL."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ICON_URL_FIELD_NUMBER: builtins.int
    icon_url: builtins.str
    """The new URL for the mint's icon."""
    def __init__(
        self,
        *,
        icon_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["icon_url", b"icon_url"]) -> None: ...

global___UpdateIconUrlRequest = UpdateIconUrlRequest

@typing.final
class UpdateNameRequest(google.protobuf.message.Message):
    """UpdateNameRequest is used to update the mint's name."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The new name for the mint."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name"]) -> None: ...

global___UpdateNameRequest = UpdateNameRequest

@typing.final
class UpdateUrlRequest(google.protobuf.message.Message):
    """UpdateUrlRequest is used to add or remove a URL associated with the mint."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    url: builtins.str
    """The URL to add or remove."""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["url", b"url"]) -> None: ...

global___UpdateUrlRequest = UpdateUrlRequest

@typing.final
class UpdateContactRequest(google.protobuf.message.Message):
    """UpdateContactRequest is used to add or remove a contact method for the mint."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METHOD_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    method: builtins.str
    """The method of contact (e.g., "email", "telegram")."""
    info: builtins.str
    """The contact information (e.g., "info@example.com")."""
    def __init__(
        self,
        *,
        method: builtins.str = ...,
        info: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["info", b"info", "method", b"method"]) -> None: ...

global___UpdateContactRequest = UpdateContactRequest

@typing.final
class MintMethodOptions(google.protobuf.message.Message):
    """MintMethodOptions defines specific options for a NUT-04 (minting) method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESCRIPTION_FIELD_NUMBER: builtins.int
    description: builtins.bool
    """Bolt11 options
    Indicates if a description is required for Bolt11 invoices.
    """
    def __init__(
        self,
        *,
        description: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description"]) -> None: ...

global___MintMethodOptions = MintMethodOptions

@typing.final
class UpdateNut04Request(google.protobuf.message.Message):
    """UpdateNut04Request is used to configure a NUT-04 (minting) payment method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UNIT_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    DISABLED_FIELD_NUMBER: builtins.int
    MIN_AMOUNT_FIELD_NUMBER: builtins.int
    MAX_AMOUNT_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    unit: builtins.str
    """The unit of the payment method (e.g., "sat")."""
    method: builtins.str
    """The method of payment (e.g., "bolt11")."""
    disabled: builtins.bool
    """Optional: If true, disables this payment method."""
    min_amount: builtins.int
    """Optional: The minimum amount allowed for this method."""
    max_amount: builtins.int
    """Optional: The maximum amount allowed for this method."""
    @property
    def options(self) -> global___MintMethodOptions:
        """Optional: Specific options for this minting method."""

    def __init__(
        self,
        *,
        unit: builtins.str = ...,
        method: builtins.str = ...,
        disabled: builtins.bool | None = ...,
        min_amount: builtins.int | None = ...,
        max_amount: builtins.int | None = ...,
        options: global___MintMethodOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_disabled", b"_disabled", "_max_amount", b"_max_amount", "_min_amount", b"_min_amount", "_options", b"_options", "disabled", b"disabled", "max_amount", b"max_amount", "min_amount", b"min_amount", "options", b"options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_disabled", b"_disabled", "_max_amount", b"_max_amount", "_min_amount", b"_min_amount", "_options", b"_options", "disabled", b"disabled", "max_amount", b"max_amount", "method", b"method", "min_amount", b"min_amount", "options", b"options", "unit", b"unit"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_disabled", b"_disabled"]) -> typing.Literal["disabled"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_max_amount", b"_max_amount"]) -> typing.Literal["max_amount"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_min_amount", b"_min_amount"]) -> typing.Literal["min_amount"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_options", b"_options"]) -> typing.Literal["options"] | None: ...

global___UpdateNut04Request = UpdateNut04Request

@typing.final
class MeltMethodOptions(google.protobuf.message.Message):
    """MeltMethodOptions defines specific options for a NUT-05 (melting) method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AMOUNTLESS_FIELD_NUMBER: builtins.int
    amountless: builtins.bool
    """Bolt11 options
    Indicates if the amount can be omitted for Bolt11 invoices.
    """
    def __init__(
        self,
        *,
        amountless: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["amountless", b"amountless"]) -> None: ...

global___MeltMethodOptions = MeltMethodOptions

@typing.final
class UpdateNut05Request(google.protobuf.message.Message):
    """UpdateNut05Request is used to configure a NUT-05 (melting) payment method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UNIT_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    DISABLED_FIELD_NUMBER: builtins.int
    MIN_AMOUNT_FIELD_NUMBER: builtins.int
    MAX_AMOUNT_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    unit: builtins.str
    """The unit of the payment method (e.g., "sat")."""
    method: builtins.str
    """The method of payment (e.g., "bolt11")."""
    disabled: builtins.bool
    """Optional: If true, disables this payment method."""
    min_amount: builtins.int
    """Optional: The minimum amount allowed for this method."""
    max_amount: builtins.int
    """Optional: The maximum amount allowed for this method."""
    @property
    def options(self) -> global___MeltMethodOptions:
        """Optional: Specific options for this melting method."""

    def __init__(
        self,
        *,
        unit: builtins.str = ...,
        method: builtins.str = ...,
        disabled: builtins.bool | None = ...,
        min_amount: builtins.int | None = ...,
        max_amount: builtins.int | None = ...,
        options: global___MeltMethodOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_disabled", b"_disabled", "_max_amount", b"_max_amount", "_min_amount", b"_min_amount", "_options", b"_options", "disabled", b"disabled", "max_amount", b"max_amount", "min_amount", b"min_amount", "options", b"options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_disabled", b"_disabled", "_max_amount", b"_max_amount", "_min_amount", b"_min_amount", "_options", b"_options", "disabled", b"disabled", "max_amount", b"max_amount", "method", b"method", "min_amount", b"min_amount", "options", b"options", "unit", b"unit"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_disabled", b"_disabled"]) -> typing.Literal["disabled"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_max_amount", b"_max_amount"]) -> typing.Literal["max_amount"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_min_amount", b"_min_amount"]) -> typing.Literal["min_amount"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_options", b"_options"]) -> typing.Literal["options"] | None: ...

global___UpdateNut05Request = UpdateNut05Request

@typing.final
class UpdateQuoteTtlRequest(google.protobuf.message.Message):
    """UpdateQuoteTtlRequest is used to update the Time-To-Live (TTL) for quotes."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MINT_TTL_FIELD_NUMBER: builtins.int
    MELT_TTL_FIELD_NUMBER: builtins.int
    mint_ttl: builtins.int
    """Optional: The TTL in seconds for minting (NUT-04) quotes."""
    melt_ttl: builtins.int
    """Optional: The TTL in seconds for melting (NUT-05) quotes."""
    def __init__(
        self,
        *,
        mint_ttl: builtins.int | None = ...,
        melt_ttl: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_melt_ttl", b"_melt_ttl", "_mint_ttl", b"_mint_ttl", "melt_ttl", b"melt_ttl", "mint_ttl", b"mint_ttl"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_melt_ttl", b"_melt_ttl", "_mint_ttl", b"_mint_ttl", "melt_ttl", b"melt_ttl", "mint_ttl", b"mint_ttl"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_melt_ttl", b"_melt_ttl"]) -> typing.Literal["melt_ttl"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_mint_ttl", b"_mint_ttl"]) -> typing.Literal["mint_ttl"] | None: ...

global___UpdateQuoteTtlRequest = UpdateQuoteTtlRequest

@typing.final
class Nut04Quote(google.protobuf.message.Message):
    """Nut04Quote represents a quote for minting (NUT-04)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUOTE_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    REQUEST_FIELD_NUMBER: builtins.int
    CHECKING_ID_FIELD_NUMBER: builtins.int
    UNIT_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CREATED_TIME_FIELD_NUMBER: builtins.int
    PAID_TIME_FIELD_NUMBER: builtins.int
    EXPIRY_FIELD_NUMBER: builtins.int
    PUBKEY_FIELD_NUMBER: builtins.int
    quote: builtins.str
    """The unique identifier for the quote."""
    method: builtins.str
    """The payment method used for this quote (e.g., "bolt11")."""
    request: builtins.str
    """The original request string (e.g., Bolt11 invoice)."""
    checking_id: builtins.str
    """The ID used for checking the payment status."""
    unit: builtins.str
    """The unit of the amount (e.g., "sat")."""
    amount: builtins.int
    """The amount of tokens to be minted."""
    state: builtins.str
    """Optional: The current state of the quote (e.g., "pending", "paid", "expired")."""
    created_time: builtins.int
    """Optional: The Unix timestamp when the quote was created."""
    paid_time: builtins.int
    """Optional: The Unix timestamp when the quote was paid."""
    expiry: builtins.int
    """Optional: The Unix timestamp when the quote expires."""
    pubkey: builtins.str
    """Optional: The public key associated with the quote, if applicable."""
    def __init__(
        self,
        *,
        quote: builtins.str = ...,
        method: builtins.str = ...,
        request: builtins.str = ...,
        checking_id: builtins.str = ...,
        unit: builtins.str = ...,
        amount: builtins.int = ...,
        state: builtins.str | None = ...,
        created_time: builtins.int | None = ...,
        paid_time: builtins.int | None = ...,
        expiry: builtins.int | None = ...,
        pubkey: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_created_time", b"_created_time", "_expiry", b"_expiry", "_paid_time", b"_paid_time", "_pubkey", b"_pubkey", "_state", b"_state", "created_time", b"created_time", "expiry", b"expiry", "paid_time", b"paid_time", "pubkey", b"pubkey", "state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_created_time", b"_created_time", "_expiry", b"_expiry", "_paid_time", b"_paid_time", "_pubkey", b"_pubkey", "_state", b"_state", "amount", b"amount", "checking_id", b"checking_id", "created_time", b"created_time", "expiry", b"expiry", "method", b"method", "paid_time", b"paid_time", "pubkey", b"pubkey", "quote", b"quote", "request", b"request", "state", b"state", "unit", b"unit"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_created_time", b"_created_time"]) -> typing.Literal["created_time"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_expiry", b"_expiry"]) -> typing.Literal["expiry"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_paid_time", b"_paid_time"]) -> typing.Literal["paid_time"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pubkey", b"_pubkey"]) -> typing.Literal["pubkey"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_state", b"_state"]) -> typing.Literal["state"] | None: ...

global___Nut04Quote = Nut04Quote

@typing.final
class BlindedMessage(google.protobuf.message.Message):
    """BlindedMessage represents a blinded message used in Cashu."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AMOUNT_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    B__FIELD_NUMBER: builtins.int
    WITNESS_FIELD_NUMBER: builtins.int
    amount: builtins.int
    """The amount of the token."""
    id: builtins.str
    """The ID of the keyset."""
    B_: builtins.str
    """The blinded point B_."""
    witness: builtins.str
    """Optional: The witness for the blinded message."""
    def __init__(
        self,
        *,
        amount: builtins.int = ...,
        id: builtins.str = ...,
        B_: builtins.str = ...,
        witness: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_witness", b"_witness", "witness", b"witness"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["B_", b"B_", "_witness", b"_witness", "amount", b"amount", "id", b"id", "witness", b"witness"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_witness", b"_witness"]) -> typing.Literal["witness"] | None: ...

global___BlindedMessage = BlindedMessage

@typing.final
class DLEQ(google.protobuf.message.Message):
    """DLEQ represents a Discrete Logarithm Equality Proof."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    E_FIELD_NUMBER: builtins.int
    S_FIELD_NUMBER: builtins.int
    e: builtins.str
    """The 'e' value of the DLEQ proof."""
    s: builtins.str
    """The 's' value of the DLEQ proof."""
    def __init__(
        self,
        *,
        e: builtins.str = ...,
        s: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["e", b"e", "s", b"s"]) -> None: ...

global___DLEQ = DLEQ

@typing.final
class BlindedSignature(google.protobuf.message.Message):
    """BlindedSignature represents a blinded signature from the mint."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    C__FIELD_NUMBER: builtins.int
    DLEQ_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID of the keyset."""
    amount: builtins.int
    """The amount of the token."""
    C_: builtins.str
    """The blinded signature C_."""
    @property
    def dleq(self) -> global___DLEQ:
        """Optional: The DLEQ proof for the signature."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        amount: builtins.int = ...,
        C_: builtins.str = ...,
        dleq: global___DLEQ | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_dleq", b"_dleq", "dleq", b"dleq"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["C_", b"C_", "_dleq", b"_dleq", "amount", b"amount", "dleq", b"dleq", "id", b"id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_dleq", b"_dleq"]) -> typing.Literal["dleq"] | None: ...

global___BlindedSignature = BlindedSignature

@typing.final
class Nut05Quote(google.protobuf.message.Message):
    """Nut05Quote represents a quote for melting (NUT-05)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUOTE_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    REQUEST_FIELD_NUMBER: builtins.int
    CHECKING_ID_FIELD_NUMBER: builtins.int
    UNIT_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    FEE_RESERVE_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CREATED_TIME_FIELD_NUMBER: builtins.int
    PAID_TIME_FIELD_NUMBER: builtins.int
    FEE_PAID_FIELD_NUMBER: builtins.int
    PAYMENT_PREIMAGE_FIELD_NUMBER: builtins.int
    EXPIRY_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    CHANGE_FIELD_NUMBER: builtins.int
    quote: builtins.str
    """The unique identifier for the quote."""
    method: builtins.str
    """The payment method used for this quote (e.g., "bolt11")."""
    request: builtins.str
    """The original request string (e.g., Bolt11 invoice)."""
    checking_id: builtins.str
    """The ID used for checking the payment status."""
    unit: builtins.str
    """The unit of the amount (e.g., "sat")."""
    amount: builtins.int
    """The amount of tokens to be melted."""
    fee_reserve: builtins.int
    """The fee reserve for the melting operation."""
    state: builtins.str
    """The current state of the quote (e.g., "pending", "paid", "success", "failed")."""
    created_time: builtins.int
    """Optional: The Unix timestamp when the quote was created."""
    paid_time: builtins.int
    """Optional: The Unix timestamp when the quote was paid."""
    fee_paid: builtins.int
    """The actual fee paid for the melting operation."""
    payment_preimage: builtins.str
    """Optional: The payment preimage if the payment was successful."""
    expiry: builtins.int
    """Optional: The Unix timestamp when the quote expires."""
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BlindedMessage]:
        """A list of blinded messages representing the outputs (e.g., change)."""

    @property
    def change(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BlindedSignature]:
        """A list of blinded signatures representing the change."""

    def __init__(
        self,
        *,
        quote: builtins.str = ...,
        method: builtins.str = ...,
        request: builtins.str = ...,
        checking_id: builtins.str = ...,
        unit: builtins.str = ...,
        amount: builtins.int = ...,
        fee_reserve: builtins.int = ...,
        state: builtins.str = ...,
        created_time: builtins.int | None = ...,
        paid_time: builtins.int | None = ...,
        fee_paid: builtins.int = ...,
        payment_preimage: builtins.str | None = ...,
        expiry: builtins.int | None = ...,
        outputs: collections.abc.Iterable[global___BlindedMessage] | None = ...,
        change: collections.abc.Iterable[global___BlindedSignature] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_created_time", b"_created_time", "_expiry", b"_expiry", "_paid_time", b"_paid_time", "_payment_preimage", b"_payment_preimage", "created_time", b"created_time", "expiry", b"expiry", "paid_time", b"paid_time", "payment_preimage", b"payment_preimage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_created_time", b"_created_time", "_expiry", b"_expiry", "_paid_time", b"_paid_time", "_payment_preimage", b"_payment_preimage", "amount", b"amount", "change", b"change", "checking_id", b"checking_id", "created_time", b"created_time", "expiry", b"expiry", "fee_paid", b"fee_paid", "fee_reserve", b"fee_reserve", "method", b"method", "outputs", b"outputs", "paid_time", b"paid_time", "payment_preimage", b"payment_preimage", "quote", b"quote", "request", b"request", "state", b"state", "unit", b"unit"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_created_time", b"_created_time"]) -> typing.Literal["created_time"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_expiry", b"_expiry"]) -> typing.Literal["expiry"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_paid_time", b"_paid_time"]) -> typing.Literal["paid_time"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_payment_preimage", b"_payment_preimage"]) -> typing.Literal["payment_preimage"] | None: ...

global___Nut05Quote = Nut05Quote

@typing.final
class GetNut04QuoteRequest(google.protobuf.message.Message):
    """GetNut04QuoteRequest is used to request a specific NUT-04 quote."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUOTE_ID_FIELD_NUMBER: builtins.int
    quote_id: builtins.str
    """The ID of the NUT-04 quote to retrieve."""
    def __init__(
        self,
        *,
        quote_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["quote_id", b"quote_id"]) -> None: ...

global___GetNut04QuoteRequest = GetNut04QuoteRequest

@typing.final
class GetNut04QuoteResponse(google.protobuf.message.Message):
    """GetNut04QuoteResponse contains the requested NUT-04 quote."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUOTE_FIELD_NUMBER: builtins.int
    @property
    def quote(self) -> global___Nut04Quote:
        """The NUT-04 quote object."""

    def __init__(
        self,
        *,
        quote: global___Nut04Quote | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["quote", b"quote"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["quote", b"quote"]) -> None: ...

global___GetNut04QuoteResponse = GetNut04QuoteResponse

@typing.final
class GetNut05QuoteRequest(google.protobuf.message.Message):
    """GetNut05QuoteRequest is used to request a specific NUT-05 quote."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUOTE_ID_FIELD_NUMBER: builtins.int
    quote_id: builtins.str
    """The ID of the NUT-05 quote to retrieve."""
    def __init__(
        self,
        *,
        quote_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["quote_id", b"quote_id"]) -> None: ...

global___GetNut05QuoteRequest = GetNut05QuoteRequest

@typing.final
class GetNut05QuoteResponse(google.protobuf.message.Message):
    """GetNut05QuoteResponse contains the requested NUT-05 quote."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUOTE_FIELD_NUMBER: builtins.int
    @property
    def quote(self) -> global___Nut05Quote:
        """The NUT-05 quote object."""

    def __init__(
        self,
        *,
        quote: global___Nut05Quote | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["quote", b"quote"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["quote", b"quote"]) -> None: ...

global___GetNut05QuoteResponse = GetNut05QuoteResponse

@typing.final
class UpdateQuoteRequest(google.protobuf.message.Message):
    """UpdateQuoteRequest is used to update the state of a minting or melting quote."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUOTE_ID_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    quote_id: builtins.str
    """The ID of the quote to update."""
    state: builtins.str
    """The new state for the quote (e.g., "paid", "expired", "success", "failed")."""
    def __init__(
        self,
        *,
        quote_id: builtins.str = ...,
        state: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["quote_id", b"quote_id", "state", b"state"]) -> None: ...

global___UpdateQuoteRequest = UpdateQuoteRequest

@typing.final
class RotateNextKeysetRequest(google.protobuf.message.Message):
    """RotateNextKeysetRequest is used to initiate a keyset rotation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UNIT_FIELD_NUMBER: builtins.int
    MAX_ORDER_FIELD_NUMBER: builtins.int
    INPUT_FEE_PPK_FIELD_NUMBER: builtins.int
    unit: builtins.str
    """The unit for which to rotate the keyset (e.g., "sat")."""
    max_order: builtins.int
    """Optional: The maximum order of the new keyset."""
    input_fee_ppk: builtins.int
    """Optional: The input fee per kilobyte for the new keyset."""
    def __init__(
        self,
        *,
        unit: builtins.str = ...,
        max_order: builtins.int | None = ...,
        input_fee_ppk: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_input_fee_ppk", b"_input_fee_ppk", "_max_order", b"_max_order", "input_fee_ppk", b"input_fee_ppk", "max_order", b"max_order"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_input_fee_ppk", b"_input_fee_ppk", "_max_order", b"_max_order", "input_fee_ppk", b"input_fee_ppk", "max_order", b"max_order", "unit", b"unit"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_input_fee_ppk", b"_input_fee_ppk"]) -> typing.Literal["input_fee_ppk"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_max_order", b"_max_order"]) -> typing.Literal["max_order"] | None: ...

global___RotateNextKeysetRequest = RotateNextKeysetRequest

@typing.final
class RotateNextKeysetResponse(google.protobuf.message.Message):
    """RotateNextKeysetResponse contains information about the newly rotated keyset."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    UNIT_FIELD_NUMBER: builtins.int
    MAX_ORDER_FIELD_NUMBER: builtins.int
    INPUT_FEE_PPK_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID of the new keyset."""
    unit: builtins.str
    """The unit of the new keyset."""
    max_order: builtins.int
    """The maximum order of the new keyset."""
    input_fee_ppk: builtins.int
    """The input fee per kilobyte for the new keyset."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        unit: builtins.str = ...,
        max_order: builtins.int = ...,
        input_fee_ppk: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "input_fee_ppk", b"input_fee_ppk", "max_order", b"max_order", "unit", b"unit"]) -> None: ...

global___RotateNextKeysetResponse = RotateNextKeysetResponse

@typing.final
class UpdateLightningFeeRequest(google.protobuf.message.Message):
    """UpdateLightningFeeRequest is used to update the lightning network fee configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEE_PERCENT_FIELD_NUMBER: builtins.int
    FEE_MIN_RESERVE_FIELD_NUMBER: builtins.int
    fee_percent: builtins.float
    """Optional: The percentage of the fee."""
    fee_min_reserve: builtins.int
    """Optional: The minimum reserve amount for the fee."""
    def __init__(
        self,
        *,
        fee_percent: builtins.float | None = ...,
        fee_min_reserve: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_fee_min_reserve", b"_fee_min_reserve", "_fee_percent", b"_fee_percent", "fee_min_reserve", b"fee_min_reserve", "fee_percent", b"fee_percent"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_fee_min_reserve", b"_fee_min_reserve", "_fee_percent", b"_fee_percent", "fee_min_reserve", b"fee_min_reserve", "fee_percent", b"fee_percent"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_fee_min_reserve", b"_fee_min_reserve"]) -> typing.Literal["fee_min_reserve"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_fee_percent", b"_fee_percent"]) -> typing.Literal["fee_percent"] | None: ...

global___UpdateLightningFeeRequest = UpdateLightningFeeRequest

@typing.final
class UpdateAuthLimitsRequest(google.protobuf.message.Message):
    """UpdateAuthLimitsRequest is used to update authentication rate limits."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUTH_RATE_LIMIT_PER_MINUTE_FIELD_NUMBER: builtins.int
    AUTH_MAX_BLIND_TOKENS_FIELD_NUMBER: builtins.int
    auth_rate_limit_per_minute: builtins.int
    """Optional: The maximum number of authentication requests allowed per minute."""
    auth_max_blind_tokens: builtins.int
    """Optional: The maximum number of blind tokens allowed for authentication."""
    def __init__(
        self,
        *,
        auth_rate_limit_per_minute: builtins.int | None = ...,
        auth_max_blind_tokens: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_auth_max_blind_tokens", b"_auth_max_blind_tokens", "_auth_rate_limit_per_minute", b"_auth_rate_limit_per_minute", "auth_max_blind_tokens", b"auth_max_blind_tokens", "auth_rate_limit_per_minute", b"auth_rate_limit_per_minute"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_auth_max_blind_tokens", b"_auth_max_blind_tokens", "_auth_rate_limit_per_minute", b"_auth_rate_limit_per_minute", "auth_max_blind_tokens", b"auth_max_blind_tokens", "auth_rate_limit_per_minute", b"auth_rate_limit_per_minute"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_auth_max_blind_tokens", b"_auth_max_blind_tokens"]) -> typing.Literal["auth_max_blind_tokens"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_auth_rate_limit_per_minute", b"_auth_rate_limit_per_minute"]) -> typing.Literal["auth_rate_limit_per_minute"] | None: ...

global___UpdateAuthLimitsRequest = UpdateAuthLimitsRequest
