import os

from setuptools import find_packages, setup


def read(*rnames):
    return open(os.path.join(os.path.dirname(__file__), *rnames)).read()


version = "3.3.0"

tests_require = [
    "pytest==8.4.2",
    "pytest-cov",
]

dev_require = [
    "black==23.12.1",
    "flake8==7.3.0",
    "mypy==1.18.2",
] + tests_require

setup(
    name="graphene-federation",
    packages=find_packages(exclude=["tests"]),
    version=version,
    license="MIT",
    description="Federation implementation for graphene",
    long_description=(read("README.md")),
    long_description_content_type="text/markdown",
    author="Igor Kasianov",
    author_email="super.hang.glider@gmail.com",
    url="https://github.com/graphql-python/graphene-federation",
    download_url=f"https://github.com/graphql-python/graphene-federation/archive/{version}.tar.gz",
    keywords=["graphene", "graphql", "gql", "federation"],
    install_requires=[
        "graphene>=3.1",
        "graphql-core>=3.1",
        "graphene-directives>=0.5.0",
    ],
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: 3.13",
        "Programming Language :: Python :: 3.14",
    ],
    extras_require={
        "test": tests_require,
        "dev": dev_require,
    },
)
