# SPDX-FileCopyrightText: 2023 Helge
#
# SPDX-License-Identifier: MIT

# generated by datamodel-codegen:
#   filename:  models.schema.json
#   timestamp: 2024-11-22T18:43:47+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel

from .types.jrd import JrdData, JrdLink  # noqa: F401


class Model(RootModel[Any]):
    root: Any


class DataIntegrityProof(BaseModel):
    """
    A data integrity proof provides information about the proof mechanism, parameters required to verify that proof, and the proof value itself. See https://www.w3.org/TR/vc-data-integrity/#proofs
    """

    model_config = ConfigDict(
        extra="forbid",
    )
    field_context: Optional[Any] = Field(None, alias="@context")
    """
    Optional `@context` parameter
    """
    id: Optional[str] = None
    """
    An optional identifier for the proof, which MUST be a URL, such as a UUID as a URN (urn:uuid:6a1676b8-b51f-11ed-937b-d76685a20ff5).
    """
    type: str
    """
    The specific proof type used for the cryptographic proof MUST be specified as a string that maps to a URL. Examples of proof types include DataIntegrityProof and Ed25519Signature2020. Proof types determine what other fields are required to secure and verify the proof. 
    """
    cryptosuite: str
    """
    fixme
    """
    created: Optional[datetime] = None
    """
    The date and time the proof was created 
    """
    expires: Optional[datetime] = None
    """
    dateTimeStamp string specifying when the proof expires. 
    """
    verificationMethod: str
    """
    The means and information needed to verify the proof MUST be specified as a string that maps to a URL. An example of a verification method is a link to a public key which includes cryptographic material that is used by a verifier during the verification process. 
    """
    proofPurpose: str
    """
    The proof purpose acts as a safeguard to prevent the proof from being misused by being applied to a purpose other than the one that was intended. 
    """
    proofValue: Optional[str] = None
    """
    A string value that contains the base-encoded binary data necessary to verify the digital proof using the verificationMethod specified. 
    """
    nonce: Optional[str] = None
    domain: Optional[Union[str, List[str]]] = None
    challenge: Optional[str] = None
    previousProof: Optional[Union[str, List[str]]] = None


class Type(Enum):
    """
    The type, must be Multikey
    """

    Multikey = "Multikey"


class Multikey(BaseModel):
    """
    Representation of a cryptographic identifier as specified by Verifiable Credentials Data Integrity [here](https://www.w3.org/TR/vc-data-integrity/#multikey)
    """

    model_config = ConfigDict(
        extra="forbid",
    )
    field_context: Optional[Any] = Field(None, alias="@context")
    id: Optional[str] = None
    """
    optional id
    """
    type: Type
    """
    The type, must be Multikey
    """
    controller: str
    """
    The controller, i.e. the person holding the corresponding secret
    """
    publicKeyMultibase: str
    """
    The public key encoded in base 58 with an appropriate prefix
    """
    expires: Optional[datetime] = None
    """
    dateTimeStamp string specifying when the key expires. 
    """
    revoked: Optional[datetime] = None
    """
    dateTimeStamp string specifying when the key was revoked. 
    """
